/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.init.Biomes;
import net.minecraft.init.Fluids;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.ServerTickList;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.LegacyStructureDataUtil;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.storage.IThreadedFileIO;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraft.world.storage.WorldSavedDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnvilChunkLoader
implements IChunkLoader,
IThreadedFileIO {
    private static final Logger field_151505_a = LogManager.getLogger();
    private final Map<ChunkPos, NBTTagCompound> field_75828_a = Maps.newHashMap();
    private final File field_75825_d;
    private final DataFixer field_193416_e;
    private LegacyStructureDataUtil field_208031_e;
    private boolean field_183014_e;

    public AnvilChunkLoader(File file, DataFixer dataFixer) {
        this.field_75825_d = file;
        this.field_193416_e = dataFixer;
    }

    @Nullable
    private NBTTagCompound func_208030_a(IWorld iWorld, int n, int n2) throws IOException {
        return this.func_212146_a(iWorld.func_201675_m().func_186058_p(), iWorld.func_175693_T(), n, n2);
    }

    @Nullable
    private NBTTagCompound func_212146_a(DimensionType dimensionType, @Nullable WorldSavedDataStorage worldSavedDataStorage, int n, int n2) throws IOException {
        NBTTagCompound nBTTagCompound = this.field_75828_a.get(new ChunkPos(n, n2));
        if (nBTTagCompound != null) {
            return nBTTagCompound;
        }
        DataInputStream \u26032 = RegionFileCache.func_76549_c(this.field_75825_d, n, n2);
        if (\u26032 == null) {
            return null;
        }
        \u2603 = CompressedStreamTools.func_74794_a(\u26032);
        \u26032.close();
        int n3 = \u2603 = \u2603.func_150297_b("DataVersion", 99) ? \u2603.func_74762_e("DataVersion") : -1;
        if (\u2603 < 1493 && (\u2603 = NBTUtil.func_210821_a(this.field_193416_e, (DSL.TypeReference)DataFixTypes.CHUNK, \u2603, \u2603, 1493)).func_74775_l("Level").func_74767_n("hasLegacyStructureData")) {
            this.func_212429_a(dimensionType, worldSavedDataStorage);
            \u2603 = this.field_208031_e.func_212181_a(\u2603);
        }
        \u2603 = NBTUtil.func_210822_a(this.field_193416_e, (DSL.TypeReference)DataFixTypes.CHUNK, \u2603, Math.max(1493, \u2603));
        if (\u2603 < 1631) {
            \u2603.func_74768_a("DataVersion", 1631);
            this.func_75824_a(new ChunkPos(n, n2), \u2603);
        }
        return \u2603;
    }

    public void func_212429_a(DimensionType dimensionType, @Nullable WorldSavedDataStorage worldSavedDataStorage) {
        if (this.field_208031_e == null) {
            this.field_208031_e = LegacyStructureDataUtil.func_212183_a(dimensionType, worldSavedDataStorage);
        }
    }

    @Override
    @Nullable
    public Chunk func_199813_a(IWorld iWorld, int n, int n2, Consumer<Chunk> consumer) throws IOException {
        NBTTagCompound nBTTagCompound = this.func_208030_a(iWorld, n, n2);
        if (nBTTagCompound == null) {
            return null;
        }
        Chunk \u26032 = this.func_75822_a(iWorld, n, n2, nBTTagCompound);
        if (\u26032 != null) {
            consumer.accept(\u26032);
            this.func_199814_a(nBTTagCompound.func_74775_l("Level"), \u26032);
        }
        return \u26032;
    }

    @Override
    @Nullable
    public ChunkPrimer func_202152_b(IWorld iWorld, int n, int n2, Consumer<IChunk> consumer) throws IOException {
        try {
            NBTTagCompound nBTTagCompound = this.func_208030_a(iWorld, n, n2);
        }
        catch (ReportedException reportedException) {
            if (reportedException.getCause() instanceof IOException) {
                throw (IOException)reportedException.getCause();
            }
            throw reportedException;
        }
        if (nBTTagCompound == null) {
            return null;
        }
        ChunkPrimer chunkPrimer = this.func_202165_b(iWorld, n, n2, nBTTagCompound);
        if (chunkPrimer != null) {
            consumer.accept(chunkPrimer);
        }
        return chunkPrimer;
    }

    @Nullable
    protected Chunk func_75822_a(IWorld iWorld, int n, int n2, NBTTagCompound nBTTagCompound) {
        if (!nBTTagCompound.func_150297_b("Level", 10) || !nBTTagCompound.func_74775_l("Level").func_150297_b("Status", 8)) {
            field_151505_a.error("Chunk file at {},{} is missing level data, skipping", (Object)n, (Object)n2);
            return null;
        }
        ChunkStatus.Type type = this.func_202161_a(nBTTagCompound);
        if (type != ChunkStatus.Type.LEVELCHUNK) {
            return null;
        }
        NBTTagCompound \u26032 = nBTTagCompound.func_74775_l("Level");
        if (!\u26032.func_150297_b("Sections", 9)) {
            field_151505_a.error("Chunk file at {},{} is missing block data, skipping", (Object)n, (Object)n2);
            return null;
        }
        Chunk \u26033 = this.func_75823_a(iWorld, \u26032);
        if (!\u26033.func_76600_a(n, n2)) {
            field_151505_a.error("Chunk file at {},{} is in the wrong location; relocating. (Expected {}, {}, got {}, {})", (Object)n, (Object)n2, (Object)n, (Object)n2, (Object)\u26033.field_76635_g, (Object)\u26033.field_76647_h);
            \u26032.func_74768_a("xPos", n);
            \u26032.func_74768_a("zPos", n2);
            \u26033 = this.func_75823_a(iWorld, \u26032);
        }
        return \u26033;
    }

    @Nullable
    protected ChunkPrimer func_202165_b(IWorld iWorld, int n, int n2, NBTTagCompound nBTTagCompound) {
        if (!nBTTagCompound.func_150297_b("Level", 10) || !nBTTagCompound.func_74775_l("Level").func_150297_b("Status", 8)) {
            field_151505_a.error("Chunk file at {},{} is missing level data, skipping", (Object)n, (Object)n2);
            return null;
        }
        ChunkStatus.Type type = this.func_202161_a(nBTTagCompound);
        if (type == ChunkStatus.Type.LEVELCHUNK) {
            return new ChunkPrimerWrapper(this.func_75822_a(iWorld, n, n2, nBTTagCompound));
        }
        NBTTagCompound \u26032 = nBTTagCompound.func_74775_l("Level");
        return this.func_202155_b(iWorld, \u26032);
    }

    @Override
    public void func_75816_a(World world, IChunk iChunk) throws IOException, SessionLockException {
        world.func_72906_B();
        try {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            \u2603 = new NBTTagCompound();
            nBTTagCompound.func_74768_a("DataVersion", 1631);
            ChunkPos \u26032 = iChunk.func_76632_l();
            nBTTagCompound.func_74782_a("Level", \u2603);
            if (iChunk.func_201589_g().func_202129_d() == ChunkStatus.Type.LEVELCHUNK) {
                this.func_75820_a((Chunk)iChunk, world, \u2603);
            } else {
                \u2603 = this.func_208030_a(world, \u26032.field_77276_a, \u26032.field_77275_b);
                if (\u2603 != null && this.func_202161_a(\u2603) == ChunkStatus.Type.LEVELCHUNK) {
                    return;
                }
                this.func_202156_a((ChunkPrimer)iChunk, world, \u2603);
            }
            this.func_75824_a(\u26032, nBTTagCompound);
        }
        catch (Exception exception) {
            field_151505_a.error("Failed to save chunk", (Throwable)exception);
        }
    }

    protected void func_75824_a(ChunkPos chunkPos, NBTTagCompound nBTTagCompound) {
        this.field_75828_a.put(chunkPos, nBTTagCompound);
        ThreadedFileIOBase.func_178779_a().func_75735_a(this);
    }

    @Override
    public boolean func_75814_c() {
        Iterator<Map.Entry<ChunkPos, NBTTagCompound>> iterator = this.field_75828_a.entrySet().iterator();
        if (!iterator.hasNext()) {
            if (this.field_183014_e) {
                field_151505_a.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)this.field_75825_d.getName());
            }
            return false;
        }
        Map.Entry<ChunkPos, NBTTagCompound> \u26032 = iterator.next();
        iterator.remove();
        ChunkPos \u26033 = \u26032.getKey();
        NBTTagCompound \u26034 = \u26032.getValue();
        if (\u26034 == null) {
            return true;
        }
        try {
            DataOutputStream dataOutputStream = RegionFileCache.func_76552_d(this.field_75825_d, \u26033.field_77276_a, \u26033.field_77275_b);
            CompressedStreamTools.func_74800_a(\u26034, dataOutputStream);
            dataOutputStream.close();
            if (this.field_208031_e != null) {
                this.field_208031_e.func_208216_a(\u26033.func_201841_a());
            }
        }
        catch (Exception exception) {
            field_151505_a.error("Failed to save chunk", (Throwable)exception);
        }
        return true;
    }

    private ChunkStatus.Type func_202161_a(@Nullable NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound != null && (\u2603 = ChunkStatus.func_202127_a(nBTTagCompound.func_74775_l("Level").func_74779_i("Status"))) != null) {
            return \u2603.func_202129_d();
        }
        return ChunkStatus.Type.PROTOCHUNK;
    }

    @Override
    public void func_75818_b() {
        try {
            this.field_183014_e = true;
            while (this.func_75814_c()) {
            }
        }
        finally {
            this.field_183014_e = false;
        }
    }

    private void func_202156_a(ChunkPrimer chunkPrimer2, World world, NBTTagCompound nBTTagCompound2) {
        int n = chunkPrimer2.func_76632_l().field_77276_a;
        int n2 = chunkPrimer2.func_76632_l().field_77275_b;
        nBTTagCompound2.func_74768_a("xPos", n);
        nBTTagCompound2.func_74768_a("zPos", n2);
        nBTTagCompound2.func_74772_a("LastUpdate", world.func_82737_E());
        nBTTagCompound2.func_74772_a("InhabitedTime", chunkPrimer2.func_209216_m());
        nBTTagCompound2.func_74778_a("Status", chunkPrimer2.func_201589_g().func_202125_b());
        UpgradeData \u26032 = chunkPrimer2.func_201631_p();
        if (!\u26032.func_196988_a()) {
            nBTTagCompound2.func_74782_a("UpgradeData", \u26032.func_196992_b());
        }
        ChunkSection[] \u26033 = chunkPrimer2.func_76587_i();
        NBTTagList \u26034 = this.func_202159_a(world, \u26033);
        nBTTagCompound2.func_74782_a("Sections", \u26034);
        Biome[] \u26035 = chunkPrimer2.func_201590_e();
        int[] nArray = \u2603 = \u26035 != null ? new int[\u26035.length] : new int[]{};
        if (\u26035 != null) {
            for (\u2603 = 0; \u2603 < \u26035.length; ++\u2603) {
                \u2603[\u2603] = IRegistry.field_212624_m.func_148757_b(\u26035[\u2603]);
            }
        }
        nBTTagCompound2.func_74783_a("Biomes", \u2603);
        NBTTagList \u26036 = new NBTTagList();
        for (NBTTagCompound nBTTagCompound : chunkPrimer2.func_201652_l()) {
            \u26036.add(nBTTagCompound);
        }
        nBTTagCompound2.func_74782_a("Entities", \u26036);
        NBTTagList \u26037 = new NBTTagList();
        for (BlockPos blockPos : chunkPrimer2.func_201638_j()) {
            TileEntity tileEntity = chunkPrimer2.func_175625_s(blockPos);
            if (tileEntity != null) {
                NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
                tileEntity.func_189515_b(nBTTagCompound3);
                \u26037.add(nBTTagCompound3);
                continue;
            }
            \u26037.add(chunkPrimer2.func_201579_g(blockPos));
        }
        nBTTagCompound2.func_74782_a("TileEntities", \u26037);
        nBTTagCompound2.func_74782_a("Lights", AnvilChunkLoader.func_202163_a(chunkPrimer2.func_201647_i()));
        nBTTagCompound2.func_74782_a("PostProcessing", AnvilChunkLoader.func_202163_a(chunkPrimer2.func_201645_n()));
        nBTTagCompound2.func_74782_a("ToBeTicked", ((ChunkPrimerTickList)chunkPrimer2.func_205218_i_()).func_205379_a());
        nBTTagCompound2.func_74782_a("LiquidsToBeTicked", ((ChunkPrimerTickList)chunkPrimer2.func_212247_j()).func_205379_a());
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        for (Heightmap.Type type : chunkPrimer2.func_201634_m()) {
            nBTTagCompound.func_74782_a(type.func_203500_b(), new NBTTagLongArray(chunkPrimer2.func_201642_a(type).func_202269_a()));
        }
        nBTTagCompound2.func_74782_a("Heightmaps", nBTTagCompound);
        NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
        for (GenerationStage.Carving carving : GenerationStage.Carving.values()) {
            nBTTagCompound3.func_74773_a(carving.toString(), chunkPrimer2.func_205749_a(carving).toByteArray());
        }
        nBTTagCompound2.func_74782_a("CarvingMasks", nBTTagCompound3);
        nBTTagCompound2.func_74782_a("Structures", this.func_202160_a(n, n2, chunkPrimer2.func_201609_c(), chunkPrimer2.func_201604_d()));
    }

    private void func_75820_a(Chunk chunk2, World world, NBTTagCompound nBTTagCompound2) {
        nBTTagCompound2.func_74768_a("xPos", chunk2.field_76635_g);
        nBTTagCompound2.func_74768_a("zPos", chunk2.field_76647_h);
        nBTTagCompound2.func_74772_a("LastUpdate", world.func_82737_E());
        nBTTagCompound2.func_74772_a("InhabitedTime", chunk2.func_177416_w());
        nBTTagCompound2.func_74778_a("Status", chunk2.func_201589_g().func_202125_b());
        UpgradeData upgradeData = chunk2.func_196966_y();
        if (!upgradeData.func_196988_a()) {
            nBTTagCompound2.func_74782_a("UpgradeData", upgradeData.func_196992_b());
        }
        ChunkSection[] \u26032 = chunk2.func_76587_i();
        NBTTagList \u26033 = this.func_202159_a(world, \u26032);
        nBTTagCompound2.func_74782_a("Sections", \u26033);
        Biome[] \u26034 = chunk2.func_201590_e();
        int[] \u26035 = new int[\u26034.length];
        for (int i = 0; i < \u26034.length; ++i) {
            \u26035[i] = IRegistry.field_212624_m.func_148757_b(\u26034[i]);
        }
        nBTTagCompound2.func_74783_a("Biomes", \u26035);
        chunk2.func_177409_g(false);
        NBTTagList \u26036 = new NBTTagList();
        for (int i = 0; i < chunk2.func_177429_s().length; ++i) {
            for (Entity entity : chunk2.func_177429_s()[i]) {
                NBTTagCompound nBTTagCompound;
                if (!entity.func_70039_c(nBTTagCompound = new NBTTagCompound())) continue;
                chunk2.func_177409_g(true);
                \u26036.add(nBTTagCompound);
            }
        }
        nBTTagCompound2.func_74782_a("Entities", \u26036);
        NBTTagList \u26037 = new NBTTagList();
        for (BlockPos blockPos : chunk2.func_203066_o()) {
            TileEntity tileEntity = chunk2.func_175625_s(blockPos);
            if (tileEntity != null) {
                NBTTagCompound \u26038 = new NBTTagCompound();
                tileEntity.func_189515_b(\u26038);
                \u26038.func_74757_a("keepPacked", false);
                \u26037.add(\u26038);
                continue;
            }
            NBTTagCompound nBTTagCompound = chunk2.func_201579_g(blockPos);
            if (nBTTagCompound == null) continue;
            nBTTagCompound.func_74757_a("keepPacked", true);
            \u26037.add(nBTTagCompound);
        }
        nBTTagCompound2.func_74782_a("TileEntities", \u26037);
        if (world.func_205220_G_() instanceof ServerTickList) {
            nBTTagCompound2.func_74782_a("TileTicks", ((ServerTickList)world.func_205220_G_()).func_205363_a(chunk2));
        }
        if (world.func_205219_F_() instanceof ServerTickList) {
            nBTTagCompound2.func_74782_a("LiquidTicks", ((ServerTickList)world.func_205219_F_()).func_205363_a(chunk2));
        }
        nBTTagCompound2.func_74782_a("PostProcessing", AnvilChunkLoader.func_202163_a(chunk2.func_201614_D()));
        if (chunk2.func_205218_i_() instanceof ChunkPrimerTickList) {
            nBTTagCompound2.func_74782_a("ToBeTicked", ((ChunkPrimerTickList)chunk2.func_205218_i_()).func_205379_a());
        }
        if (chunk2.func_212247_j() instanceof ChunkPrimerTickList) {
            nBTTagCompound2.func_74782_a("LiquidsToBeTicked", ((ChunkPrimerTickList)chunk2.func_212247_j()).func_205379_a());
        }
        NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
        for (Heightmap.Type type : chunk2.func_201615_v()) {
            if (type.func_207512_c() != Heightmap.Usage.LIVE_WORLD) continue;
            nBTTagCompound3.func_74782_a(type.func_203500_b(), new NBTTagLongArray(chunk2.func_201608_a(type).func_202269_a()));
        }
        nBTTagCompound2.func_74782_a("Heightmaps", nBTTagCompound3);
        nBTTagCompound2.func_74782_a("Structures", this.func_202160_a(chunk2.field_76635_g, chunk2.field_76647_h, chunk2.func_201609_c(), chunk2.func_201604_d()));
    }

    private Chunk func_75823_a(IWorld iWorld, NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        Object \u26034;
        int n = nBTTagCompound2.func_74762_e("xPos");
        \u2603 = nBTTagCompound2.func_74762_e("zPos");
        Biome[] \u26032 = new Biome[256];
        BlockPos.MutableBlockPos \u26033 = new BlockPos.MutableBlockPos();
        if (nBTTagCompound2.func_150297_b("Biomes", 11)) {
            \u26034 = nBTTagCompound2.func_74759_k("Biomes");
            for (int i = 0; i < ((int[])\u26034).length; ++i) {
                \u26032[i] = IRegistry.field_212624_m.func_148754_a(\u26034[i]);
                if (\u26032[i] != null) continue;
                \u26032[i] = iWorld.func_72863_F().func_201711_g().func_202090_b().func_180300_a(\u26033.func_181079_c((i & 0xF) + (n << 4), 0, (i >> 4 & 0xF) + (\u2603 << 4)), Biomes.field_76772_c);
            }
        } else {
            for (int i = 0; i < \u26032.length; ++i) {
                \u26032[i] = iWorld.func_72863_F().func_201711_g().func_202090_b().func_180300_a(\u26033.func_181079_c((i & 0xF) + (n << 4), 0, (i >> 4 & 0xF) + (\u2603 << 4)), Biomes.field_76772_c);
            }
        }
        \u26034 = nBTTagCompound2.func_150297_b("UpgradeData", 10) ? new UpgradeData(nBTTagCompound2.func_74775_l("UpgradeData")) : UpgradeData.field_196994_a;
        ChunkPrimerTickList<Block> \u26035 = new ChunkPrimerTickList<Block>(block -> block.func_176223_P().func_196958_f(), IRegistry.field_212618_g::func_177774_c, IRegistry.field_212618_g::func_82594_a, new ChunkPos(n, \u2603));
        ChunkPrimerTickList<Fluid> \u26036 = new ChunkPrimerTickList<Fluid>(fluid -> fluid == Fluids.field_204541_a, IRegistry.field_212619_h::func_177774_c, IRegistry.field_212619_h::func_82594_a, new ChunkPos(n, \u2603));
        long \u26037 = nBTTagCompound2.func_74763_f("InhabitedTime");
        Chunk \u26038 = new Chunk(iWorld.func_201672_e(), n, \u2603, \u26032, (UpgradeData)\u26034, \u26035, \u26036, \u26037);
        \u26038.func_201613_c(nBTTagCompound2.func_74779_i("Status"));
        NBTTagList \u26039 = nBTTagCompound2.func_150295_c("Sections", 10);
        \u26038.func_76602_a(this.func_202158_a(iWorld, \u26039));
        \u2603 = nBTTagCompound2.func_74775_l("Heightmaps");
        for (Object object : Heightmap.Type.values()) {
            if (object.func_207512_c() != Heightmap.Usage.LIVE_WORLD) continue;
            String string = object.func_203500_b();
            if (\u2603.func_150297_b(string, 12)) {
                \u26038.func_201607_a((Heightmap.Type)((Object)object), \u2603.func_197645_o(string));
                continue;
            }
            \u26038.func_201608_a((Heightmap.Type)((Object)object)).func_202266_a();
        }
        \u2603 = nBTTagCompound2.func_74775_l("Structures");
        \u26038.func_201612_a(this.func_202162_c(iWorld, \u2603));
        \u26038.func_201606_b(this.func_202167_b(\u2603));
        NBTTagList \u260310 = nBTTagCompound2.func_150295_c("PostProcessing", 9);
        for (int i = 0; i < \u260310.size(); ++i) {
            Object object;
            object = \u260310.func_202169_e(i);
            for (int j = 0; j < ((NBTTagList)object).size(); ++j) {
                \u26038.func_201610_a(((NBTTagList)object).func_202170_f(j), i);
            }
        }
        \u26035.func_205380_a(nBTTagCompound2.func_150295_c("ToBeTicked", 9));
        \u26036.func_205380_a(nBTTagCompound2.func_150295_c("LiquidsToBeTicked", 9));
        if (nBTTagCompound2.func_74767_n("shouldSave")) {
            \u26038.func_177427_f(true);
        }
        return \u26038;
    }

    private void func_199814_a(NBTTagCompound nBTTagCompound2, Chunk chunk) {
        NBTTagCompound nBTTagCompound2;
        NBTTagList nBTTagList = nBTTagCompound2.func_150295_c("Entities", 10);
        World \u26032 = chunk.func_177412_p();
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound3 = nBTTagList.func_150305_b(i);
            AnvilChunkLoader.func_186050_a(nBTTagCompound3, \u26032, chunk);
            chunk.func_177409_g(true);
        }
        NBTTagList \u26033 = nBTTagCompound2.func_150295_c("TileEntities", 10);
        for (int i = 0; i < \u26033.size(); ++i) {
            NBTTagCompound nBTTagCompound4 = \u26033.func_150305_b(i);
            boolean \u26034 = nBTTagCompound4.func_74767_n("keepPacked");
            if (\u26034) {
                chunk.func_201591_a(nBTTagCompound4);
                continue;
            }
            TileEntity \u26035 = TileEntity.func_203403_c(nBTTagCompound4);
            if (\u26035 == null) continue;
            chunk.func_150813_a(\u26035);
        }
        if (nBTTagCompound2.func_150297_b("TileTicks", 9) && \u26032.func_205220_G_() instanceof ServerTickList) {
            ((ServerTickList)\u26032.func_205220_G_()).func_205369_a(nBTTagCompound2.func_150295_c("TileTicks", 10));
        }
        if (nBTTagCompound2.func_150297_b("LiquidTicks", 9) && \u26032.func_205219_F_() instanceof ServerTickList) {
            ((ServerTickList)\u26032.func_205219_F_()).func_205369_a(nBTTagCompound2.func_150295_c("LiquidTicks", 10));
        }
    }

    private ChunkPrimer func_202155_b(IWorld iWorld, NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        Object \u26034;
        int n = nBTTagCompound2.func_74762_e("xPos");
        \u2603 = nBTTagCompound2.func_74762_e("zPos");
        Biome[] \u26032 = new Biome[256];
        BlockPos.MutableBlockPos \u26033 = new BlockPos.MutableBlockPos();
        if (nBTTagCompound2.func_150297_b("Biomes", 11)) {
            \u26034 = nBTTagCompound2.func_74759_k("Biomes");
            for (int i = 0; i < ((int[])\u26034).length; ++i) {
                \u26032[i] = IRegistry.field_212624_m.func_148754_a(\u26034[i]);
                if (\u26032[i] != null) continue;
                \u26032[i] = iWorld.func_72863_F().func_201711_g().func_202090_b().func_180300_a(\u26033.func_181079_c((i & 0xF) + (n << 4), 0, (i >> 4 & 0xF) + (\u2603 << 4)), Biomes.field_76772_c);
            }
        } else {
            for (int i = 0; i < \u26032.length; ++i) {
                \u26032[i] = iWorld.func_72863_F().func_201711_g().func_202090_b().func_180300_a(\u26033.func_181079_c((i & 0xF) + (n << 4), 0, (i >> 4 & 0xF) + (\u2603 << 4)), Biomes.field_76772_c);
            }
        }
        \u26034 = nBTTagCompound2.func_150297_b("UpgradeData", 10) ? new UpgradeData(nBTTagCompound2.func_74775_l("UpgradeData")) : UpgradeData.field_196994_a;
        ChunkPrimer \u26035 = new ChunkPrimer(n, \u2603, (UpgradeData)\u26034);
        \u26035.func_201577_a(\u26032);
        \u26035.func_209215_b(nBTTagCompound2.func_74763_f("InhabitedTime"));
        \u26035.func_201650_c(nBTTagCompound2.func_74779_i("Status"));
        NBTTagList \u26036 = nBTTagCompound2.func_150295_c("Sections", 10);
        \u26035.func_201630_a(this.func_202158_a(iWorld, \u26036));
        NBTTagList \u26037 = nBTTagCompound2.func_150295_c("Entities", 10);
        for (int i = 0; i < \u26037.size(); ++i) {
            \u26035.func_201626_b(\u26037.func_150305_b(i));
        }
        NBTTagList \u26038 = nBTTagCompound2.func_150295_c("TileEntities", 10);
        for (int i = 0; i < \u26038.size(); ++i) {
            NBTTagCompound nBTTagCompound3 = \u26038.func_150305_b(i);
            \u26035.func_201591_a(nBTTagCompound3);
        }
        NBTTagList \u26039 = nBTTagCompound2.func_150295_c("Lights", 9);
        for (int i = 0; i < \u26039.size(); ++i) {
            NBTTagList nBTTagList = \u26039.func_202169_e(i);
            for (int j = 0; j < nBTTagList.size(); ++j) {
                \u26035.func_201646_a(nBTTagList.func_202170_f(j), i);
            }
        }
        NBTTagList \u260310 = nBTTagCompound2.func_150295_c("PostProcessing", 9);
        for (int i = 0; i < \u260310.size(); ++i) {
            NBTTagList nBTTagList = \u260310.func_202169_e(i);
            for (int j = 0; j < nBTTagList.size(); ++j) {
                \u26035.func_201636_b(nBTTagList.func_202170_f(j), i);
            }
        }
        ((ChunkPrimerTickList)\u26035.func_205218_i_()).func_205380_a(nBTTagCompound2.func_150295_c("ToBeTicked", 9));
        ((ChunkPrimerTickList)\u26035.func_212247_j()).func_205380_a(nBTTagCompound2.func_150295_c("LiquidsToBeTicked", 9));
        \u2603 = nBTTagCompound2.func_74775_l("Heightmaps");
        for (String string : \u2603.func_150296_c()) {
            \u26035.func_201643_a(Heightmap.Type.func_203501_a(string), \u2603.func_197645_o(string));
        }
        nBTTagList = nBTTagCompound2.func_74775_l("Structures");
        \u26035.func_201648_a(this.func_202162_c(iWorld, nBTTagList));
        \u26035.func_201641_b(this.func_202167_b(nBTTagList));
        \u2603 = nBTTagCompound2.func_74775_l("CarvingMasks");
        for (String string : \u2603.func_150296_c()) {
            GenerationStage.Carving carving = GenerationStage.Carving.valueOf(string);
            \u26035.func_205767_a(carving, BitSet.valueOf(\u2603.func_74770_j(string)));
        }
        return \u26035;
    }

    private NBTTagList func_202159_a(World world, ChunkSection[] chunkSectionArray) {
        NBTTagList nBTTagList = new NBTTagList();
        boolean \u26032 = world.field_73011_w.func_191066_m();
        for (ChunkSection chunkSection : chunkSectionArray) {
            if (chunkSection == Chunk.field_186036_a) continue;
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74774_a("Y", (byte)(chunkSection.func_76662_d() >> 4 & 0xFF));
            chunkSection.func_186049_g().func_196963_b(nBTTagCompound, "Palette", "BlockStates");
            nBTTagCompound.func_74773_a("BlockLight", chunkSection.func_76661_k().func_177481_a());
            if (\u26032) {
                nBTTagCompound.func_74773_a("SkyLight", chunkSection.func_76671_l().func_177481_a());
            } else {
                nBTTagCompound.func_74773_a("SkyLight", new byte[chunkSection.func_76661_k().func_177481_a().length]);
            }
            nBTTagList.add(nBTTagCompound);
        }
        return nBTTagList;
    }

    private ChunkSection[] func_202158_a(IWorldReaderBase iWorldReaderBase, NBTTagList nBTTagList) {
        int n = 16;
        ChunkSection[] \u26032 = new ChunkSection[16];
        boolean \u26033 = iWorldReaderBase.func_201675_m().func_191066_m();
        for (\u2603 = 0; \u2603 < nBTTagList.size(); ++\u2603) {
            NBTTagCompound nBTTagCompound = nBTTagList.func_150305_b(\u2603);
            byte \u26034 = nBTTagCompound.func_74771_c("Y");
            ChunkSection \u26035 = new ChunkSection(\u26034 << 4, \u26033);
            \u26035.func_186049_g().func_196964_a(nBTTagCompound, "Palette", "BlockStates");
            \u26035.func_76659_c(new NibbleArray(nBTTagCompound.func_74770_j("BlockLight")));
            if (\u26033) {
                \u26035.func_76666_d(new NibbleArray(nBTTagCompound.func_74770_j("SkyLight")));
            }
            \u26035.func_76672_e();
            \u26032[\u26034] = \u26035;
        }
        return \u26032;
    }

    private NBTTagCompound func_202160_a(int n, int n2, Map<String, StructureStart> map, Map<String, LongSet> map2) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        \u2603 = new NBTTagCompound();
        for (Map.Entry<String, StructureStart> entry : map.entrySet()) {
            \u2603.func_74782_a(entry.getKey(), entry.getValue().func_143021_a(n, n2));
        }
        nBTTagCompound.func_74782_a("Starts", \u2603);
        \u2603 = new NBTTagCompound();
        for (Map.Entry<String, LongSet> entry : map2.entrySet()) {
            \u2603.func_74782_a(entry.getKey(), new NBTTagLongArray(entry.getValue()));
        }
        nBTTagCompound.func_74782_a("References", \u2603);
        return nBTTagCompound;
    }

    private Map<String, StructureStart> func_202162_c(IWorld iWorld, NBTTagCompound nBTTagCompound) {
        HashMap hashMap = Maps.newHashMap();
        NBTTagCompound \u26032 = nBTTagCompound.func_74775_l("Starts");
        for (String string : \u26032.func_150296_c()) {
            hashMap.put(string, StructureIO.func_202602_a(\u26032.func_74775_l(string), iWorld));
        }
        return hashMap;
    }

    private Map<String, LongSet> func_202167_b(NBTTagCompound nBTTagCompound) {
        HashMap hashMap = Maps.newHashMap();
        NBTTagCompound \u26032 = nBTTagCompound.func_74775_l("References");
        for (String string : \u26032.func_150296_c()) {
            hashMap.put(string, new LongOpenHashSet(\u26032.func_197645_o(string)));
        }
        return hashMap;
    }

    public static NBTTagList func_202163_a(ShortList[] shortListArray) {
        NBTTagList nBTTagList = new NBTTagList();
        for (ShortList shortList : shortListArray) {
            NBTTagList nBTTagList2 = new NBTTagList();
            if (shortList != null) {
                for (Short s : shortList) {
                    nBTTagList2.add(new NBTTagShort(s));
                }
            }
            nBTTagList.add(nBTTagList2);
        }
        return nBTTagList;
    }

    @Nullable
    private static Entity func_206240_a(NBTTagCompound nBTTagCompound, World world, Function<Entity, Entity> function) {
        Entity entity = AnvilChunkLoader.func_186053_a(nBTTagCompound, world);
        if (entity == null) {
            return null;
        }
        if ((entity = function.apply(entity)) != null && nBTTagCompound.func_150297_b("Passengers", 9)) {
            NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Passengers", 10);
            for (int i = 0; i < nBTTagList.size(); ++i) {
                Entity entity2 = AnvilChunkLoader.func_206240_a(nBTTagList.func_150305_b(i), world, function);
                if (entity2 == null) continue;
                entity2.func_184205_a(entity, true);
            }
        }
        return entity;
    }

    @Nullable
    public static Entity func_186050_a(NBTTagCompound nBTTagCompound, World world, Chunk chunk) {
        return AnvilChunkLoader.func_206240_a(nBTTagCompound, world, entity -> {
            chunk.func_76612_a((Entity)entity);
            return entity;
        });
    }

    @Nullable
    public static Entity func_186054_a(NBTTagCompound nBTTagCompound, World world, double d, double d2, double d3, boolean bl) {
        return AnvilChunkLoader.func_206240_a(nBTTagCompound, world, entity -> {
            entity.func_70012_b(d, d2, d3, entity.field_70177_z, entity.field_70125_A);
            if (bl && !world.func_72838_d((Entity)entity)) {
                return null;
            }
            return entity;
        });
    }

    @Nullable
    public static Entity func_186051_a(NBTTagCompound nBTTagCompound, World world, boolean bl) {
        return AnvilChunkLoader.func_206240_a(nBTTagCompound, world, entity -> {
            if (bl && !world.func_72838_d((Entity)entity)) {
                return null;
            }
            return entity;
        });
    }

    @Nullable
    protected static Entity func_186053_a(NBTTagCompound nBTTagCompound, World world) {
        try {
            return EntityType.func_200716_a(nBTTagCompound, world);
        }
        catch (RuntimeException runtimeException) {
            field_151505_a.warn("Exception loading entity: ", (Throwable)runtimeException);
            return null;
        }
    }

    public static void func_186052_a(Entity entity, IWorld iWorld) {
        if (iWorld.func_72838_d(entity) && entity.func_184207_aI()) {
            for (Entity entity2 : entity.func_184188_bt()) {
                AnvilChunkLoader.func_186052_a(entity2, iWorld);
            }
        }
    }

    public boolean func_212147_a(ChunkPos chunkPos, DimensionType dimensionType, WorldSavedDataStorage worldSavedDataStorage) {
        boolean bl = false;
        try {
            this.func_212146_a(dimensionType, worldSavedDataStorage, chunkPos.field_77276_a, chunkPos.field_77275_b);
            while (this.func_75814_c()) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }
}

