/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStemGrown;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumDirection8;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpgradeData {
    private static final Logger field_209162_b = LogManager.getLogger();
    public static final UpgradeData field_196994_a = new UpgradeData();
    private static final EnumDirection8[] field_208832_b = EnumDirection8.values();
    private final EnumSet<EnumDirection8> field_196995_b = EnumSet.noneOf(EnumDirection8.class);
    private final int[][] field_196996_c = new int[16][];
    private static final Map<Block, IBlockFixer> field_196997_d = new IdentityHashMap<Block, IBlockFixer>();
    private static final Set<IBlockFixer> field_208833_f = Sets.newHashSet();

    private UpgradeData() {
    }

    public UpgradeData(NBTTagCompound nBTTagCompound2) {
        this();
        NBTTagCompound nBTTagCompound2;
        if (nBTTagCompound2.func_150297_b("Indices", 10)) {
            \u2603 = nBTTagCompound2.func_74775_l("Indices");
            for (int i = 0; i < this.field_196996_c.length; ++i) {
                String string = String.valueOf(i);
                if (!\u2603.func_150297_b(string, 11)) continue;
                this.field_196996_c[i] = \u2603.func_74759_k(string);
            }
        }
        int \u26032 = nBTTagCompound2.func_74762_e("Sides");
        for (EnumDirection8 enumDirection8 : EnumDirection8.values()) {
            if ((\u26032 & 1 << enumDirection8.ordinal()) == 0) continue;
            this.field_196995_b.add(enumDirection8);
        }
    }

    public void func_196990_a(Chunk chunk2) {
        Chunk chunk2;
        this.func_196989_a(chunk2);
        for (EnumDirection8 enumDirection8 : field_208832_b) {
            UpgradeData.func_196991_a(chunk2, enumDirection8);
        }
        World \u26032 = chunk2.func_177412_p();
        field_208833_f.forEach(iBlockFixer -> iBlockFixer.func_208826_a(\u26032));
    }

    private static void func_196991_a(Chunk chunk, EnumDirection8 enumDirection8) {
        World world = chunk.func_177412_p();
        if (!chunk.func_196966_y().field_196995_b.remove((Object)enumDirection8)) {
            return;
        }
        Set<EnumFacing> \u26032 = enumDirection8.func_197532_a();
        boolean \u26033 = false;
        int \u26034 = 15;
        boolean \u26035 = \u26032.contains(EnumFacing.EAST);
        boolean \u26036 = \u26032.contains(EnumFacing.WEST);
        boolean \u26037 = \u26032.contains(EnumFacing.SOUTH);
        boolean \u26038 = \u26032.contains(EnumFacing.NORTH);
        boolean \u26039 = \u26032.size() == 1;
        int \u260310 = (chunk.field_76635_g << 4) + (\u26039 && (\u26038 || \u26037) ? 1 : (\u26036 ? 0 : 15));
        int \u260311 = (chunk.field_76635_g << 4) + (\u26039 && (\u26038 || \u26037) ? 14 : (\u26036 ? 0 : 15));
        int \u260312 = (chunk.field_76647_h << 4) + (\u26039 && (\u26035 || \u26036) ? 1 : (\u26038 ? 0 : 15));
        int \u260313 = (chunk.field_76647_h << 4) + (\u26039 && (\u26035 || \u26036) ? 14 : (\u26038 ? 0 : 15));
        EnumFacing[] \u260314 = EnumFacing.values();
        BlockPos.MutableBlockPos \u260315 = new BlockPos.MutableBlockPos();
        for (BlockPos.MutableBlockPos mutableBlockPos : BlockPos.func_191531_b(\u260310, 0, \u260312, \u260311, world.func_72800_K() - 1, \u260313)) {
            IBlockState iBlockState;
            IBlockState iBlockState2 = iBlockState = world.func_180495_p(mutableBlockPos);
            for (EnumFacing enumFacing : \u260314) {
                \u260315.func_189533_g(mutableBlockPos).func_189536_c(enumFacing);
                iBlockState2 = UpgradeData.func_196987_a(iBlockState2, enumFacing, world, mutableBlockPos, \u260315);
            }
            Block.func_196263_a(iBlockState, iBlockState2, world, mutableBlockPos, 18);
        }
    }

    private static IBlockState func_196987_a(IBlockState iBlockState, EnumFacing enumFacing, IWorld iWorld, BlockPos.MutableBlockPos mutableBlockPos, BlockPos.MutableBlockPos mutableBlockPos2) {
        return field_196997_d.getOrDefault(iBlockState.func_177230_c(), BlockFixers.DEFAULT).func_196982_a(iBlockState, enumFacing, iWorld.func_180495_p(mutableBlockPos2), iWorld, mutableBlockPos, mutableBlockPos2);
    }

    private void func_196989_a(Chunk chunk) {
        try (BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            pooledMutableBlockPos2 = BlockPos.PooledMutableBlockPos.func_185346_s();
            Throwable throwable = null;
            try {
                int n;
                World world = chunk.func_177412_p();
                for (n = 0; n < 16; ++n) {
                    ChunkSection chunkSection = chunk.func_76587_i()[n];
                    int[] \u26032 = this.field_196996_c[n];
                    this.field_196996_c[n] = null;
                    if (chunkSection == null || \u26032 == null || \u26032.length <= 0) continue;
                    EnumFacing[] \u26033 = EnumFacing.values();
                    BlockStateContainer<IBlockState> \u26034 = chunkSection.func_186049_g();
                    for (int n2 : \u26032) {
                        IBlockState iBlockState;
                        \u2603 = n2 & 0xF;
                        \u2603 = n2 >> 8 & 0xF;
                        \u2603 = n2 >> 4 & 0xF;
                        pooledMutableBlockPos.func_181079_c(\u2603 + (chunk.field_76635_g << 4), \u2603 + (n << 4), \u2603 + (chunk.field_76647_h << 4));
                        IBlockState iBlockState2 = iBlockState = \u26034.func_186015_a(n2);
                        for (EnumFacing enumFacing : \u26033) {
                            pooledMutableBlockPos2.func_189533_g(pooledMutableBlockPos).func_189536_c(enumFacing);
                            if (pooledMutableBlockPos.func_177958_n() >> 4 != chunk.field_76635_g || pooledMutableBlockPos.func_177952_p() >> 4 != chunk.field_76647_h) continue;
                            iBlockState2 = UpgradeData.func_196987_a(iBlockState2, enumFacing, world, pooledMutableBlockPos, pooledMutableBlockPos2);
                        }
                        Block.func_196263_a(iBlockState, iBlockState2, world, pooledMutableBlockPos, 18);
                    }
                }
                for (n = 0; n < this.field_196996_c.length; ++n) {
                    if (this.field_196996_c[n] != null) {
                        field_209162_b.warn("Discarding update data for section {} for chunk ({} {})", (Object)n, (Object)chunk.field_76635_g, (Object)chunk.field_76647_h);
                    }
                    this.field_196996_c[n] = null;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                BlockPos.PooledMutableBlockPos pooledMutableBlockPos2;
                if (pooledMutableBlockPos2 != null) {
                    if (throwable != null) {
                        try {
                            pooledMutableBlockPos2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        pooledMutableBlockPos2.close();
                    }
                }
            }
        }
    }

    public boolean func_196988_a() {
        for (int[] nArray : this.field_196996_c) {
            if (nArray == null) continue;
            return false;
        }
        return this.field_196995_b.isEmpty();
    }

    public NBTTagCompound func_196992_b() {
        NBTTagCompound nBTTagCompound;
        int \u26032;
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound = new NBTTagCompound();
        for (\u26032 = 0; \u26032 < this.field_196996_c.length; ++\u26032) {
            String string = String.valueOf(\u26032);
            if (this.field_196996_c[\u26032] == null || this.field_196996_c[\u26032].length == 0) continue;
            nBTTagCompound.func_74783_a(string, this.field_196996_c[\u26032]);
        }
        if (!nBTTagCompound.isEmpty()) {
            nBTTagCompound2.func_74782_a("Indices", nBTTagCompound);
        }
        \u26032 = 0;
        for (EnumDirection8 enumDirection8 : this.field_196995_b) {
            \u26032 |= 1 << enumDirection8.ordinal();
        }
        nBTTagCompound2.func_74774_a("Sides", (byte)\u26032);
        return nBTTagCompound2;
    }

    static enum BlockFixers implements IBlockFixer
    {
        BLACKLIST(new Block[]{Blocks.field_190976_dk, Blocks.field_150427_aO, Blocks.field_196860_iS, Blocks.field_196862_iT, Blocks.field_196864_iU, Blocks.field_196866_iV, Blocks.field_196868_iW, Blocks.field_196870_iX, Blocks.field_196872_iY, Blocks.field_196874_iZ, Blocks.field_196877_ja, Blocks.field_196878_jb, Blocks.field_196879_jc, Blocks.field_196880_jd, Blocks.field_196881_je, Blocks.field_196882_jf, Blocks.field_196883_jg, Blocks.field_196884_jh, Blocks.field_150467_bQ, Blocks.field_196717_eY, Blocks.field_196718_eZ, Blocks.field_150380_bt, Blocks.field_150351_n, Blocks.field_150354_m, Blocks.field_196611_F, Blocks.field_196649_cc, Blocks.field_150444_as}){

            @Override
            public IBlockState func_196982_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
                return iBlockState;
            }
        }
        ,
        DEFAULT(new Block[0]){

            @Override
            public IBlockState func_196982_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
                return iBlockState.func_196956_a(enumFacing, iWorld.func_180495_p(blockPos2), iWorld, blockPos, blockPos2);
            }
        }
        ,
        CHEST(new Block[]{Blocks.field_150486_ae, Blocks.field_150447_bR}){

            @Override
            public IBlockState func_196982_a(IBlockState iBlockState3, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
                IBlockState iBlockState3;
                if (iBlockState2.func_177230_c() == iBlockState3.func_177230_c() && enumFacing.func_176740_k().func_176722_c() && iBlockState3.func_177229_b(BlockChest.field_196314_b) == ChestType.SINGLE && iBlockState2.func_177229_b(BlockChest.field_196314_b) == ChestType.SINGLE) {
                    EnumFacing enumFacing2 = iBlockState3.func_177229_b(BlockChest.field_176459_a);
                    if (enumFacing.func_176740_k() != enumFacing2.func_176740_k() && enumFacing2 == iBlockState2.func_177229_b(BlockChest.field_176459_a)) {
                        ChestType chestType = enumFacing == enumFacing2.func_176746_e() ? ChestType.LEFT : ChestType.RIGHT;
                        iWorld.func_180501_a(blockPos2, (IBlockState)iBlockState2.func_206870_a(BlockChest.field_196314_b, chestType.func_208081_a()), 18);
                        if (enumFacing2 == EnumFacing.NORTH || enumFacing2 == EnumFacing.EAST) {
                            TileEntity tileEntity = iWorld.func_175625_s(blockPos);
                            \u2603 = iWorld.func_175625_s(blockPos2);
                            if (tileEntity instanceof TileEntityChest && \u2603 instanceof TileEntityChest) {
                                TileEntityChest.func_199722_a((TileEntityChest)tileEntity, (TileEntityChest)\u2603);
                            }
                        }
                        return (IBlockState)iBlockState3.func_206870_a(BlockChest.field_196314_b, chestType);
                    }
                }
                return iBlockState3;
            }
        }
        ,
        LEAVES(true, new Block[]{Blocks.field_196572_aa, Blocks.field_196647_Y, Blocks.field_196574_ab, Blocks.field_196648_Z, Blocks.field_196642_W, Blocks.field_196645_X}){
            private final ThreadLocal<List<ObjectSet<BlockPos>>> field_208828_g = ThreadLocal.withInitial(() -> Lists.newArrayListWithCapacity((int)7));

            @Override
            public IBlockState func_196982_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
                IBlockState iBlockState3 = iBlockState.func_196956_a(enumFacing, iWorld.func_180495_p(blockPos2), iWorld, blockPos, blockPos2);
                if (iBlockState != iBlockState3) {
                    int n = iBlockState3.func_177229_b(BlockStateProperties.field_208514_aa);
                    List<ObjectSet<BlockPos>> \u26032 = this.field_208828_g.get();
                    if (\u26032.isEmpty()) {
                        for (\u2603 = 0; \u2603 < 7; ++\u2603) {
                            \u26032.add((ObjectSet<BlockPos>)new ObjectOpenHashSet());
                        }
                    }
                    \u26032.get(n).add((Object)blockPos.func_185334_h());
                }
                return iBlockState;
            }

            @Override
            public void func_208826_a(IWorld iWorld) {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                List<ObjectSet<BlockPos>> \u26032 = this.field_208828_g.get();
                for (int i = 2; i < \u26032.size(); ++i) {
                    \u2603 = i - 1;
                    ObjectSet<BlockPos> objectSet = \u26032.get(\u2603);
                    \u2603 = \u26032.get(i);
                    for (BlockPos blockPos : objectSet) {
                        IBlockState iBlockState = iWorld.func_180495_p(blockPos);
                        if (iBlockState.func_177229_b(BlockStateProperties.field_208514_aa) < \u2603) continue;
                        iWorld.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(BlockStateProperties.field_208514_aa, \u2603), 18);
                        if (i == 7) continue;
                        for (EnumFacing enumFacing : field_208827_f) {
                            mutableBlockPos.func_189533_g(blockPos).func_189536_c(enumFacing);
                            IBlockState iBlockState2 = iWorld.func_180495_p(mutableBlockPos);
                            if (!iBlockState2.func_196959_b(BlockStateProperties.field_208514_aa) || iBlockState.func_177229_b(BlockStateProperties.field_208514_aa) <= i) continue;
                            \u2603.add((Object)mutableBlockPos.func_185334_h());
                        }
                    }
                }
                \u26032.clear();
            }
        }
        ,
        STEM_BLOCK(new Block[]{Blocks.field_150394_bc, Blocks.field_150393_bb}){

            @Override
            public IBlockState func_196982_a(IBlockState iBlockState3, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
                IBlockState iBlockState3;
                if (iBlockState3.func_177229_b(BlockStem.field_176484_a) == 7) {
                    BlockStemGrown blockStemGrown = ((BlockStem)iBlockState3.func_177230_c()).func_208486_d();
                    if (iBlockState2.func_177230_c() == blockStemGrown) {
                        return (IBlockState)blockStemGrown.func_196523_e().func_176223_P().func_206870_a(BlockHorizontal.field_185512_D, enumFacing);
                    }
                }
                return iBlockState3;
            }
        };

        public static final EnumFacing[] field_208827_f;

        private BlockFixers(Block ... blockArray) {
            this(false, blockArray);
        }

        private BlockFixers(boolean bl2, Block ... blockArray) {
            boolean bl2;
            for (Block block : blockArray) {
                field_196997_d.put(block, this);
            }
            if (bl2) {
                field_208833_f.add(this);
            }
        }

        static {
            field_208827_f = EnumFacing.values();
        }
    }

    public static interface IBlockFixer {
        public IBlockState func_196982_a(IBlockState var1, EnumFacing var2, IBlockState var3, IWorld var4, BlockPos var5, BlockPos var6);

        default public void func_208826_a(IWorld iWorld) {
        }
    }
}

