/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.INpc;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockAction;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.network.play.server.SPacketSpawnGlobalEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.ScoreboardSaveData;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.VillageCollection;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.ServerTickList;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.BonusChestFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedDataCallableSave;
import net.minecraft.world.storage.WorldSavedDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldServer
extends World
implements IThreadListener {
    private static final Logger field_147491_a = LogManager.getLogger();
    private final MinecraftServer field_73061_a;
    private final EntityTracker field_73062_L;
    private final PlayerChunkMap field_73063_M;
    private final Map<UUID, Entity> field_175741_N = Maps.newHashMap();
    public boolean field_73058_d;
    private boolean field_73068_P;
    private int field_80004_Q;
    private final Teleporter field_85177_Q;
    private final WorldEntitySpawner field_175742_R = new WorldEntitySpawner();
    private final ServerTickList<Block> field_94579_S = new ServerTickList<Block>(this, block -> block == null || block.func_176223_P().func_196958_f(), IRegistry.field_212618_g::func_177774_c, IRegistry.field_212618_g::func_82594_a, this::func_205338_b);
    private final ServerTickList<Fluid> field_205342_P = new ServerTickList<Fluid>(this, fluid -> fluid == null || fluid == Fluids.field_204541_a, IRegistry.field_212619_h::func_177774_c, IRegistry.field_212619_h::func_82594_a, this::func_205339_a);
    protected final VillageSiege field_175740_d = new VillageSiege(this);
    ObjectLinkedOpenHashSet<BlockEventData> field_147490_S = new ObjectLinkedOpenHashSet();
    private boolean field_211159_Q;

    public WorldServer(MinecraftServer minecraftServer, ISaveHandler iSaveHandler, WorldSavedDataStorage worldSavedDataStorage, WorldInfo worldInfo, DimensionType dimensionType, Profiler profiler) {
        super(iSaveHandler, worldSavedDataStorage, worldInfo, dimensionType.func_186070_d(), profiler, false);
        this.field_73061_a = minecraftServer;
        this.field_73062_L = new EntityTracker(this);
        this.field_73063_M = new PlayerChunkMap(this);
        this.field_73011_w.func_76558_a(this);
        this.field_73020_y = this.func_72970_h();
        this.field_85177_Q = new Teleporter(this);
        this.func_72966_v();
        this.func_72947_a();
        this.func_175723_af().func_177725_a(minecraftServer.func_175580_aG());
    }

    public WorldServer func_212251_i__() {
        String string = VillageCollection.func_176062_a(this.field_73011_w);
        VillageCollection \u26032 = this.func_212411_a(DimensionType.OVERWORLD, VillageCollection::new, string);
        if (\u26032 == null) {
            this.field_72982_D = new VillageCollection(this);
            this.func_212409_a(DimensionType.OVERWORLD, string, this.field_72982_D);
        } else {
            this.field_72982_D = \u26032;
            this.field_72982_D.func_82566_a(this);
        }
        ScoreboardSaveData \u26033 = this.func_212411_a(DimensionType.OVERWORLD, ScoreboardSaveData::new, "scoreboard");
        if (\u26033 == null) {
            \u26033 = new ScoreboardSaveData();
            this.func_212409_a(DimensionType.OVERWORLD, "scoreboard", \u26033);
        }
        \u26033.func_96499_a(this.field_73061_a.func_200251_aP());
        this.field_73061_a.func_200251_aP().func_186684_a(new WorldSavedDataCallableSave(\u26033));
        this.func_175723_af().func_177739_c(this.field_72986_A.func_176120_C(), this.field_72986_A.func_176126_D());
        this.func_175723_af().func_177744_c(this.field_72986_A.func_176140_I());
        this.func_175723_af().func_177724_b(this.field_72986_A.func_176138_H());
        this.func_175723_af().func_177747_c(this.field_72986_A.func_176131_J());
        this.func_175723_af().func_177723_b(this.field_72986_A.func_176139_K());
        if (this.field_72986_A.func_176134_F() > 0L) {
            this.func_175723_af().func_177738_a(this.field_72986_A.func_176137_E(), this.field_72986_A.func_176132_G(), this.field_72986_A.func_176134_F());
        } else {
            this.func_175723_af().func_177750_a(this.field_72986_A.func_176137_E());
        }
        return this;
    }

    @Override
    public void func_72835_b(BooleanSupplier booleanSupplier2) {
        BooleanSupplier booleanSupplier2;
        this.field_211159_Q = true;
        super.func_72835_b(booleanSupplier2);
        if (this.func_72912_H().func_76093_s() && this.func_175659_aa() != EnumDifficulty.HARD) {
            this.func_72912_H().func_176144_a(EnumDifficulty.HARD);
        }
        this.field_73020_y.func_201711_g().func_202090_b().func_73660_a();
        if (this.func_73056_e()) {
            if (this.func_82736_K().func_82766_b("doDaylightCycle")) {
                long l = this.field_72986_A.func_76073_f() + 24000L;
                this.field_72986_A.func_76068_b(l - l % 24000L);
            }
            this.func_73053_d();
        }
        this.field_72984_F.func_76320_a("spawner");
        if (this.func_82736_K().func_82766_b("doMobSpawning") && this.field_72986_A.func_76067_t() != WorldType.field_180272_g) {
            this.field_175742_R.func_77192_a(this, this.field_72985_G, this.field_72992_H, this.field_72986_A.func_82573_f() % 400L == 0L);
            this.func_72863_F().func_203082_a(this, this.field_72985_G, this.field_72992_H);
        }
        this.field_72984_F.func_76318_c("chunkSource");
        this.field_73020_y.func_73156_b(booleanSupplier2);
        int \u26032 = this.func_72967_a(1.0f);
        if (\u26032 != this.func_175657_ab()) {
            this.func_175692_b(\u26032);
        }
        this.field_72986_A.func_82572_b(this.field_72986_A.func_82573_f() + 1L);
        if (this.func_82736_K().func_82766_b("doDaylightCycle")) {
            this.field_72986_A.func_76068_b(this.field_72986_A.func_76073_f() + 1L);
        }
        this.field_72984_F.func_76318_c("tickPending");
        this.func_72955_a();
        this.field_72984_F.func_76318_c("tickBlocks");
        this.func_147456_g();
        this.field_72984_F.func_76318_c("chunkMap");
        this.field_73063_M.func_72693_b();
        this.field_72984_F.func_76318_c("village");
        this.field_72982_D.func_75544_a();
        this.field_175740_d.func_75528_a();
        this.field_72984_F.func_76318_c("portalForcer");
        this.field_85177_Q.func_85189_a(this.func_82737_E());
        this.field_72984_F.func_76319_b();
        this.func_147488_Z();
        this.field_211159_Q = false;
    }

    public boolean func_211158_j_() {
        return this.field_211159_Q;
    }

    @Nullable
    public Biome.SpawnListEntry func_175734_a(EnumCreatureType enumCreatureType, BlockPos blockPos) {
        List<Biome.SpawnListEntry> list = this.func_72863_F().func_177458_a(enumCreatureType, blockPos);
        if (list.isEmpty()) {
            return null;
        }
        return WeightedRandom.func_76271_a(this.field_73012_v, list);
    }

    public boolean func_175732_a(EnumCreatureType enumCreatureType, Biome.SpawnListEntry spawnListEntry, BlockPos blockPos) {
        List<Biome.SpawnListEntry> list = this.func_72863_F().func_177458_a(enumCreatureType, blockPos);
        if (list == null || list.isEmpty()) {
            return false;
        }
        return list.contains(spawnListEntry);
    }

    @Override
    public void func_72854_c() {
        this.field_73068_P = false;
        if (!this.field_73010_i.isEmpty()) {
            int n;
            int n2 = 0;
            n = 0;
            for (EntityPlayer entityPlayer : this.field_73010_i) {
                if (entityPlayer.func_175149_v()) {
                    ++n2;
                    continue;
                }
                if (!entityPlayer.func_70608_bn()) continue;
                ++n;
            }
            this.field_73068_P = n > 0 && n >= this.field_73010_i.size() - n2;
        }
    }

    @Override
    public ServerScoreboard func_96441_U() {
        return this.field_73061_a.func_200251_aP();
    }

    protected void func_73053_d() {
        this.field_73068_P = false;
        List list = this.field_73010_i.stream().filter(EntityPlayer::func_70608_bn).collect(Collectors.toList());
        for (EntityPlayer entityPlayer : list) {
            entityPlayer.func_70999_a(false, false, true);
        }
        if (this.func_82736_K().func_82766_b("doWeatherCycle")) {
            this.func_73051_P();
        }
    }

    private void func_73051_P() {
        this.field_72986_A.func_76080_g(0);
        this.field_72986_A.func_76084_b(false);
        this.field_72986_A.func_76090_f(0);
        this.field_72986_A.func_76069_a(false);
    }

    public boolean func_73056_e() {
        if (this.field_73068_P && !this.field_72995_K) {
            for (EntityPlayer entityPlayer : this.field_73010_i) {
                if (entityPlayer.func_175149_v() || entityPlayer.func_71026_bH()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_175680_a(int n, int n2, boolean bl) {
        return this.func_201697_a(n, n2);
    }

    public boolean func_201697_a(int n, int n2) {
        return this.func_72863_F().func_73149_a(n, n2);
    }

    protected void func_184162_i() {
        this.field_72984_F.func_76320_a("playerCheckLight");
        if (!this.field_73010_i.isEmpty()) {
            int n = this.field_73012_v.nextInt(this.field_73010_i.size());
            EntityPlayer \u26032 = (EntityPlayer)this.field_73010_i.get(n);
            \u2603 = MathHelper.func_76128_c(\u26032.field_70165_t) + this.field_73012_v.nextInt(11) - 5;
            \u2603 = MathHelper.func_76128_c(\u26032.field_70163_u) + this.field_73012_v.nextInt(11) - 5;
            \u2603 = MathHelper.func_76128_c(\u26032.field_70161_v) + this.field_73012_v.nextInt(11) - 5;
            this.func_175664_x(new BlockPos(\u2603, \u2603, \u2603));
        }
        this.field_72984_F.func_76319_b();
    }

    @Override
    protected void func_147456_g() {
        this.func_184162_i();
        if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            Iterator<Chunk> iterator = this.field_73063_M.func_187300_b();
            while (iterator.hasNext()) {
                iterator.next().func_150804_b(false);
            }
            return;
        }
        int n = this.func_82736_K().func_180263_c("randomTickSpeed");
        boolean \u26032 = this.func_72896_J();
        boolean \u26033 = this.func_72911_I();
        this.field_72984_F.func_76320_a("pollingChunks");
        Iterator<Chunk> \u26034 = this.field_73063_M.func_187300_b();
        while (\u26034.hasNext()) {
            Object \u26038;
            BlockPos \u26037;
            int n2;
            this.field_72984_F.func_76320_a("getChunk");
            Chunk chunk = \u26034.next();
            int \u26035 = chunk.field_76635_g * 16;
            int \u26036 = chunk.field_76647_h * 16;
            this.field_72984_F.func_76318_c("checkNextLight");
            chunk.func_76594_o();
            this.field_72984_F.func_76318_c("tickChunk");
            chunk.func_150804_b(false);
            this.field_72984_F.func_76318_c("thunder");
            if (\u26032 && \u26033 && this.field_73012_v.nextInt(100000) == 0) {
                this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                n2 = this.field_73005_l >> 2;
                \u26037 = this.func_175736_a(new BlockPos(\u26035 + (n2 & 0xF), 0, \u26036 + (n2 >> 8 & 0xF)));
                if (this.func_175727_C(\u26037)) {
                    boolean bl;
                    \u26038 = this.func_175649_E(\u26037);
                    boolean bl2 = bl = this.func_82736_K().func_82766_b("doMobSpawning") && this.field_73012_v.nextDouble() < (double)((DifficultyInstance)\u26038).func_180168_b() * 0.01;
                    if (bl) {
                        EntitySkeletonHorse entitySkeletonHorse = new EntitySkeletonHorse(this);
                        entitySkeletonHorse.func_190691_p(true);
                        entitySkeletonHorse.func_70873_a(0);
                        entitySkeletonHorse.func_70107_b(\u26037.func_177958_n(), \u26037.func_177956_o(), \u26037.func_177952_p());
                        this.func_72838_d(entitySkeletonHorse);
                    }
                    this.func_72942_c(new EntityLightningBolt(this, (double)\u26037.func_177958_n() + 0.5, \u26037.func_177956_o(), (double)\u26037.func_177952_p() + 0.5, bl));
                }
            }
            this.field_72984_F.func_76318_c("iceandsnow");
            if (this.field_73012_v.nextInt(16) == 0) {
                this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                n2 = this.field_73005_l >> 2;
                \u26037 = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(\u26035 + (n2 & 0xF), 0, \u26036 + (n2 >> 8 & 0xF)));
                \u26038 = \u26037.func_177977_b();
                Biome \u26039 = this.func_180494_b(\u26037);
                if (\u26039.func_201848_a(this, (BlockPos)\u26038)) {
                    this.func_175656_a((BlockPos)\u26038, Blocks.field_150432_aD.func_176223_P());
                }
                if (\u26032 && \u26039.func_201850_b(this, \u26037)) {
                    this.func_175656_a(\u26037, Blocks.field_150433_aE.func_176223_P());
                }
                if (\u26032 && this.func_180494_b((BlockPos)\u26038).func_201851_b() == Biome.RainType.RAIN) {
                    this.func_180495_p((BlockPos)\u26038).func_177230_c().func_176224_k(this, (BlockPos)\u26038);
                }
            }
            this.field_72984_F.func_76318_c("tickBlocks");
            if (n > 0) {
                for (ChunkSection chunkSection : chunk.func_76587_i()) {
                    if (chunkSection == Chunk.field_186036_a || !chunkSection.func_206915_b()) continue;
                    for (int i = 0; i < n; ++i) {
                        this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                        \u2603 = this.field_73005_l >> 2;
                        \u2603 = \u2603 & 0xF;
                        \u2603 = \u2603 >> 8 & 0xF;
                        \u2603 = \u2603 >> 16 & 0xF;
                        IBlockState iBlockState = chunkSection.func_177485_a(\u2603, \u2603, \u2603);
                        IFluidState \u260310 = chunkSection.func_206914_b(\u2603, \u2603, \u2603);
                        this.field_72984_F.func_76320_a("randomTick");
                        if (iBlockState.func_204519_t()) {
                            iBlockState.func_196944_b(this, new BlockPos(\u2603 + \u26035, \u2603 + chunkSection.func_76662_d(), \u2603 + \u26036), this.field_73012_v);
                        }
                        if (\u260310.func_206890_h()) {
                            \u260310.func_206891_b(this, new BlockPos(\u2603 + \u26035, \u2603 + chunkSection.func_76662_d(), \u2603 + \u26036), this.field_73012_v);
                        }
                        this.field_72984_F.func_76319_b();
                    }
                }
            }
            this.field_72984_F.func_76319_b();
        }
        this.field_72984_F.func_76319_b();
    }

    protected BlockPos func_175736_a(BlockPos blockPos) {
        BlockPos blockPos2;
        blockPos2 = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockPos);
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(blockPos2, new BlockPos(blockPos2.func_177958_n(), this.func_72800_K(), blockPos2.func_177952_p())).func_186662_g(3.0);
        List<EntityLivingBase> \u26032 = this.func_175647_a(EntityLivingBase.class, axisAlignedBB, entityLivingBase -> entityLivingBase != null && entityLivingBase.func_70089_S() && this.func_175678_i(entityLivingBase.func_180425_c()));
        if (!\u26032.isEmpty()) {
            return \u26032.get(this.field_73012_v.nextInt(\u26032.size())).func_180425_c();
        }
        if (blockPos2.func_177956_o() == -1) {
            blockPos2 = blockPos2.func_177981_b(2);
        }
        return blockPos2;
    }

    @Override
    public void func_72939_s() {
        if (this.field_73010_i.isEmpty()) {
            if (this.field_80004_Q++ >= 300) {
                return;
            }
        } else {
            this.func_82742_i();
        }
        this.field_73011_w.func_186059_r();
        super.func_72939_s();
    }

    @Override
    protected void func_184147_l() {
        super.func_184147_l();
        this.field_72984_F.func_76318_c("players");
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            Entity entity = (Entity)this.field_73010_i.get(i);
            \u2603 = entity.func_184187_bx();
            if (\u2603 != null) {
                if (!\u2603.field_70128_L && \u2603.func_184196_w(entity)) continue;
                entity.func_184210_p();
            }
            this.field_72984_F.func_76320_a("tick");
            if (!entity.field_70128_L) {
                try {
                    this.func_72870_g(entity);
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Ticking player");
                    CrashReportCategory \u26032 = crashReport.func_85058_a("Player being ticked");
                    entity.func_85029_a(\u26032);
                    throw new ReportedException(crashReport);
                }
            }
            this.field_72984_F.func_76319_b();
            this.field_72984_F.func_76320_a("remove");
            if (entity.field_70128_L) {
                int n = entity.field_70176_ah;
                \u2603 = entity.field_70164_aj;
                if (entity.field_70175_ag && this.func_175680_a(n, \u2603, true)) {
                    this.func_72964_e(n, \u2603).func_76622_b(entity);
                }
                this.field_72996_f.remove(entity);
                this.func_72847_b(entity);
            }
            this.field_72984_F.func_76319_b();
        }
    }

    public void func_82742_i() {
        this.field_80004_Q = 0;
    }

    public void func_72955_a() {
        if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            return;
        }
        this.field_94579_S.func_205365_a();
        this.field_205342_P.func_205365_a();
    }

    private void func_205339_a(NextTickListEntry<Fluid> nextTickListEntry) {
        IFluidState iFluidState = this.func_204610_c(nextTickListEntry.field_180282_a);
        if (iFluidState.func_206886_c() == nextTickListEntry.func_151351_a()) {
            iFluidState.func_206880_a(this, nextTickListEntry.field_180282_a);
        }
    }

    private void func_205338_b(NextTickListEntry<Block> nextTickListEntry) {
        IBlockState iBlockState = this.func_180495_p(nextTickListEntry.field_180282_a);
        if (iBlockState.func_177230_c() == nextTickListEntry.func_151351_a()) {
            iBlockState.func_196940_a(this, nextTickListEntry.field_180282_a, this.field_73012_v);
        }
    }

    @Override
    public void func_72866_a(Entity entity, boolean bl) {
        if (!this.func_175735_ai() && (entity instanceof EntityAnimal || entity instanceof EntityWaterMob)) {
            entity.func_70106_y();
        }
        if (!this.func_175738_ah() && entity instanceof INpc) {
            entity.func_70106_y();
        }
        super.func_72866_a(entity, bl);
    }

    private boolean func_175738_ah() {
        return this.field_73061_a.func_71220_V();
    }

    private boolean func_175735_ai() {
        return this.field_73061_a.func_71268_U();
    }

    @Override
    protected IChunkProvider func_72970_h() {
        IChunkLoader iChunkLoader = this.field_73019_z.func_75763_a(this.field_73011_w);
        return new ChunkProviderServer(this, iChunkLoader, this.field_73011_w.func_186060_c(), this.field_73061_a);
    }

    @Override
    public boolean func_175660_a(EntityPlayer entityPlayer, BlockPos blockPos) {
        return !this.field_73061_a.func_175579_a(this, blockPos, entityPlayer) && this.func_175723_af().func_177746_a(blockPos);
    }

    @Override
    public void func_72963_a(WorldSettings worldSettings) {
        if (!this.field_72986_A.func_76070_v()) {
            try {
                this.func_73052_b(worldSettings);
                if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
                    this.func_175737_aj();
                }
                super.func_72963_a(worldSettings);
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception initializing level");
                try {
                    this.func_72914_a(crashReport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            this.field_72986_A.func_76091_d(true);
        }
    }

    private void func_175737_aj() {
        this.field_72986_A.func_176128_f(false);
        this.field_72986_A.func_176121_c(true);
        this.field_72986_A.func_76084_b(false);
        this.field_72986_A.func_76069_a(false);
        this.field_72986_A.func_176142_i(1000000000);
        this.field_72986_A.func_76068_b(6000L);
        this.field_72986_A.func_76060_a(GameType.SPECTATOR);
        this.field_72986_A.func_176119_g(false);
        this.field_72986_A.func_176144_a(EnumDifficulty.PEACEFUL);
        this.field_72986_A.func_180783_e(true);
        this.func_82736_K().func_82764_b("doDaylightCycle", "false", this.field_73061_a);
    }

    private void func_73052_b(WorldSettings worldSettings2) {
        WorldSettings worldSettings2;
        ChunkPos chunkPos;
        if (!this.field_73011_w.func_76567_e()) {
            this.field_72986_A.func_176143_a(BlockPos.field_177992_a.func_177981_b(this.field_73020_y.func_201711_g().func_205470_d()));
            return;
        }
        if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            this.field_72986_A.func_176143_a(BlockPos.field_177992_a.func_177984_a());
            return;
        }
        BiomeProvider biomeProvider = this.field_73020_y.func_201711_g().func_202090_b();
        BlockPos \u26032 = biomeProvider.func_180630_a(0, 0, 256, \u2603 = biomeProvider.func_76932_a(), \u2603 = new Random(this.func_72905_C()));
        ChunkPos chunkPos2 = chunkPos = \u26032 == null ? new ChunkPos(0, 0) : new ChunkPos(\u26032);
        if (\u26032 == null) {
            field_147491_a.warn("Unable to find spawn biome");
        }
        boolean \u26033 = false;
        for (Block block : BlockTags.field_205599_H.func_199885_a()) {
            if (!biomeProvider.func_205706_b().contains(block.func_176223_P())) continue;
            \u26033 = true;
            break;
        }
        this.field_72986_A.func_176143_a(chunkPos.func_206849_h().func_177982_a(8, this.field_73020_y.func_201711_g().func_205470_d(), 8));
        int \u26034 = 0;
        int \u26035 = 0;
        int \u26036 = 0;
        int \u26037 = -1;
        int \u26038 = 32;
        for (int i = 0; i < 1024; ++i) {
            if (\u26034 > -16 && \u26034 <= 16 && \u26035 > -16 && \u26035 <= 16 && (\u2603 = this.field_73011_w.func_206920_a(new ChunkPos(chunkPos.field_77276_a + \u26034, chunkPos.field_77275_b + \u26035), \u26033)) != null) {
                this.field_72986_A.func_176143_a(\u2603);
                break;
            }
            if (\u26034 == \u26035 || \u26034 < 0 && \u26034 == -\u26035 || \u26034 > 0 && \u26034 == 1 - \u26035) {
                \u2603 = \u26036;
                \u26036 = -\u26037;
                \u26037 = \u2603;
            }
            \u26034 += \u26036;
            \u26035 += \u26037;
        }
        if (worldSettings2.func_77167_c()) {
            this.func_73047_i();
        }
    }

    protected void func_73047_i() {
        BonusChestFeature bonusChestFeature = new BonusChestFeature();
        for (int i = 0; i < 10; ++i) {
            \u2603 = this.field_72986_A.func_76079_c() + this.field_73012_v.nextInt(6) - this.field_73012_v.nextInt(6);
            \u2603 = this.field_72986_A.func_76074_e() + this.field_73012_v.nextInt(6) - this.field_73012_v.nextInt(6);
            BlockPos blockPos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(\u2603, 0, \u2603)).func_177984_a();
            if (bonusChestFeature.func_212245_a((IWorld)this, this.field_73020_y.func_201711_g(), this.field_73012_v, blockPos, IFeatureConfig.field_202429_e)) break;
        }
    }

    @Nullable
    public BlockPos func_180504_m() {
        return this.field_73011_w.func_177496_h();
    }

    public void func_73044_a(boolean bl, @Nullable IProgressUpdate iProgressUpdate) throws SessionLockException {
        ChunkProviderServer chunkProviderServer = this.func_72863_F();
        if (!chunkProviderServer.func_73157_c()) {
            return;
        }
        if (iProgressUpdate != null) {
            iProgressUpdate.func_200210_a(new TextComponentTranslation("menu.savingLevel", new Object[0]));
        }
        this.func_73042_a();
        if (iProgressUpdate != null) {
            iProgressUpdate.func_200209_c(new TextComponentTranslation("menu.savingChunks", new Object[0]));
        }
        chunkProviderServer.func_186027_a(bl);
        ArrayList \u26032 = Lists.newArrayList(chunkProviderServer.func_189548_a());
        for (Chunk chunk : \u26032) {
            if (chunk == null || this.field_73063_M.func_152621_a(chunk.field_76635_g, chunk.field_76647_h)) continue;
            chunkProviderServer.func_189549_a(chunk);
        }
    }

    public void func_104140_m() {
        ChunkProviderServer chunkProviderServer = this.func_72863_F();
        if (!chunkProviderServer.func_73157_c()) {
            return;
        }
        chunkProviderServer.func_104112_b();
    }

    protected void func_73042_a() throws SessionLockException {
        this.func_72906_B();
        for (WorldServer worldServer : this.field_73061_a.func_212370_w()) {
            if (!(worldServer instanceof WorldServerMulti)) continue;
            ((WorldServerMulti)worldServer).func_184166_c();
        }
        this.field_72986_A.func_176145_a(this.func_175723_af().func_177741_h());
        this.field_72986_A.func_176124_d(this.func_175723_af().func_177731_f());
        this.field_72986_A.func_176141_c(this.func_175723_af().func_177721_g());
        this.field_72986_A.func_176129_e(this.func_175723_af().func_177742_m());
        this.field_72986_A.func_176125_f(this.func_175723_af().func_177727_n());
        this.field_72986_A.func_176122_j(this.func_175723_af().func_177748_q());
        this.field_72986_A.func_176136_k(this.func_175723_af().func_177740_p());
        this.field_72986_A.func_176118_b(this.func_175723_af().func_177751_j());
        this.field_72986_A.func_176135_e(this.func_175723_af().func_177732_i());
        this.field_72986_A.func_201356_c(this.field_73061_a.func_201300_aS().func_201380_c());
        this.field_73019_z.func_75755_a(this.field_72986_A, this.field_73061_a.func_184103_al().func_72378_q());
        this.func_175693_T().func_75744_a();
    }

    @Override
    public boolean func_72838_d(Entity entity) {
        if (this.func_184165_i(entity)) {
            return super.func_72838_d(entity);
        }
        return false;
    }

    @Override
    public void func_212420_a(Stream<Entity> stream) {
        stream.forEach(entity -> {
            if (this.func_184165_i((Entity)entity)) {
                this.field_72996_f.add(entity);
                this.func_72923_a((Entity)entity);
            }
        });
    }

    private boolean func_184165_i(Entity entity) {
        if (entity.field_70128_L) {
            field_147491_a.warn("Tried to add entity {} but it was marked as removed already", (Object)EntityType.func_200718_a(entity.func_200600_R()));
            return false;
        }
        UUID uUID = entity.func_110124_au();
        if (this.field_175741_N.containsKey(uUID)) {
            Entity entity2 = this.field_175741_N.get(uUID);
            if (this.field_72997_g.contains(entity2)) {
                this.field_72997_g.remove(entity2);
            } else {
                if (!(entity instanceof EntityPlayer)) {
                    field_147491_a.warn("Keeping entity {} that already exists with UUID {}", (Object)EntityType.func_200718_a(entity2.func_200600_R()), (Object)uUID.toString());
                    return false;
                }
                field_147491_a.warn("Force-added player with duplicate UUID {}", (Object)uUID.toString());
            }
            this.func_72973_f(entity2);
        }
        return true;
    }

    @Override
    protected void func_72923_a(Entity entity) {
        super.func_72923_a(entity);
        this.field_175729_l.func_76038_a(entity.func_145782_y(), entity);
        this.field_175741_N.put(entity.func_110124_au(), entity);
        Entity[] entityArray = entity.func_70021_al();
        if (entityArray != null) {
            for (Entity entity2 : entityArray) {
                this.field_175729_l.func_76038_a(entity2.func_145782_y(), entity2);
            }
        }
    }

    @Override
    protected void func_72847_b(Entity entity) {
        super.func_72847_b(entity);
        this.field_175729_l.func_76049_d(entity.func_145782_y());
        this.field_175741_N.remove(entity.func_110124_au());
        Entity[] entityArray = entity.func_70021_al();
        if (entityArray != null) {
            for (Entity entity2 : entityArray) {
                this.field_175729_l.func_76049_d(entity2.func_145782_y());
            }
        }
    }

    @Override
    public boolean func_72942_c(Entity entity) {
        if (super.func_72942_c(entity)) {
            this.field_73061_a.func_184103_al().func_148543_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 512.0, this.field_73011_w.func_186058_p(), new SPacketSpawnGlobalEntity(entity));
            return true;
        }
        return false;
    }

    @Override
    public void func_72960_a(Entity entity, byte by) {
        this.func_73039_n().func_151248_b(entity, new SPacketEntityStatus(entity, by));
    }

    @Override
    public ChunkProviderServer func_72863_F() {
        return (ChunkProviderServer)super.func_72863_F();
    }

    @Override
    public Explosion func_211529_a(@Nullable Entity entity, DamageSource damageSource, double d, double d2, double d3, float f, boolean bl, boolean bl2) {
        Explosion explosion = new Explosion(this, entity, d, d2, d3, f, bl, bl2);
        if (damageSource != null) {
            explosion.func_199592_a(damageSource);
        }
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        if (!bl2) {
            explosion.func_180342_d();
        }
        for (EntityPlayer entityPlayer : this.field_73010_i) {
            if (!(entityPlayer.func_70092_e(d, d2, d3) < 4096.0)) continue;
            ((EntityPlayerMP)entityPlayer).field_71135_a.func_147359_a(new SPacketExplosion(d, d2, d3, f, explosion.func_180343_e(), explosion.func_77277_b().get(entityPlayer)));
        }
        return explosion;
    }

    @Override
    public void func_175641_c(BlockPos blockPos, Block block, int n, int n2) {
        this.field_147490_S.add((Object)new BlockEventData(blockPos, block, n, n2));
    }

    private void func_147488_Z() {
        while (!this.field_147490_S.isEmpty()) {
            BlockEventData blockEventData = (BlockEventData)this.field_147490_S.removeFirst();
            if (!this.func_147485_a(blockEventData)) continue;
            this.field_73061_a.func_184103_al().func_148543_a(null, blockEventData.func_180328_a().func_177958_n(), blockEventData.func_180328_a().func_177956_o(), blockEventData.func_180328_a().func_177952_p(), 64.0, this.field_73011_w.func_186058_p(), new SPacketBlockAction(blockEventData.func_180328_a(), blockEventData.func_151337_f(), blockEventData.func_151339_d(), blockEventData.func_151338_e()));
        }
    }

    private boolean func_147485_a(BlockEventData blockEventData) {
        IBlockState iBlockState = this.func_180495_p(blockEventData.func_180328_a());
        if (iBlockState.func_177230_c() == blockEventData.func_151337_f()) {
            return iBlockState.func_189547_a(this, blockEventData.func_180328_a(), blockEventData.func_151339_d(), blockEventData.func_151338_e());
        }
        return false;
    }

    @Override
    public void close() {
        this.field_73019_z.func_75759_a();
        super.close();
    }

    @Override
    protected void func_72979_l() {
        boolean bl = this.func_72896_J();
        super.func_72979_l();
        if (this.field_73003_n != this.field_73004_o) {
            this.field_73061_a.func_184103_al().func_148537_a(new SPacketChangeGameState(7, this.field_73004_o), this.field_73011_w.func_186058_p());
        }
        if (this.field_73018_p != this.field_73017_q) {
            this.field_73061_a.func_184103_al().func_148537_a(new SPacketChangeGameState(8, this.field_73017_q), this.field_73011_w.func_186058_p());
        }
        if (bl != this.func_72896_J()) {
            if (bl) {
                this.field_73061_a.func_184103_al().func_148540_a(new SPacketChangeGameState(2, 0.0f));
            } else {
                this.field_73061_a.func_184103_al().func_148540_a(new SPacketChangeGameState(1, 0.0f));
            }
            this.field_73061_a.func_184103_al().func_148540_a(new SPacketChangeGameState(7, this.field_73004_o));
            this.field_73061_a.func_184103_al().func_148540_a(new SPacketChangeGameState(8, this.field_73017_q));
        }
    }

    public ServerTickList<Block> func_205220_G_() {
        return this.field_94579_S;
    }

    public ServerTickList<Fluid> func_205219_F_() {
        return this.field_205342_P;
    }

    @Override
    @Nonnull
    public MinecraftServer func_73046_m() {
        return this.field_73061_a;
    }

    public EntityTracker func_73039_n() {
        return this.field_73062_L;
    }

    public PlayerChunkMap func_184164_w() {
        return this.field_73063_M;
    }

    public Teleporter func_85176_s() {
        return this.field_85177_Q;
    }

    public TemplateManager func_184163_y() {
        return this.field_73019_z.func_186340_h();
    }

    public <T extends IParticleData> int func_195598_a(T t, double d, double d2, double d3, int n, double d4, double d5, double d6, double d7) {
        SPacketParticles sPacketParticles = new SPacketParticles(t, false, (float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7, n);
        int \u26032 = 0;
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)this.field_73010_i.get(i);
            if (!this.func_195601_a(entityPlayerMP, false, d, d2, d3, sPacketParticles)) continue;
            ++\u26032;
        }
        return \u26032;
    }

    public <T extends IParticleData> boolean func_195600_a(EntityPlayerMP entityPlayerMP, T t, boolean bl, double d, double d2, double d3, int n, double d4, double d5, double d6, double d7) {
        SPacketParticles sPacketParticles = new SPacketParticles(t, bl, (float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7, n);
        return this.func_195601_a(entityPlayerMP, bl, d, d2, d3, sPacketParticles);
    }

    private boolean func_195601_a(EntityPlayerMP entityPlayerMP, boolean bl, double d, double d2, double d3, Packet<?> packet) {
        if (entityPlayerMP.func_71121_q() != this) {
            return false;
        }
        BlockPos blockPos = entityPlayerMP.func_180425_c();
        double \u26032 = blockPos.func_177954_c(d, d2, d3);
        if (\u26032 <= 1024.0 || bl && \u26032 <= 262144.0) {
            entityPlayerMP.field_71135_a.func_147359_a(packet);
            return true;
        }
        return false;
    }

    @Nullable
    public Entity func_175733_a(UUID uUID) {
        return this.field_175741_N.get(uUID);
    }

    @Override
    public ListenableFuture<Object> func_152344_a(Runnable runnable) {
        return this.field_73061_a.func_152344_a(runnable);
    }

    @Override
    public boolean func_152345_ab() {
        return this.field_73061_a.func_152345_ab();
    }

    @Override
    @Nullable
    public BlockPos func_211157_a(String string, BlockPos blockPos, int n, boolean bl) {
        return this.func_72863_F().func_211268_a(this, string, blockPos, n, bl);
    }

    @Override
    public RecipeManager func_199532_z() {
        return this.field_73061_a.func_199529_aN();
    }

    @Override
    public NetworkTagManager func_205772_D() {
        return this.field_73061_a.func_199731_aO();
    }

    @Override
    public /* synthetic */ Scoreboard func_96441_U() {
        return this.func_96441_U();
    }

    @Override
    public /* synthetic */ IChunkProvider func_72863_F() {
        return this.func_72863_F();
    }

    public /* synthetic */ ITickList func_205219_F_() {
        return this.func_205219_F_();
    }

    public /* synthetic */ ITickList func_205220_G_() {
        return this.func_205220_G_();
    }
}

