/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.types.templates.TaggedChoice;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.datafix.fixes.AddNewChoices;
import net.minecraft.util.datafix.fixes.LeavesFix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrappedChestTileEntitySplit
extends DataFix {
    private static final Logger field_212536_a = LogManager.getLogger();

    public TrappedChestTileEntitySplit(Schema schema, boolean bl) {
        super(schema, bl);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(TypeReferences.field_211287_c);
        \u2603 = type.findFieldType("Level");
        \u2603 = \u2603.findFieldType("TileEntities");
        if (!(\u2603 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType \u26032 = (List.ListType)\u2603;
        OpticFinder \u26033 = DSL.fieldFinder((String)"TileEntities", (Type)\u26032);
        \u2603 = this.getInputSchema().getType(TypeReferences.field_211287_c);
        OpticFinder \u26034 = \u2603.findField("Level");
        OpticFinder \u26035 = \u26034.type().findField("Sections");
        \u2603 = \u26035.type();
        if (!(\u2603 instanceof List.ListType)) {
            throw new IllegalStateException("Expecting sections to be a list.");
        }
        \u2603 = ((List.ListType)\u2603).getElement();
        OpticFinder \u26036 = DSL.typeFinder((Type)\u2603);
        return TypeRewriteRule.seq((TypeRewriteRule)new AddNewChoices(this.getOutputSchema(), "AddTrappedChestFix", TypeReferences.field_211294_j).makeRule(), (TypeRewriteRule)this.fixTypeEverywhereTyped("Trapped Chest fix", \u2603, typed -> typed.updateTyped(\u26034, typed2 -> {
            Typed typed2;
            Optional optional = typed2.getOptionalTyped(\u26035);
            if (!optional.isPresent()) {
                return typed2;
            }
            List \u26032 = ((Typed)optional.get()).getAllTyped(\u26036);
            IntOpenHashSet \u26033 = new IntOpenHashSet();
            for (Typed typed3 : \u26032) {
                Section section = new Section(typed3, this.getInputSchema());
                if (section.func_208461_a()) continue;
                for (int i = 0; i < 4096; ++i) {
                    \u2603 = section.func_208453_a(i);
                    if (!section.func_212511_a(\u2603)) continue;
                    \u26033.add(section.func_208456_b() << 12 | i);
                }
            }
            Dynamic \u26034 = (Dynamic)typed2.get(DSL.remainderFinder());
            int \u26035 = \u26034.getInt("xPos");
            int \u26036 = \u26034.getInt("zPos");
            TaggedChoice.TaggedChoiceType \u26037 = this.getInputSchema().findChoiceType(TypeReferences.field_211294_j);
            return typed2.updateTyped(\u26033, arg_0 -> TrappedChestTileEntitySplit.func_212532_a(\u26037, \u26035, \u26036, (IntSet)\u26033, arg_0));
        })));
    }

    private static /* synthetic */ Typed func_212532_a(TaggedChoice.TaggedChoiceType taggedChoiceType, int n, int n2, IntSet intSet, Typed typed2) {
        return typed2.updateTyped(taggedChoiceType.finder(), typed -> {
            Dynamic dynamic = (Dynamic)typed.getOrCreate(DSL.remainderFinder());
            int \u26032 = dynamic.getInt("x") - (n << 4);
            if (intSet.contains(LeavesFix.func_208411_a(\u26032, \u2603 = dynamic.getInt("y"), \u2603 = dynamic.getInt("z") - (n2 << 4)))) {
                return typed.update(taggedChoiceType.finder(), pair -> pair.mapFirst(string -> {
                    if (!Objects.equals(string, "minecraft:chest")) {
                        field_212536_a.warn("Block Entity was expected to be a chest");
                    }
                    return "minecraft:trapped_chest";
                }));
            }
            return typed;
        });
    }

    public static final class Section
    extends LeavesFix.Section {
        @Nullable
        private IntSet field_212512_f;

        public Section(Typed<?> typed, Schema schema) {
            super(typed, schema);
        }

        @Override
        protected boolean func_212508_a() {
            this.field_212512_f = new IntOpenHashSet();
            for (int i = 0; i < this.field_208469_d.size(); ++i) {
                Dynamic dynamic = (Dynamic)this.field_208469_d.get(i);
                String \u26032 = dynamic.getString("Name");
                if (!Objects.equals(\u26032, "minecraft:trapped_chest")) continue;
                this.field_212512_f.add(i);
            }
            return this.field_212512_f.isEmpty();
        }

        public boolean func_212511_a(int n) {
            return this.field_212512_f.contains(n);
        }
    }
}

