/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.util.datafix.TypeReferences;

public class ObjectiveRenderType
extends DataFix {
    public ObjectiveRenderType(Schema schema, boolean bl) {
        super(schema, bl);
    }

    private static ScoreCriteria.RenderType func_211858_a(String string) {
        return string.equals("health") ? ScoreCriteria.RenderType.HEARTS : ScoreCriteria.RenderType.INTEGER;
    }

    protected TypeRewriteRule makeRule() {
        Type type = DSL.named((String)TypeReferences.field_211873_t.typeName(), (Type)DSL.remainderType());
        if (!Objects.equals(type, this.getInputSchema().getType(TypeReferences.field_211873_t))) {
            throw new IllegalStateException("Objective type is not what was expected.");
        }
        return this.fixTypeEverywhere("ObjectiveRenderTypeFix", type, dynamicOps -> pair -> pair.mapSecond(dynamic -> {
            Optional optional = dynamic.get("RenderType").flatMap(Dynamic::getStringValue);
            if (!optional.isPresent()) {
                String string = dynamic.getString("CriteriaName");
                ScoreCriteria.RenderType \u26032 = ObjectiveRenderType.func_211858_a(string);
                return dynamic.set("RenderType", dynamic.createString(\u26032.func_211838_a()));
            }
            return dynamic;
        }));
    }
}

