/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.util.Util;

public interface IStatFormater {
    public static final DecimalFormat DECIMAL_FORMAT = Util.func_200696_a(new DecimalFormat("########0.00"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final IStatFormater DEFAULT = NumberFormat.getIntegerInstance(Locale.US)::format;
    public static final IStatFormater DIVIDE_BY_TEN = n -> DECIMAL_FORMAT.format((double)n * 0.1);
    public static final IStatFormater DISTANCE = n -> {
        double d = (double)n / 100.0;
        \u2603 = d / 1000.0;
        if (\u2603 > 0.5) {
            return DECIMAL_FORMAT.format(\u2603) + " km";
        }
        if (d > 0.5) {
            return DECIMAL_FORMAT.format(d) + " m";
        }
        return n + " cm";
    };
    public static final IStatFormater TIME = n -> {
        double d = (double)n / 20.0;
        \u2603 = d / 60.0;
        \u2603 = \u2603 / 60.0;
        \u2603 = \u2603 / 24.0;
        \u2603 = \u2603 / 365.0;
        if (\u2603 > 0.5) {
            return DECIMAL_FORMAT.format(\u2603) + " y";
        }
        if (\u2603 > 0.5) {
            return DECIMAL_FORMAT.format(\u2603) + " d";
        }
        if (\u2603 > 0.5) {
            return DECIMAL_FORMAT.format(\u2603) + " h";
        }
        if (\u2603 > 0.5) {
            return DECIMAL_FORMAT.format(\u2603) + " m";
        }
        return d + " s";
    };
}

