/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemGroup;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.network.rcon.RConThreadMain;
import net.minecraft.network.rcon.RConThreadQuery;
import net.minecraft.profiler.Snooper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerEula;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.PendingCommand;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.server.dedicated.ServerHangWatchdog;
import net.minecraft.server.gui.MinecraftServerGui;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.CryptManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.DefaultUncaughtExceptionHandlerWithName;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DedicatedServer
extends MinecraftServer
implements IServer {
    private static final Logger field_155771_h = LogManager.getLogger();
    private static final Pattern field_189647_l = Pattern.compile("^[a-fA-F0-9]{40}$");
    private final List<PendingCommand> field_71341_l = Collections.synchronizedList(Lists.newArrayList());
    private RConThreadQuery field_71342_m;
    private final RConConsoleSource field_184115_n = new RConConsoleSource(this);
    private RConThreadMain field_71339_n;
    private PropertyManager field_71340_o;
    private ServerEula field_154332_n;
    private boolean field_71338_p;
    private GameType field_71337_q;
    private boolean field_71335_s;

    public DedicatedServer(File file, DataFixer dataFixer, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, PlayerProfileCache playerProfileCache) {
        super(file, Proxy.NO_PROXY, dataFixer, new Commands(true), yggdrasilAuthenticationService, minecraftSessionService, gameProfileRepository, playerProfileCache);
        new Thread("Server Infinisleeper"){
            {
                this.setDaemon(true);
                this.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_155771_h));
                this.start();
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(Integer.MAX_VALUE);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
    }

    @Override
    protected boolean func_71197_b() throws IOException {
        WorldType worldType;
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                try {
                    while (!DedicatedServer.this.func_71241_aa() && DedicatedServer.this.func_71278_l() && (\u2603 = bufferedReader.readLine()) != null) {
                        DedicatedServer.this.func_195581_a(\u2603, DedicatedServer.this.func_195573_aM());
                    }
                }
                catch (IOException \u26032) {
                    field_155771_h.error("Exception handling console input", (Throwable)\u26032);
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_155771_h));
        thread.start();
        field_155771_h.info("Starting minecraft server version 1.13.2");
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            field_155771_h.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        field_155771_h.info("Loading properties");
        this.field_71340_o = new PropertyManager(new File("server.properties"));
        this.field_154332_n = new ServerEula(new File("eula.txt"));
        if (!this.field_154332_n.func_154346_a()) {
            field_155771_h.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
            this.field_154332_n.func_154348_b();
            return false;
        }
        if (this.func_71264_H()) {
            this.func_71189_e("127.0.0.1");
        } else {
            this.func_71229_d(this.field_71340_o.func_73670_a("online-mode", true));
            this.func_190517_e(this.field_71340_o.func_73670_a("prevent-proxy-connections", false));
            this.func_71189_e(this.field_71340_o.func_73671_a("server-ip", ""));
        }
        this.func_71251_e(this.field_71340_o.func_73670_a("spawn-animals", true));
        this.func_71257_f(this.field_71340_o.func_73670_a("spawn-npcs", true));
        this.func_71188_g(this.field_71340_o.func_73670_a("pvp", true));
        this.func_71245_h(this.field_71340_o.func_73670_a("allow-flight", false));
        this.func_180507_a_(this.field_71340_o.func_73671_a("resource-pack", ""), this.func_184113_aK());
        this.func_71205_p(this.field_71340_o.func_73671_a("motd", "A Minecraft Server"));
        this.func_104055_i(this.field_71340_o.func_73670_a("force-gamemode", false));
        this.func_143006_e(this.field_71340_o.func_73669_a("player-idle-timeout", 0));
        this.func_205741_k(this.field_71340_o.func_73670_a("enforce-whitelist", false));
        if (this.field_71340_o.func_73669_a("difficulty", 1) < 0) {
            this.field_71340_o.func_73667_a("difficulty", 0);
        } else if (this.field_71340_o.func_73669_a("difficulty", 1) > 3) {
            this.field_71340_o.func_73667_a("difficulty", 3);
        }
        this.field_71338_p = this.field_71340_o.func_73670_a("generate-structures", true);
        int \u26032 = this.field_71340_o.func_73669_a("gamemode", GameType.SURVIVAL.func_77148_a());
        this.field_71337_q = WorldSettings.func_77161_a(\u26032);
        field_155771_h.info("Default game type: {}", (Object)this.field_71337_q);
        InetAddress \u26033 = null;
        if (!this.func_71211_k().isEmpty()) {
            \u26033 = InetAddress.getByName(this.func_71211_k());
        }
        if (this.func_71215_F() < 0) {
            this.func_71208_b(this.field_71340_o.func_73669_a("server-port", 25565));
        }
        field_155771_h.info("Generating keypair");
        this.func_71253_a(CryptManager.func_75891_b());
        field_155771_h.info("Starting Minecraft server on {}:{}", (Object)(this.func_71211_k().isEmpty() ? "*" : this.func_71211_k()), (Object)this.func_71215_F());
        try {
            this.func_147137_ag().func_151265_a(\u26033, this.func_71215_F());
        }
        catch (IOException \u26034) {
            field_155771_h.warn("**** FAILED TO BIND TO PORT!");
            field_155771_h.warn("The exception was: {}", (Object)\u26034.toString());
            field_155771_h.warn("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.func_71266_T()) {
            field_155771_h.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            field_155771_h.warn("The server will make no attempt to authenticate usernames. Beware.");
            field_155771_h.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            field_155771_h.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (this.func_152368_aE()) {
            this.func_152358_ax().func_152658_c();
        }
        if (!PreYggdrasilConverter.func_152714_a(this.field_71340_o)) {
            return false;
        }
        this.func_184105_a(new DedicatedPlayerList(this));
        long \u26035 = Util.func_211178_c();
        if (this.func_71270_I() == null) {
            this.func_71261_m(this.field_71340_o.func_73671_a("level-name", "world"));
        }
        String \u26036 = this.field_71340_o.func_73671_a("level-seed", "");
        String \u26037 = this.field_71340_o.func_73671_a("level-type", "DEFAULT");
        String \u26038 = this.field_71340_o.func_73671_a("generator-settings", "");
        long \u26039 = new Random().nextLong();
        if (!\u26036.isEmpty()) {
            try {
                long l = Long.parseLong(\u26036);
                if (l != 0L) {
                    \u26039 = l;
                }
            }
            catch (NumberFormatException numberFormatException) {
                \u26039 = \u26036.hashCode();
            }
        }
        if ((worldType = WorldType.func_77130_a(\u26037)) == null) {
            worldType = WorldType.field_77137_b;
        }
        this.func_82356_Z();
        this.func_110455_j();
        this.func_70002_Q();
        this.func_175577_aI();
        this.func_71191_d(this.field_71340_o.func_73669_a("max-build-height", 256));
        this.func_71191_d((this.func_71207_Z() + 8) / 16 * 16);
        this.func_71191_d(MathHelper.func_76125_a(this.func_71207_Z(), 64, 256));
        this.field_71340_o.func_73667_a("max-build-height", this.func_71207_Z());
        TileEntitySkull.func_184293_a(this.func_152358_ax());
        TileEntitySkull.func_184294_a(this.func_147130_as());
        PlayerProfileCache.func_187320_a(this.func_71266_T());
        field_155771_h.info("Preparing level \"{}\"", (Object)this.func_71270_I());
        JsonObject \u260310 = new JsonObject();
        if (worldType == WorldType.field_77138_c) {
            \u260310.addProperty("flat_world_options", \u26038);
        } else if (!\u26038.isEmpty()) {
            \u260310 = JsonUtils.func_212745_a(\u26038);
        }
        this.func_71247_a(this.func_71270_I(), this.func_71270_I(), \u26039, worldType, (JsonElement)\u260310);
        long \u260311 = Util.func_211178_c() - \u26035;
        String \u260312 = String.format(Locale.ROOT, "%.3fs", (double)\u260311 / 1.0E9);
        field_155771_h.info("Done ({})! For help, type \"help\"", (Object)\u260312);
        if (this.field_71340_o.func_187239_a("announce-player-achievements")) {
            this.func_200252_aR().func_82764_b("announceAdvancements", this.field_71340_o.func_73670_a("announce-player-achievements", true) ? "true" : "false", this);
            this.field_71340_o.func_187238_b("announce-player-achievements");
            this.field_71340_o.func_73668_b();
        }
        if (this.field_71340_o.func_73670_a("enable-query", false)) {
            field_155771_h.info("Starting GS4 status listener");
            this.field_71342_m = new RConThreadQuery(this);
            this.field_71342_m.func_72602_a();
        }
        if (this.field_71340_o.func_73670_a("enable-rcon", false)) {
            field_155771_h.info("Starting remote control listener");
            this.field_71339_n = new RConThreadMain(this);
            this.field_71339_n.func_72602_a();
        }
        if (this.func_175593_aQ() > 0L) {
            Thread thread2 = new Thread(new ServerHangWatchdog(this));
            thread2.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandlerWithName(field_155771_h));
            thread2.setName("Server Watchdog");
            thread2.setDaemon(true);
            thread2.start();
        }
        Items.field_190931_a.func_150895_a(ItemGroup.field_78027_g, NonNullList.func_191196_a());
        return true;
    }

    public String func_184113_aK() {
        String string;
        if (this.field_71340_o.func_187239_a("resource-pack-hash")) {
            if (this.field_71340_o.func_187239_a("resource-pack-sha1")) {
                field_155771_h.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            } else {
                field_155771_h.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
                this.field_71340_o.func_73671_a("resource-pack-sha1", this.field_71340_o.func_73671_a("resource-pack-hash", ""));
                this.field_71340_o.func_187238_b("resource-pack-hash");
            }
        }
        if (!(string = this.field_71340_o.func_73671_a("resource-pack-sha1", "")).isEmpty() && !field_189647_l.matcher(string).matches()) {
            field_155771_h.warn("Invalid sha1 for ressource-pack-sha1");
        }
        if (!this.field_71340_o.func_73671_a("resource-pack", "").isEmpty() && string.isEmpty()) {
            field_155771_h.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        }
        return string;
    }

    @Override
    public void func_71235_a(GameType gameType) {
        super.func_71235_a(gameType);
        this.field_71337_q = gameType;
    }

    @Override
    public boolean func_71225_e() {
        return this.field_71338_p;
    }

    @Override
    public GameType func_71265_f() {
        return this.field_71337_q;
    }

    @Override
    public EnumDifficulty func_147135_j() {
        return EnumDifficulty.func_151523_a(this.field_71340_o.func_73669_a("difficulty", EnumDifficulty.NORMAL.func_151525_a()));
    }

    @Override
    public boolean func_71199_h() {
        return this.field_71340_o.func_73670_a("hardcore", false);
    }

    @Override
    public CrashReport func_71230_b(CrashReport crashReport) {
        crashReport = super.func_71230_b(crashReport);
        crashReport.func_85056_g().func_189529_a("Is Modded", () -> {
            String string = this.getServerModName();
            if (!"vanilla".equals(string)) {
                return "Definitely; Server brand changed to '" + string + "'";
            }
            return "Unknown (can't tell)";
        });
        crashReport.func_85056_g().func_189529_a("Type", () -> "Dedicated Server (map_server.txt)");
        return crashReport;
    }

    @Override
    protected void func_71240_o() {
        System.exit(0);
    }

    @Override
    protected void func_71190_q(BooleanSupplier booleanSupplier) {
        super.func_71190_q(booleanSupplier);
        this.func_71333_ah();
    }

    @Override
    public boolean func_71255_r() {
        return this.field_71340_o.func_73670_a("allow-nether", true);
    }

    @Override
    public boolean func_71193_K() {
        return this.field_71340_o.func_73670_a("spawn-monsters", true);
    }

    @Override
    public void func_70000_a(Snooper snooper) {
        snooper.func_152768_a("whitelist_enabled", this.func_184103_al().func_72383_n());
        snooper.func_152768_a("whitelist_count", this.func_184103_al().func_152598_l().length);
        super.func_70000_a(snooper);
    }

    @Override
    public boolean func_70002_Q() {
        if (this.field_71340_o.func_73670_a("snooper-enabled", true)) {
            // empty if block
        }
        return false;
    }

    public void func_195581_a(String string, CommandSource commandSource) {
        this.field_71341_l.add(new PendingCommand(string, commandSource));
    }

    public void func_71333_ah() {
        while (!this.field_71341_l.isEmpty()) {
            PendingCommand pendingCommand = this.field_71341_l.remove(0);
            this.func_195571_aL().func_197059_a(pendingCommand.field_73701_b, pendingCommand.field_73702_a);
        }
    }

    @Override
    public boolean func_71262_S() {
        return true;
    }

    @Override
    public boolean func_181035_ah() {
        return this.field_71340_o.func_73670_a("use-native-transport", true);
    }

    @Override
    public DedicatedPlayerList func_184103_al() {
        return (DedicatedPlayerList)super.func_184103_al();
    }

    @Override
    public boolean func_71344_c() {
        return true;
    }

    @Override
    public int func_71327_a(String string, int n) {
        return this.field_71340_o.func_73669_a(string, n);
    }

    @Override
    public String func_71330_a(String string, String string2) {
        return this.field_71340_o.func_73671_a(string, string2);
    }

    public boolean func_71332_a(String string, boolean bl) {
        return this.field_71340_o.func_73670_a(string, bl);
    }

    @Override
    public void func_71328_a(String string, Object object) {
        this.field_71340_o.func_73667_a(string, object);
    }

    @Override
    public void func_71326_a() {
        this.field_71340_o.func_73668_b();
    }

    @Override
    public String func_71329_c() {
        File file = this.field_71340_o.func_73665_c();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "No settings file";
    }

    @Override
    public String func_71277_t() {
        return this.func_71211_k();
    }

    @Override
    public int func_71234_u() {
        return this.func_71215_F();
    }

    @Override
    public String func_71274_v() {
        return this.func_71273_Y();
    }

    public void func_120011_ar() {
        MinecraftServerGui.func_120016_a(this);
        this.field_71335_s = true;
    }

    @Override
    public boolean func_71279_ae() {
        return this.field_71335_s;
    }

    @Override
    public boolean func_195565_a(GameType gameType, boolean bl, int n) {
        return false;
    }

    @Override
    public boolean func_82356_Z() {
        return this.field_71340_o.func_73670_a("enable-command-block", false);
    }

    @Override
    public int func_82357_ak() {
        return this.field_71340_o.func_73669_a("spawn-protection", super.func_82357_ak());
    }

    @Override
    public boolean func_175579_a(World world, BlockPos blockPos, EntityPlayer entityPlayer) {
        if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return false;
        }
        if (this.func_184103_al().func_152603_m().func_152690_d()) {
            return false;
        }
        if (this.func_184103_al().func_152596_g(entityPlayer.func_146103_bH())) {
            return false;
        }
        if (this.func_82357_ak() <= 0) {
            return false;
        }
        BlockPos blockPos2 = world.func_175694_M();
        int \u26032 = MathHelper.func_76130_a(blockPos.func_177958_n() - blockPos2.func_177958_n());
        int \u26033 = Math.max(\u26032, \u2603 = MathHelper.func_76130_a(blockPos.func_177952_p() - blockPos2.func_177952_p()));
        return \u26033 <= this.func_82357_ak();
    }

    @Override
    public int func_110455_j() {
        return this.field_71340_o.func_73669_a("op-permission-level", 4);
    }

    @Override
    public void func_143006_e(int n) {
        super.func_143006_e(n);
        this.field_71340_o.func_73667_a("player-idle-timeout", n);
        this.func_71326_a();
    }

    @Override
    public boolean func_195569_l() {
        return this.field_71340_o.func_73670_a("broadcast-rcon-to-ops", true);
    }

    @Override
    public boolean func_195041_r_() {
        return this.field_71340_o.func_73670_a("broadcast-console-to-ops", true);
    }

    @Override
    public int func_175580_aG() {
        int n = this.field_71340_o.func_73669_a("max-world-size", super.func_175580_aG());
        if (n < 1) {
            n = 1;
        } else if (n > super.func_175580_aG()) {
            n = super.func_175580_aG();
        }
        return n;
    }

    @Override
    public int func_175577_aI() {
        return this.field_71340_o.func_73669_a("network-compression-threshold", super.func_175577_aI());
    }

    protected boolean func_152368_aE() {
        int n;
        boolean bl = false;
        for (n = 0; !bl && n <= 2; ++n) {
            if (n > 0) {
                field_155771_h.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.func_152369_aG();
            }
            bl = PreYggdrasilConverter.func_152724_a(this);
        }
        boolean bl2 = false;
        for (n = 0; !bl2 && n <= 2; ++n) {
            if (n > 0) {
                field_155771_h.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.func_152369_aG();
            }
            bl2 = PreYggdrasilConverter.func_152722_b(this);
        }
        boolean bl3 = false;
        for (n = 0; !bl3 && n <= 2; ++n) {
            if (n > 0) {
                field_155771_h.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.func_152369_aG();
            }
            bl3 = PreYggdrasilConverter.func_152718_c(this);
        }
        boolean bl4 = false;
        for (n = 0; !bl4 && n <= 2; ++n) {
            if (n > 0) {
                field_155771_h.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.func_152369_aG();
            }
            bl4 = PreYggdrasilConverter.func_152710_d(this);
        }
        boolean bl5 = false;
        for (n = 0; !bl5 && n <= 2; ++n) {
            if (n > 0) {
                field_155771_h.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.func_152369_aG();
            }
            bl5 = PreYggdrasilConverter.func_152723_a(this, this.field_71340_o);
        }
        return bl || bl2 || bl3 || bl4 || bl5;
    }

    private void func_152369_aG() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public long func_175593_aQ() {
        return this.field_71340_o.func_179885_a("max-tick-time", TimeUnit.MINUTES.toMillis(1L));
    }

    @Override
    public String func_71258_A() {
        return "";
    }

    @Override
    public String func_71252_i(String string) {
        this.field_184115_n.func_70007_b();
        this.func_195571_aL().func_197059_a(this.field_184115_n.func_195540_f(), string);
        return this.field_184115_n.func_70008_c();
    }

    @Override
    public /* synthetic */ PlayerList func_184103_al() {
        return this.func_184103_al();
    }
}

