/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.AbstractResourcePack;
import net.minecraft.resources.ResourcePackFileNotFoundException;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.Util;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FolderPack
extends AbstractResourcePack {
    private static final Logger field_200699_b = LogManager.getLogger();
    private static final boolean field_195779_b = Util.func_110647_a() == Util.EnumOS.WINDOWS;
    private static final CharMatcher field_195780_c = CharMatcher.is((char)'\\');

    public FolderPack(File file) {
        super(file);
    }

    public static boolean func_195777_a(File file, String string) throws IOException {
        \u2603 = file.getCanonicalPath();
        if (field_195779_b) {
            \u2603 = field_195780_c.replaceFrom((CharSequence)\u2603, '/');
        }
        return \u2603.endsWith(string);
    }

    @Override
    protected InputStream func_195766_a(String string) throws IOException {
        File file = this.func_195776_e(string);
        if (file == null) {
            throw new ResourcePackFileNotFoundException(this.field_195771_a, string);
        }
        return new FileInputStream(file);
    }

    @Override
    protected boolean func_195768_c(String string) {
        return this.func_195776_e(string) != null;
    }

    @Nullable
    private File func_195776_e(String string) {
        try {
            File file = new File(this.field_195771_a, string);
            if (file.isFile() && FolderPack.func_195777_a(file, string)) {
                return file;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Set<String> func_195759_a(ResourcePackType resourcePackType) {
        HashSet hashSet = Sets.newHashSet();
        File \u26032 = new File(this.field_195771_a, resourcePackType.func_198956_a());
        File[] \u26033 = \u26032.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (\u26033 != null) {
            for (File file : \u26033) {
                String string = FolderPack.func_195767_a(\u26032, file);
                if (string.equals(string.toLowerCase(Locale.ROOT))) {
                    hashSet.add(string.substring(0, string.length() - 1));
                    continue;
                }
                this.func_195769_d(string);
            }
        }
        return hashSet;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Collection<ResourceLocation> func_195758_a(ResourcePackType resourcePackType, String string, int n, Predicate<String> predicate) {
        File file = new File(this.field_195771_a, resourcePackType.func_198956_a());
        ArrayList \u26032 = Lists.newArrayList();
        for (String string2 : this.func_195759_a(resourcePackType)) {
            this.func_199546_a(new File(new File(file, string2), string), n, string2, \u26032, string + "/", predicate);
        }
        return \u26032;
    }

    private void func_199546_a(File file, int n, String string, List<ResourceLocation> list, String string2, Predicate<String> predicate) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    if (n <= 0) continue;
                    this.func_199546_a(file2, n - 1, string, list, string2 + file2.getName() + "/", predicate);
                    continue;
                }
                if (file2.getName().endsWith(".mcmeta") || !predicate.test(file2.getName())) continue;
                try {
                    list.add(new ResourceLocation(string, string2 + file2.getName()));
                }
                catch (ResourceLocationException resourceLocationException) {
                    field_200699_b.error(resourceLocationException.getMessage());
                }
            }
        }
    }
}

