/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleResource;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FallbackResourceManager
implements IResourceManager {
    private static final Logger field_199024_b = LogManager.getLogger();
    protected final List<IResourcePack> field_199023_a = Lists.newArrayList();
    private final ResourcePackType field_199025_c;

    public FallbackResourceManager(ResourcePackType resourcePackType) {
        this.field_199025_c = resourcePackType;
    }

    public void func_199021_a(IResourcePack iResourcePack) {
        this.field_199023_a.add(iResourcePack);
    }

    @Override
    public IResource func_199002_a(ResourceLocation resourceLocation) throws IOException {
        this.func_199022_d(resourceLocation);
        IResourcePack iResourcePack = null;
        ResourceLocation \u26032 = FallbackResourceManager.func_199020_c(resourceLocation);
        for (int i = this.field_199023_a.size() - 1; i >= 0; --i) {
            IResourcePack iResourcePack2 = this.field_199023_a.get(i);
            if (iResourcePack == null && iResourcePack2.func_195764_b(this.field_199025_c, \u26032)) {
                iResourcePack = iResourcePack2;
            }
            if (!iResourcePack2.func_195764_b(this.field_199025_c, resourceLocation)) continue;
            InputStream \u26033 = null;
            if (iResourcePack != null) {
                \u26033 = this.func_199019_a(\u26032, iResourcePack);
            }
            return new SimpleResource(iResourcePack2.func_195762_a(), resourceLocation, this.func_199019_a(resourceLocation, iResourcePack2), \u26033);
        }
        throw new FileNotFoundException(resourceLocation.toString());
    }

    protected InputStream func_199019_a(ResourceLocation resourceLocation, IResourcePack iResourcePack) throws IOException {
        InputStream inputStream = iResourcePack.func_195761_a(this.field_199025_c, resourceLocation);
        return field_199024_b.isDebugEnabled() ? new LeakComplainerInputStream(inputStream, resourceLocation, iResourcePack.func_195762_a()) : inputStream;
    }

    private void func_199022_d(ResourceLocation resourceLocation) throws IOException {
        if (resourceLocation.func_110623_a().contains("..")) {
            throw new IOException("Invalid relative path to resource: " + resourceLocation);
        }
    }

    @Override
    public List<IResource> func_199004_b(ResourceLocation resourceLocation) throws IOException {
        this.func_199022_d(resourceLocation);
        ArrayList arrayList = Lists.newArrayList();
        ResourceLocation \u26032 = FallbackResourceManager.func_199020_c(resourceLocation);
        for (IResourcePack iResourcePack : this.field_199023_a) {
            if (!iResourcePack.func_195764_b(this.field_199025_c, resourceLocation)) continue;
            InputStream inputStream = iResourcePack.func_195764_b(this.field_199025_c, \u26032) ? this.func_199019_a(\u26032, iResourcePack) : null;
            arrayList.add(new SimpleResource(iResourcePack.func_195762_a(), resourceLocation, this.func_199019_a(resourceLocation, iResourcePack), inputStream));
        }
        if (arrayList.isEmpty()) {
            throw new FileNotFoundException(resourceLocation.toString());
        }
        return arrayList;
    }

    @Override
    public Collection<ResourceLocation> func_199003_a(String string, Predicate<String> predicate) {
        ArrayList arrayList = Lists.newArrayList();
        for (IResourcePack iResourcePack : this.field_199023_a) {
            arrayList.addAll(iResourcePack.func_195758_a(this.field_199025_c, string, Integer.MAX_VALUE, predicate));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    static ResourceLocation func_199020_c(ResourceLocation resourceLocation) {
        return new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a() + ".mcmeta");
    }

    static class LeakComplainerInputStream
    extends InputStream {
        private final InputStream field_198998_a;
        private final String field_198999_b;
        private boolean field_199000_c;

        public LeakComplainerInputStream(InputStream inputStream, ResourceLocation resourceLocation, String string) {
            this.field_198998_a = inputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(byteArrayOutputStream));
            this.field_198999_b = "Leaked resource: '" + resourceLocation + "' loaded from pack: '" + string + "'\n" + byteArrayOutputStream;
        }

        @Override
        public void close() throws IOException {
            this.field_198998_a.close();
            this.field_199000_c = true;
        }

        protected void finalize() throws Throwable {
            if (!this.field_199000_c) {
                field_199024_b.warn(this.field_198999_b);
            }
            super.finalize();
        }

        @Override
        public int read() throws IOException {
            return this.field_198998_a.read();
        }
    }
}

