/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;

public class PotionUtils {
    public static List<PotionEffect> func_185189_a(ItemStack itemStack) {
        return PotionUtils.func_185185_a(itemStack.func_77978_p());
    }

    public static List<PotionEffect> func_185186_a(PotionType potionType, Collection<PotionEffect> collection) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(potionType.func_185170_a());
        arrayList.addAll(collection);
        return arrayList;
    }

    public static List<PotionEffect> func_185185_a(@Nullable NBTTagCompound nBTTagCompound) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(PotionUtils.func_185187_c(nBTTagCompound).func_185170_a());
        PotionUtils.func_185193_a(nBTTagCompound, arrayList);
        return arrayList;
    }

    public static List<PotionEffect> func_185190_b(ItemStack itemStack) {
        return PotionUtils.func_185192_b(itemStack.func_77978_p());
    }

    public static List<PotionEffect> func_185192_b(@Nullable NBTTagCompound nBTTagCompound) {
        ArrayList arrayList = Lists.newArrayList();
        PotionUtils.func_185193_a(nBTTagCompound, arrayList);
        return arrayList;
    }

    public static void func_185193_a(@Nullable NBTTagCompound nBTTagCompound, List<PotionEffect> list) {
        if (nBTTagCompound != null && nBTTagCompound.func_150297_b("CustomPotionEffects", 9)) {
            NBTTagList nBTTagList = nBTTagCompound.func_150295_c("CustomPotionEffects", 10);
            for (int i = 0; i < nBTTagList.size(); ++i) {
                NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
                PotionEffect \u26032 = PotionEffect.func_82722_b(nBTTagCompound2);
                if (\u26032 == null) continue;
                list.add(\u26032);
            }
        }
    }

    public static int func_190932_c(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound != null && nBTTagCompound.func_150297_b("CustomPotionColor", 99)) {
            return nBTTagCompound.func_74762_e("CustomPotionColor");
        }
        return PotionUtils.func_185191_c(itemStack) == PotionTypes.field_185229_a ? 0xF800F8 : PotionUtils.func_185181_a(PotionUtils.func_185189_a(itemStack));
    }

    public static int func_185183_a(PotionType potionType) {
        return potionType == PotionTypes.field_185229_a ? 0xF800F8 : PotionUtils.func_185181_a(potionType.func_185170_a());
    }

    public static int func_185181_a(Collection<PotionEffect> collection) {
        int n;
        int n2 = 3694022;
        if (collection.isEmpty()) {
            return 3694022;
        }
        float \u26032 = 0.0f;
        float \u26033 = 0.0f;
        float \u26034 = 0.0f;
        n = 0;
        for (PotionEffect potionEffect : collection) {
            if (!potionEffect.func_188418_e()) continue;
            int n3 = potionEffect.func_188419_a().func_76401_j();
            \u2603 = potionEffect.func_76458_c() + 1;
            \u26032 += (float)(\u2603 * (n3 >> 16 & 0xFF)) / 255.0f;
            \u26033 += (float)(\u2603 * (n3 >> 8 & 0xFF)) / 255.0f;
            \u26034 += (float)(\u2603 * (n3 >> 0 & 0xFF)) / 255.0f;
            n += \u2603;
        }
        if (n == 0) {
            return 0;
        }
        \u26032 = \u26032 / (float)n * 255.0f;
        \u26033 = \u26033 / (float)n * 255.0f;
        \u26034 = \u26034 / (float)n * 255.0f;
        return (int)\u26032 << 16 | (int)\u26033 << 8 | (int)\u26034;
    }

    public static PotionType func_185191_c(ItemStack itemStack) {
        return PotionUtils.func_185187_c(itemStack.func_77978_p());
    }

    public static PotionType func_185187_c(@Nullable NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound == null) {
            return PotionTypes.field_185229_a;
        }
        return PotionType.func_185168_a(nBTTagCompound.func_74779_i("Potion"));
    }

    public static ItemStack func_185188_a(ItemStack itemStack, PotionType potionType) {
        ResourceLocation resourceLocation = IRegistry.field_212621_j.func_177774_c(potionType);
        if (potionType == PotionTypes.field_185229_a) {
            itemStack.func_196083_e("Potion");
        } else {
            itemStack.func_196082_o().func_74778_a("Potion", resourceLocation.toString());
        }
        return itemStack;
    }

    public static ItemStack func_185184_a(ItemStack itemStack, Collection<PotionEffect> collection) {
        if (collection.isEmpty()) {
            return itemStack;
        }
        NBTTagCompound nBTTagCompound = itemStack.func_196082_o();
        NBTTagList \u26032 = nBTTagCompound.func_150295_c("CustomPotionEffects", 9);
        for (PotionEffect potionEffect : collection) {
            \u26032.add(potionEffect.func_82719_a(new NBTTagCompound()));
        }
        nBTTagCompound.func_74782_a("CustomPotionEffects", \u26032);
        return itemStack;
    }
}

