/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCollection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTDynamicOps
implements DynamicOps<INBTBase> {
    public static final NBTDynamicOps field_210820_a = new NBTDynamicOps();

    protected NBTDynamicOps() {
    }

    public INBTBase empty() {
        return new NBTTagEnd();
    }

    public Type<?> getType(INBTBase iNBTBase) {
        switch (iNBTBase.func_74732_a()) {
            case 0: {
                return DSL.nilType();
            }
            case 1: {
                return DSL.byteType();
            }
            case 2: {
                return DSL.shortType();
            }
            case 3: {
                return DSL.intType();
            }
            case 4: {
                return DSL.longType();
            }
            case 5: {
                return DSL.floatType();
            }
            case 6: {
                return DSL.doubleType();
            }
            case 7: {
                return DSL.list((Type)DSL.byteType());
            }
            case 8: {
                return DSL.string();
            }
            case 9: {
                return DSL.list((Type)DSL.remainderType());
            }
            case 10: {
                return DSL.compoundList((Type)DSL.remainderType(), (Type)DSL.remainderType());
            }
            case 11: {
                return DSL.list((Type)DSL.intType());
            }
            case 12: {
                return DSL.list((Type)DSL.longType());
            }
        }
        return DSL.remainderType();
    }

    public Optional<Number> getNumberValue(INBTBase iNBTBase) {
        if (iNBTBase instanceof NBTPrimitive) {
            return Optional.of(((NBTPrimitive)iNBTBase).func_209908_j());
        }
        return Optional.empty();
    }

    public INBTBase createNumeric(Number number) {
        return new NBTTagDouble(number.doubleValue());
    }

    public INBTBase createByte(byte by) {
        return new NBTTagByte(by);
    }

    public INBTBase createShort(short s) {
        return new NBTTagShort(s);
    }

    public INBTBase createInt(int n) {
        return new NBTTagInt(n);
    }

    public INBTBase createLong(long l) {
        return new NBTTagLong(l);
    }

    public INBTBase createFloat(float f) {
        return new NBTTagFloat(f);
    }

    public INBTBase createDouble(double d) {
        return new NBTTagDouble(d);
    }

    public Optional<String> getStringValue(INBTBase iNBTBase) {
        if (iNBTBase instanceof NBTTagString) {
            return Optional.of(iNBTBase.func_150285_a_());
        }
        return Optional.empty();
    }

    public INBTBase createString(String string) {
        return new NBTTagString(string);
    }

    public INBTBase mergeInto(INBTBase iNBTBase3, INBTBase iNBTBase22) {
        INBTBase iNBTBase3;
        if (iNBTBase22 instanceof NBTTagEnd) {
            return iNBTBase3;
        }
        if (iNBTBase3 instanceof NBTTagCompound) {
            if (iNBTBase22 instanceof NBTTagCompound) {
                INBTBase iNBTBase22;
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                \u2603 = (NBTTagCompound)iNBTBase3;
                for (String string : \u2603.func_150296_c()) {
                    nBTTagCompound.func_74782_a(string, \u2603.func_74781_a(string));
                }
                NBTTagCompound \u26032 = (NBTTagCompound)iNBTBase22;
                for (String string : \u26032.func_150296_c()) {
                    nBTTagCompound.func_74782_a(string, \u26032.func_74781_a(string));
                }
                return nBTTagCompound;
            }
            return iNBTBase3;
        }
        if (iNBTBase3 instanceof NBTTagEnd) {
            throw new IllegalArgumentException("mergeInto called with a null input.");
        }
        if (!(iNBTBase3 instanceof NBTTagCollection)) {
            return iNBTBase3;
        }
        NBTTagList \u26033 = new NBTTagList();
        NBTTagCollection \u26034 = (NBTTagCollection)iNBTBase3;
        \u26033.addAll(\u26034);
        ((AbstractList)\u26033).add(iNBTBase22);
        return \u26033;
    }

    public INBTBase mergeInto(INBTBase iNBTBase4, INBTBase iNBTBase2, INBTBase iNBTBase3) {
        INBTBase iNBTBase4;
        NBTTagCompound nBTTagCompound;
        if (iNBTBase4 instanceof NBTTagEnd) {
            nBTTagCompound = new NBTTagCompound();
        } else if (iNBTBase4 instanceof NBTTagCompound) {
            NBTTagCompound nBTTagCompound2 = (NBTTagCompound)iNBTBase4;
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound2.func_150296_c().forEach(string -> nBTTagCompound.func_74782_a((String)string, nBTTagCompound2.func_74781_a((String)string)));
        } else {
            return iNBTBase4;
        }
        nBTTagCompound.func_74782_a(iNBTBase2.func_150285_a_(), iNBTBase3);
        return nBTTagCompound;
    }

    public INBTBase merge(INBTBase iNBTBase3, INBTBase iNBTBase2) {
        INBTBase iNBTBase3;
        if (iNBTBase3 instanceof NBTTagEnd) {
            return iNBTBase2;
        }
        if (iNBTBase2 instanceof NBTTagEnd) {
            return iNBTBase3;
        }
        if (iNBTBase3 instanceof NBTTagCompound && iNBTBase2 instanceof NBTTagCompound) {
            \u2603 = (NBTTagCompound)iNBTBase3;
            NBTTagCompound nBTTagCompound = (NBTTagCompound)iNBTBase2;
            \u2603 = new NBTTagCompound();
            ((NBTTagCompound)\u2603).func_150296_c().forEach(arg_0 -> NBTDynamicOps.func_211384_c(\u2603, (NBTTagCompound)\u2603, arg_0));
            nBTTagCompound.func_150296_c().forEach(string -> \u2603.func_74782_a((String)string, nBTTagCompound.func_74781_a((String)string)));
        }
        if (iNBTBase3 instanceof NBTTagCollection && iNBTBase2 instanceof NBTTagCollection) {
            \u2603 = new NBTTagList();
            ((AbstractCollection)((Object)\u2603)).addAll((NBTTagCollection)iNBTBase3);
            ((AbstractCollection)((Object)\u2603)).addAll((NBTTagCollection)iNBTBase2);
            return \u2603;
        }
        throw new IllegalArgumentException("Could not merge " + iNBTBase3 + " and " + iNBTBase2);
    }

    public Optional<Map<INBTBase, INBTBase>> getMapValues(INBTBase iNBTBase) {
        if (iNBTBase instanceof NBTTagCompound) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)iNBTBase;
            return Optional.of(nBTTagCompound.func_150296_c().stream().map(string -> Pair.of((Object)this.createString((String)string), (Object)nBTTagCompound.func_74781_a((String)string))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }
        return Optional.empty();
    }

    public INBTBase createMap(Map<INBTBase, INBTBase> map) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        for (Map.Entry<INBTBase, INBTBase> entry : map.entrySet()) {
            nBTTagCompound.func_74782_a(entry.getKey().func_150285_a_(), entry.getValue());
        }
        return nBTTagCompound;
    }

    public Optional<Stream<INBTBase>> getStream(INBTBase iNBTBase2) {
        if (iNBTBase2 instanceof NBTTagCollection) {
            return Optional.of(((NBTTagCollection)iNBTBase2).stream().map(iNBTBase -> iNBTBase));
        }
        return Optional.empty();
    }

    public Optional<ByteBuffer> getByteBuffer(INBTBase iNBTBase) {
        if (iNBTBase instanceof NBTTagByteArray) {
            return Optional.of(ByteBuffer.wrap(((NBTTagByteArray)iNBTBase).func_150292_c()));
        }
        return super.getByteBuffer((Object)iNBTBase);
    }

    public INBTBase createByteList(ByteBuffer byteBuffer) {
        return new NBTTagByteArray(DataFixUtils.toArray((ByteBuffer)byteBuffer));
    }

    public Optional<IntStream> getIntStream(INBTBase iNBTBase) {
        if (iNBTBase instanceof NBTTagIntArray) {
            return Optional.of(Arrays.stream(((NBTTagIntArray)iNBTBase).func_150302_c()));
        }
        return super.getIntStream((Object)iNBTBase);
    }

    public INBTBase createIntList(IntStream intStream) {
        return new NBTTagIntArray(intStream.toArray());
    }

    public Optional<LongStream> getLongStream(INBTBase iNBTBase) {
        if (iNBTBase instanceof NBTTagLongArray) {
            return Optional.of(Arrays.stream(((NBTTagLongArray)iNBTBase).func_197652_h()));
        }
        return super.getLongStream((Object)iNBTBase);
    }

    public INBTBase createLongList(LongStream longStream) {
        return new NBTTagLongArray(longStream.toArray());
    }

    public INBTBase createList(Stream<INBTBase> stream) {
        PeekingIterator peekingIterator = Iterators.peekingIterator(stream.iterator());
        if (!peekingIterator.hasNext()) {
            return new NBTTagList();
        }
        INBTBase \u26032 = (INBTBase)peekingIterator.peek();
        if (\u26032 instanceof NBTTagByte) {
            ArrayList arrayList = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, iNBTBase -> ((NBTTagByte)iNBTBase).func_150290_f()));
            return new NBTTagByteArray(arrayList);
        }
        if (\u26032 instanceof NBTTagInt) {
            ArrayList \u26033 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, iNBTBase -> ((NBTTagInt)iNBTBase).func_150287_d()));
            return new NBTTagIntArray(\u26033);
        }
        if (\u26032 instanceof NBTTagLong) {
            ArrayList \u26034 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, iNBTBase -> ((NBTTagLong)iNBTBase).func_150291_c()));
            return new NBTTagLongArray(\u26034);
        }
        NBTTagList nBTTagList = new NBTTagList();
        while (peekingIterator.hasNext()) {
            INBTBase iNBTBase2 = (INBTBase)peekingIterator.next();
            if (iNBTBase2 instanceof NBTTagEnd) continue;
            nBTTagList.add(iNBTBase2);
        }
        return nBTTagList;
    }

    public INBTBase remove(INBTBase iNBTBase2, String string3) {
        INBTBase iNBTBase2;
        if (iNBTBase2 instanceof NBTTagCompound) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)iNBTBase2;
            \u2603 = new NBTTagCompound();
            nBTTagCompound.func_150296_c().stream().filter(string2 -> !Objects.equals(string2, string3)).forEach(string -> \u2603.func_74782_a((String)string, nBTTagCompound.func_74781_a((String)string)));
            return \u2603;
        }
        return iNBTBase2;
    }

    public String toString() {
        return "NBT";
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.remove((INBTBase)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.createLongList(longStream);
    }

    public /* synthetic */ Optional getLongStream(Object object) {
        return this.getLongStream((INBTBase)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.createIntList(intStream);
    }

    public /* synthetic */ Optional getIntStream(Object object) {
        return this.getIntStream((INBTBase)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.createByteList(byteBuffer);
    }

    public /* synthetic */ Optional getByteBuffer(Object object) {
        return this.getByteBuffer((INBTBase)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.createList(stream);
    }

    public /* synthetic */ Optional getStream(Object object) {
        return this.getStream((INBTBase)object);
    }

    public /* synthetic */ Object createMap(Map map) {
        return this.createMap(map);
    }

    public /* synthetic */ Optional getMapValues(Object object) {
        return this.getMapValues((INBTBase)object);
    }

    public /* synthetic */ Object merge(Object object, Object object2) {
        return this.merge((INBTBase)object, (INBTBase)object2);
    }

    public /* synthetic */ Object mergeInto(Object object, Object object2, Object object3) {
        return this.mergeInto((INBTBase)object, (INBTBase)object2, (INBTBase)object3);
    }

    public /* synthetic */ Object mergeInto(Object object, Object object2) {
        return this.mergeInto((INBTBase)object, (INBTBase)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.createString(string);
    }

    public /* synthetic */ Optional getStringValue(Object object) {
        return this.getStringValue((INBTBase)object);
    }

    public /* synthetic */ Object createDouble(double d) {
        return this.createDouble(d);
    }

    public /* synthetic */ Object createFloat(float f) {
        return this.createFloat(f);
    }

    public /* synthetic */ Object createLong(long l) {
        return this.createLong(l);
    }

    public /* synthetic */ Object createInt(int n) {
        return this.createInt(n);
    }

    public /* synthetic */ Object createShort(short s) {
        return this.createShort(s);
    }

    public /* synthetic */ Object createByte(byte by) {
        return this.createByte(by);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.createNumeric(number);
    }

    public /* synthetic */ Optional getNumberValue(Object object) {
        return this.getNumberValue((INBTBase)object);
    }

    public /* synthetic */ Type getType(Object object) {
        return this.getType((INBTBase)object);
    }

    public /* synthetic */ Object empty() {
        return this.empty();
    }

    private static /* synthetic */ void func_211384_c(NBTTagCompound nBTTagCompound, NBTTagCompound nBTTagCompound2, String string) {
        nBTTagCompound.func_74782_a(string, nBTTagCompound2.func_74781_a(string));
    }
}

