/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.init;

import java.io.PrintStream;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarvedPumpkin;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSkullWither;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.EntityOptions;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBoneMeal;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemSpawnEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionType;
import net.minecraft.server.DebugLoggingPrintStream;
import net.minecraft.stats.StatList;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.LoggingPrintStream;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGeneratorType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Bootstrap {
    public static final PrintStream field_179872_a = System.out;
    private static boolean field_151355_a;
    private static final Logger field_179871_c;

    public static boolean func_179869_a() {
        return field_151355_a;
    }

    static void func_151353_a() {
        BlockDispenser.func_199774_a(Items.field_151032_g, new BehaviorProjectileDispense(){

            @Override
            protected IProjectile func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                EntityTippedArrow entityTippedArrow = new EntityTippedArrow(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c());
                entityTippedArrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entityTippedArrow;
            }
        });
        BlockDispenser.func_199774_a(Items.field_185167_i, new BehaviorProjectileDispense(){

            @Override
            protected IProjectile func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                EntityTippedArrow entityTippedArrow = new EntityTippedArrow(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c());
                entityTippedArrow.func_184555_a(itemStack);
                entityTippedArrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entityTippedArrow;
            }
        });
        BlockDispenser.func_199774_a(Items.field_185166_h, new BehaviorProjectileDispense(){

            @Override
            protected IProjectile func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                EntitySpectralArrow entitySpectralArrow = new EntitySpectralArrow(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c());
                entitySpectralArrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entitySpectralArrow;
            }
        });
        BlockDispenser.func_199774_a(Items.field_151110_aK, new BehaviorProjectileDispense(){

            @Override
            protected IProjectile func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                return new EntityEgg(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c());
            }
        });
        BlockDispenser.func_199774_a(Items.field_151126_ay, new BehaviorProjectileDispense(){

            @Override
            protected IProjectile func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                return new EntitySnowball(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c());
            }
        });
        BlockDispenser.func_199774_a(Items.field_151062_by, new BehaviorProjectileDispense(){

            @Override
            protected IProjectile func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                return new EntityExpBottle(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c());
            }

            @Override
            protected float func_82498_a() {
                return super.func_82498_a() * 0.5f;
            }

            @Override
            protected float func_82500_b() {
                return super.func_82500_b() * 1.25f;
            }
        });
        BlockDispenser.func_199774_a(Items.field_185155_bH, new IBehaviorDispenseItem(){

            @Override
            public ItemStack dispense(IBlockSource iBlockSource, final ItemStack itemStack) {
                return new BehaviorProjectileDispense(){

                    @Override
                    protected IProjectile func_82499_a(World world, IPosition iPosition, ItemStack itemStack2) {
                        return new EntityPotion(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c(), itemStack.func_77946_l());
                    }

                    @Override
                    protected float func_82498_a() {
                        return super.func_82498_a() * 0.5f;
                    }

                    @Override
                    protected float func_82500_b() {
                        return super.func_82500_b() * 1.25f;
                    }
                }.dispense(iBlockSource, itemStack);
            }
        });
        BlockDispenser.func_199774_a(Items.field_185156_bI, new IBehaviorDispenseItem(){

            @Override
            public ItemStack dispense(IBlockSource iBlockSource, final ItemStack itemStack) {
                return new BehaviorProjectileDispense(){

                    @Override
                    protected IProjectile func_82499_a(World world, IPosition iPosition, ItemStack itemStack2) {
                        return new EntityPotion(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c(), itemStack.func_77946_l());
                    }

                    @Override
                    protected float func_82498_a() {
                        return super.func_82498_a() * 0.5f;
                    }

                    @Override
                    protected float func_82500_b() {
                        return super.func_82500_b() * 1.25f;
                    }
                }.dispense(iBlockSource, itemStack);
            }
        });
        BehaviorDefaultDispenseItem behaviorDefaultDispenseItem = new BehaviorDefaultDispenseItem(){

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                EnumFacing enumFacing = iBlockSource.func_189992_e().func_177229_b(BlockDispenser.field_176441_a);
                EntityType<?> \u26032 = ((ItemSpawnEgg)itemStack.func_77973_b()).func_208076_b(itemStack.func_77978_p());
                if (\u26032 != null) {
                    \u26032.func_208049_a(iBlockSource.func_197524_h(), itemStack, null, iBlockSource.func_180699_d().func_177972_a(enumFacing), enumFacing != EnumFacing.UP, false);
                }
                itemStack.func_190918_g(1);
                return itemStack;
            }
        };
        for (ItemSpawnEgg itemSpawnEgg : ItemSpawnEgg.func_195985_g()) {
            BlockDispenser.func_199774_a(itemSpawnEgg, behaviorDefaultDispenseItem);
        }
        BlockDispenser.func_199774_a(Items.field_196152_dE, new BehaviorDefaultDispenseItem(){

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                EnumFacing enumFacing = iBlockSource.func_189992_e().func_177229_b(BlockDispenser.field_176441_a);
                double \u26032 = iBlockSource.func_82615_a() + (double)enumFacing.func_82601_c();
                double \u26033 = (float)iBlockSource.func_180699_d().func_177956_o() + 0.2f;
                double \u26034 = iBlockSource.func_82616_c() + (double)enumFacing.func_82599_e();
                EntityFireworkRocket \u26035 = new EntityFireworkRocket(iBlockSource.func_197524_h(), \u26032, \u26033, \u26034, itemStack);
                iBlockSource.func_197524_h().func_72838_d(\u26035);
                itemStack.func_190918_g(1);
                return itemStack;
            }

            @Override
            protected void func_82485_a(IBlockSource iBlockSource) {
                iBlockSource.func_197524_h().func_175718_b(1004, iBlockSource.func_180699_d(), 0);
            }
        });
        BlockDispenser.func_199774_a(Items.field_151059_bz, new BehaviorDefaultDispenseItem(){

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                EnumFacing enumFacing = iBlockSource.func_189992_e().func_177229_b(BlockDispenser.field_176441_a);
                IPosition \u26032 = BlockDispenser.func_149939_a(iBlockSource);
                double \u26033 = \u26032.func_82615_a() + (double)((float)enumFacing.func_82601_c() * 0.3f);
                double \u26034 = \u26032.func_82617_b() + (double)((float)enumFacing.func_96559_d() * 0.3f);
                double \u26035 = \u26032.func_82616_c() + (double)((float)enumFacing.func_82599_e() * 0.3f);
                World \u26036 = iBlockSource.func_197524_h();
                Random \u26037 = \u26036.field_73012_v;
                double \u26038 = \u26037.nextGaussian() * 0.05 + (double)enumFacing.func_82601_c();
                double \u26039 = \u26037.nextGaussian() * 0.05 + (double)enumFacing.func_96559_d();
                double \u260310 = \u26037.nextGaussian() * 0.05 + (double)enumFacing.func_82599_e();
                \u26036.func_72838_d(new EntitySmallFireball(\u26036, \u26033, \u26034, \u26035, \u26038, \u26039, \u260310));
                itemStack.func_190918_g(1);
                return itemStack;
            }

            @Override
            protected void func_82485_a(IBlockSource iBlockSource) {
                iBlockSource.func_197524_h().func_175718_b(1018, iBlockSource.func_180699_d(), 0);
            }
        });
        BlockDispenser.func_199774_a(Items.field_151124_az, new BehaviorDispenseBoat(EntityBoat.Type.OAK));
        BlockDispenser.func_199774_a(Items.field_185150_aH, new BehaviorDispenseBoat(EntityBoat.Type.SPRUCE));
        BlockDispenser.func_199774_a(Items.field_185151_aI, new BehaviorDispenseBoat(EntityBoat.Type.BIRCH));
        BlockDispenser.func_199774_a(Items.field_185152_aJ, new BehaviorDispenseBoat(EntityBoat.Type.JUNGLE));
        BlockDispenser.func_199774_a(Items.field_185154_aL, new BehaviorDispenseBoat(EntityBoat.Type.DARK_OAK));
        BlockDispenser.func_199774_a(Items.field_185153_aK, new BehaviorDispenseBoat(EntityBoat.Type.ACACIA));
        BehaviorDefaultDispenseItem behaviorDefaultDispenseItem2 = new BehaviorDefaultDispenseItem(){
            private final BehaviorDefaultDispenseItem field_150841_b = new BehaviorDefaultDispenseItem();

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                ItemBucket itemBucket = (ItemBucket)itemStack.func_77973_b();
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(BlockDispenser.field_176441_a));
                World \u26033 = iBlockSource.func_197524_h();
                if (itemBucket.func_180616_a(null, \u26033, \u26032, null)) {
                    itemBucket.func_203792_a(\u26033, itemStack, \u26032);
                    return new ItemStack(Items.field_151133_ar);
                }
                return this.field_150841_b.dispense(iBlockSource, itemStack);
            }
        };
        BlockDispenser.func_199774_a(Items.field_151129_at, behaviorDefaultDispenseItem2);
        BlockDispenser.func_199774_a(Items.field_151131_as, behaviorDefaultDispenseItem2);
        BlockDispenser.func_199774_a(Items.field_203796_aM, behaviorDefaultDispenseItem2);
        BlockDispenser.func_199774_a(Items.field_203797_aN, behaviorDefaultDispenseItem2);
        BlockDispenser.func_199774_a(Items.field_203795_aL, behaviorDefaultDispenseItem2);
        BlockDispenser.func_199774_a(Items.field_204272_aO, behaviorDefaultDispenseItem2);
        BlockDispenser.func_199774_a(Items.field_151133_ar, new BehaviorDefaultDispenseItem(){
            private final BehaviorDefaultDispenseItem field_150840_b = new BehaviorDefaultDispenseItem();

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource2, ItemStack itemStack) {
                Fluid fluid;
                World world = iBlockSource2.func_197524_h();
                IBlockState \u26032 = world.func_180495_p(\u2603 = iBlockSource2.func_180699_d().func_177972_a(iBlockSource2.func_189992_e().func_177229_b(BlockDispenser.field_176441_a)));
                Block \u26033 = \u26032.func_177230_c();
                if (\u26033 instanceof IBucketPickupHandler) {
                    fluid = ((IBucketPickupHandler)((Object)\u26033)).func_204508_a(world, \u2603, \u26032);
                    if (!(fluid instanceof FlowingFluid)) {
                        return super.func_82487_b(iBlockSource2, itemStack);
                    }
                } else {
                    IBlockSource iBlockSource2;
                    return super.func_82487_b(iBlockSource2, itemStack);
                }
                Item \u26034 = fluid.func_204524_b();
                itemStack.func_190918_g(1);
                if (itemStack.func_190926_b()) {
                    return new ItemStack(\u26034);
                }
                if (((TileEntityDispenser)iBlockSource2.func_150835_j()).func_146019_a(new ItemStack(\u26034)) < 0) {
                    this.field_150840_b.dispense(iBlockSource2, new ItemStack(\u26034));
                }
                return itemStack;
            }
        });
        BlockDispenser.func_199774_a(Items.field_151033_d, new BehaviorDispenseOptional(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack2) {
                ItemStack itemStack2;
                World world = iBlockSource.func_197524_h();
                this.field_190911_b = true;
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(BlockDispenser.field_176441_a));
                if (ItemFlintAndSteel.func_201825_a(world, \u26032)) {
                    world.func_175656_a(\u26032, Blocks.field_150480_ab.func_176223_P());
                } else {
                    Block block = world.func_180495_p(\u26032).func_177230_c();
                    if (block instanceof BlockTNT) {
                        ((BlockTNT)block).func_196534_a(world, \u26032);
                        world.func_175698_g(\u26032);
                    } else {
                        this.field_190911_b = false;
                    }
                }
                if (this.field_190911_b && itemStack2.func_96631_a(1, world.field_73012_v, null)) {
                    itemStack2.func_190920_e(0);
                }
                return itemStack2;
            }
        });
        BlockDispenser.func_199774_a(Items.field_196106_bc, new BehaviorDispenseOptional(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                this.field_190911_b = true;
                World world = iBlockSource.func_197524_h();
                if (ItemBoneMeal.func_195966_a(itemStack, world, \u2603 = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(BlockDispenser.field_176441_a))) || ItemBoneMeal.func_203173_b(itemStack, world, \u2603, null)) {
                    if (!world.field_72995_K) {
                        world.func_175718_b(2005, \u2603, 0);
                    }
                } else {
                    this.field_190911_b = false;
                }
                return itemStack;
            }
        });
        BlockDispenser.func_199774_a(Blocks.field_150335_W, new BehaviorDefaultDispenseItem(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                World world = iBlockSource.func_197524_h();
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(BlockDispenser.field_176441_a));
                EntityTNTPrimed \u26033 = new EntityTNTPrimed(world, (double)\u26032.func_177958_n() + 0.5, \u26032.func_177956_o(), (double)\u26032.func_177952_p() + 0.5, null);
                world.func_72838_d(\u26033);
                world.func_184148_a(null, \u26033.field_70165_t, \u26033.field_70163_u, \u26033.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                itemStack.func_190918_g(1);
                return itemStack;
            }
        });
        BehaviorDispenseOptional behaviorDispenseOptional = new BehaviorDispenseOptional(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                this.field_190911_b = !ItemArmor.func_185082_a(iBlockSource, itemStack).func_190926_b();
                return itemStack;
            }
        };
        BlockDispenser.func_199774_a(Items.field_196185_dy, behaviorDispenseOptional);
        BlockDispenser.func_199774_a(Items.field_196186_dz, behaviorDispenseOptional);
        BlockDispenser.func_199774_a(Items.field_196151_dA, behaviorDispenseOptional);
        BlockDispenser.func_199774_a(Items.field_196182_dv, behaviorDispenseOptional);
        BlockDispenser.func_199774_a(Items.field_196184_dx, behaviorDispenseOptional);
        BlockDispenser.func_199774_a(Items.field_196183_dw, new BehaviorDispenseOptional(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource2, ItemStack itemStack) {
                IBlockSource iBlockSource2;
                World world = iBlockSource2.func_197524_h();
                EnumFacing \u26032 = iBlockSource2.func_189992_e().func_177229_b(BlockDispenser.field_176441_a);
                BlockPos \u26033 = iBlockSource2.func_180699_d().func_177972_a(\u26032);
                this.field_190911_b = true;
                if (world.func_175623_d(\u26033) && BlockSkullWither.func_196299_b(world, \u26033, itemStack)) {
                    world.func_180501_a(\u26033, (IBlockState)Blocks.field_196705_eO.func_176223_P().func_206870_a(BlockSkull.field_196294_a, \u26032.func_176740_k() == EnumFacing.Axis.Y ? 0 : \u26032.func_176734_d().func_176736_b() * 4), 3);
                    TileEntity tileEntity = world.func_175625_s(\u26033);
                    if (tileEntity instanceof TileEntitySkull) {
                        BlockSkullWither.func_196298_a(world, \u26033, (TileEntitySkull)tileEntity);
                    }
                    itemStack.func_190918_g(1);
                } else if (ItemArmor.func_185082_a(iBlockSource2, itemStack).func_190926_b()) {
                    this.field_190911_b = false;
                }
                return itemStack;
            }
        });
        BlockDispenser.func_199774_a(Blocks.field_196625_cS, new BehaviorDispenseOptional(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack2) {
                ItemStack itemStack2;
                World world = iBlockSource.func_197524_h();
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(BlockDispenser.field_176441_a));
                BlockCarvedPumpkin \u26033 = (BlockCarvedPumpkin)Blocks.field_196625_cS;
                this.field_190911_b = true;
                if (world.func_175623_d(\u26032) && \u26033.func_196354_a(world, \u26032)) {
                    if (!world.field_72995_K) {
                        world.func_180501_a(\u26032, \u26033.func_176223_P(), 3);
                    }
                    itemStack2.func_190918_g(1);
                } else {
                    ItemStack itemStack3 = ItemArmor.func_185082_a(iBlockSource, itemStack2);
                    if (itemStack3.func_190926_b()) {
                        this.field_190911_b = false;
                    }
                }
                return itemStack2;
            }
        });
        BlockDispenser.func_199774_a(Blocks.field_204409_il.func_199767_j(), new BehaviorDispenseShulkerBox());
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            BlockDispenser.func_199774_a(BlockShulkerBox.func_190952_a(enumDyeColor).func_199767_j(), new BehaviorDispenseShulkerBox());
        }
    }

    public static void func_151354_b() {
        if (field_151355_a) {
            return;
        }
        field_151355_a = true;
        SoundEvent.func_187504_b();
        Fluid.func_207195_i();
        Block.func_149671_p();
        BlockFire.func_149843_e();
        Potion.func_188411_k();
        Enchantment.func_185257_f();
        if (EntityType.func_200718_a(EntityType.field_200729_aH) == null) {
            throw new IllegalStateException("Failed loading EntityTypes");
        }
        Item.func_150900_l();
        PotionType.func_185175_b();
        PotionBrewing.func_185207_a();
        Biome.func_185358_q();
        EntityOptions.func_197445_a();
        ParticleType.func_197576_c();
        Bootstrap.func_151353_a();
        ArgumentTypes.func_197483_a();
        BiomeProviderType.func_212580_a();
        TileEntityType.func_212641_a();
        ChunkGeneratorType.func_212675_a();
        DimensionType.func_212680_a();
        PaintingType.func_200831_a();
        StatList.func_212734_a();
        IRegistry.func_212613_e();
        if (SharedConstants.field_206244_b) {
            Bootstrap.func_210839_a("block", IRegistry.field_212618_g, Block::func_149739_a);
            Bootstrap.func_210839_a("biome", IRegistry.field_212624_m, Biome::func_210773_k);
            Bootstrap.func_210839_a("enchantment", IRegistry.field_212628_q, Enchantment::func_77320_a);
            Bootstrap.func_210839_a("item", IRegistry.field_212630_s, Item::func_77658_a);
            Bootstrap.func_210839_a("effect", IRegistry.field_212631_t, Potion::func_76393_a);
            Bootstrap.func_210839_a("entity", IRegistry.field_212629_r, EntityType::func_210760_d);
        }
        Bootstrap.func_179868_d();
    }

    private static <T> void func_210839_a(String string, IRegistry<T> iRegistry, Function<T, String> function) {
        LanguageMap languageMap = LanguageMap.func_74808_a();
        iRegistry.iterator().forEachRemaining(object -> {
            String string2 = (String)function.apply(object);
            if (!languageMap.func_210813_b(string2)) {
                field_179871_c.warn("Missing translation for {}: {} (key: '{}')", (Object)string, (Object)iRegistry.func_177774_c(object), (Object)string2);
            }
        });
    }

    private static void func_179868_d() {
        if (field_179871_c.isDebugEnabled()) {
            System.setErr(new DebugLoggingPrintStream("STDERR", System.err));
            System.setOut(new DebugLoggingPrintStream("STDOUT", field_179872_a));
        } else {
            System.setErr(new LoggingPrintStream("STDERR", System.err));
            System.setOut(new LoggingPrintStream("STDOUT", field_179872_a));
        }
    }

    static {
        field_179871_c = LogManager.getLogger();
    }

    static class DispensePlaceContext
    extends BlockItemUseContext {
        private final EnumFacing field_196015_j;

        public DispensePlaceContext(World world, BlockPos blockPos, EnumFacing enumFacing, ItemStack itemStack, EnumFacing enumFacing2) {
            super(world, null, itemStack, blockPos, enumFacing2, 0.5f, 0.0f, 0.5f);
            this.field_196015_j = enumFacing;
        }

        @Override
        public BlockPos func_195995_a() {
            return this.field_196008_i;
        }

        @Override
        public boolean func_196011_b() {
            return this.field_196006_g.func_180495_p(this.field_196008_i).func_196953_a(this);
        }

        @Override
        public boolean func_196012_c() {
            return this.func_196011_b();
        }

        @Override
        public EnumFacing func_196010_d() {
            return EnumFacing.DOWN;
        }

        @Override
        public EnumFacing[] func_196009_e() {
            switch (this.field_196015_j) {
                default: {
                    return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP};
                }
                case UP: {
                    return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
                }
                case NORTH: {
                    return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.UP, EnumFacing.SOUTH};
                }
                case SOUTH: {
                    return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.UP, EnumFacing.NORTH};
                }
                case WEST: {
                    return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST};
                }
                case EAST: 
            }
            return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.WEST};
        }

        @Override
        public EnumFacing func_195992_f() {
            return this.field_196015_j.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : this.field_196015_j;
        }

        @Override
        public boolean func_195998_g() {
            return false;
        }

        @Override
        public float func_195990_h() {
            return this.field_196015_j.func_176736_b() * 90;
        }
    }

    static class BehaviorDispenseShulkerBox
    extends BehaviorDispenseOptional {
        private BehaviorDispenseShulkerBox() {
        }

        @Override
        protected ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
            this.field_190911_b = false;
            Item item = itemStack.func_77973_b();
            if (item instanceof ItemBlock) {
                EnumFacing enumFacing = iBlockSource.func_189992_e().func_177229_b(BlockDispenser.field_176441_a);
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(enumFacing);
                \u2603 = iBlockSource.func_197524_h().func_175623_d(\u26032.func_177977_b()) ? enumFacing : EnumFacing.UP;
                boolean bl = this.field_190911_b = ((ItemBlock)item).func_195942_a(new DispensePlaceContext(iBlockSource.func_197524_h(), \u26032, enumFacing, itemStack, \u2603)) == EnumActionResult.SUCCESS;
                if (this.field_190911_b) {
                    itemStack.func_190918_g(1);
                }
            }
            return itemStack;
        }
    }

    public static abstract class BehaviorDispenseOptional
    extends BehaviorDefaultDispenseItem {
        protected boolean field_190911_b = true;

        @Override
        protected void func_82485_a(IBlockSource iBlockSource) {
            iBlockSource.func_197524_h().func_175718_b(this.field_190911_b ? 1000 : 1001, iBlockSource.func_180699_d(), 0);
        }
    }

    public static class BehaviorDispenseBoat
    extends BehaviorDefaultDispenseItem {
        private final BehaviorDefaultDispenseItem field_185026_b = new BehaviorDefaultDispenseItem();
        private final EntityBoat.Type field_185027_c;

        public BehaviorDispenseBoat(EntityBoat.Type type) {
            this.field_185027_c = type;
        }

        @Override
        public ItemStack func_82487_b(IBlockSource iBlockSource2, ItemStack itemStack) {
            double d;
            EnumFacing enumFacing = iBlockSource2.func_189992_e().func_177229_b(BlockDispenser.field_176441_a);
            World \u26032 = iBlockSource2.func_197524_h();
            double \u26033 = iBlockSource2.func_82615_a() + (double)((float)enumFacing.func_82601_c() * 1.125f);
            double \u26034 = iBlockSource2.func_82617_b() + (double)((float)enumFacing.func_96559_d() * 1.125f);
            double \u26035 = iBlockSource2.func_82616_c() + (double)((float)enumFacing.func_82599_e() * 1.125f);
            BlockPos \u26036 = iBlockSource2.func_180699_d().func_177972_a(enumFacing);
            if (\u26032.func_204610_c(\u26036).func_206884_a(FluidTags.field_206959_a)) {
                d = 1.0;
            } else if (\u26032.func_180495_p(\u26036).func_196958_f() && \u26032.func_204610_c(\u26036.func_177977_b()).func_206884_a(FluidTags.field_206959_a)) {
                d = 0.0;
            } else {
                IBlockSource iBlockSource2;
                return this.field_185026_b.dispense(iBlockSource2, itemStack);
            }
            EntityBoat \u26037 = new EntityBoat(\u26032, \u26033, \u26034 + d, \u26035);
            \u26037.func_184458_a(this.field_185027_c);
            \u26037.field_70177_z = enumFacing.func_185119_l();
            \u26032.func_72838_d(\u26037);
            itemStack.func_190918_g(1);
            return itemStack;
        }

        @Override
        protected void func_82485_a(IBlockSource iBlockSource) {
            iBlockSource.func_197524_h().func_175718_b(1000, iBlockSource.func_180699_d(), 0);
        }
    }
}

