/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBreakBlock;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityDrowned;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityTurtle;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityZombie
extends EntityMob {
    protected static final IAttribute field_110186_bp = new RangedAttribute(null, "zombie.spawnReinforcements", 0.0, 0.0, 1.0).func_111117_a("Spawn Reinforcements Chance");
    private static final UUID field_110187_bq = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier field_110188_br = new AttributeModifier(field_110187_bq, "Baby speed boost", 0.5, 1);
    private static final DataParameter<Boolean> field_184737_bv = EntityDataManager.func_187226_a(EntityZombie.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_184738_bw = EntityDataManager.func_187226_a(EntityZombie.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184740_by = EntityDataManager.func_187226_a(EntityZombie.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_204709_bA = EntityDataManager.func_187226_a(EntityZombie.class, DataSerializers.field_187198_h);
    private final EntityAIBreakDoor field_146075_bs = new EntityAIBreakDoor(this);
    private boolean field_146076_bu;
    private int field_204707_bD;
    private int field_204708_bE;
    private float field_146074_bv = -1.0f;
    private float field_146073_bw;

    public EntityZombie(EntityType<?> entityType, World world) {
        super(entityType, world);
        this.func_70105_a(0.6f, 1.95f);
    }

    public EntityZombie(World world) {
        this(EntityType.field_200725_aD, world);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, new AIAttackTurtleEgg(Blocks.field_203213_jA, this, 1.0, 3));
        this.field_70714_bg.func_75776_a(5, new EntityAIMoveTowardsRestriction(this, 1.0));
        this.field_70714_bg.func_75776_a(8, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, new EntityAILookIdle(this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(2, new EntityAIZombieAttack(this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, new EntityAIMoveThroughVillage(this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, new EntityAIWanderAvoidWater(this, 1.0));
        this.field_70715_bh.func_75776_a(1, new EntityAIHurtByTarget((EntityCreature)this, true, EntityPigZombie.class));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTarget<EntityVillager>((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTarget<EntityIronGolem>((EntityCreature)this, EntityIronGolem.class, true));
        this.field_70715_bh.func_75776_a(5, new EntityAINearestAttackableTarget<Entity>(this, EntityTurtle.class, 10, true, false, EntityTurtle.field_203029_bx));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(field_110186_bp).func_111128_a(this.field_70146_Z.nextDouble() * (double)0.1f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(field_184737_bv, false);
        this.func_184212_Q().func_187214_a(field_184738_bw, 0);
        this.func_184212_Q().func_187214_a(field_184740_by, false);
        this.func_184212_Q().func_187214_a(field_204709_bA, false);
    }

    public boolean func_204706_dD() {
        return this.func_184212_Q().func_187225_a(field_204709_bA);
    }

    public void func_184724_a(boolean bl) {
        this.func_184212_Q().func_187227_b(field_184740_by, bl);
    }

    public boolean func_146072_bX() {
        return this.field_146076_bu;
    }

    public void func_146070_a(boolean bl) {
        if (this.func_204900_dz()) {
            if (this.field_146076_bu != bl) {
                this.field_146076_bu = bl;
                ((PathNavigateGround)this.func_70661_as()).func_179688_b(bl);
                if (bl) {
                    this.field_70714_bg.func_75776_a(1, this.field_146075_bs);
                } else {
                    this.field_70714_bg.func_85156_a(this.field_146075_bs);
                }
            }
        } else if (this.field_146076_bu) {
            this.field_70714_bg.func_85156_a(this.field_146075_bs);
            this.field_146076_bu = false;
        }
    }

    protected boolean func_204900_dz() {
        return true;
    }

    @Override
    public boolean func_70631_g_() {
        return this.func_184212_Q().func_187225_a(field_184737_bv);
    }

    @Override
    protected int func_70693_a(EntityPlayer entityPlayer) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(entityPlayer);
    }

    public void func_82227_f(boolean bl2) {
        boolean bl2;
        this.func_184212_Q().func_187227_b(field_184737_bv, bl2);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iAttributeInstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iAttributeInstance.func_111124_b(field_110188_br);
            if (bl2) {
                iAttributeInstance.func_111121_a(field_110188_br);
            }
        }
        this.func_146071_k(bl2);
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_184737_bv.equals(dataParameter)) {
            this.func_146071_k(this.func_70631_g_());
        }
        super.func_184206_a(dataParameter);
    }

    protected boolean func_204703_dA() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_204706_dD()) {
                --this.field_204708_bE;
                if (this.field_204708_bE < 0) {
                    this.func_207302_dI();
                }
            } else if (this.func_204703_dA()) {
                if (this.func_208600_a(FluidTags.field_206959_a)) {
                    ++this.field_204707_bD;
                    if (this.field_204707_bD >= 600) {
                        this.func_204704_a(300);
                    }
                } else {
                    this.field_204707_bD = -1;
                }
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void func_70636_d() {
        boolean bl;
        boolean bl2 = bl = this.func_190730_o() && this.func_204609_dp();
        if (bl) {
            ItemStack itemStack = this.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!itemStack.func_190926_b()) {
                if (itemStack.func_77984_f()) {
                    itemStack.func_196085_b(itemStack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (itemStack.func_77952_i() >= itemStack.func_77958_k()) {
                        this.func_70669_a(itemStack);
                        this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                    }
                }
                bl = false;
            }
            if (bl) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    private void func_204704_a(int n) {
        this.field_204708_bE = n;
        this.func_184212_Q().func_187227_b(field_204709_bA, true);
    }

    protected void func_207302_dI() {
        this.func_207305_a(new EntityDrowned(this.field_70170_p));
        this.field_70170_p.func_180498_a(null, 1040, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
    }

    protected void func_207305_a(EntityZombie entityZombie2) {
        EntityZombie entityZombie2;
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return;
        }
        entityZombie2.func_82149_j(this);
        entityZombie2.func_207301_a(this.func_98052_bS(), this.func_146072_bX(), this.func_70631_g_(), this.func_175446_cd());
        for (EntityEquipmentSlot entityEquipmentSlot : EntityEquipmentSlot.values()) {
            ItemStack itemStack = this.func_184582_a(entityEquipmentSlot);
            if (itemStack.func_190926_b()) continue;
            entityZombie2.func_184201_a(entityEquipmentSlot, itemStack);
            entityZombie2.func_184642_a(entityEquipmentSlot, this.func_205712_c(entityEquipmentSlot));
        }
        if (this.func_145818_k_()) {
            entityZombie2.func_200203_b(this.func_200201_e());
            entityZombie2.func_174805_g(this.func_174833_aM());
        }
        this.field_70170_p.func_72838_d(entityZombie2);
        this.func_70106_y();
    }

    protected boolean func_190730_o() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (super.func_70097_a(damageSource, f)) {
            EntityLivingBase entityLivingBase = this.func_70638_az();
            if (entityLivingBase == null && damageSource.func_76346_g() instanceof EntityLivingBase) {
                entityLivingBase = (EntityLivingBase)damageSource.func_76346_g();
            }
            if (entityLivingBase != null && this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && (double)this.field_70146_Z.nextFloat() < this.func_110148_a(field_110186_bp).func_111126_e() && this.field_70170_p.func_82736_K().func_82766_b("doMobSpawning")) {
                int n = MathHelper.func_76128_c(this.field_70165_t);
                \u2603 = MathHelper.func_76128_c(this.field_70163_u);
                \u2603 = MathHelper.func_76128_c(this.field_70161_v);
                EntityZombie \u26032 = new EntityZombie(this.field_70170_p);
                for (\u2603 = 0; \u2603 < 50; ++\u2603) {
                    \u2603 = n + MathHelper.func_76136_a(this.field_70146_Z, 7, 40) * MathHelper.func_76136_a(this.field_70146_Z, -1, 1);
                    if (!this.field_70170_p.func_180495_p(new BlockPos(\u2603, (\u2603 = \u2603 + MathHelper.func_76136_a(this.field_70146_Z, 7, 40) * MathHelper.func_76136_a(this.field_70146_Z, -1, 1)) - 1, \u2603 = \u2603 + MathHelper.func_76136_a(this.field_70146_Z, 7, 40) * MathHelper.func_76136_a(this.field_70146_Z, -1, 1))).func_185896_q() || this.field_70170_p.func_201696_r(new BlockPos(\u2603, \u2603, \u2603)) >= 10) continue;
                    \u26032.func_70107_b(\u2603, \u2603, \u2603);
                    if (this.field_70170_p.func_175636_b(\u2603, \u2603, \u2603, 7.0) || !this.field_70170_p.func_195587_c(\u26032, \u26032.func_174813_aQ()) || !this.field_70170_p.func_195586_b(\u26032, \u26032.func_174813_aQ()) || this.field_70170_p.func_72953_d(\u26032.func_174813_aQ())) continue;
                    this.field_70170_p.func_72838_d(\u26032);
                    \u26032.func_70624_b(entityLivingBase);
                    \u26032.func_204210_a(this.field_70170_p.func_175649_E(new BlockPos(\u26032)), null, null);
                    this.func_110148_a(field_110186_bp).func_111121_a(new AttributeModifier("Zombie reinforcement caller charge", -0.05f, 0));
                    \u26032.func_110148_a(field_110186_bp).func_111121_a(new AttributeModifier("Zombie reinforcement callee charge", -0.05f, 0));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean bl = super.func_70652_k(entity);
        if (bl) {
            float f = this.field_70170_p.func_175649_E(new BlockPos(this)).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entity.func_70015_d(2 * (int)f);
            }
        }
        return bl;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187934_hh;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    protected SoundEvent func_190731_di() {
        return SoundEvents.field_187939_hm;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, IBlockState iBlockState) {
        this.func_184185_a(this.func_190731_di(), 0.15f, 1.0f);
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.UNDEAD;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186383_ah;
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        super.func_180481_a(difficultyInstance);
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int n = this.field_70146_Z.nextInt(3);
            if (n == 0) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151037_a));
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        if (this.func_70631_g_()) {
            nBTTagCompound.func_74757_a("IsBaby", true);
        }
        nBTTagCompound.func_74757_a("CanBreakDoors", this.func_146072_bX());
        nBTTagCompound.func_74768_a("InWaterTime", this.func_70090_H() ? this.field_204707_bD : -1);
        nBTTagCompound.func_74768_a("DrownedConversionTime", this.func_204706_dD() ? this.field_204708_bE : -1);
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        if (nBTTagCompound.func_74767_n("IsBaby")) {
            this.func_82227_f(true);
        }
        this.func_146070_a(nBTTagCompound.func_74767_n("CanBreakDoors"));
        this.field_204707_bD = nBTTagCompound.func_74762_e("InWaterTime");
        if (nBTTagCompound.func_150297_b("DrownedConversionTime", 99) && nBTTagCompound.func_74762_e("DrownedConversionTime") > -1) {
            this.func_204704_a(nBTTagCompound.func_74762_e("DrownedConversionTime"));
        }
    }

    @Override
    public void func_70074_a(EntityLivingBase entityLivingBase) {
        super.func_70074_a(entityLivingBase);
        if ((this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) && entityLivingBase instanceof EntityVillager) {
            if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD && this.field_70146_Z.nextBoolean()) {
                return;
            }
            EntityVillager entityVillager = (EntityVillager)entityLivingBase;
            EntityZombieVillager \u26032 = new EntityZombieVillager(this.field_70170_p);
            \u26032.func_82149_j(entityVillager);
            this.field_70170_p.func_72900_e(entityVillager);
            \u26032.func_204210_a(this.field_70170_p.func_175649_E(new BlockPos(\u26032)), new GroupData(false), null);
            \u26032.func_190733_a(entityVillager.func_70946_n());
            \u26032.func_82227_f(entityVillager.func_70631_g_());
            \u26032.func_94061_f(entityVillager.func_175446_cd());
            if (entityVillager.func_145818_k_()) {
                \u26032.func_200203_b(entityVillager.func_200201_e());
                \u26032.func_174805_g(entityVillager.func_174833_aM());
            }
            this.field_70170_p.func_72838_d(\u26032);
            this.field_70170_p.func_180498_a(null, 1026, new BlockPos(this), 0);
        }
    }

    @Override
    public float func_70047_e() {
        float f = 1.74f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    @Override
    protected boolean func_175448_a(ItemStack itemStack) {
        if (itemStack.func_77973_b() == Items.field_151110_aK && this.func_70631_g_() && this.func_184218_aH()) {
            return false;
        }
        return super.func_175448_a(itemStack);
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance2, @Nullable IEntityLivingData iEntityLivingData2, @Nullable NBTTagCompound nBTTagCompound) {
        Object object;
        IEntityLivingData iEntityLivingData2 = super.func_204210_a(difficultyInstance2, iEntityLivingData2, nBTTagCompound);
        float \u26032 = difficultyInstance2.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * \u26032);
        if (iEntityLivingData2 == null) {
            iEntityLivingData2 = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < 0.05f);
        }
        if (iEntityLivingData2 instanceof GroupData) {
            DifficultyInstance difficultyInstance2;
            object = (GroupData)iEntityLivingData2;
            if (((GroupData)object).field_142048_a) {
                List<Entity> list;
                this.func_82227_f(true);
                if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    list = this.field_70170_p.func_175647_a(EntityChicken.class, this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0), EntitySelectors.field_152785_b);
                    if (!list.isEmpty()) {
                        EntityChicken entityChicken = (EntityChicken)list.get(0);
                        entityChicken.func_152117_i(true);
                        this.func_184220_m(entityChicken);
                    }
                } else if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    list = new EntityChicken(this.field_70170_p);
                    ((Entity)((Object)list)).func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                    ((EntityLiving)((Object)list)).func_204210_a(difficultyInstance2, null, null);
                    ((EntityChicken)((Object)list)).func_152117_i(true);
                    this.field_70170_p.func_72838_d((Entity)((Object)list));
                    this.func_184220_m((Entity)((Object)list));
                }
            }
            this.func_146070_a(this.func_204900_dz() && this.field_70146_Z.nextFloat() < \u26032 * 0.1f);
            this.func_180481_a(difficultyInstance2);
            this.func_180483_b(difficultyInstance2);
        }
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
            object = LocalDate.now();
            int \u26033 = ((LocalDate)object).get(ChronoField.DAY_OF_MONTH);
            int \u26034 = ((LocalDate)object).get(ChronoField.MONTH_OF_YEAR);
            if (\u26034 == 10 && \u26033 == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
                this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_196628_cT : Blocks.field_196625_cS));
                this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
            }
        }
        this.func_207304_a(\u26032);
        return iEntityLivingData2;
    }

    protected void func_207301_a(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.func_98053_h(bl);
        this.func_146070_a(this.func_204900_dz() && bl2);
        this.func_207304_a(this.field_70170_p.func_175649_E(new BlockPos(this)).func_180170_c());
        this.func_82227_f(bl3);
        this.func_94061_f(bl4);
    }

    protected void func_207304_a(float f) {
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, 0));
        double d = this.field_70146_Z.nextDouble() * 1.5 * (double)f;
        if (d > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random zombie-spawn bonus", d, 2));
        }
        if (this.field_70146_Z.nextFloat() < f * 0.05f) {
            this.func_110148_a(field_110186_bp).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 0.25 + 0.5, 0));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
            this.func_146070_a(this.func_204900_dz());
        }
    }

    public void func_146071_k(boolean bl) {
        this.func_146069_a(bl ? 0.5f : 1.0f);
    }

    @Override
    protected final void func_70105_a(float f, float f2) {
        boolean bl = this.field_146074_bv > 0.0f && this.field_146073_bw > 0.0f;
        this.field_146074_bv = f;
        this.field_146073_bw = f2;
        if (!bl) {
            this.func_146069_a(1.0f);
        }
    }

    protected final void func_146069_a(float f) {
        super.func_70105_a(this.field_146074_bv * f, this.field_146073_bw * f);
    }

    @Override
    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (damageSource.func_76346_g() instanceof EntityCreeper && (\u2603 = (EntityCreeper)damageSource.func_76346_g()).func_70830_n() && \u2603.func_70650_aV()) {
            \u2603.func_175493_co();
            ItemStack itemStack = this.func_190732_dj();
            if (!itemStack.func_190926_b()) {
                this.func_199701_a_(itemStack);
            }
        }
    }

    protected ItemStack func_190732_dj() {
        return new ItemStack(Items.field_196186_dz);
    }

    class AIAttackTurtleEgg
    extends EntityAIBreakBlock {
        AIAttackTurtleEgg(Block block, EntityCreature entityCreature, double d, int n) {
            super(block, entityCreature, d, n);
        }

        @Override
        public void func_203114_b(IWorld iWorld, BlockPos blockPos) {
            iWorld.func_184133_a(null, blockPos, SoundEvents.field_203276_jU, SoundCategory.HOSTILE, 0.5f, 0.9f + EntityZombie.this.field_70146_Z.nextFloat() * 0.2f);
        }

        @Override
        public void func_203116_c(World world, BlockPos blockPos) {
            world.func_184133_a(null, blockPos, SoundEvents.field_203281_iz, SoundCategory.BLOCKS, 0.7f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
        }

        @Override
        public double func_203110_f() {
            return 1.3;
        }
    }

    public class GroupData
    implements IEntityLivingData {
        public boolean field_142048_a;

        private GroupData(boolean bl) {
            this.field_142048_a = bl;
        }
    }
}

