/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIDefendVillage;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookAtVillager;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Fluids;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityIronGolem
extends EntityGolem {
    protected static final DataParameter<Byte> field_184750_a = EntityDataManager.func_187226_a(EntityIronGolem.class, DataSerializers.field_187191_a);
    private int field_70858_e;
    @Nullable
    private Village field_70857_d;
    private int field_70855_f;
    private int field_70856_g;

    public EntityIronGolem(World world) {
        super(EntityType.field_200757_aw, world);
        this.func_70105_a(1.4f, 2.7f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new EntityAIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, new EntityAIMoveTowardsTarget(this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(3, new EntityAIMoveThroughVillage(this, 0.6, true));
        this.field_70714_bg.func_75776_a(4, new EntityAIMoveTowardsRestriction(this, 1.0));
        this.field_70714_bg.func_75776_a(5, new EntityAILookAtVillager(this));
        this.field_70714_bg.func_75776_a(6, new EntityAIWanderAvoidWater(this, 0.6));
        this.field_70714_bg.func_75776_a(7, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, new EntityAIDefendVillage(this));
        this.field_70715_bh.func_75776_a(2, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 10, false, true, entityLiving -> entityLiving != null && IMob.field_175450_e.test((Entity)entityLiving) && !(entityLiving instanceof EntityCreeper)));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184750_a, (byte)0);
    }

    @Override
    protected void func_70619_bc() {
        if (--this.field_70858_e <= 0) {
            this.field_70858_e = 70 + this.field_70146_Z.nextInt(50);
            this.field_70857_d = this.field_70170_p.func_175714_ae().func_176056_a(new BlockPos(this), 32);
            if (this.field_70857_d == null) {
                this.func_110177_bN();
            } else {
                BlockPos blockPos = this.field_70857_d.func_180608_a();
                this.func_175449_a(blockPos, (int)((float)this.field_70857_d.func_75568_b() * 0.6f));
            }
        }
        super.func_70619_bc();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected int func_70682_h(int n) {
        return n;
    }

    @Override
    protected void func_82167_n(Entity entity) {
        if (entity instanceof IMob && !(entity instanceof EntityCreeper) && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((EntityLivingBase)entity);
        }
        super.func_82167_n(entity);
    }

    @Override
    public void func_70636_d() {
        IBlockState iBlockState;
        super.func_70636_d();
        if (this.field_70855_f > 0) {
            --this.field_70855_f;
        }
        if (this.field_70856_g > 0) {
            --this.field_70856_g;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && !(iBlockState = this.field_70170_p.func_180495_p(new BlockPos(\u2603 = MathHelper.func_76128_c(this.field_70165_t), \u2603 = MathHelper.func_76128_c(this.field_70163_u - (double)0.2f), \u2603 = MathHelper.func_76128_c(this.field_70161_v)))).func_196958_f()) {
            this.field_70170_p.func_195594_a(new BlockParticleData(Particles.field_197611_d, iBlockState), this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
    }

    @Override
    public boolean func_70686_a(Class<? extends EntityLivingBase> clazz) {
        if (this.func_70850_q() && EntityPlayer.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz == EntityCreeper.class) {
            return false;
        }
        return super.func_70686_a(clazz);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("PlayerCreated", this.func_70850_q());
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        this.func_70849_f(nBTTagCompound.func_74767_n("PlayerCreated"));
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        this.field_70855_f = 10;
        this.field_70170_p.func_72960_a(this, (byte)4);
        boolean bl = entity.func_70097_a(DamageSource.func_76358_a(this), 7 + this.field_70146_Z.nextInt(15));
        if (bl) {
            entity.field_70181_x += (double)0.4f;
            this.func_174815_a(this, entity);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return bl;
    }

    public Village func_70852_n() {
        return this.field_70857_d;
    }

    public void func_70851_e(boolean bl) {
        if (bl) {
            this.field_70856_g = 400;
            this.field_70170_p.func_72960_a(this, (byte)11);
        } else {
            this.field_70856_g = 0;
            this.field_70170_p.func_72960_a(this, (byte)34);
        }
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187602_cF;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, IBlockState iBlockState) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186443_y;
    }

    public int func_70853_p() {
        return this.field_70856_g;
    }

    public boolean func_70850_q() {
        return (this.field_70180_af.func_187225_a(field_184750_a) & 1) != 0;
    }

    public void func_70849_f(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184750_a);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184750_a, (byte)(by | 1));
        } else {
            this.field_70180_af.func_187227_b(field_184750_a, (byte)(by & 0xFFFFFFFE));
        }
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.func_70850_q() && this.field_70717_bb != null && this.field_70857_d != null) {
            this.field_70857_d.func_82688_a(this.field_70717_bb.func_146103_bH().getName(), -5);
        }
        super.func_70645_a(damageSource);
    }

    @Override
    public boolean func_205019_a(IWorldReaderBase iWorldReaderBase) {
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        IBlockState \u26032 = iWorldReaderBase.func_180495_p(blockPos);
        IBlockState \u26033 = iWorldReaderBase.func_180495_p(blockPos.func_177977_b());
        IBlockState \u26034 = iWorldReaderBase.func_180495_p(blockPos.func_177984_a());
        return \u26033.func_185896_q() && WorldEntitySpawner.func_206851_a(\u26034, \u26034.func_204520_s()) && WorldEntitySpawner.func_206851_a(\u26032, Fluids.field_204541_a.func_207188_f()) && iWorldReaderBase.func_195586_b(this, this.func_174813_aQ()) && iWorldReaderBase.func_195587_c(this, this.func_174813_aQ());
    }
}

