/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityWither
extends EntityMob
implements IRangedAttackMob {
    private static final DataParameter<Integer> field_184741_a = EntityDataManager.func_187226_a(EntityWither.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184742_b = EntityDataManager.func_187226_a(EntityWither.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184743_c = EntityDataManager.func_187226_a(EntityWither.class, DataSerializers.field_187192_b);
    private static final List<DataParameter<Integer>> field_184745_bv = ImmutableList.of(field_184741_a, field_184742_b, field_184743_c);
    private static final DataParameter<Integer> field_184746_bw = EntityDataManager.func_187226_a(EntityWither.class, DataSerializers.field_187192_b);
    private final float[] field_82220_d = new float[2];
    private final float[] field_82221_e = new float[2];
    private final float[] field_82217_f = new float[2];
    private final float[] field_82218_g = new float[2];
    private final int[] field_82223_h = new int[2];
    private final int[] field_82224_i = new int[2];
    private int field_82222_j;
    private final BossInfoServer field_184744_bE = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private static final Predicate<Entity> field_82219_bJ = entity -> entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() != CreatureAttribute.UNDEAD && ((EntityLivingBase)entity).func_190631_cK();

    public EntityWither(World world) {
        super(EntityType.field_200760_az, world);
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(0.9f, 3.5f);
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_212239_d(true);
        this.field_70728_aV = 50;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new AIDoNothing());
        this.field_70714_bg.func_75776_a(2, new EntityAIAttackRanged(this, 1.0, 40, 20.0f));
        this.field_70714_bg.func_75776_a(5, new EntityAIWanderAvoidWater(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestAttackableTarget<Entity>(this, EntityLiving.class, 0, false, false, field_82219_bJ));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184741_a, 0);
        this.field_70180_af.func_187214_a(field_184742_b, 0);
        this.field_70180_af.func_187214_a(field_184743_c, 0);
        this.field_70180_af.func_187214_a(field_184746_bw, 0);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Invul", this.func_82212_n());
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        this.func_82215_s(nBTTagCompound.func_74762_e("Invul"));
        if (this.func_145818_k_()) {
            this.field_184744_bE.func_186739_a(this.func_145748_c_());
        }
    }

    @Override
    public void func_200203_b(@Nullable ITextComponent iTextComponent) {
        super.func_200203_b(iTextComponent);
        this.field_184744_bE.func_186739_a(this.func_145748_c_());
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187925_gy;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187851_gB;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187849_gA;
    }

    @Override
    public void func_70636_d() {
        int n;
        Entity entity;
        this.field_70181_x *= (double)0.6f;
        if (!this.field_70170_p.field_72995_K && this.func_82203_t(0) > 0 && (entity = this.field_70170_p.func_73045_a(this.func_82203_t(0))) != null) {
            if (this.field_70163_u < entity.field_70163_u || !this.func_82205_o() && this.field_70163_u < entity.field_70163_u + 5.0) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
                this.field_70181_x += (0.5 - this.field_70181_x) * (double)0.6f;
            }
            if ((\u2603 = (\u2603 = entity.field_70165_t - this.field_70165_t) * \u2603 + (d = entity.field_70161_v - this.field_70161_v) * d) > 9.0) {
                double d = MathHelper.func_76133_a(\u2603);
                this.field_70159_w += (\u2603 / d * 0.5 - this.field_70159_w) * (double)0.6f;
                this.field_70179_y += (d / d * 0.5 - this.field_70179_y) * (double)0.6f;
            }
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > (double)0.05f) {
            this.field_70177_z = (float)MathHelper.func_181159_b(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        for (n = 0; n < 2; ++n) {
            this.field_82218_g[n] = this.field_82221_e[n];
            this.field_82217_f[n] = this.field_82220_d[n];
        }
        for (n = 0; n < 2; ++n) {
            \u2603 = this.func_82203_t(n + 1);
            Entity entity2 = null;
            if (\u2603 > 0) {
                entity2 = this.field_70170_p.func_73045_a(\u2603);
            }
            if (entity2 != null) {
                double d = this.func_82214_u(n + 1);
                \u2603 = this.func_82208_v(n + 1);
                d = this.func_82213_w(n + 1);
                \u2603 = entity2.field_70165_t - d;
                \u2603 = entity2.field_70163_u + (double)entity2.func_70047_e() - \u2603;
                \u2603 = entity2.field_70161_v - d;
                \u2603 = MathHelper.func_76133_a(\u2603 * \u2603 + \u2603 * \u2603);
                float \u26032 = (float)(MathHelper.func_181159_b(\u2603, \u2603) * 57.2957763671875) - 90.0f;
                float \u26033 = (float)(-(MathHelper.func_181159_b(\u2603, \u2603) * 57.2957763671875));
                this.field_82220_d[n] = this.func_82204_b(this.field_82220_d[n], \u26033, 40.0f);
                this.field_82221_e[n] = this.func_82204_b(this.field_82221_e[n], \u26032, 10.0f);
                continue;
            }
            this.field_82221_e[n] = this.func_82204_b(this.field_82221_e[n], this.field_70761_aq, 10.0f);
        }
        n = this.func_82205_o() ? 1 : 0;
        for (i = 0; i < 3; ++i) {
            double d = this.func_82214_u(i);
            \u2603 = this.func_82208_v(i);
            \u2603 = this.func_82213_w(i);
            this.field_70170_p.func_195594_a(Particles.field_197601_L, d + this.field_70146_Z.nextGaussian() * (double)0.3f, \u2603 + this.field_70146_Z.nextGaussian() * (double)0.3f, \u2603 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
            if (n == 0 || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            this.field_70170_p.func_195594_a(Particles.field_197625_r, d + this.field_70146_Z.nextGaussian() * (double)0.3f, \u2603 + this.field_70146_Z.nextGaussian() * (double)0.3f, \u2603 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.7f, 0.7f, 0.5);
        }
        if (this.func_82212_n() > 0) {
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_195594_a(Particles.field_197625_r, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian(), 0.7f, 0.7f, 0.9f);
            }
        }
    }

    @Override
    protected void func_70619_bc() {
        int n;
        if (this.func_82212_n() > 0) {
            int n2 = this.func_82212_n() - 1;
            if (n2 <= 0) {
                this.field_70170_p.func_72885_a(this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_175669_a(1023, new BlockPos(this), 0);
            }
            this.func_82215_s(n2);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(10.0f);
            }
            return;
        }
        super.func_70619_bc();
        block0: for (n = 1; n < 3; ++n) {
            Object object;
            if (this.field_70173_aa < this.field_82223_h[n - 1]) continue;
            this.field_82223_h[n - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                int n3 = n - 1;
                int n4 = this.field_82224_i[n3];
                this.field_82224_i[n3] = n4 + 1;
                if (n4 > 15) {
                    float f = 10.0f;
                    \u2603 = 5.0f;
                    double \u26032 = MathHelper.func_82716_a(this.field_70146_Z, this.field_70165_t - 10.0, this.field_70165_t + 10.0);
                    double \u26033 = MathHelper.func_82716_a(this.field_70146_Z, this.field_70163_u - 5.0, this.field_70163_u + 5.0);
                    double \u26034 = MathHelper.func_82716_a(this.field_70146_Z, this.field_70161_v - 10.0, this.field_70161_v + 10.0);
                    this.func_82209_a(n + 1, \u26032, \u26033, \u26034, true);
                    this.field_82224_i[n - 1] = 0;
                }
            }
            if ((\u2603 = this.func_82203_t(n)) > 0) {
                object = this.field_70170_p.func_73045_a(\u2603);
                if (object == null || !((Entity)object).func_70089_S() || this.func_70068_e((Entity)object) > 900.0 || !this.func_70685_l((Entity)object)) {
                    this.func_82211_c(n, 0);
                    continue;
                }
                if (object instanceof EntityPlayer && ((EntityPlayer)object).field_71075_bZ.field_75102_a) {
                    this.func_82211_c(n, 0);
                    continue;
                }
                this.func_82216_a(n + 1, (EntityLivingBase)object);
                this.field_82223_h[n - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                this.field_82224_i[n - 1] = 0;
                continue;
            }
            object = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0), field_82219_bJ.and(EntitySelectors.field_180132_d));
            for (int i = 0; i < 10 && !object.isEmpty(); ++i) {
                EntityLivingBase entityLivingBase = (EntityLivingBase)object.get(this.field_70146_Z.nextInt(object.size()));
                if (entityLivingBase != this && entityLivingBase.func_70089_S() && this.func_70685_l(entityLivingBase)) {
                    if (entityLivingBase instanceof EntityPlayer) {
                        if (((EntityPlayer)entityLivingBase).field_71075_bZ.field_75102_a) continue block0;
                        this.func_82211_c(n, entityLivingBase.func_145782_y());
                        continue block0;
                    }
                    this.func_82211_c(n, entityLivingBase.func_145782_y());
                    continue block0;
                }
                object.remove(entityLivingBase);
            }
        }
        if (this.func_70638_az() != null) {
            this.func_82211_c(0, this.func_70638_az().func_145782_y());
        } else {
            this.func_82211_c(0, 0);
        }
        if (this.field_82222_j > 0) {
            --this.field_82222_j;
            if (this.field_82222_j == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                n = MathHelper.func_76128_c(this.field_70163_u);
                \u2603 = MathHelper.func_76128_c(this.field_70165_t);
                \u2603 = MathHelper.func_76128_c(this.field_70161_v);
                boolean \u26035 = false;
                for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                    for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                        for (\u2603 = 0; \u2603 <= 3; ++\u2603) {
                            \u2603 = \u2603 + \u2603;
                            \u2603 = n + \u2603;
                            \u2603 = \u2603 + \u2603;
                            BlockPos blockPos = new BlockPos(\u2603, \u2603, \u2603);
                            IBlockState \u26036 = this.field_70170_p.func_180495_p(blockPos);
                            Block \u26037 = \u26036.func_177230_c();
                            if (\u26036.func_196958_f() || !EntityWither.func_181033_a(\u26037)) continue;
                            \u26035 = this.field_70170_p.func_175655_b(blockPos, true) || \u26035;
                        }
                    }
                }
                if (\u26035) {
                    this.field_70170_p.func_180498_a(null, 1022, new BlockPos(this), 0);
                }
            }
        }
        if (this.field_70173_aa % 20 == 0) {
            this.func_70691_i(1.0f);
        }
        this.field_184744_bE.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public static boolean func_181033_a(Block block) {
        return block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI && block != Blocks.field_185776_dc && block != Blocks.field_185777_dd && block != Blocks.field_180401_cv && block != Blocks.field_185779_df && block != Blocks.field_189881_dj && block != Blocks.field_196603_bb && block != Blocks.field_185775_db;
    }

    public void func_82206_m() {
        this.func_82215_s(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    @Override
    public void func_70110_aj() {
    }

    @Override
    public void func_184178_b(EntityPlayerMP entityPlayerMP) {
        super.func_184178_b(entityPlayerMP);
        this.field_184744_bE.func_186760_a(entityPlayerMP);
    }

    @Override
    public void func_184203_c(EntityPlayerMP entityPlayerMP) {
        super.func_184203_c(entityPlayerMP);
        this.field_184744_bE.func_186761_b(entityPlayerMP);
    }

    private double func_82214_u(int n) {
        if (n <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (n - 1))) * ((float)Math.PI / 180);
        \u2603 = MathHelper.func_76134_b(f);
        return this.field_70165_t + (double)\u2603 * 1.3;
    }

    private double func_82208_v(int n) {
        if (n <= 0) {
            return this.field_70163_u + 3.0;
        }
        return this.field_70163_u + 2.2;
    }

    private double func_82213_w(int n) {
        if (n <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (n - 1))) * ((float)Math.PI / 180);
        \u2603 = MathHelper.func_76126_a(f);
        return this.field_70161_v + (double)\u2603 * 1.3;
    }

    private float func_82204_b(float f, float f2, float f3) {
        \u2603 = MathHelper.func_76142_g(f2 - f);
        if (\u2603 > f3) {
            \u2603 = f3;
        }
        if (\u2603 < -f3) {
            \u2603 = -f3;
        }
        return f + \u2603;
    }

    private void func_82216_a(int n, EntityLivingBase entityLivingBase) {
        this.func_82209_a(n, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u + (double)entityLivingBase.func_70047_e() * 0.5, entityLivingBase.field_70161_v, n == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void func_82209_a(int n, double d, double d2, double d3, boolean bl) {
        this.field_70170_p.func_180498_a(null, 1024, new BlockPos(this), 0);
        double d4 = this.func_82214_u(n);
        \u2603 = this.func_82208_v(n);
        \u2603 = this.func_82213_w(n);
        \u2603 = d - d4;
        \u2603 = d2 - \u2603;
        \u2603 = d3 - \u2603;
        EntityWitherSkull \u26032 = new EntityWitherSkull(this.field_70170_p, this, \u2603, \u2603, \u2603);
        if (bl) {
            \u26032.func_82343_e(true);
        }
        \u26032.field_70163_u = \u2603;
        \u26032.field_70165_t = d4;
        \u26032.field_70161_v = \u2603;
        this.field_70170_p.func_72838_d(\u26032);
    }

    @Override
    public void func_82196_d(EntityLivingBase entityLivingBase, float f) {
        this.func_82216_a(0, entityLivingBase);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (damageSource == DamageSource.field_76369_e || damageSource.func_76346_g() instanceof EntityWither) {
            return false;
        }
        if (this.func_82212_n() > 0 && damageSource != DamageSource.field_76380_i) {
            return false;
        }
        if (this.func_82205_o() && (entity = damageSource.func_76364_f()) instanceof EntityArrow) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        if (entity != null && !(entity instanceof EntityPlayer) && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == this.func_70668_bt()) {
            return false;
        }
        if (this.field_82222_j <= 0) {
            this.field_82222_j = 20;
        }
        int \u26032 = 0;
        while (\u26032 < this.field_82224_i.length) {
            int n = \u26032++;
            this.field_82224_i[n] = this.field_82224_i[n] + 3;
        }
        return super.func_70097_a(damageSource, f);
    }

    @Override
    protected void func_70628_a(boolean bl, int n) {
        EntityItem entityItem = this.func_199703_a(Items.field_151156_bN);
        if (entityItem != null) {
            entityItem.func_174873_u();
        }
    }

    @Override
    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @Override
    public void func_180430_e(float f, float f2) {
    }

    @Override
    public boolean func_195064_c(PotionEffect potionEffect) {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public int func_82212_n() {
        return this.field_70180_af.func_187225_a(field_184746_bw);
    }

    public void func_82215_s(int n) {
        this.field_70180_af.func_187227_b(field_184746_bw, n);
    }

    public int func_82203_t(int n) {
        return this.field_70180_af.func_187225_a(field_184745_bv.get(n));
    }

    public void func_82211_c(int n, int n2) {
        this.field_70180_af.func_187227_b(field_184745_bv.get(n), n2);
    }

    public boolean func_82205_o() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.UNDEAD;
    }

    @Override
    protected boolean func_184228_n(Entity entity) {
        return false;
    }

    @Override
    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_184724_a(boolean bl) {
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.func_75248_a(7);
        }

        @Override
        public boolean func_75250_a() {
            return EntityWither.this.func_82212_n() > 0;
        }
    }
}

