/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SharedMonsterAttributes {
    private static final Logger field_151476_f = LogManager.getLogger();
    public static final IAttribute field_111267_a = new RangedAttribute(null, "generic.maxHealth", 20.0, 0.0, 1024.0).func_111117_a("Max Health").func_111112_a(true);
    public static final IAttribute field_111265_b = new RangedAttribute(null, "generic.followRange", 32.0, 0.0, 2048.0).func_111117_a("Follow Range");
    public static final IAttribute field_111266_c = new RangedAttribute(null, "generic.knockbackResistance", 0.0, 0.0, 1.0).func_111117_a("Knockback Resistance");
    public static final IAttribute field_111263_d = new RangedAttribute(null, "generic.movementSpeed", 0.7f, 0.0, 1024.0).func_111117_a("Movement Speed").func_111112_a(true);
    public static final IAttribute field_193334_e = new RangedAttribute(null, "generic.flyingSpeed", 0.4f, 0.0, 1024.0).func_111117_a("Flying Speed").func_111112_a(true);
    public static final IAttribute field_111264_e = new RangedAttribute(null, "generic.attackDamage", 2.0, 0.0, 2048.0);
    public static final IAttribute field_188790_f = new RangedAttribute(null, "generic.attackSpeed", 4.0, 0.0, 1024.0).func_111112_a(true);
    public static final IAttribute field_188791_g = new RangedAttribute(null, "generic.armor", 0.0, 0.0, 30.0).func_111112_a(true);
    public static final IAttribute field_189429_h = new RangedAttribute(null, "generic.armorToughness", 0.0, 0.0, 20.0).func_111112_a(true);
    public static final IAttribute field_188792_h = new RangedAttribute(null, "generic.luck", 0.0, -1024.0, 1024.0).func_111112_a(true);

    public static NBTTagList func_111257_a(AbstractAttributeMap abstractAttributeMap) {
        NBTTagList nBTTagList = new NBTTagList();
        for (IAttributeInstance iAttributeInstance : abstractAttributeMap.func_111146_a()) {
            nBTTagList.add(SharedMonsterAttributes.func_111261_a(iAttributeInstance));
        }
        return nBTTagList;
    }

    private static NBTTagCompound func_111261_a(IAttributeInstance iAttributeInstance) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        IAttribute \u26032 = iAttributeInstance.func_111123_a();
        nBTTagCompound.func_74778_a("Name", \u26032.func_111108_a());
        nBTTagCompound.func_74780_a("Base", iAttributeInstance.func_111125_b());
        Collection<AttributeModifier> \u26033 = iAttributeInstance.func_111122_c();
        if (\u26033 != null && !\u26033.isEmpty()) {
            NBTTagList nBTTagList = new NBTTagList();
            for (AttributeModifier attributeModifier : \u26033) {
                if (!attributeModifier.func_111165_e()) continue;
                nBTTagList.add(SharedMonsterAttributes.func_111262_a(attributeModifier));
            }
            nBTTagCompound.func_74782_a("Modifiers", nBTTagList);
        }
        return nBTTagCompound;
    }

    public static NBTTagCompound func_111262_a(AttributeModifier attributeModifier) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74778_a("Name", attributeModifier.func_111166_b());
        nBTTagCompound.func_74780_a("Amount", attributeModifier.func_111164_d());
        nBTTagCompound.func_74768_a("Operation", attributeModifier.func_111169_c());
        nBTTagCompound.func_186854_a("UUID", attributeModifier.func_111167_a());
        return nBTTagCompound;
    }

    public static void func_151475_a(AbstractAttributeMap abstractAttributeMap, NBTTagList nBTTagList) {
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound = nBTTagList.func_150305_b(i);
            IAttributeInstance \u26032 = abstractAttributeMap.func_111152_a(nBTTagCompound.func_74779_i("Name"));
            if (\u26032 == null) {
                field_151476_f.warn("Ignoring unknown attribute '{}'", (Object)nBTTagCompound.func_74779_i("Name"));
                continue;
            }
            SharedMonsterAttributes.func_111258_a(\u26032, nBTTagCompound);
        }
    }

    private static void func_111258_a(IAttributeInstance iAttributeInstance, NBTTagCompound nBTTagCompound) {
        iAttributeInstance.func_111128_a(nBTTagCompound.func_74769_h("Base"));
        if (nBTTagCompound.func_150297_b("Modifiers", 9)) {
            NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Modifiers", 10);
            for (int i = 0; i < nBTTagList.size(); ++i) {
                AttributeModifier attributeModifier = SharedMonsterAttributes.func_111259_a(nBTTagList.func_150305_b(i));
                if (attributeModifier == null) continue;
                \u2603 = iAttributeInstance.func_111127_a(attributeModifier.func_111167_a());
                if (\u2603 != null) {
                    iAttributeInstance.func_111124_b(\u2603);
                }
                iAttributeInstance.func_111121_a(attributeModifier);
            }
        }
    }

    @Nullable
    public static AttributeModifier func_111259_a(NBTTagCompound nBTTagCompound) {
        UUID uUID = nBTTagCompound.func_186857_a("UUID");
        try {
            return new AttributeModifier(uUID, nBTTagCompound.func_74779_i("Name"), nBTTagCompound.func_74769_h("Amount"), nBTTagCompound.func_74762_e("Operation"));
        }
        catch (Exception \u26032) {
            field_151476_f.warn("Unable to create attribute: {}", (Object)\u26032.getMessage());
            return null;
        }
    }
}

