/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentSweepingEdge;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.IRegistry;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnchantmentHelper {
    public static int func_77506_a(Enchantment enchantment, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return 0;
        }
        ResourceLocation resourceLocation = IRegistry.field_212628_q.func_177774_c(enchantment);
        NBTTagList \u26032 = itemStack.func_77986_q();
        for (int i = 0; i < \u26032.size(); ++i) {
            NBTTagCompound nBTTagCompound = \u26032.func_150305_b(i);
            ResourceLocation \u26033 = ResourceLocation.func_208304_a(nBTTagCompound.func_74779_i("id"));
            if (\u26033 == null || !\u26033.equals(resourceLocation)) continue;
            return nBTTagCompound.func_74762_e("lvl");
        }
        return 0;
    }

    public static Map<Enchantment, Integer> func_82781_a(ItemStack itemStack) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        NBTTagList \u26032 = itemStack.func_77973_b() == Items.field_151134_bR ? ItemEnchantedBook.func_92110_g(itemStack) : itemStack.func_77986_q();
        for (int i = 0; i < \u26032.size(); ++i) {
            NBTTagCompound nBTTagCompound = \u26032.func_150305_b(i);
            Enchantment \u26033 = IRegistry.field_212628_q.func_212608_b(ResourceLocation.func_208304_a(nBTTagCompound.func_74779_i("id")));
            if (\u26033 == null) continue;
            linkedHashMap.put(\u26033, nBTTagCompound.func_74762_e("lvl"));
        }
        return linkedHashMap;
    }

    public static void func_82782_a(Map<Enchantment, Integer> map, ItemStack itemStack) {
        NBTTagList nBTTagList = new NBTTagList();
        for (Map.Entry<Enchantment, Integer> entry : map.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int \u26032 = entry.getValue();
            NBTTagCompound \u26033 = new NBTTagCompound();
            \u26033.func_74778_a("id", String.valueOf(IRegistry.field_212628_q.func_177774_c(enchantment)));
            \u26033.func_74777_a("lvl", (short)\u26032);
            nBTTagList.add(\u26033);
            if (itemStack.func_77973_b() != Items.field_151134_bR) continue;
            ItemEnchantedBook.func_92115_a(itemStack, new EnchantmentData(enchantment, \u26032));
        }
        if (nBTTagList.isEmpty()) {
            itemStack.func_196083_e("Enchantments");
        } else if (itemStack.func_77973_b() != Items.field_151134_bR) {
            itemStack.func_77983_a("Enchantments", nBTTagList);
        }
    }

    private static void func_77518_a(IEnchantmentVisitor iEnchantmentVisitor, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        NBTTagList nBTTagList = itemStack.func_77986_q();
        for (int i = 0; i < nBTTagList.size(); ++i) {
            String string = nBTTagList.func_150305_b(i).func_74779_i("id");
            int \u26032 = nBTTagList.func_150305_b(i).func_74762_e("lvl");
            Enchantment \u26033 = IRegistry.field_212628_q.func_212608_b(ResourceLocation.func_208304_a(string));
            if (\u26033 == null) continue;
            iEnchantmentVisitor.accept(\u26033, \u26032);
        }
    }

    private static void func_77516_a(IEnchantmentVisitor iEnchantmentVisitor, Iterable<ItemStack> iterable) {
        for (ItemStack itemStack : iterable) {
            EnchantmentHelper.func_77518_a(iEnchantmentVisitor, itemStack);
        }
    }

    public static int func_77508_a(Iterable<ItemStack> iterable, DamageSource damageSource) {
        MutableInt mutableInt = new MutableInt();
        EnchantmentHelper.func_77516_a((enchantment, n) -> mutableInt.add(enchantment.func_77318_a(n, damageSource)), iterable);
        return mutableInt.intValue();
    }

    public static float func_152377_a(ItemStack itemStack, CreatureAttribute creatureAttribute) {
        MutableFloat mutableFloat = new MutableFloat();
        EnchantmentHelper.func_77518_a((enchantment, n) -> mutableFloat.add(enchantment.func_152376_a(n, creatureAttribute)), itemStack);
        return mutableFloat.floatValue();
    }

    public static float func_191527_a(EntityLivingBase entityLivingBase) {
        int n = EnchantmentHelper.func_185284_a(Enchantments.field_191530_r, entityLivingBase);
        if (n > 0) {
            return EnchantmentSweepingEdge.func_191526_e(n);
        }
        return 0.0f;
    }

    public static void func_151384_a(EntityLivingBase entityLivingBase, Entity entity) {
        IEnchantmentVisitor iEnchantmentVisitor = (enchantment, n) -> enchantment.func_151367_b(entityLivingBase, entity, n);
        if (entityLivingBase != null) {
            EnchantmentHelper.func_77516_a(iEnchantmentVisitor, entityLivingBase.func_184209_aF());
        }
        if (entity instanceof EntityPlayer) {
            EnchantmentHelper.func_77518_a(iEnchantmentVisitor, entityLivingBase.func_184614_ca());
        }
    }

    public static void func_151385_b(EntityLivingBase entityLivingBase, Entity entity) {
        IEnchantmentVisitor iEnchantmentVisitor = (enchantment, n) -> enchantment.func_151368_a(entityLivingBase, entity, n);
        if (entityLivingBase != null) {
            EnchantmentHelper.func_77516_a(iEnchantmentVisitor, entityLivingBase.func_184209_aF());
        }
        if (entityLivingBase instanceof EntityPlayer) {
            EnchantmentHelper.func_77518_a(iEnchantmentVisitor, entityLivingBase.func_184614_ca());
        }
    }

    public static int func_185284_a(Enchantment enchantment, EntityLivingBase entityLivingBase) {
        List<ItemStack> list = enchantment.func_185260_a(entityLivingBase);
        if (list == null) {
            return 0;
        }
        int \u26032 = 0;
        for (ItemStack itemStack : list) {
            int n = EnchantmentHelper.func_77506_a(enchantment, itemStack);
            if (n <= \u26032) continue;
            \u26032 = n;
        }
        return \u26032;
    }

    public static int func_77501_a(EntityLivingBase entityLivingBase) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_180313_o, entityLivingBase);
    }

    public static int func_90036_a(EntityLivingBase entityLivingBase) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_77334_n, entityLivingBase);
    }

    public static int func_185292_c(EntityLivingBase entityLivingBase) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185298_f, entityLivingBase);
    }

    public static int func_185294_d(EntityLivingBase entityLivingBase) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185300_i, entityLivingBase);
    }

    public static int func_185293_e(EntityLivingBase entityLivingBase) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185305_q, entityLivingBase);
    }

    public static int func_191529_b(ItemStack itemStack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_151370_z, itemStack);
    }

    public static int func_191528_c(ItemStack itemStack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_151369_A, itemStack);
    }

    public static int func_185283_h(EntityLivingBase entityLivingBase) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185304_p, entityLivingBase);
    }

    public static boolean func_185287_i(EntityLivingBase entityLivingBase) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185299_g, entityLivingBase) > 0;
    }

    public static boolean func_189869_j(EntityLivingBase entityLivingBase) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185301_j, entityLivingBase) > 0;
    }

    public static boolean func_190938_b(ItemStack itemStack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_190941_k, itemStack) > 0;
    }

    public static boolean func_190939_c(ItemStack itemStack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_190940_C, itemStack) > 0;
    }

    public static int func_203191_f(ItemStack itemStack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_203193_C, itemStack);
    }

    public static int func_203190_g(ItemStack itemStack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_203195_E, itemStack);
    }

    public static boolean func_203192_h(ItemStack itemStack) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_203196_F, itemStack) > 0;
    }

    public static ItemStack func_92099_a(Enchantment enchantment, EntityLivingBase entityLivingBase2) {
        EntityLivingBase entityLivingBase2;
        List<ItemStack> list = enchantment.func_185260_a(entityLivingBase2);
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ArrayList \u26032 = Lists.newArrayList();
        for (ItemStack itemStack : list) {
            if (itemStack.func_190926_b() || EnchantmentHelper.func_77506_a(enchantment, itemStack) <= 0) continue;
            \u26032.add(itemStack);
        }
        return \u26032.isEmpty() ? ItemStack.field_190927_a : (ItemStack)\u26032.get(entityLivingBase2.func_70681_au().nextInt(\u26032.size()));
    }

    public static int func_77514_a(Random random2, int n, int n22, ItemStack itemStack) {
        Random random2;
        Item item = itemStack.func_77973_b();
        int \u26032 = item.func_77619_b();
        if (\u26032 <= 0) {
            return 0;
        }
        if (n22 > 15) {
            int n22 = 15;
        }
        int \u26033 = random2.nextInt(8) + 1 + (n22 >> 1) + random2.nextInt(n22 + 1);
        if (n == 0) {
            return Math.max(\u26033 / 3, 1);
        }
        if (n == 1) {
            return \u26033 * 2 / 3 + 1;
        }
        return Math.max(\u26033, n22 * 2);
    }

    public static ItemStack func_77504_a(Random random, ItemStack itemStack2, int n, boolean bl) {
        List<EnchantmentData> list = EnchantmentHelper.func_77513_b(random, itemStack2, n, bl);
        boolean bl2 = \u2603 = itemStack2.func_77973_b() == Items.field_151122_aG;
        if (\u2603) {
            ItemStack itemStack2 = new ItemStack(Items.field_151134_bR);
        }
        for (EnchantmentData \u26032 : list) {
            if (\u2603) {
                ItemEnchantedBook.func_92115_a(itemStack2, \u26032);
                continue;
            }
            itemStack2.func_77966_a(\u26032.field_76302_b, \u26032.field_76303_c);
        }
        return itemStack2;
    }

    public static List<EnchantmentData> func_77513_b(Random random, ItemStack itemStack, int n, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        Item \u26032 = itemStack.func_77973_b();
        int \u26033 = \u26032.func_77619_b();
        if (\u26033 <= 0) {
            return arrayList;
        }
        n += 1 + random.nextInt(\u26033 / 4 + 1) + random.nextInt(\u26033 / 4 + 1);
        float \u26034 = (random.nextFloat() + random.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentData> \u26035 = EnchantmentHelper.func_185291_a(n = MathHelper.func_76125_a(Math.round((float)n + (float)n * \u26034), 1, Integer.MAX_VALUE), itemStack, bl);
        if (!\u26035.isEmpty()) {
            arrayList.add(WeightedRandom.func_76271_a(random, \u26035));
            while (random.nextInt(50) <= n) {
                EnchantmentHelper.func_185282_a(\u26035, (EnchantmentData)Util.func_184878_a(arrayList));
                if (\u26035.isEmpty()) break;
                arrayList.add(WeightedRandom.func_76271_a(random, \u26035));
                n /= 2;
            }
        }
        return arrayList;
    }

    public static void func_185282_a(List<EnchantmentData> list, EnchantmentData enchantmentData) {
        Iterator<EnchantmentData> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (enchantmentData.field_76302_b.func_191560_c(iterator.next().field_76302_b)) continue;
            iterator.remove();
        }
    }

    public static boolean func_201840_a(Collection<Enchantment> collection, Enchantment enchantment) {
        for (Enchantment enchantment2 : collection) {
            if (enchantment2.func_191560_c(enchantment)) continue;
            return false;
        }
        return true;
    }

    public static List<EnchantmentData> func_185291_a(int n, ItemStack itemStack, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        Item \u26032 = itemStack.func_77973_b();
        boolean \u26033 = itemStack.func_77973_b() == Items.field_151122_aG;
        block0: for (Enchantment enchantment : IRegistry.field_212628_q) {
            if (enchantment.func_185261_e() && !bl || !enchantment.field_77351_y.func_77557_a(\u26032) && !\u26033) continue;
            for (int i = enchantment.func_77325_b(); i > enchantment.func_77319_d() - 1; --i) {
                if (n < enchantment.func_77321_a(i) || n > enchantment.func_77317_b(i)) continue;
                arrayList.add(new EnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return arrayList;
    }

    @FunctionalInterface
    static interface IEnchantmentVisitor {
        public void accept(Enchantment var1, int var2);
    }
}

