/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FurnaceRecipeBuilder {
    private static final Logger field_202144_a = LogManager.getLogger();
    private final Item field_202145_b;
    private final Ingredient field_202146_c;
    private final float field_202147_d;
    private final int field_202148_e;
    private final Advancement.Builder field_202149_f = Advancement.Builder.func_200278_a();
    private String field_202150_g;

    public FurnaceRecipeBuilder(Ingredient ingredient, IItemProvider iItemProvider, float f, int n) {
        this.field_202145_b = iItemProvider.func_199767_j();
        this.field_202146_c = ingredient;
        this.field_202147_d = f;
        this.field_202148_e = n;
    }

    public static FurnaceRecipeBuilder func_202138_a(Ingredient ingredient, IItemProvider iItemProvider, float f, int n) {
        return new FurnaceRecipeBuilder(ingredient, iItemProvider, f, n);
    }

    public FurnaceRecipeBuilder func_202139_a(String string, ICriterionInstance iCriterionInstance) {
        this.field_202149_f.func_200275_a(string, iCriterionInstance);
        return this;
    }

    public void func_202140_a(Consumer<IFinishedRecipe> consumer) {
        this.func_202143_a(consumer, IRegistry.field_212630_s.func_177774_c(this.field_202145_b));
    }

    public void func_202141_a(Consumer<IFinishedRecipe> consumer, String string) {
        ResourceLocation resourceLocation = IRegistry.field_212630_s.func_177774_c(this.field_202145_b);
        if (new ResourceLocation(string).equals(resourceLocation)) {
            throw new IllegalStateException("Smelting Recipe " + string + " should remove its 'save' argument");
        }
        this.func_202143_a(consumer, new ResourceLocation(string));
    }

    public void func_202143_a(Consumer<IFinishedRecipe> consumer, ResourceLocation resourceLocation) {
        this.func_202142_a(resourceLocation);
        this.field_202149_f.func_200272_a(new ResourceLocation("minecraft:recipes/root")).func_200275_a("has_the_recipe", new RecipeUnlockedTrigger.Instance(resourceLocation)).func_200271_a(AdvancementRewards.Builder.func_200280_c(resourceLocation)).func_200270_a(RequirementsStrategy.OR);
        consumer.accept(new Result(resourceLocation, this.field_202150_g == null ? "" : this.field_202150_g, this.field_202146_c, this.field_202145_b, this.field_202147_d, this.field_202148_e, this.field_202149_f, new ResourceLocation(resourceLocation.func_110624_b(), "recipes/" + this.field_202145_b.func_77640_w().func_200300_c() + "/" + resourceLocation.func_110623_a())));
    }

    private void func_202142_a(ResourceLocation resourceLocation) {
        if (this.field_202149_f.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + resourceLocation);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation field_202117_a;
        private final String field_202118_b;
        private final Ingredient field_202119_c;
        private final Item field_202120_d;
        private final float field_202121_e;
        private final int field_202122_f;
        private final Advancement.Builder field_202123_g;
        private final ResourceLocation field_202124_h;

        public Result(ResourceLocation resourceLocation, String string, Ingredient ingredient, Item item, float f, int n, Advancement.Builder builder, ResourceLocation resourceLocation2) {
            this.field_202117_a = resourceLocation;
            this.field_202118_b = string;
            this.field_202119_c = ingredient;
            this.field_202120_d = item;
            this.field_202121_e = f;
            this.field_202122_f = n;
            this.field_202123_g = builder;
            this.field_202124_h = resourceLocation2;
        }

        @Override
        public JsonObject func_200441_a() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", "smelting");
            if (!this.field_202118_b.isEmpty()) {
                jsonObject.addProperty("group", this.field_202118_b);
            }
            jsonObject.add("ingredient", this.field_202119_c.func_200304_c());
            jsonObject.addProperty("result", IRegistry.field_212630_s.func_177774_c(this.field_202120_d).toString());
            jsonObject.addProperty("experience", (Number)Float.valueOf(this.field_202121_e));
            jsonObject.addProperty("cookingtime", (Number)this.field_202122_f);
            return jsonObject;
        }

        @Override
        public ResourceLocation func_200442_b() {
            return this.field_202117_a;
        }

        @Override
        @Nullable
        public JsonObject func_200440_c() {
            return this.field_202123_g.func_200273_b();
        }

        @Override
        @Nullable
        public ResourceLocation func_200443_d() {
            return this.field_202124_h;
        }
    }
}

