/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectoryCache {
    private static final Logger field_208324_a = LogManager.getLogger();
    private final Path field_208325_b;
    private final Path field_208326_c;
    private int field_208327_d;
    private final Map<Path, String> field_208328_e = Maps.newHashMap();
    private final Map<Path, String> field_208329_f = Maps.newHashMap();

    public DirectoryCache(Path path2, String string2) throws IOException {
        this.field_208325_b = path2;
        Path path3 = path2.resolve(".cache");
        Files.createDirectories(path3, new FileAttribute[0]);
        this.field_208326_c = path3.resolve(string2);
        this.func_209398_c().forEach(path -> this.field_208328_e.put((Path)path, ""));
        if (Files.isReadable(this.field_208326_c)) {
            IOUtils.readLines((InputStream)Files.newInputStream(this.field_208326_c, new OpenOption[0]), (Charset)Charsets.UTF_8).forEach(string -> {
                int n = string.indexOf(32);
                this.field_208328_e.put(path2.resolve(string.substring(n + 1)), string.substring(0, n));
            });
        }
    }

    public void func_208317_a() throws IOException {
        this.func_209400_b();
        try {
            BufferedWriter bufferedWriter = Files.newBufferedWriter(this.field_208326_c, new OpenOption[0]);
        }
        catch (IOException iOException) {
            field_208324_a.warn("Unable write cachefile {}: {}", (Object)this.field_208326_c, (Object)iOException.toString());
            return;
        }
        IOUtils.writeLines((Collection)this.field_208329_f.entrySet().stream().map(entry -> (String)entry.getValue() + ' ' + this.field_208325_b.relativize((Path)entry.getKey())).collect(Collectors.toList()), (String)System.lineSeparator(), (Writer)bufferedWriter);
        ((Writer)bufferedWriter).close();
        field_208324_a.debug("Caching: cache hits: {}, created: {} removed: {}", (Object)this.field_208327_d, (Object)(this.field_208329_f.size() - this.field_208327_d), (Object)this.field_208328_e.size());
    }

    @Nullable
    public String func_208323_a(Path path) {
        return this.field_208328_e.get(path);
    }

    public void func_208316_a(Path path, String string) {
        this.field_208329_f.put(path, string);
        if (Objects.equals(this.field_208328_e.remove(path), string)) {
            ++this.field_208327_d;
        }
    }

    public boolean func_208320_b(Path path) {
        return this.field_208328_e.containsKey(path);
    }

    private void func_209400_b() throws IOException {
        this.func_209398_c().forEach(path -> {
            if (this.func_208320_b((Path)path)) {
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    field_208324_a.debug("Unable to delete: {} ({})", path, (Object)iOException.toString());
                }
            }
        });
    }

    private Stream<Path> func_209398_c() throws IOException {
        return Files.walk(this.field_208325_b, new FileVisitOption[0]).filter(path -> !Objects.equals(this.field_208326_c, path) && !Files.isDirectory(path, new LinkOption[0]));
    }
}

