/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextComponentUtils;

public class TagCommand {
    private static final SimpleCommandExceptionType field_198752_a = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.tag.add.failed", new Object[0]));
    private static final SimpleCommandExceptionType field_198753_b = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.tag.remove.failed", new Object[0]));

    public static void func_198743_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("tag").requires(commandSource -> commandSource.func_197034_c(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("targets", EntityArgument.func_197093_b()).then(Commands.func_197057_a("add").then(Commands.func_197056_a("name", StringArgumentType.word()).executes(commandContext -> TagCommand.func_198749_a((CommandSource)commandContext.getSource(), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets"), StringArgumentType.getString((CommandContext)commandContext, (String)"name")))))).then(Commands.func_197057_a("remove").then(Commands.func_197056_a("name", StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> ISuggestionProvider.func_197005_b(TagCommand.func_198748_a(EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets")), suggestionsBuilder)).executes(commandContext -> TagCommand.func_198750_b((CommandSource)commandContext.getSource(), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets"), StringArgumentType.getString((CommandContext)commandContext, (String)"name")))))).then(Commands.func_197057_a("list").executes(commandContext -> TagCommand.func_198744_a((CommandSource)commandContext.getSource(), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets"))))));
    }

    private static Collection<String> func_198748_a(Collection<? extends Entity> collection) {
        HashSet hashSet = Sets.newHashSet();
        for (Entity entity : collection) {
            hashSet.addAll(entity.func_184216_O());
        }
        return hashSet;
    }

    private static int func_198749_a(CommandSource commandSource, Collection<? extends Entity> collection, String string) throws CommandSyntaxException {
        int n = 0;
        for (Entity entity : collection) {
            if (!entity.func_184211_a(string)) continue;
            ++n;
        }
        if (n == 0) {
            throw field_198752_a.create();
        }
        if (collection.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.tag.add.success.single", string, collection.iterator().next().func_145748_c_()), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.tag.add.success.multiple", string, collection.size()), true);
        }
        return n;
    }

    private static int func_198750_b(CommandSource commandSource, Collection<? extends Entity> collection, String string) throws CommandSyntaxException {
        int n = 0;
        for (Entity entity : collection) {
            if (!entity.func_184197_b(string)) continue;
            ++n;
        }
        if (n == 0) {
            throw field_198753_b.create();
        }
        if (collection.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.tag.remove.success.single", string, collection.iterator().next().func_145748_c_()), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.tag.remove.success.multiple", string, collection.size()), true);
        }
        return n;
    }

    private static int func_198744_a(CommandSource commandSource, Collection<? extends Entity> collection2) {
        HashSet hashSet = Sets.newHashSet();
        for (Entity entity : collection2) {
            hashSet.addAll(entity.func_184216_O());
        }
        if (collection2.size() == 1) {
            Entity entity = collection2.iterator().next();
            if (hashSet.isEmpty()) {
                commandSource.func_197030_a(new TextComponentTranslation("commands.tag.list.single.empty", entity.func_145748_c_()), false);
            } else {
                commandSource.func_197030_a(new TextComponentTranslation("commands.tag.list.single.success", entity.func_145748_c_(), hashSet.size(), TextComponentUtils.func_197678_a(hashSet)), false);
            }
        } else if (hashSet.isEmpty()) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.tag.list.multiple.empty", collection2.size()), false);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.tag.list.multiple.success", collection2.size(), hashSet.size(), TextComponentUtils.func_197678_a(hashSet)), false);
        }
        return hashSet.size();
    }
}

