/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;

public class PlaySoundCommand {
    private static final SimpleCommandExceptionType field_198579_a = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.playsound.failed", new Object[0]));

    public static void func_198572_a(CommandDispatcher<CommandSource> commandDispatcher2) {
        CommandDispatcher<CommandSource> commandDispatcher2;
        RequiredArgumentBuilder requiredArgumentBuilder = Commands.func_197056_a("sound", ResourceLocationArgument.func_197197_a()).suggests(SuggestionProviders.field_197504_c);
        for (SoundCategory soundCategory : SoundCategory.values()) {
            requiredArgumentBuilder.then(PlaySoundCommand.func_198577_a(soundCategory));
        }
        commandDispatcher2.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("playsound").requires(commandSource -> commandSource.func_197034_c(2))).then((ArgumentBuilder)requiredArgumentBuilder));
    }

    private static LiteralArgumentBuilder<CommandSource> func_198577_a(SoundCategory soundCategory) {
        return (LiteralArgumentBuilder)Commands.func_197057_a(soundCategory.func_187948_a()).then(((RequiredArgumentBuilder)Commands.func_197056_a("targets", EntityArgument.func_197094_d()).executes(commandContext -> PlaySoundCommand.func_198573_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), ResourceLocationArgument.func_197195_e((CommandContext<CommandSource>)commandContext, "sound"), soundCategory, ((CommandSource)commandContext.getSource()).func_197036_d(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.func_197056_a("pos", Vec3Argument.func_197301_a()).executes(commandContext -> PlaySoundCommand.func_198573_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), ResourceLocationArgument.func_197195_e((CommandContext<CommandSource>)commandContext, "sound"), soundCategory, Vec3Argument.func_197300_a((CommandContext<CommandSource>)commandContext, "pos"), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.func_197056_a("volume", FloatArgumentType.floatArg((float)0.0f)).executes(commandContext -> PlaySoundCommand.func_198573_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), ResourceLocationArgument.func_197195_e((CommandContext<CommandSource>)commandContext, "sound"), soundCategory, Vec3Argument.func_197300_a((CommandContext<CommandSource>)commandContext, "pos"), ((Float)commandContext.getArgument("volume", Float.class)).floatValue(), 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.func_197056_a("pitch", FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(commandContext -> PlaySoundCommand.func_198573_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), ResourceLocationArgument.func_197195_e((CommandContext<CommandSource>)commandContext, "sound"), soundCategory, Vec3Argument.func_197300_a((CommandContext<CommandSource>)commandContext, "pos"), ((Float)commandContext.getArgument("volume", Float.class)).floatValue(), ((Float)commandContext.getArgument("pitch", Float.class)).floatValue(), 0.0f))).then(Commands.func_197056_a("minVolume", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(commandContext -> PlaySoundCommand.func_198573_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), ResourceLocationArgument.func_197195_e((CommandContext<CommandSource>)commandContext, "sound"), soundCategory, Vec3Argument.func_197300_a((CommandContext<CommandSource>)commandContext, "pos"), ((Float)commandContext.getArgument("volume", Float.class)).floatValue(), ((Float)commandContext.getArgument("pitch", Float.class)).floatValue(), ((Float)commandContext.getArgument("minVolume", Float.class)).floatValue())))))));
    }

    private static int func_198573_a(CommandSource commandSource, Collection<EntityPlayerMP> collection, ResourceLocation resourceLocation, SoundCategory soundCategory, Vec3d vec3d, float f, float f2, float f3) throws CommandSyntaxException {
        double d = Math.pow(f > 1.0f ? (double)(f * 16.0f) : 16.0, 2.0);
        int \u26032 = 0;
        for (EntityPlayerMP entityPlayerMP : collection) {
            double d2 = vec3d.field_72450_a - entityPlayerMP.field_70165_t;
            \u2603 = vec3d.field_72448_b - entityPlayerMP.field_70163_u;
            \u2603 = vec3d.field_72449_c - entityPlayerMP.field_70161_v;
            \u2603 = d2 * d2 + \u2603 * \u2603 + \u2603 * \u2603;
            Vec3d \u26033 = vec3d;
            float \u26034 = f;
            if (\u2603 > d) {
                if (f3 <= 0.0f) continue;
                \u2603 = MathHelper.func_76133_a(\u2603);
                \u26033 = new Vec3d(entityPlayerMP.field_70165_t + d2 / \u2603 * 2.0, entityPlayerMP.field_70163_u + \u2603 / \u2603 * 2.0, entityPlayerMP.field_70161_v + \u2603 / \u2603 * 2.0);
                \u26034 = f3;
            }
            entityPlayerMP.field_71135_a.func_147359_a(new SPacketCustomSound(resourceLocation, soundCategory, \u26033, \u26034, f2));
            ++\u26032;
        }
        if (\u26032 == 0) {
            throw field_198579_a.create();
        }
        if (collection.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.playsound.success.single", resourceLocation, collection.iterator().next().func_145748_c_()), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.playsound.success.single", resourceLocation, collection.iterator().next().func_145748_c_()), true);
        }
        return \u26032;
    }
}

