/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextComponentTranslation;

public class EntityArgument
implements ArgumentType<EntitySelector> {
    private static final Collection<String> field_201310_f = Arrays.asList("Player", "0123", "@e", "@e[type=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    public static final SimpleCommandExceptionType field_197098_a = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.entity.toomany", new Object[0]));
    public static final SimpleCommandExceptionType field_197099_b = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.player.toomany", new Object[0]));
    public static final SimpleCommandExceptionType field_197100_c = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.player.entities", new Object[0]));
    public static final SimpleCommandExceptionType field_197101_d = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.entity.notfound.entity", new Object[0]));
    public static final SimpleCommandExceptionType field_197102_e = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.entity.notfound.player", new Object[0]));
    public static final SimpleCommandExceptionType field_210323_f = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.entity.selector.not_allowed", new Object[0]));
    private final boolean field_197103_f;
    private final boolean field_197104_g;

    protected EntityArgument(boolean bl, boolean bl2) {
        this.field_197103_f = bl;
        this.field_197104_g = bl2;
    }

    public static EntityArgument func_197086_a() {
        return new EntityArgument(true, false);
    }

    public static Entity func_197088_a(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return ((EntitySelector)commandContext.getArgument(string, EntitySelector.class)).func_197340_a((CommandSource)commandContext.getSource());
    }

    public static EntityArgument func_197093_b() {
        return new EntityArgument(false, false);
    }

    public static Collection<? extends Entity> func_197097_b(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        Collection<? extends Entity> collection = EntityArgument.func_197087_c(commandContext, string);
        if (collection.isEmpty()) {
            throw field_197101_d.create();
        }
        return collection;
    }

    public static Collection<? extends Entity> func_197087_c(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return ((EntitySelector)commandContext.getArgument(string, EntitySelector.class)).func_197341_b((CommandSource)commandContext.getSource());
    }

    public static Collection<EntityPlayerMP> func_201309_d(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return ((EntitySelector)commandContext.getArgument(string, EntitySelector.class)).func_197342_d((CommandSource)commandContext.getSource());
    }

    public static EntityArgument func_197096_c() {
        return new EntityArgument(true, true);
    }

    public static EntityPlayerMP func_197089_d(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return ((EntitySelector)commandContext.getArgument(string, EntitySelector.class)).func_197347_c((CommandSource)commandContext.getSource());
    }

    public static EntityArgument func_197094_d() {
        return new EntityArgument(false, true);
    }

    public static Collection<EntityPlayerMP> func_197090_e(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        List<EntityPlayerMP> list = ((EntitySelector)commandContext.getArgument(string, EntitySelector.class)).func_197342_d((CommandSource)commandContext.getSource());
        if (list.isEmpty()) {
            throw field_197102_e.create();
        }
        return list;
    }

    public EntitySelector parse(StringReader stringReader) throws CommandSyntaxException {
        boolean bl = false;
        EntitySelectorParser \u26032 = new EntitySelectorParser(stringReader);
        EntitySelector \u26033 = \u26032.func_201345_m();
        if (\u26033.func_197346_a() > 1 && this.field_197103_f) {
            if (this.field_197104_g) {
                stringReader.setCursor(0);
                throw field_197099_b.createWithContext((ImmutableStringReader)stringReader);
            }
            stringReader.setCursor(0);
            throw field_197098_a.createWithContext((ImmutableStringReader)stringReader);
        }
        if (\u26033.func_197351_b() && this.field_197104_g && !\u26033.func_197352_c()) {
            stringReader.setCursor(0);
            throw field_197100_c.createWithContext((ImmutableStringReader)stringReader);
        }
        return \u26033;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder2) {
        if (commandContext.getSource() instanceof ISuggestionProvider) {
            StringReader stringReader = new StringReader(suggestionsBuilder2.getInput());
            stringReader.setCursor(suggestionsBuilder2.getStart());
            ISuggestionProvider \u26032 = (ISuggestionProvider)commandContext.getSource();
            EntitySelectorParser \u26033 = new EntitySelectorParser(stringReader, \u26032.func_197034_c(2));
            try {
                \u26033.func_201345_m();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return \u26033.func_201993_a(suggestionsBuilder2, suggestionsBuilder -> {
                Collection<String> collection = \u26032.func_197011_j();
                \u2603 = this.field_197104_g ? collection : Iterables.concat(collection, \u26032.func_211270_p());
                ISuggestionProvider.func_197005_b(\u2603, suggestionsBuilder);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return field_201310_f;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class Serializer
    implements IArgumentSerializer<EntityArgument> {
        @Override
        public void func_197072_a(EntityArgument entityArgument, PacketBuffer packetBuffer) {
            byte by = 0;
            if (entityArgument.field_197103_f) {
                by = (byte)(by | 1);
            }
            if (entityArgument.field_197104_g) {
                by = (byte)(by | 2);
            }
            packetBuffer.writeByte(by);
        }

        @Override
        public EntityArgument func_197071_b(PacketBuffer packetBuffer) {
            byte by = packetBuffer.readByte();
            return new EntityArgument((by & 1) != 0, (by & 2) != 0);
        }

        @Override
        public void func_212244_a(EntityArgument entityArgument, JsonObject jsonObject) {
            jsonObject.addProperty("amount", entityArgument.field_197103_f ? "single" : "multiple");
            jsonObject.addProperty("type", entityArgument.field_197104_g ? "players" : "entities");
        }

        @Override
        public /* synthetic */ ArgumentType func_197071_b(PacketBuffer packetBuffer) {
            return this.func_197071_b(packetBuffer);
        }
    }
}

