/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.LocationInput;
import net.minecraft.command.arguments.LocationPart;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;

public class ColumnPosArgument
implements ArgumentType<ILocationArgument> {
    private static final Collection<String> field_212605_b = Arrays.asList("0 0", "~ ~", "~1 ~-2", "^ ^", "^-1 ^0");
    public static final SimpleCommandExceptionType field_212604_a = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.pos2d.incomplete", new Object[0]));

    public static ColumnPosArgument func_212603_a() {
        return new ColumnPosArgument();
    }

    public static ColumnPos func_212602_a(CommandContext<CommandSource> commandContext, String string) {
        BlockPos blockPos = ((ILocationArgument)commandContext.getArgument(string, ILocationArgument.class)).func_197280_c((CommandSource)commandContext.getSource());
        return new ColumnPos(blockPos.func_177958_n(), blockPos.func_177952_p());
    }

    public ILocationArgument parse(StringReader stringReader) throws CommandSyntaxException {
        int n = stringReader.getCursor();
        if (!stringReader.canRead()) {
            throw field_212604_a.createWithContext((ImmutableStringReader)stringReader);
        }
        LocationPart \u26032 = LocationPart.func_197307_a(stringReader);
        if (!stringReader.canRead() || stringReader.peek() != ' ') {
            stringReader.setCursor(n);
            throw field_212604_a.createWithContext((ImmutableStringReader)stringReader);
        }
        stringReader.skip();
        LocationPart \u26033 = LocationPart.func_197307_a(stringReader);
        return new LocationInput(\u26032, new LocationPart(true, 0.0), \u26033);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        if (commandContext.getSource() instanceof ISuggestionProvider) {
            String string = suggestionsBuilder.getRemaining();
            Collection<ISuggestionProvider.Coordinates> \u26032 = !string.isEmpty() && string.charAt(0) == '^' ? Collections.singleton(ISuggestionProvider.Coordinates.field_209004_a) : ((ISuggestionProvider)commandContext.getSource()).func_199613_a(false);
            return ISuggestionProvider.func_211269_a(string, \u26032, suggestionsBuilder, Commands.func_212590_a(this::parse));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return field_212605_b;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class ColumnPos {
        public final int field_212600_a;
        public final int field_212601_b;

        public ColumnPos(int n, int n2) {
            this.field_212600_a = n;
            this.field_212601_b = n2;
        }

        public String toString() {
            return "[" + this.field_212600_a + ", " + this.field_212601_b + "]";
        }
    }
}

