/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.state.pattern;

import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReaderBase;

public class BlockPattern {
    private final Predicate<BlockWorldState>[][][] field_177689_a;
    private final int field_177687_b;
    private final int field_177688_c;
    private final int field_177686_d;

    public BlockPattern(Predicate<BlockWorldState>[][][] predicateArray) {
        this.field_177689_a = predicateArray;
        this.field_177687_b = predicateArray.length;
        if (this.field_177687_b > 0) {
            this.field_177688_c = predicateArray[0].length;
            this.field_177686_d = this.field_177688_c > 0 ? predicateArray[0][0].length : 0;
        } else {
            this.field_177688_c = 0;
            this.field_177686_d = 0;
        }
    }

    public int func_185922_a() {
        return this.field_177687_b;
    }

    public int func_177685_b() {
        return this.field_177688_c;
    }

    public int func_177684_c() {
        return this.field_177686_d;
    }

    @Nullable
    private PatternHelper func_177682_a(BlockPos blockPos2, EnumFacing enumFacing, EnumFacing enumFacing2, LoadingCache<BlockPos, BlockWorldState> loadingCache) {
        BlockPos blockPos2;
        for (int i = 0; i < this.field_177686_d; ++i) {
            for (\u2603 = 0; \u2603 < this.field_177688_c; ++\u2603) {
                for (\u2603 = 0; \u2603 < this.field_177687_b; ++\u2603) {
                    if (this.field_177689_a[\u2603][\u2603][i].test((BlockWorldState)loadingCache.getUnchecked((Object)BlockPattern.func_177683_a(blockPos2, enumFacing, enumFacing2, i, \u2603, \u2603)))) continue;
                    return null;
                }
            }
        }
        return new PatternHelper(blockPos2, enumFacing, enumFacing2, loadingCache, this.field_177686_d, this.field_177688_c, this.field_177687_b);
    }

    @Nullable
    public PatternHelper func_177681_a(IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
        LoadingCache<BlockPos, BlockWorldState> loadingCache = BlockPattern.func_181627_a(iWorldReaderBase, false);
        int \u26032 = Math.max(Math.max(this.field_177686_d, this.field_177688_c), this.field_177687_b);
        for (BlockPos blockPos2 : BlockPos.func_177980_a(blockPos, blockPos.func_177982_a(\u26032 - 1, \u26032 - 1, \u26032 - 1))) {
            for (EnumFacing enumFacing : EnumFacing.values()) {
                for (EnumFacing enumFacing2 : EnumFacing.values()) {
                    if (enumFacing2 == enumFacing || enumFacing2 == enumFacing.func_176734_d() || (\u2603 = this.func_177682_a(blockPos2, enumFacing, enumFacing2, loadingCache)) == null) continue;
                    return \u2603;
                }
            }
        }
        return null;
    }

    public static LoadingCache<BlockPos, BlockWorldState> func_181627_a(IWorldReaderBase iWorldReaderBase, boolean bl) {
        return CacheBuilder.newBuilder().build((com.google.common.cache.CacheLoader)new CacheLoader(iWorldReaderBase, bl));
    }

    protected static BlockPos func_177683_a(BlockPos blockPos, EnumFacing enumFacing, EnumFacing enumFacing2, int n, int n2, int n3) {
        if (enumFacing == enumFacing2 || enumFacing == enumFacing2.func_176734_d()) {
            throw new IllegalArgumentException("Invalid forwards & up combination");
        }
        Vec3i vec3i = new Vec3i(enumFacing.func_82601_c(), enumFacing.func_96559_d(), enumFacing.func_82599_e());
        \u2603 = new Vec3i(enumFacing2.func_82601_c(), enumFacing2.func_96559_d(), enumFacing2.func_82599_e());
        \u2603 = vec3i.func_177955_d(\u2603);
        return blockPos.func_177982_a(\u2603.func_177958_n() * -n2 + \u2603.func_177958_n() * n + vec3i.func_177958_n() * n3, \u2603.func_177956_o() * -n2 + \u2603.func_177956_o() * n + vec3i.func_177956_o() * n3, \u2603.func_177952_p() * -n2 + \u2603.func_177952_p() * n + vec3i.func_177952_p() * n3);
    }

    public static class PatternHelper {
        private final BlockPos field_177674_a;
        private final EnumFacing field_177672_b;
        private final EnumFacing field_177673_c;
        private final LoadingCache<BlockPos, BlockWorldState> field_177671_d;
        private final int field_181120_e;
        private final int field_181121_f;
        private final int field_181122_g;

        public PatternHelper(BlockPos blockPos, EnumFacing enumFacing, EnumFacing enumFacing2, LoadingCache<BlockPos, BlockWorldState> loadingCache, int n, int n2, int n3) {
            this.field_177674_a = blockPos;
            this.field_177672_b = enumFacing;
            this.field_177673_c = enumFacing2;
            this.field_177671_d = loadingCache;
            this.field_181120_e = n;
            this.field_181121_f = n2;
            this.field_181122_g = n3;
        }

        public BlockPos func_181117_a() {
            return this.field_177674_a;
        }

        public EnumFacing func_177669_b() {
            return this.field_177672_b;
        }

        public EnumFacing func_177668_c() {
            return this.field_177673_c;
        }

        public int func_181118_d() {
            return this.field_181120_e;
        }

        public int func_181119_e() {
            return this.field_181121_f;
        }

        public BlockWorldState func_177670_a(int n, int n2, int n3) {
            return (BlockWorldState)this.field_177671_d.getUnchecked((Object)BlockPattern.func_177683_a(this.field_177674_a, this.func_177669_b(), this.func_177668_c(), n, n2, n3));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("up", (Object)this.field_177673_c).add("forwards", (Object)this.field_177672_b).add("frontTopLeft", (Object)this.field_177674_a).toString();
        }
    }

    static class CacheLoader
    extends com.google.common.cache.CacheLoader<BlockPos, BlockWorldState> {
        private final IWorldReaderBase field_177680_a;
        private final boolean field_181626_b;

        public CacheLoader(IWorldReaderBase iWorldReaderBase, boolean bl) {
            this.field_177680_a = iWorldReaderBase;
            this.field_181626_b = bl;
        }

        public BlockWorldState load(BlockPos blockPos) throws Exception {
            return new BlockWorldState(this.field_177680_a, blockPos, this.field_181626_b);
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((BlockPos)object);
        }
    }
}

