/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;

public class BlockRedstoneComparator
extends BlockRedstoneDiode
implements ITileEntityProvider {
    public static final EnumProperty<ComparatorMode> field_176463_b = BlockStateProperties.field_208141_ap;

    public BlockRedstoneComparator(Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_185512_D, EnumFacing.NORTH)).func_206870_a(field_196348_c, false)).func_206870_a(field_176463_b, ComparatorMode.COMPARE));
    }

    @Override
    protected int func_196346_i(IBlockState iBlockState) {
        return 2;
    }

    @Override
    protected int func_176408_a(IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState) {
        TileEntity tileEntity = iBlockReader.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityComparator) {
            return ((TileEntityComparator)tileEntity).func_145996_a();
        }
        return 0;
    }

    private int func_176460_j(World world, BlockPos blockPos, IBlockState iBlockState) {
        if (iBlockState.func_177229_b(field_176463_b) == ComparatorMode.SUBTRACT) {
            return Math.max(this.func_176397_f(world, blockPos, iBlockState) - this.func_176407_c(world, blockPos, iBlockState), 0);
        }
        return this.func_176397_f(world, blockPos, iBlockState);
    }

    @Override
    protected boolean func_176404_e(World world, BlockPos blockPos, IBlockState iBlockState) {
        int n = this.func_176397_f(world, blockPos, iBlockState);
        if (n >= 15) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        return n >= this.func_176407_c(world, blockPos, iBlockState);
    }

    @Override
    protected void func_211326_a(World world, BlockPos blockPos) {
        world.func_175713_t(blockPos);
    }

    @Override
    protected int func_176397_f(World world, BlockPos blockPos, IBlockState iBlockState) {
        int n = super.func_176397_f(world, blockPos, iBlockState);
        EnumFacing \u26032 = iBlockState.func_177229_b(field_185512_D);
        BlockPos \u26033 = blockPos.func_177972_a(\u26032);
        IBlockState \u26034 = world.func_180495_p(\u26033);
        if (\u26034.func_185912_n()) {
            n = \u26034.func_185888_a(world, \u26033);
        } else if (n < 15 && \u26034.func_185915_l()) {
            \u26034 = world.func_180495_p(\u26033 = \u26033.func_177972_a(\u26032));
            if (\u26034.func_185912_n()) {
                n = \u26034.func_185888_a(world, \u26033);
            } else if (\u26034.func_196958_f() && (\u2603 = this.func_176461_a(world, \u26032, \u26033)) != null) {
                n = \u2603.func_174866_q();
            }
        }
        return n;
    }

    @Nullable
    private EntityItemFrame func_176461_a(World world, EnumFacing enumFacing, BlockPos blockPos) {
        List<EntityItemFrame> list = world.func_175647_a(EntityItemFrame.class, new AxisAlignedBB(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos.func_177958_n() + 1, blockPos.func_177956_o() + 1, blockPos.func_177952_p() + 1), entityItemFrame -> entityItemFrame != null && entityItemFrame.func_174811_aO() == enumFacing);
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public boolean func_196250_a(IBlockState iBlockState, World world, BlockPos blockPos, EntityPlayer entityPlayer, EnumHand enumHand, EnumFacing enumFacing, float f, float f2, float f3) {
        if (!entityPlayer.field_71075_bZ.field_75099_e) {
            return false;
        }
        \u2603 = (iBlockState = (IBlockState)iBlockState.func_177231_a(field_176463_b)).func_177229_b(field_176463_b) == ComparatorMode.SUBTRACT ? 0.55f : 0.5f;
        world.func_184133_a(entityPlayer, blockPos, SoundEvents.field_187556_aj, SoundCategory.BLOCKS, 0.3f, \u2603);
        world.func_180501_a(blockPos, iBlockState, 2);
        this.func_176462_k(world, blockPos, iBlockState);
        return true;
    }

    @Override
    protected void func_176398_g(World world, BlockPos blockPos, IBlockState iBlockState) {
        if (world.func_205220_G_().func_205361_b(blockPos, this)) {
            return;
        }
        int n = this.func_176460_j(world, blockPos, iBlockState);
        TileEntity \u26032 = world.func_175625_s(blockPos);
        int n2 = \u2603 = \u26032 instanceof TileEntityComparator ? ((TileEntityComparator)\u26032).func_145996_a() : 0;
        if (n != \u2603 || iBlockState.func_177229_b(field_196348_c).booleanValue() != this.func_176404_e(world, blockPos, iBlockState)) {
            TickPriority tickPriority = this.func_176402_i(world, blockPos, iBlockState) ? TickPriority.HIGH : TickPriority.NORMAL;
            world.func_205220_G_().func_205362_a(blockPos, this, 2, tickPriority);
        }
    }

    private void func_176462_k(World world, BlockPos blockPos, IBlockState iBlockState) {
        int \u26033;
        int n = this.func_176460_j(world, blockPos, iBlockState);
        TileEntity \u26032 = world.func_175625_s(blockPos);
        \u26033 = 0;
        if (\u26032 instanceof TileEntityComparator) {
            TileEntityComparator tileEntityComparator = (TileEntityComparator)\u26032;
            \u26033 = tileEntityComparator.func_145996_a();
            tileEntityComparator.func_145995_a(n);
        }
        if (\u26033 != n || iBlockState.func_177229_b(field_176463_b) == ComparatorMode.COMPARE) {
            boolean \u26034 = this.func_176404_e(world, blockPos, iBlockState);
            boolean \u26035 = iBlockState.func_177229_b(field_196348_c);
            if (\u26035 && !\u26034) {
                world.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_196348_c, false), 2);
            } else if (!\u26035 && \u26034) {
                world.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_196348_c, true), 2);
            }
            this.func_176400_h(world, blockPos, iBlockState);
        }
    }

    @Override
    public void func_196267_b(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        this.func_176462_k(world, blockPos, iBlockState);
    }

    @Override
    public boolean func_189539_a(IBlockState iBlockState, World world, BlockPos blockPos, int n, int n2) {
        super.func_189539_a(iBlockState, world, blockPos, n, n2);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        return tileEntity != null && tileEntity.func_145842_c(n, n2);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new TileEntityComparator();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_185512_D, field_176463_b, field_196348_c);
    }
}

