/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.common.ForgeHooks;

public class LootPool {
    private final String name;
    private final List<LootEntry> field_186453_a;
    private final List<LootCondition> field_186454_b;
    private RandomValueRange field_186455_c;
    private RandomValueRange field_186456_d;
    private boolean isFrozen = false;

    public LootPool(LootEntry[] lootEntriesIn, LootCondition[] poolConditionsIn, RandomValueRange rollsIn, RandomValueRange bonusRollsIn, String name) {
        this.name = name;
        this.field_186453_a = Lists.newArrayList((Object[])lootEntriesIn);
        this.field_186454_b = Lists.newArrayList((Object[])poolConditionsIn);
        this.field_186455_c = rollsIn;
        this.field_186456_d = bonusRollsIn;
    }

    protected void func_186452_a(Collection<ItemStack> stacks, Random rand, LootContext context) {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        for (LootEntry lootentry : this.field_186453_a) {
            int j;
            if (!LootConditionManager.func_186638_a(lootentry.field_186366_e, rand, context) || (j = lootentry.func_186361_a(context.func_186491_f())) <= 0) continue;
            list.add(lootentry);
            i += j;
        }
        if (i != 0 && !list.isEmpty()) {
            int k = rand.nextInt(i);
            for (LootEntry lootentry1 : list) {
                if ((k -= lootentry1.func_186361_a(context.func_186491_f())) >= 0) continue;
                lootentry1.func_186363_a(stacks, rand, context);
                return;
            }
        }
    }

    public void func_186449_b(Collection<ItemStack> stacks, Random rand, LootContext context) {
        if (LootConditionManager.testAllConditions(this.field_186454_b, rand, context)) {
            int i = this.field_186455_c.func_186511_a(rand) + MathHelper.func_76141_d((float)(this.field_186456_d.func_186507_b(rand) * context.func_186491_f()));
            for (int j = 0; j < i; ++j) {
                this.func_186452_a(stacks, rand, context);
            }
        }
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootPool after being frozen!");
        }
    }

    public String getName() {
        return this.name;
    }

    public RandomValueRange getRolls() {
        return this.field_186455_c;
    }

    public RandomValueRange getBonusRolls() {
        return this.field_186456_d;
    }

    public void setRolls(RandomValueRange v) {
        this.checkFrozen();
        this.field_186455_c = v;
    }

    public void setBonusRolls(RandomValueRange v) {
        this.checkFrozen();
        this.field_186456_d = v;
    }

    public LootEntry getEntry(String name) {
        return this.field_186453_a.stream().filter(e -> name.equals(e.getEntryName())).findFirst().orElse(null);
    }

    public LootEntry removeEntry(String name) {
        this.checkFrozen();
        for (LootEntry entry : this.field_186453_a) {
            if (!name.equals(entry.getEntryName())) continue;
            this.field_186453_a.remove(entry);
            return entry;
        }
        return null;
    }

    public void addEntry(LootEntry entry) {
        this.checkFrozen();
        if (this.field_186453_a.stream().anyMatch(e -> e == entry || e.getEntryName().equals(entry.getEntryName()))) {
            throw new RuntimeException("Attempted to add a duplicate entry to pool: " + entry.getEntryName());
        }
        this.field_186453_a.add(entry);
    }

    public static class Serializer
    implements JsonDeserializer<LootPool>,
    JsonSerializer<LootPool> {
        public LootPool deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)p_deserialize_1_, (String)"loot pool");
            LootEntry[] alootentry = (LootEntry[])JsonUtils.func_188174_a((JsonObject)jsonobject, (String)"entries", (JsonDeserializationContext)p_deserialize_3_, LootEntry[].class);
            LootCondition[] alootcondition = (LootCondition[])JsonUtils.func_188177_a((JsonObject)jsonobject, (String)"conditions", (Object)new LootCondition[0], (JsonDeserializationContext)p_deserialize_3_, LootCondition[].class);
            RandomValueRange randomvaluerange = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)jsonobject, (String)"rolls", (JsonDeserializationContext)p_deserialize_3_, RandomValueRange.class);
            RandomValueRange randomvaluerange1 = (RandomValueRange)JsonUtils.func_188177_a((JsonObject)jsonobject, (String)"bonus_rolls", (Object)new RandomValueRange(0.0f, 0.0f), (JsonDeserializationContext)p_deserialize_3_, RandomValueRange.class);
            return new LootPool(alootentry, alootcondition, randomvaluerange, randomvaluerange1, ForgeHooks.readPoolName((JsonObject)jsonobject));
        }

        public JsonElement serialize(LootPool p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject jsonobject = new JsonObject();
            if (p_serialize_1_.name != null && !p_serialize_1_.name.startsWith("custom#")) {
                jsonobject.add("name", p_serialize_3_.serialize((Object)p_serialize_1_.name));
            }
            jsonobject.add("entries", p_serialize_3_.serialize((Object)p_serialize_1_.field_186453_a));
            jsonobject.add("rolls", p_serialize_3_.serialize((Object)p_serialize_1_.field_186455_c));
            if (p_serialize_1_.field_186456_d.func_186509_a() != 0.0f && p_serialize_1_.field_186456_d.func_186512_b() != 0.0f) {
                jsonobject.add("bonus_rolls", p_serialize_3_.serialize((Object)p_serialize_1_.field_186456_d));
            }
            if (!p_serialize_1_.field_186454_b.isEmpty()) {
                jsonobject.add("conditions", p_serialize_3_.serialize((Object)p_serialize_1_.field_186454_b));
            }
            return jsonobject;
        }
    }
}

