/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.ForgeHooks;

public abstract class LootEntry {
    protected final int field_186364_c;
    protected final int field_186365_d;
    protected final LootCondition[] field_186366_e;
    protected final String entryName;

    protected LootEntry(int weightIn, int qualityIn, LootCondition[] conditionsIn, String entryName) {
        this.field_186364_c = weightIn;
        this.field_186365_d = qualityIn;
        this.field_186366_e = conditionsIn;
        this.entryName = entryName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public int func_186361_a(float luck) {
        return Math.max(MathHelper.func_76141_d((float)((float)this.field_186364_c + (float)this.field_186365_d * luck)), 0);
    }

    public abstract void func_186363_a(Collection<ItemStack> var1, Random var2, LootContext var3);

    protected abstract void func_186362_a(JsonObject var1, JsonSerializationContext var2);

    public static class Serializer
    implements JsonDeserializer<LootEntry>,
    JsonSerializer<LootEntry> {
        public LootEntry deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            LootCondition[] alootcondition;
            int j;
            int i;
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)p_deserialize_1_, (String)"loot item");
            String s = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"type");
            LootEntry ret = ForgeHooks.deserializeJsonLootEntry((String)s, (JsonObject)jsonobject, (int)(i = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"weight", (int)1)), (int)(j = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"quality", (int)0)), (LootCondition[])(alootcondition = jsonobject.has("conditions") ? (LootCondition[])JsonUtils.func_188174_a((JsonObject)jsonobject, (String)"conditions", (JsonDeserializationContext)p_deserialize_3_, LootCondition[].class) : new LootCondition[]{}));
            if (ret != null) {
                return ret;
            }
            if ("item".equals(s)) {
                return LootEntryItem.func_186367_a(jsonobject, p_deserialize_3_, i, j, alootcondition);
            }
            if ("loot_table".equals(s)) {
                return LootEntryTable.func_186370_a(jsonobject, p_deserialize_3_, i, j, alootcondition);
            }
            if ("empty".equals(s)) {
                return LootEntryEmpty.func_186372_a(jsonobject, p_deserialize_3_, i, j, alootcondition);
            }
            throw new JsonSyntaxException("Unknown loot entry type '" + s + "'");
        }

        public JsonElement serialize(LootEntry p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            String type;
            JsonObject jsonobject = new JsonObject();
            if (p_serialize_1_.entryName != null && !p_serialize_1_.entryName.startsWith("custom#")) {
                jsonobject.addProperty("entryName", p_serialize_1_.entryName);
            }
            jsonobject.addProperty("weight", (Number)p_serialize_1_.field_186364_c);
            jsonobject.addProperty("quality", (Number)p_serialize_1_.field_186365_d);
            if (p_serialize_1_.field_186366_e.length > 0) {
                jsonobject.add("conditions", p_serialize_3_.serialize((Object)p_serialize_1_.field_186366_e));
            }
            if ((type = ForgeHooks.getLootEntryType((LootEntry)p_serialize_1_)) != null) {
                jsonobject.addProperty("type", type);
            } else if (p_serialize_1_ instanceof LootEntryItem) {
                jsonobject.addProperty("type", "item");
            } else if (p_serialize_1_ instanceof LootEntryTable) {
                jsonobject.addProperty("type", "loot_table");
            } else {
                if (!(p_serialize_1_ instanceof LootEntryEmpty)) {
                    throw new IllegalArgumentException("Don't know how to serialize " + p_serialize_1_);
                }
                jsonobject.addProperty("type", "empty");
            }
            p_serialize_1_.func_186362_a(jsonobject, p_serialize_3_);
            return jsonobject;
        }
    }
}

