/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Sets;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.ForgeHooks;

public class LootContext {
    private final float field_186498_a;
    private final WorldServer field_186499_b;
    private final LootTableManager field_186500_c;
    @Nullable
    private final Entity field_186501_d;
    @Nullable
    private final EntityPlayer field_186502_e;
    @Nullable
    private final DamageSource field_186503_f;
    @Nullable
    private final BlockPos field_204316_g;
    private final Set<LootTable> field_186504_g = Sets.newLinkedHashSet();

    public LootContext(float p_i48874_1_, WorldServer p_i48874_2_, LootTableManager p_i48874_3_, @Nullable Entity p_i48874_4_, @Nullable EntityPlayer p_i48874_5_, @Nullable DamageSource p_i48874_6_, @Nullable BlockPos p_i48874_7_) {
        this.field_186498_a = p_i48874_1_;
        this.field_186499_b = p_i48874_2_;
        this.field_186500_c = p_i48874_3_;
        this.field_186501_d = p_i48874_4_;
        this.field_186502_e = p_i48874_5_;
        this.field_186503_f = p_i48874_6_;
        this.field_204316_g = p_i48874_7_;
    }

    @Nullable
    public Entity func_186493_a() {
        return this.field_186501_d;
    }

    @Nullable
    public Entity func_186495_b() {
        return this.field_186502_e;
    }

    @Nullable
    public Entity func_186492_c() {
        return this.field_186503_f == null ? null : this.field_186503_f.func_76346_g();
    }

    @Nullable
    public BlockPos func_204315_e() {
        return this.field_204316_g;
    }

    public boolean func_186496_a(LootTable lootTableIn) {
        return this.field_186504_g.add(lootTableIn);
    }

    public void func_186490_b(LootTable lootTableIn) {
        this.field_186504_g.remove(lootTableIn);
    }

    public LootTableManager func_186497_e() {
        return this.field_186500_c;
    }

    public float func_186491_f() {
        return this.field_186498_a;
    }

    public WorldServer func_202879_g() {
        return this.field_186499_b;
    }

    @Nullable
    public Entity func_186494_a(EntityTarget target) {
        switch (target) {
            case THIS: {
                return this.func_186493_a();
            }
            case KILLER: {
                return this.func_186492_c();
            }
            case KILLER_PLAYER: {
                return this.func_186495_b();
            }
        }
        return null;
    }

    public int getLootingModifier() {
        return ForgeHooks.getLootingLevel((Entity)this.func_186493_a(), (Entity)this.func_186492_c(), (DamageSource)this.field_186503_f);
    }

    public static enum EntityTarget {
        THIS("this"),
        KILLER("killer"),
        KILLER_PLAYER("killer_player");

        private final String field_186488_d;

        private EntityTarget(String type) {
            this.field_186488_d = type;
        }

        public static EntityTarget func_186482_a(String type) {
            for (EntityTarget lootcontext$entitytarget : EntityTarget.values()) {
                if (!lootcontext$entitytarget.field_186488_d.equals(type)) continue;
                return lootcontext$entitytarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + type);
        }

        public static class Serializer
        extends TypeAdapter<EntityTarget> {
            public void write(JsonWriter p_write_1_, EntityTarget p_write_2_) throws IOException {
                p_write_1_.value(p_write_2_.field_186488_d);
            }

            public EntityTarget read(JsonReader p_read_1_) throws IOException {
                return EntityTarget.func_186482_a(p_read_1_.nextString());
            }
        }
    }

    public static class Builder {
        private final WorldServer field_186474_a;
        private float field_186475_b;
        private Entity field_186476_c;
        private EntityPlayer field_186477_d;
        private DamageSource field_186478_e;
        private BlockPos field_204314_f;

        public Builder(WorldServer worldIn) {
            this.field_186474_a = worldIn;
        }

        public Builder func_186469_a(float luckIn) {
            this.field_186475_b = luckIn;
            return this;
        }

        public Builder func_186472_a(Entity entityIn) {
            this.field_186476_c = entityIn;
            return this;
        }

        public Builder func_186470_a(EntityPlayer playerIn) {
            this.field_186477_d = playerIn;
            return this;
        }

        public Builder func_186473_a(DamageSource dmgSource) {
            this.field_186478_e = dmgSource;
            return this;
        }

        public Builder func_204313_a(BlockPos p_204313_1_) {
            this.field_204314_f = p_204313_1_;
            return this;
        }

        public LootContext func_186471_a() {
            return new LootContext(this.field_186475_b, this.field_186474_a, this.field_186474_a.func_73046_m().func_200249_aQ(), this.field_186476_c, this.field_186477_d, this.field_186478_e, this.field_204314_f);
        }
    }
}

