/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.structure.StructurePiece;

public abstract class StructureStart {
    protected final List<StructurePiece> field_75075_a = Lists.newArrayList();
    protected MutableBoundingBox field_75074_b;
    protected int field_143024_c;
    protected int field_143023_d;
    private Biome field_202505_e;
    private int field_212688_f;

    public StructureStart() {
    }

    public StructureStart(int chunkPosX, int chunkPosZ, Biome biomeIn, SharedSeedRandom random, long seed) {
        this.field_143024_c = chunkPosX;
        this.field_143023_d = chunkPosZ;
        this.field_202505_e = biomeIn;
        random.func_202425_c(seed, this.field_143024_c, this.field_143023_d);
    }

    public MutableBoundingBox func_75071_a() {
        return this.field_75074_b;
    }

    public List<StructurePiece> func_186161_c() {
        return this.field_75075_a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_75068_a(IWorld worldIn, Random rand, MutableBoundingBox structurebb, ChunkPos p_75068_4_) {
        List<StructurePiece> list = this.field_75075_a;
        synchronized (list) {
            Iterator<StructurePiece> iterator = this.field_75075_a.iterator();
            while (iterator.hasNext()) {
                StructurePiece structurepiece = iterator.next();
                if (!structurepiece.func_74874_b().func_78884_a(structurebb) || structurepiece.func_74875_a(worldIn, rand, structurebb, p_75068_4_)) continue;
                iterator.remove();
            }
            this.func_202500_a((IBlockReader)worldIn);
        }
    }

    protected void func_202500_a(IBlockReader blockReader) {
        this.field_75074_b = MutableBoundingBox.func_78887_a();
        for (StructurePiece structurepiece : this.field_75075_a) {
            this.field_75074_b.func_78888_b(structurepiece.func_74874_b());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTTagCompound func_143021_a(int chunkX, int chunkZ) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (this.func_75069_d()) {
            if (StructureIO.func_143033_a((StructureStart)this) == null) {
                throw new RuntimeException("StructureStart \"" + this.getClass().getName() + "\" missing ID Mapping, Modder see MapGenStructureIO");
            }
            nbttagcompound.func_74778_a("id", StructureIO.func_143033_a((StructureStart)this));
            nbttagcompound.func_74778_a("biome", IRegistry.field_212624_m.func_177774_c(this.field_202505_e).toString());
            nbttagcompound.func_74768_a("ChunkX", chunkX);
            nbttagcompound.func_74768_a("ChunkZ", chunkZ);
            nbttagcompound.func_74768_a("references", this.field_212688_f);
            nbttagcompound.func_74782_a("BB", (INBTBase)this.field_75074_b.func_151535_h());
            NBTTagList lvt_4_1_ = new NBTTagList();
            List<StructurePiece> list = this.field_75075_a;
            synchronized (list) {
                for (StructurePiece structurepiece : this.field_75075_a) {
                    lvt_4_1_.add((INBTBase)structurepiece.func_143010_b());
                }
            }
            nbttagcompound.func_74782_a("Children", (INBTBase)lvt_4_1_);
            this.func_143022_a(nbttagcompound);
            return nbttagcompound;
        }
        nbttagcompound.func_74778_a("id", "INVALID");
        return nbttagcompound;
    }

    public void func_143022_a(NBTTagCompound tagCompound) {
    }

    public void func_143020_a(IWorld worldIn, NBTTagCompound tagCompound) {
        this.field_143024_c = tagCompound.func_74762_e("ChunkX");
        this.field_143023_d = tagCompound.func_74762_e("ChunkZ");
        this.field_212688_f = tagCompound.func_74762_e("references");
        Biome biome = this.field_202505_e = tagCompound.func_74764_b("biome") ? IRegistry.field_212624_m.func_212608_b(new ResourceLocation(tagCompound.func_74779_i("biome"))) : worldIn.func_72863_F().func_201711_g().func_202090_b().func_180300_a(new BlockPos((this.field_143024_c << 4) + 9, 0, (this.field_143023_d << 4) + 9), Biomes.field_76772_c);
        if (tagCompound.func_74764_b("BB")) {
            this.field_75074_b = new MutableBoundingBox(tagCompound.func_74759_k("BB"));
        }
        NBTTagList nbttaglist = tagCompound.func_150295_c("Children", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            StructurePiece tmp = StructureIO.func_143032_b((NBTTagCompound)nbttaglist.func_150305_b(i), (IWorld)worldIn);
            if (tmp == null) continue;
            this.field_75075_a.add(tmp);
        }
        this.func_143017_b(tagCompound);
    }

    public void func_143017_b(NBTTagCompound tagCompound) {
    }

    protected void func_75067_a(IWorldReaderBase worldIn, Random rand, int p_75067_3_) {
        int i = worldIn.func_181545_F() - p_75067_3_;
        int j = this.field_75074_b.func_78882_c() + 1;
        if (j < i) {
            j += rand.nextInt(i - j);
        }
        int k = j - this.field_75074_b.field_78894_e;
        this.field_75074_b.func_78886_a(0, k, 0);
        for (StructurePiece structurepiece : this.field_75075_a) {
            structurepiece.func_181138_a(0, k, 0);
        }
    }

    protected void func_75070_a(IBlockReader worldIn, Random rand, int p_75070_3_, int p_75070_4_) {
        int i = p_75070_4_ - p_75070_3_ + 1 - this.field_75074_b.func_78882_c();
        int j = i > 1 ? p_75070_3_ + rand.nextInt(i) : p_75070_3_;
        int k = j - this.field_75074_b.field_78895_b;
        this.field_75074_b.func_78886_a(0, k, 0);
        for (StructurePiece structurepiece : this.field_75075_a) {
            structurepiece.func_181138_a(0, k, 0);
        }
    }

    public boolean func_75069_d() {
        return true;
    }

    public void func_175787_b(ChunkPos pair) {
    }

    public int func_143019_e() {
        return this.field_143024_c;
    }

    public int func_143018_f() {
        return this.field_143023_d;
    }

    public BlockPos func_204294_a() {
        return new BlockPos(this.field_143024_c << 4, 0, this.field_143023_d << 4);
    }

    public boolean func_212687_g() {
        return this.field_212688_f < this.func_212686_i();
    }

    public void func_212685_h() {
        ++this.field_212688_f;
    }

    protected int func_212686_i() {
        return 1;
    }
}

