/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.Scheduler;
import net.minecraft.util.TaskManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkCacheNeighborNotification;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.tasks.ProtoChunkScheduler;
import net.minecraft.world.storage.SessionLockException;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkProviderServer
implements IChunkProvider {
    private static final Logger field_147417_b = LogManager.getLogger();
    private final LongSet field_73248_b = new LongOpenHashSet();
    public final IChunkGenerator<?> field_186029_c;
    public final IChunkLoader field_73247_e;
    public final Long2ObjectMap<Chunk> field_73244_f = Long2ObjectMaps.synchronize((Long2ObjectMap)new ChunkCacheNeighborNotification(8192));
    private Chunk field_212472_f;
    private final ProtoChunkScheduler field_201723_f;
    private final TaskManager<ChunkPos, ChunkStatus, ChunkPrimer> field_201724_g;
    public final WorldServer field_73251_h;
    private final IThreadListener field_212473_j;

    public ChunkProviderServer(WorldServer worldIn, IChunkLoader chunkLoaderIn, IChunkGenerator<?> chunkGeneratorIn, IThreadListener threadListener) {
        this.field_73251_h = worldIn;
        this.field_73247_e = chunkLoaderIn;
        this.field_186029_c = chunkGeneratorIn;
        this.field_212473_j = threadListener;
        this.field_201723_f = new ProtoChunkScheduler(2, worldIn, chunkGeneratorIn, chunkLoaderIn, threadListener);
        this.field_201724_g = new TaskManager((Scheduler)this.field_201723_f);
    }

    public Collection<Chunk> func_189548_a() {
        return this.field_73244_f.values();
    }

    public void func_189549_a(Chunk chunkIn) {
        if (this.field_73251_h.field_73011_w.func_186056_c(chunkIn.field_76635_g, chunkIn.field_76647_h)) {
            this.field_73248_b.add(ChunkPos.func_77272_a((int)chunkIn.field_76635_g, (int)chunkIn.field_76647_h));
        }
    }

    public void func_73240_a() {
        for (Chunk chunk : this.field_73244_f.values()) {
            this.func_189549_a(chunk);
        }
    }

    public void func_212469_a(int p_212469_1_, int p_212469_2_) {
        this.field_73248_b.remove(ChunkPos.func_77272_a((int)p_212469_1_, (int)p_212469_2_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Chunk func_186025_d(int x, int z, boolean p_186025_3_, boolean p_186025_4_) {
        Chunk chunk;
        IChunkLoader iChunkLoader = this.field_73247_e;
        synchronized (iChunkLoader) {
            if (this.field_212472_f != null && this.field_212472_f.func_76632_l().field_77276_a == x && this.field_212472_f.func_76632_l().field_77275_b == z) {
                return this.field_212472_f;
            }
            long i = ChunkPos.func_77272_a((int)x, (int)z);
            chunk = (Chunk)this.field_73244_f.get(i);
            if (chunk != null) {
                this.field_212472_f = chunk;
                return chunk;
            }
            if (p_186025_3_) {
                try {
                    chunk = this.field_73247_e.func_199813_a((IWorld)this.field_73251_h, x, z, p_212471_3_ -> {
                        p_212471_3_.func_177432_b(this.field_73251_h.func_82737_E());
                        this.field_73244_f.put(ChunkPos.func_77272_a((int)x, (int)z), p_212471_3_);
                    });
                }
                catch (Exception exception) {
                    field_147417_b.error("Couldn't load chunk", (Throwable)exception);
                }
            }
        }
        if (chunk != null) {
            this.field_212473_j.func_152344_a(chunk::func_76631_c);
            return chunk;
        }
        if (p_186025_4_) {
            try {
                this.field_201724_g.func_202928_b();
                this.field_201724_g.func_202926_a((Object)new ChunkPos(x, z));
                CompletableFuture completablefuture = this.field_201724_g.func_202927_c();
                return (Chunk)((CompletableFuture)completablefuture.thenApply(this::func_201719_a)).join();
            }
            catch (RuntimeException runtimeexception) {
                throw this.func_201722_a(x, z, runtimeexception);
            }
        }
        return null;
    }

    public IChunk func_201713_d(int x, int z, boolean p_201713_3_) {
        Chunk ichunk = this.func_186025_d(x, z, true, false);
        return ichunk != null ? ichunk : (IChunk)this.field_201723_f.func_212537_b(new ChunkPos(x, z), p_201713_3_);
    }

    public CompletableFuture<ChunkPrimer> func_201720_a(Iterable<ChunkPos> positions, Consumer<Chunk> loadedChunkConsumer) {
        this.field_201724_g.func_202928_b();
        for (ChunkPos chunkpos : positions) {
            Chunk chunk = this.func_186025_d(chunkpos.field_77276_a, chunkpos.field_77275_b, true, false);
            if (chunk != null) {
                loadedChunkConsumer.accept(chunk);
                continue;
            }
            ((CompletableFuture)this.field_201724_g.func_202926_a((Object)chunkpos).thenApply(this::func_201719_a)).thenAccept(loadedChunkConsumer);
        }
        return this.field_201724_g.func_202927_c();
    }

    private ReportedException func_201722_a(int x, int z, Throwable cause) {
        CrashReport crashreport = CrashReport.func_85055_a(cause, "Exception generating new chunk");
        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Chunk to be generated");
        crashreportcategory.func_71507_a("Location", String.format("%d,%d", x, z));
        crashreportcategory.func_71507_a("Position hash", ChunkPos.func_77272_a((int)x, (int)z));
        crashreportcategory.func_71507_a("Generator", this.field_186029_c);
        return new ReportedException(crashreport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chunk func_201719_a(IChunk chunkIn) {
        Chunk chunk;
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        long k = ChunkPos.func_77272_a((int)i, (int)j);
        Long2ObjectMap<Chunk> long2ObjectMap = this.field_73244_f;
        synchronized (long2ObjectMap) {
            Chunk chunk1 = (Chunk)this.field_73244_f.get(k);
            if (chunk1 != null) {
                return chunk1;
            }
            if (chunkIn instanceof Chunk) {
                chunk = (Chunk)chunkIn;
            } else {
                if (!(chunkIn instanceof ChunkPrimer)) {
                    throw new IllegalStateException();
                }
                chunk = new Chunk((World)this.field_73251_h, (ChunkPrimer)chunkIn, i, j);
            }
            this.field_73244_f.put(k, (Object)chunk);
            this.field_212472_f = chunk;
        }
        this.field_212473_j.func_152344_a(chunk::func_76631_c);
        return chunk;
    }

    private void func_73242_b(IChunk chunkIn) {
        try {
            chunkIn.func_177432_b(this.field_73251_h.func_82737_E());
            this.field_73247_e.func_75816_a((World)this.field_73251_h, chunkIn);
        }
        catch (IOException ioexception) {
            field_147417_b.error("Couldn't save chunk", (Throwable)ioexception);
        }
        catch (SessionLockException sessionlockexception) {
            field_147417_b.error("Couldn't save chunk; already in use by another instance of Minecraft?", (Throwable)sessionlockexception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_186027_a(boolean all) {
        int i = 0;
        this.field_201723_f.func_208484_a(() -> true);
        IChunkLoader iChunkLoader = this.field_73247_e;
        synchronized (iChunkLoader) {
            for (Chunk chunk : this.field_73244_f.values()) {
                if (!chunk.func_76601_a(all)) continue;
                this.func_73242_b(chunk);
                chunk.func_177427_f(false);
                if (++i != 24 || all) continue;
                return false;
            }
            return true;
        }
    }

    public void close() {
        try {
            this.field_201724_g.func_202925_a();
        }
        catch (InterruptedException interruptedexception) {
            field_147417_b.error("Couldn't stop taskManager", (Throwable)interruptedexception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_104112_b() {
        IChunkLoader iChunkLoader = this.field_73247_e;
        synchronized (iChunkLoader) {
            this.field_73247_e.func_75818_b();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_73156_b(BooleanSupplier p_73156_1_) {
        if (!this.field_73251_h.field_73058_d) {
            if (!this.field_73248_b.isEmpty()) {
                LongIterator iterator = this.field_73248_b.iterator();
                int i = 0;
                while (iterator.hasNext() && (p_73156_1_.getAsBoolean() || i < 200 || this.field_73248_b.size() > 2000)) {
                    Long olong = (Long)iterator.next();
                    IChunkLoader iChunkLoader = this.field_73247_e;
                    synchronized (iChunkLoader) {
                        Chunk chunk = (Chunk)this.field_73244_f.get((Object)olong);
                        if (chunk != null) {
                            chunk.func_76623_d();
                            this.func_73242_b(chunk);
                            this.field_73244_f.remove((Object)olong);
                            this.field_212472_f = null;
                            ++i;
                        }
                    }
                    iterator.remove();
                }
            }
            this.field_201723_f.func_208484_a(p_73156_1_);
        }
        if (this.field_73244_f.isEmpty()) {
            DimensionManager.unloadWorld((WorldServer)this.field_73251_h);
        }
        return false;
    }

    public boolean func_73157_c() {
        return !this.field_73251_h.field_73058_d;
    }

    public String func_73148_d() {
        return "ServerChunkCache: " + this.field_73244_f.size() + " Drop: " + this.field_73248_b.size();
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.field_186029_c.func_177458_a(creatureType, pos);
    }

    public int func_203082_a(World worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        return this.field_186029_c.func_203222_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
    }

    @Nullable
    public BlockPos func_211268_a(World worldIn, String name, BlockPos pos, int radius, boolean p_211268_5_) {
        return this.field_186029_c.func_211403_a(worldIn, name, pos, radius, p_211268_5_);
    }

    public IChunkGenerator<?> func_201711_g() {
        return this.field_186029_c;
    }

    public int func_73152_e() {
        return this.field_73244_f.size();
    }

    public boolean func_73149_a(int x, int z) {
        return this.field_73244_f.containsKey(ChunkPos.func_77272_a((int)x, (int)z));
    }
}

