/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.AbstractChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NetherGenSettings;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.eventbus.api.Event;

public class ChunkGeneratorNether
extends AbstractChunkGenerator<NetherGenSettings> {
    protected static final IBlockState field_185940_a = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState field_185941_b = Blocks.field_150424_aL.func_176223_P();
    protected static final IBlockState field_185943_d = Blocks.field_150353_l.func_176223_P();
    private NoiseGeneratorOctaves field_185957_u;
    private NoiseGeneratorOctaves field_185958_v;
    private NoiseGeneratorOctaves field_185959_w;
    private NoiseGeneratorOctaves field_73177_m;
    private NoiseGeneratorOctaves field_185946_g;
    private NoiseGeneratorOctaves field_185947_h;
    private final NetherGenSettings field_202107_q;
    private final IBlockState field_205474_p;
    private final IBlockState field_205604_n;

    public ChunkGeneratorNether(World p_i48694_1_, BiomeProvider p_i48694_2_, NetherGenSettings p_i48694_3_) {
        super(p_i48694_1_, p_i48694_2_);
        this.field_202107_q = p_i48694_3_;
        this.field_205474_p = this.field_202107_q.func_205532_l();
        this.field_205604_n = this.field_202107_q.func_205533_m();
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom(this.field_202096_b);
        this.field_185957_u = new NoiseGeneratorOctaves((Random)sharedseedrandom, 16);
        this.field_185958_v = new NoiseGeneratorOctaves((Random)sharedseedrandom, 16);
        this.field_185959_w = new NoiseGeneratorOctaves((Random)sharedseedrandom, 8);
        sharedseedrandom.func_202423_a(1048);
        this.field_73177_m = new NoiseGeneratorOctaves((Random)sharedseedrandom, 4);
        this.field_185946_g = new NoiseGeneratorOctaves((Random)sharedseedrandom, 10);
        this.field_185947_h = new NoiseGeneratorOctaves((Random)sharedseedrandom, 16);
        p_i48694_1_.func_181544_b(63);
        InitNoiseGensEvent.ContextHell ctx = new InitNoiseGensEvent.ContextHell(this.field_185957_u, this.field_185958_v, this.field_185959_w, this.field_73177_m, this.field_185946_g, this.field_185947_h);
        ctx = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((IWorld)p_i48694_1_, (Random)sharedseedrandom, (InitNoiseGensEvent.Context)ctx);
        this.field_185957_u = ctx.getLPerlin1();
        this.field_185958_v = ctx.getLPerlin2();
        this.field_185959_w = ctx.getPerlin();
        this.field_73177_m = ctx.getPerlin2();
        this.field_185946_g = ctx.getScale();
        this.field_185947_h = ctx.getDepth();
    }

    public void func_185936_a(int p_185936_1_, int p_185936_2_, IChunk primer) {
        int i = 4;
        int j = this.field_202095_a.func_181545_F() / 2 + 1;
        int k = 5;
        int l = 17;
        int i1 = 5;
        double[] adouble = this.func_202104_a(p_185936_1_ * 4, 0, p_185936_2_ * 4, 5, 17, 5);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 0; j1 < 4; ++j1) {
            for (int k1 = 0; k1 < 4; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    double d0 = 0.125;
                    double d1 = adouble[((j1 + 0) * 5 + k1 + 0) * 17 + l1 + 0];
                    double d2 = adouble[((j1 + 0) * 5 + k1 + 1) * 17 + l1 + 0];
                    double d3 = adouble[((j1 + 1) * 5 + k1 + 0) * 17 + l1 + 0];
                    double d4 = adouble[((j1 + 1) * 5 + k1 + 1) * 17 + l1 + 0];
                    double d5 = (adouble[((j1 + 0) * 5 + k1 + 0) * 17 + l1 + 1] - d1) * 0.125;
                    double d6 = (adouble[((j1 + 0) * 5 + k1 + 1) * 17 + l1 + 1] - d2) * 0.125;
                    double d7 = (adouble[((j1 + 1) * 5 + k1 + 0) * 17 + l1 + 1] - d3) * 0.125;
                    double d8 = (adouble[((j1 + 1) * 5 + k1 + 1) * 17 + l1 + 1] - d4) * 0.125;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int j2 = 0; j2 < 4; ++j2) {
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.25;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState iblockstate = field_185940_a;
                                if (l1 * 8 + i2 < j) {
                                    iblockstate = this.field_205604_n;
                                }
                                if (d15 > 0.0) {
                                    iblockstate = this.field_205474_p;
                                }
                                int l2 = j2 + j1 * 4;
                                int i3 = i2 + l1 * 8;
                                int j3 = k2 + k1 * 4;
                                primer.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(l2, i3, j3), iblockstate, false);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    @Override
    protected void func_205472_a(IChunk chunkIn, Random random) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = chunkIn.func_76632_l().func_180334_c();
        int j = chunkIn.func_76632_l().func_180333_d();
        for (BlockPos blockpos : BlockPos.func_191532_a((int)i, (int)0, (int)j, (int)(i + 16), (int)0, (int)(j + 16))) {
            for (int k = 127; k > 122; --k) {
                if (k < 127 - random.nextInt(5)) continue;
                chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), k, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
            for (int l = 4; l >= 0; --l) {
                if (l > random.nextInt(5)) continue;
                chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), l, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    @Override
    public double[] func_205473_a(int x, int z) {
        double d0 = 0.03125;
        return this.field_73177_m.func_202647_a(x << 4, z << 4, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
    }

    public void func_202088_a(IChunk chunkIn) {
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        Biome[] abiome = this.field_202097_c.func_201539_b(i * 16, j * 16, 16, 16);
        chunkIn.func_201577_a(abiome);
        this.func_185936_a(i, j, chunkIn);
        this.func_205471_a(chunkIn, abiome, sharedseedrandom, this.field_202095_a.func_181545_F());
        this.func_205472_a(chunkIn, (Random)sharedseedrandom);
        chunkIn.func_201588_a(Heightmap.Type.WORLD_SURFACE_WG, Heightmap.Type.OCEAN_FLOOR_WG);
        chunkIn.func_201574_a(ChunkStatus.BASE);
    }

    private double[] func_202104_a(int p_202104_1_, int p_202104_2_, int p_202104_3_, int p_202104_4_, int p_202104_5_, int p_202104_6_) {
        double[] adouble = new double[p_202104_4_ * p_202104_5_ * p_202104_6_];
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, adouble, p_202104_1_, p_202104_2_, p_202104_3_, p_202104_4_, p_202104_5_, p_202104_6_);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.field_185946_g.func_202647_a(p_202104_1_, p_202104_2_, p_202104_3_, p_202104_4_, 1, p_202104_6_, 1.0, 0.0, 1.0);
        this.field_185947_h.func_202647_a(p_202104_1_, p_202104_2_, p_202104_3_, p_202104_4_, 1, p_202104_6_, 100.0, 0.0, 100.0);
        double[] adouble1 = this.field_185959_w.func_202647_a(p_202104_1_, p_202104_2_, p_202104_3_, p_202104_4_, p_202104_5_, p_202104_6_, 8.555150000000001, 34.2206, 8.555150000000001);
        double[] adouble2 = this.field_185957_u.func_202647_a(p_202104_1_, p_202104_2_, p_202104_3_, p_202104_4_, p_202104_5_, p_202104_6_, 684.412, 2053.236, 684.412);
        double[] adouble3 = this.field_185958_v.func_202647_a(p_202104_1_, p_202104_2_, p_202104_3_, p_202104_4_, p_202104_5_, p_202104_6_, 684.412, 2053.236, 684.412);
        double[] adouble4 = new double[p_202104_5_];
        for (int i = 0; i < p_202104_5_; ++i) {
            adouble4[i] = Math.cos((double)i * Math.PI * 6.0 / (double)p_202104_5_) * 2.0;
            double d2 = i;
            if (i > p_202104_5_ / 2) {
                d2 = p_202104_5_ - 1 - i;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = i;
            adouble4[n] = adouble4[n] - d2 * d2 * d2 * 10.0;
        }
        int l = 0;
        for (int i1 = 0; i1 < p_202104_4_; ++i1) {
            for (int j = 0; j < p_202104_6_; ++j) {
                double d3 = 0.0;
                for (int k = 0; k < p_202104_5_; ++k) {
                    double d4 = adouble4[k];
                    double d5 = adouble2[l] / 512.0;
                    double d6 = adouble3[l] / 512.0;
                    double d7 = (adouble1[l] / 10.0 + 1.0) / 2.0;
                    double d8 = d7 < 0.0 ? d5 : (d7 > 1.0 ? d6 : d5 + (d6 - d5) * d7);
                    d8 -= d4;
                    if (k > p_202104_5_ - 4) {
                        double d9 = (float)(k - (p_202104_5_ - 4)) / 3.0f;
                        d8 = d8 * (1.0 - d9) - 10.0 * d9;
                    }
                    if ((double)k < 0.0) {
                        double d10 = (0.0 - (double)k) / 4.0;
                        d10 = MathHelper.func_151237_a((double)d10, (double)0.0, (double)1.0);
                        d8 = d8 * (1.0 - d10) - 10.0 * d10;
                    }
                    adouble[l] = d8;
                    ++l;
                }
            }
        }
        return adouble;
    }

    public void func_202093_c(WorldGenRegion region) {
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (creatureType == EnumCreatureType.MONSTER) {
            if (Feature.field_202337_o.func_202366_b(this.field_202095_a, pos)) {
                return Feature.field_202337_o.func_202279_e();
            }
            if (Feature.field_202337_o.func_175796_a(this.field_202095_a, pos) && this.field_202095_a.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196653_dH) {
                return Feature.field_202337_o.func_202279_e();
            }
        }
        Biome biome = this.field_202095_a.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    public int func_203222_a(World worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        return 0;
    }

    @Override
    public NetherGenSettings func_201496_a_() {
        return this.field_202107_q;
    }

    public int func_205470_d() {
        return this.field_202095_a.func_181545_F() + 1;
    }

    @Override
    public int func_207511_e() {
        return 128;
    }
}

