/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.init.Blocks;
import net.minecraft.util.ExpiringMap;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.WorldCarverWrapper;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractChunkGenerator<C extends IChunkGenSettings>
implements IChunkGenerator<C> {
    protected final IWorld field_202095_a;
    protected final long field_202096_b;
    protected final BiomeProvider field_202097_c;
    protected final Map<Structure<? extends IFeatureConfig>, Long2ObjectMap<StructureStart>> field_203227_d = Maps.newHashMap();
    protected final Map<Structure<? extends IFeatureConfig>, Long2ObjectMap<LongSet>> field_203228_e = Maps.newHashMap();

    public AbstractChunkGenerator(IWorld worldIn, BiomeProvider biomeProviderIn) {
        this.field_202095_a = worldIn;
        this.field_202096_b = worldIn.func_72905_C();
        this.field_202097_c = biomeProviderIn;
    }

    public void func_202091_a(WorldGenRegion region, GenerationStage.Carving carvingStage) {
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom(this.field_202096_b);
        int i = 8;
        int j = region.func_201679_a();
        int k = region.func_201680_b();
        BitSet bitset = region.func_72964_e(j, k).func_205749_a(carvingStage);
        for (int l = j - 8; l <= j + 8; ++l) {
            for (int i1 = k - 8; i1 <= k + 8; ++i1) {
                List<WorldCarverWrapper<?>> list = region.func_72863_F().func_201711_g().func_202090_b().func_180300_a(new BlockPos(l * 16, 0, i1 * 16), (Biome)null).func_203603_a(carvingStage);
                ListIterator<WorldCarverWrapper<?>> listiterator = list.listIterator();
                while (listiterator.hasNext()) {
                    int j1 = listiterator.nextIndex();
                    WorldCarverWrapper<?> worldcarverwrapper = listiterator.next();
                    sharedseedrandom.func_202425_c(region.func_201672_e().func_72905_C() + (long)j1, l, i1);
                    if (!worldcarverwrapper.func_212246_a((IBlockReader)region, (Random)sharedseedrandom, l, i1, IFeatureConfig.field_202429_e)) continue;
                    worldcarverwrapper.func_202522_a((IWorld)region, (Random)sharedseedrandom, l, i1, j, k, bitset, IFeatureConfig.field_202429_e);
                }
            }
        }
    }

    @Nullable
    public BlockPos func_211403_a(World worldIn, String name, BlockPos pos, int radius, boolean p_211403_5_) {
        Structure<?> structure = Feature.field_202300_at.get(name.toLowerCase(Locale.ROOT));
        return structure != null ? structure.func_211405_a(worldIn, (IChunkGenerator)this, pos, radius, p_211403_5_) : null;
    }

    protected void func_205472_a(IChunk chunkIn, Random random) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = chunkIn.func_76632_l().func_180334_c();
        int j = chunkIn.func_76632_l().func_180333_d();
        for (BlockPos blockpos : BlockPos.func_191532_a((int)i, (int)0, (int)j, (int)(i + 16), (int)0, (int)(j + 16))) {
            for (int k = 4; k >= 0; --k) {
                if (k > random.nextInt(5)) continue;
                chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), k, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    public void func_202092_b(WorldGenRegion region) {
        BlockFalling.field_149832_M = true;
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        int k = i * 16;
        int l = j * 16;
        BlockPos blockpos = new BlockPos(k, 0, l);
        Biome biome = region.func_72964_e(i + 1, j + 1).func_201590_e()[0];
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        long i1 = sharedseedrandom.func_202424_a(region.func_72905_C(), k, l);
        for (GenerationStage.Decoration generationstage$decoration : GenerationStage.Decoration.values()) {
            biome.func_203608_a(generationstage$decoration, this, region, i1, sharedseedrandom, blockpos);
        }
        BlockFalling.field_149832_M = false;
    }

    public void func_205471_a(IChunk chunkIn, Biome[] biomesIn, SharedSeedRandom random, int seaLevel) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (IChunk)chunkIn, (IWorld)this.field_202095_a)) {
            return;
        }
        double d0 = 0.03125;
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int i = chunkpos.func_180334_c();
        int j = chunkpos.func_180333_d();
        double[] adouble = this.func_205473_a(chunkpos.field_77276_a, chunkpos.field_77275_b);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int i1 = i + k;
                int j1 = j + l;
                int k1 = chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, k, l) + 1;
                biomesIn[l * 16 + k].func_206854_a((Random)random, chunkIn, i1, j1, k1, adouble[l * 16 + k], this.func_201496_a_().func_205532_l(), this.func_201496_a_().func_205533_m(), seaLevel, this.field_202095_a.func_72905_C());
            }
        }
    }

    public abstract C func_201496_a_();

    public abstract double[] func_205473_a(int var1, int var2);

    public boolean func_202094_a(Biome biomeIn, Structure<? extends IFeatureConfig> structureIn) {
        return biomeIn.func_201858_a(structureIn);
    }

    @Nullable
    public IFeatureConfig func_202087_b(Biome biomeIn, Structure<? extends IFeatureConfig> structureIn) {
        return biomeIn.func_201857_b(structureIn);
    }

    public BiomeProvider func_202090_b() {
        return this.field_202097_c;
    }

    public long func_202089_c() {
        return this.field_202096_b;
    }

    public Long2ObjectMap<StructureStart> func_203224_a(Structure<? extends IFeatureConfig> structureIn) {
        return this.field_203227_d.computeIfAbsent(structureIn, p_203225_0_ -> Long2ObjectMaps.synchronize((Long2ObjectMap)new ExpiringMap(8192, 10000)));
    }

    public Long2ObjectMap<LongSet> func_203223_b(Structure<? extends IFeatureConfig> structureIn) {
        return this.field_203228_e.computeIfAbsent(structureIn, p_203226_0_ -> Long2ObjectMaps.synchronize((Long2ObjectMap)new ExpiringMap(8192, 10000)));
    }

    public int func_207511_e() {
        return 256;
    }
}

