/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class Explosion {
    private final boolean field_77286_a;
    private final boolean field_82755_b;
    private final Random field_77290_i = new Random();
    private final World field_77287_j;
    private final double field_77284_b;
    private final double field_77285_c;
    private final double field_77282_d;
    private final Entity field_77283_e;
    private final float field_77280_f;
    private DamageSource field_199593_j;
    private final List<BlockPos> field_77281_g = Lists.newArrayList();
    private final Map<EntityPlayer, Vec3d> field_77288_k = Maps.newHashMap();
    private final Vec3d position;

    @OnlyIn(value=Dist.CLIENT)
    public Explosion(World worldIn, @Nullable Entity entityIn, double x, double y, double z, float size, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, x, y, z, size, false, true, affectedPositions);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Explosion(World worldIn, @Nullable Entity entityIn, double x, double y, double z, float size, boolean causesFire, boolean damagesTerrain, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, x, y, z, size, causesFire, damagesTerrain);
        this.field_77281_g.addAll(affectedPositions);
    }

    public Explosion(World worldIn, @Nullable Entity entityIn, double x, double y, double z, float size, boolean causesFire, boolean damagesTerrain) {
        this.field_77287_j = worldIn;
        this.field_77283_e = entityIn;
        this.field_77280_f = size;
        this.field_77284_b = x;
        this.field_77285_c = y;
        this.field_77282_d = z;
        this.field_77286_a = causesFire;
        this.field_82755_b = damagesTerrain;
        this.field_199593_j = DamageSource.func_94539_a((Explosion)this);
        this.position = new Vec3d(this.field_77284_b, this.field_77285_c, this.field_77282_d);
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.field_77284_b;
                    double d6 = this.field_77285_c;
                    double d8 = this.field_77282_d;
                    float f1 = 0.3f;
                    for (float f = this.field_77280_f * (0.7f + this.field_77287_j.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        IBlockState iblockstate = this.field_77287_j.func_180495_p(blockpos);
                        IFluidState ifluidstate = this.field_77287_j.func_204610_c(blockpos);
                        if (!iblockstate.isAir((IBlockReader)this.field_77287_j, blockpos) || !ifluidstate.func_206888_e()) {
                            float f2 = Math.max(iblockstate.getExplosionResistance(this.field_77287_j, blockpos, this.field_77283_e, this), ifluidstate.getExplosionResistance(this.field_77287_j, blockpos, this.field_77283_e, this));
                            if (this.field_77283_e != null) {
                                f2 = this.field_77283_e.func_180428_a(this, (IBlockReader)this.field_77287_j, blockpos, iblockstate, ifluidstate, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_174816_a(this, (IBlockReader)this.field_77287_j, blockpos, iblockstate, f))) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.field_77281_g.addAll(set);
        float f3 = this.field_77280_f * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.field_77284_b - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.field_77284_b + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.field_77285_c - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.field_77285_c + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.field_77282_d - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.field_77282_d + (double)f3 + 1.0));
        List list = this.field_77287_j.func_72839_b(this.field_77283_e, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.field_77287_j, (Explosion)this, (List)list, (double)f3);
        Vec3d vec3d = new Vec3d(this.field_77284_b, this.field_77285_c, this.field_77282_d);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            EntityPlayer entityplayer;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)((Object)list.get(k2));
            if (entity.func_180427_aV() || !((d12 = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)f3) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.field_77284_b) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * d7 + (d9 = entity.field_70161_v - this.field_77282_d) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = this.field_77287_j.func_72842_a(vec3d, entity.func_174813_aQ());
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a(this.func_199591_b(), (int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0));
            double d11 = d10;
            if (entity instanceof EntityLivingBase) {
                d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
            }
            entity.field_70159_w += d5 * d11;
            entity.field_70181_x += d7 * d11;
            entity.field_70179_y += d9 * d11;
            if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
            this.field_77288_k.put(entityplayer, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        this.field_77287_j.func_184148_a(null, this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (!(this.field_77280_f < 2.0f) && this.field_82755_b) {
            this.field_77287_j.func_195594_a((IParticleData)Particles.field_197626_s, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
        } else {
            this.field_77287_j.func_195594_a((IParticleData)Particles.field_197627_t, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
        }
        if (this.field_82755_b) {
            for (BlockPos blockpos : this.field_77281_g) {
                IBlockState iblockstate = this.field_77287_j.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (spawnParticles) {
                    double d0 = (float)blockpos.func_177958_n() + this.field_77287_j.field_73012_v.nextFloat();
                    double d1 = (float)blockpos.func_177956_o() + this.field_77287_j.field_73012_v.nextFloat();
                    double d2 = (float)blockpos.func_177952_p() + this.field_77287_j.field_73012_v.nextFloat();
                    double d3 = d0 - this.field_77284_b;
                    double d4 = d1 - this.field_77285_c;
                    double d5 = d2 - this.field_77282_d;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.field_77280_f + 0.1);
                    this.field_77287_j.func_195594_a((IParticleData)Particles.field_197598_I, (d0 + this.field_77284_b) / 2.0, (d1 + this.field_77285_c) / 2.0, (d2 + this.field_77282_d) / 2.0, d3 *= (d7 *= (double)(this.field_77287_j.field_73012_v.nextFloat() * this.field_77287_j.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                    this.field_77287_j.func_195594_a((IParticleData)Particles.field_197601_L, d0, d1, d2, d3, d4, d5);
                }
                if (iblockstate.isAir((IBlockReader)this.field_77287_j, blockpos)) continue;
                if (block.func_149659_a(this)) {
                    iblockstate.func_196941_a(this.field_77287_j, blockpos, 1.0f / this.field_77280_f, 0);
                }
                iblockstate.onBlockExploded(this.field_77287_j, blockpos, this);
            }
        }
        if (this.field_77286_a) {
            for (BlockPos blockpos1 : this.field_77281_g) {
                if (!this.field_77287_j.func_180495_p(blockpos1).isAir((IBlockReader)this.field_77287_j, blockpos1) || !this.field_77287_j.func_180495_p(blockpos1.func_177977_b()).func_200015_d((IBlockReader)this.field_77287_j, blockpos1.func_177977_b()) || this.field_77290_i.nextInt(3) != 0) continue;
                this.field_77287_j.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    public DamageSource func_199591_b() {
        return this.field_199593_j;
    }

    public void func_199592_a(DamageSource damageSourceIn) {
        this.field_199593_j = damageSourceIn;
    }

    public Map<EntityPlayer, Vec3d> func_77277_b() {
        return this.field_77288_k;
    }

    @Nullable
    public EntityLivingBase func_94613_c() {
        if (this.field_77283_e == null) {
            return null;
        }
        if (this.field_77283_e instanceof EntityTNTPrimed) {
            return ((EntityTNTPrimed)this.field_77283_e).func_94083_c();
        }
        return this.field_77283_e instanceof EntityLivingBase ? (EntityLivingBase)this.field_77283_e : null;
    }

    public void func_180342_d() {
        this.field_77281_g.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.field_77281_g;
    }

    public Vec3d getPosition() {
        return this.position;
    }
}

