/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.storage.WorldSavedData;

public class VillageCollection
extends WorldSavedData {
    private World field_75556_a;
    private final List<BlockPos> field_75554_b = Lists.newArrayList();
    private final List<VillageDoorInfo> field_75555_c = Lists.newArrayList();
    private final List<Village> field_75552_d = Lists.newArrayList();
    private int field_75553_e;

    public VillageCollection(String name) {
        super(name);
    }

    public VillageCollection(World worldIn) {
        super(VillageCollection.func_176062_a(worldIn.field_73011_w));
        this.field_75556_a = worldIn;
        this.func_76185_a();
    }

    public void func_82566_a(World worldIn) {
        this.field_75556_a = worldIn;
        for (Village village : this.field_75552_d) {
            village.func_82691_a(worldIn);
        }
    }

    public void func_176060_a(BlockPos pos) {
        if (this.field_75554_b.size() <= 64 && !this.func_176057_e(pos)) {
            this.field_75554_b.add(pos);
        }
    }

    public void func_75544_a() {
        ++this.field_75553_e;
        for (Village village : this.field_75552_d) {
            village.func_75560_a(this.field_75553_e);
        }
        this.func_75549_c();
        this.func_75543_d();
        this.func_75545_e();
        if (this.field_75553_e % 400 == 0) {
            this.func_76185_a();
        }
    }

    private void func_75549_c() {
        Iterator<Village> iterator = this.field_75552_d.iterator();
        while (iterator.hasNext()) {
            Village village = iterator.next();
            if (!village.func_75566_g()) continue;
            iterator.remove();
            this.func_76185_a();
        }
    }

    public List<Village> func_75540_b() {
        return this.field_75552_d;
    }

    public Village func_176056_a(BlockPos doorBlock, int radius) {
        Village village = null;
        double d0 = 3.4028234663852886E38;
        for (Village village1 : this.field_75552_d) {
            float f;
            double d1 = village1.func_180608_a().func_177951_i((Vec3i)doorBlock);
            if (d1 >= d0 || d1 > (double)((f = (float)(radius + village1.func_75568_b())) * f)) continue;
            village = village1;
            d0 = d1;
        }
        return village;
    }

    private void func_75543_d() {
        if (!this.field_75554_b.isEmpty()) {
            this.func_180609_b(this.field_75554_b.remove(0));
        }
    }

    private void func_75545_e() {
        for (int i = 0; i < this.field_75555_c.size(); ++i) {
            VillageDoorInfo villagedoorinfo = this.field_75555_c.get(i);
            Village village = this.func_176056_a(villagedoorinfo.func_179852_d(), 32);
            if (village == null) {
                village = new Village(this.field_75556_a);
                this.field_75552_d.add(village);
                this.func_76185_a();
            }
            village.func_75576_a(villagedoorinfo);
        }
        this.field_75555_c.clear();
    }

    private void func_180609_b(BlockPos central) {
        if (!this.field_75556_a.func_205050_e(central, 16)) {
            return;
        }
        int i = 16;
        int j = 4;
        int k = 16;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = -16; l < 16; ++l) {
            for (int i1 = -4; i1 < 4; ++i1) {
                for (int j1 = -16; j1 < 16; ++j1) {
                    blockpos$mutableblockpos.func_189533_g((Vec3i)central).func_196234_d(l, i1, j1);
                    IBlockState iblockstate = this.field_75556_a.func_180495_p((BlockPos)blockpos$mutableblockpos);
                    if (!this.func_195928_a(iblockstate)) continue;
                    VillageDoorInfo villagedoorinfo = this.func_176055_c((BlockPos)blockpos$mutableblockpos);
                    if (villagedoorinfo == null) {
                        this.func_195927_a(iblockstate, (BlockPos)blockpos$mutableblockpos);
                        continue;
                    }
                    villagedoorinfo.func_179849_a(this.field_75553_e);
                }
            }
        }
    }

    @Nullable
    private VillageDoorInfo func_176055_c(BlockPos doorBlock) {
        for (VillageDoorInfo villagedoorinfo : this.field_75555_c) {
            if (villagedoorinfo.func_179852_d().func_177958_n() != doorBlock.func_177958_n() || villagedoorinfo.func_179852_d().func_177952_p() != doorBlock.func_177952_p() || Math.abs(villagedoorinfo.func_179852_d().func_177956_o() - doorBlock.func_177956_o()) > 1) continue;
            return villagedoorinfo;
        }
        for (Village village : this.field_75552_d) {
            VillageDoorInfo villagedoorinfo1 = village.func_179864_e(doorBlock);
            if (villagedoorinfo1 == null) continue;
            return villagedoorinfo1;
        }
        return null;
    }

    private void func_195927_a(IBlockState p_195927_1_, BlockPos p_195927_2_) {
        int j;
        EnumFacing enumfacing = (EnumFacing)((Object)p_195927_1_.func_177229_b((IProperty)BlockDoor.field_176520_a));
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        int i = this.func_176061_a(p_195927_2_, enumfacing, 5);
        if (i != (j = this.func_176061_a(p_195927_2_, enumfacing1, i + 1))) {
            this.field_75555_c.add(new VillageDoorInfo(p_195927_2_, i < j ? enumfacing : enumfacing1, this.field_75553_e));
        }
    }

    private int func_176061_a(BlockPos centerPos, EnumFacing direction, int limitation) {
        int i = 0;
        for (int j = 1; j <= 5; ++j) {
            if (!this.field_75556_a.func_175678_i(centerPos.func_177967_a(direction, j)) || ++i < limitation) continue;
            return i;
        }
        return i;
    }

    private boolean func_176057_e(BlockPos pos) {
        for (BlockPos blockpos : this.field_75554_b) {
            if (!blockpos.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    private boolean func_195928_a(IBlockState p_195928_1_) {
        return p_195928_1_.func_177230_c() instanceof BlockDoor && p_195928_1_.func_185904_a() == Material.field_151575_d;
    }

    @Override
    public void func_76184_a(NBTTagCompound nbt) {
        this.field_75553_e = nbt.func_74762_e("Tick");
        NBTTagList nbttaglist = nbt.func_150295_c("Villages", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            Village village = new Village();
            village.func_82690_a(nbttagcompound);
            this.field_75552_d.add(village);
        }
    }

    @Override
    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("Tick", this.field_75553_e);
        NBTTagList nbttaglist = new NBTTagList();
        for (Village village : this.field_75552_d) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            village.func_82689_b(nbttagcompound);
            nbttaglist.add((INBTBase)nbttagcompound);
        }
        compound.func_74782_a("Villages", (INBTBase)nbttaglist);
        return compound;
    }

    public static String func_176062_a(Dimension provider) {
        return "villages" + provider.func_186058_p().func_186067_c();
    }
}

