/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeVillage;

public class Village
extends CapabilityProvider<Village>
implements IForgeVillage {
    private World field_75586_a;
    private final List<VillageDoorInfo> field_75584_b = Lists.newArrayList();
    private BlockPos field_75585_c = BlockPos.field_177992_a;
    private BlockPos field_75582_d = BlockPos.field_177992_a;
    private int field_75583_e;
    private int field_75580_f;
    private int field_75581_g;
    private int field_75588_h;
    private int field_82694_i;
    private final Map<UUID, Integer> field_82693_j = Maps.newHashMap();
    private final List<VillageAggressor> field_75589_i = Lists.newArrayList();
    private int field_75587_j;

    public Village() {
        this(null);
    }

    public Village(World worldIn) {
        super(Village.class);
        this.field_75586_a = worldIn;
        this.gatherCapabilities();
    }

    public void func_82691_a(World worldIn) {
        this.field_75586_a = worldIn;
    }

    public void func_75560_a(int tickCounterIn) {
        Entity entity;
        int i;
        this.field_75581_g = tickCounterIn;
        this.func_75557_k();
        this.func_75565_j();
        if (tickCounterIn % 20 == 0) {
            this.func_75572_i();
        }
        if (tickCounterIn % 30 == 0) {
            this.func_75579_h();
        }
        if (this.field_75587_j < (i = this.field_75588_h / 10) && this.field_75584_b.size() > 20 && this.field_75586_a.field_73012_v.nextInt(7000) == 0 && (entity = this.func_208059_f(this.field_75582_d)) != null) {
            ++this.field_75587_j;
        }
    }

    @Nullable
    private Entity func_208059_f(BlockPos p_208059_1_) {
        for (int i = 0; i < 10; ++i) {
            EntityIronGolem entityirongolem;
            BlockPos blockpos = p_208059_1_.func_177982_a(this.field_75586_a.field_73012_v.nextInt(16) - 8, this.field_75586_a.field_73012_v.nextInt(6) - 3, this.field_75586_a.field_73012_v.nextInt(16) - 8);
            if (!this.func_179866_a(blockpos) || (entityirongolem = EntityType.field_200757_aw.func_210761_b(this.field_75586_a, null, null, null, blockpos, false, false)) == null) continue;
            if (entityirongolem.func_205020_a(this.field_75586_a, false) && entityirongolem.func_205019_a(this.field_75586_a)) {
                this.field_75586_a.func_72838_d((Entity)((Object)entityirongolem));
                return entityirongolem;
            }
            entityirongolem.func_70106_y();
        }
        return null;
    }

    private void func_75579_h() {
        List<EntityIronGolem> list = this.field_75586_a.func_72872_a(EntityIronGolem.class, new AxisAlignedBB((double)(this.field_75582_d.func_177958_n() - this.field_75583_e), (double)(this.field_75582_d.func_177956_o() - 4), (double)(this.field_75582_d.func_177952_p() - this.field_75583_e), (double)(this.field_75582_d.func_177958_n() + this.field_75583_e), (double)(this.field_75582_d.func_177956_o() + 4), (double)(this.field_75582_d.func_177952_p() + this.field_75583_e)));
        this.field_75587_j = list.size();
    }

    private void func_75572_i() {
        List<EntityVillager> list = this.field_75586_a.func_72872_a(EntityVillager.class, new AxisAlignedBB((double)(this.field_75582_d.func_177958_n() - this.field_75583_e), (double)(this.field_75582_d.func_177956_o() - 4), (double)(this.field_75582_d.func_177952_p() - this.field_75583_e), (double)(this.field_75582_d.func_177958_n() + this.field_75583_e), (double)(this.field_75582_d.func_177956_o() + 4), (double)(this.field_75582_d.func_177952_p() + this.field_75583_e)));
        this.field_75588_h = list.size();
        if (this.field_75588_h == 0) {
            this.field_82693_j.clear();
        }
    }

    public BlockPos func_180608_a() {
        return this.field_75582_d;
    }

    public int func_75568_b() {
        return this.field_75583_e;
    }

    public int func_75567_c() {
        return this.field_75584_b.size();
    }

    public int func_75561_d() {
        return this.field_75581_g - this.field_75580_f;
    }

    public int func_75562_e() {
        return this.field_75588_h;
    }

    public boolean func_179866_a(BlockPos pos) {
        return this.field_75582_d.func_177951_i((Vec3i)pos) < (double)(this.field_75583_e * this.field_75583_e);
    }

    public List<VillageDoorInfo> func_75558_f() {
        return this.field_75584_b;
    }

    public VillageDoorInfo func_179865_b(BlockPos pos) {
        VillageDoorInfo villagedoorinfo = null;
        int i = Integer.MAX_VALUE;
        for (VillageDoorInfo villagedoorinfo1 : this.field_75584_b) {
            int j = villagedoorinfo1.func_179848_a(pos);
            if (j >= i) continue;
            villagedoorinfo = villagedoorinfo1;
            i = j;
        }
        return villagedoorinfo;
    }

    public VillageDoorInfo func_179863_c(BlockPos pos) {
        VillageDoorInfo villagedoorinfo = null;
        int i = Integer.MAX_VALUE;
        for (VillageDoorInfo villagedoorinfo1 : this.field_75584_b) {
            EnumFacing enumfacing;
            BlockPos blockpos;
            int j = villagedoorinfo1.func_179848_a(pos);
            j = j > 256 ? (j *= 1000) : villagedoorinfo1.func_75468_f();
            if (j >= i || !this.field_75586_a.func_180495_p((blockpos = villagedoorinfo1.func_179852_d()).func_177967_a(enumfacing = villagedoorinfo1.func_188567_j(), 1)).func_196957_g((IBlockReader)this.field_75586_a, blockpos.func_177967_a(enumfacing, 1), PathType.LAND) || !this.field_75586_a.func_180495_p(blockpos.func_177967_a(enumfacing, -1)).func_196957_g((IBlockReader)this.field_75586_a, blockpos.func_177967_a(enumfacing, -1), PathType.LAND) || !this.field_75586_a.func_180495_p(blockpos.func_177984_a().func_177967_a(enumfacing, 1)).func_196957_g((IBlockReader)this.field_75586_a, blockpos.func_177984_a().func_177967_a(enumfacing, 1), PathType.LAND) || !this.field_75586_a.func_180495_p(blockpos.func_177984_a().func_177967_a(enumfacing, -1)).func_196957_g((IBlockReader)this.field_75586_a, blockpos.func_177984_a().func_177967_a(enumfacing, -1), PathType.LAND)) continue;
            villagedoorinfo = villagedoorinfo1;
            i = j;
        }
        return villagedoorinfo;
    }

    @Nullable
    public VillageDoorInfo func_179864_e(BlockPos doorBlock) {
        if (this.field_75582_d.func_177951_i((Vec3i)doorBlock) > (double)(this.field_75583_e * this.field_75583_e)) {
            return null;
        }
        for (VillageDoorInfo villagedoorinfo : this.field_75584_b) {
            if (villagedoorinfo.func_179852_d().func_177958_n() != doorBlock.func_177958_n() || villagedoorinfo.func_179852_d().func_177952_p() != doorBlock.func_177952_p() || Math.abs(villagedoorinfo.func_179852_d().func_177956_o() - doorBlock.func_177956_o()) > 1) continue;
            return villagedoorinfo;
        }
        return null;
    }

    public void func_75576_a(VillageDoorInfo doorInfo) {
        this.field_75584_b.add(doorInfo);
        this.field_75585_c = this.field_75585_c.func_177971_a((Vec3i)doorInfo.func_179852_d());
        this.func_75573_l();
        this.field_75580_f = doorInfo.func_75473_b();
    }

    public boolean func_75566_g() {
        return this.field_75584_b.isEmpty();
    }

    public void func_75575_a(EntityLivingBase entitylivingbaseIn) {
        for (VillageAggressor village$villageaggressor : this.field_75589_i) {
            if (village$villageaggressor.field_75592_a != entitylivingbaseIn) continue;
            village$villageaggressor.field_75590_b = this.field_75581_g;
            return;
        }
        this.field_75589_i.add(new VillageAggressor(entitylivingbaseIn, this.field_75581_g));
    }

    @Nullable
    public EntityLivingBase func_75571_b(EntityLivingBase entitylivingbaseIn) {
        double d0 = Double.MAX_VALUE;
        VillageAggressor village$villageaggressor = null;
        for (int i = 0; i < this.field_75589_i.size(); ++i) {
            VillageAggressor village$villageaggressor1 = this.field_75589_i.get(i);
            double d1 = village$villageaggressor1.field_75592_a.func_70068_e(entitylivingbaseIn);
            if (d1 > d0) continue;
            village$villageaggressor = village$villageaggressor1;
            d0 = d1;
        }
        return village$villageaggressor == null ? null : village$villageaggressor.field_75592_a;
    }

    public EntityPlayer func_82685_c(EntityLivingBase villageDefender) {
        double d0 = Double.MAX_VALUE;
        EntityPlayer entityplayer = null;
        for (UUID s : this.field_82693_j.keySet()) {
            double d1;
            EntityPlayer entityplayer1;
            if (!this.isPlayerReputationTooLow(s) || (entityplayer1 = this.field_75586_a.func_152378_a(s)) == null || (d1 = entityplayer1.func_70068_e(villageDefender)) > d0) continue;
            entityplayer = entityplayer1;
            d0 = d1;
        }
        return entityplayer;
    }

    private void func_75565_j() {
        Iterator<VillageAggressor> iterator = this.field_75589_i.iterator();
        while (iterator.hasNext()) {
            VillageAggressor village$villageaggressor = iterator.next();
            if (village$villageaggressor.field_75592_a.func_70089_S() && Math.abs(this.field_75581_g - village$villageaggressor.field_75590_b) <= 300) continue;
            iterator.remove();
        }
    }

    private void func_75557_k() {
        boolean flag = false;
        boolean flag1 = this.field_75586_a.field_73012_v.nextInt(50) == 0;
        Iterator<VillageDoorInfo> iterator = this.field_75584_b.iterator();
        while (iterator.hasNext()) {
            VillageDoorInfo villagedoorinfo = iterator.next();
            if (flag1) {
                villagedoorinfo.func_75466_d();
            }
            if (!this.field_75586_a.func_175667_e(villagedoorinfo.func_179852_d()) || this.func_179860_f(villagedoorinfo.func_179852_d()) && Math.abs(this.field_75581_g - villagedoorinfo.func_75473_b()) <= 1200) continue;
            this.field_75585_c = this.field_75585_c.func_177973_b((Vec3i)villagedoorinfo.func_179852_d());
            flag = true;
            villagedoorinfo.func_179853_a(true);
            iterator.remove();
        }
        if (flag) {
            this.func_75573_l();
        }
    }

    private boolean func_179860_f(BlockPos pos) {
        IBlockState iblockstate = this.field_75586_a.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block instanceof BlockDoor) {
            return iblockstate.func_185904_a() == Material.field_151575_d;
        }
        return false;
    }

    private void func_75573_l() {
        int i = this.field_75584_b.size();
        if (i == 0) {
            this.field_75582_d = BlockPos.field_177992_a;
            this.field_75583_e = 0;
        } else {
            this.field_75582_d = new BlockPos(this.field_75585_c.func_177958_n() / i, this.field_75585_c.func_177956_o() / i, this.field_75585_c.func_177952_p() / i);
            int j = 0;
            for (VillageDoorInfo villagedoorinfo : this.field_75584_b) {
                j = Math.max(villagedoorinfo.func_179848_a(this.field_75582_d), j);
            }
            this.field_75583_e = Math.max(32, (int)Math.sqrt(j) + 1);
        }
    }

    @Deprecated
    public int func_82684_a(String playerName) {
        return this.getPlayerReputation(this.findUUID(playerName));
    }

    public int getPlayerReputation(UUID playerName) {
        Integer integer = this.field_82693_j.get(playerName);
        return integer == null ? 0 : integer;
    }

    private UUID findUUID(String name) {
        if (this.field_75586_a == null || this.field_75586_a.func_73046_m() == null) {
            return EntityPlayer.func_175147_b(name);
        }
        GameProfile profile = this.field_75586_a.func_73046_m().func_152358_ax().func_152655_a(name);
        return profile == null ? EntityPlayer.func_175147_b(name) : profile.getId();
    }

    @Deprecated
    public int func_82688_a(String playerName, int reputation) {
        return this.modifyPlayerReputation(this.findUUID(playerName), reputation);
    }

    public int modifyPlayerReputation(UUID playerName, int reputation) {
        int i = this.getPlayerReputation(playerName);
        int j = MathHelper.func_76125_a((int)(i + reputation), (int)-30, (int)10);
        this.field_82693_j.put(playerName, j);
        return j;
    }

    public boolean func_82687_d(String playerName) {
        return this.isPlayerReputationTooLow(this.findUUID(playerName));
    }

    public boolean isPlayerReputationTooLow(UUID uuid) {
        return this.getPlayerReputation(uuid) <= -15;
    }

    public void func_82690_a(NBTTagCompound compound) {
        this.field_75588_h = compound.func_74762_e("PopSize");
        this.field_75583_e = compound.func_74762_e("Radius");
        this.field_75587_j = compound.func_74762_e("Golems");
        this.field_75580_f = compound.func_74762_e("Stable");
        this.field_75581_g = compound.func_74762_e("Tick");
        this.field_82694_i = compound.func_74762_e("MTick");
        this.field_75582_d = new BlockPos(compound.func_74762_e("CX"), compound.func_74762_e("CY"), compound.func_74762_e("CZ"));
        this.field_75585_c = new BlockPos(compound.func_74762_e("ACX"), compound.func_74762_e("ACY"), compound.func_74762_e("ACZ"));
        NBTTagList nbttaglist = compound.func_150295_c("Doors", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            VillageDoorInfo villagedoorinfo = new VillageDoorInfo(new BlockPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Y"), nbttagcompound.func_74762_e("Z")), nbttagcompound.func_74762_e("IDX"), nbttagcompound.func_74762_e("IDZ"), nbttagcompound.func_74762_e("TS"));
            this.field_75584_b.add(villagedoorinfo);
        }
        NBTTagList nbttaglist1 = compound.func_150295_c("Players", 10);
        for (int j = 0; j < nbttaglist1.size(); ++j) {
            NBTTagCompound nbttagcompound1 = nbttaglist1.func_150305_b(j);
            if (nbttagcompound1.func_74764_b("UUID")) {
                this.field_82693_j.put(UUID.fromString(nbttagcompound1.func_74779_i("UUID")), nbttagcompound1.func_74762_e("S"));
                continue;
            }
            this.field_82693_j.put(this.findUUID(nbttagcompound1.func_74779_i("Name")), nbttagcompound1.func_74762_e("S"));
        }
        if (compound.func_74764_b("ForgeCaps")) {
            this.deserializeCaps(compound.func_74775_l("ForgeCaps"));
        }
    }

    public void func_82689_b(NBTTagCompound compound) {
        compound.func_74768_a("PopSize", this.field_75588_h);
        compound.func_74768_a("Radius", this.field_75583_e);
        compound.func_74768_a("Golems", this.field_75587_j);
        compound.func_74768_a("Stable", this.field_75580_f);
        compound.func_74768_a("Tick", this.field_75581_g);
        compound.func_74768_a("MTick", this.field_82694_i);
        compound.func_74768_a("CX", this.field_75582_d.func_177958_n());
        compound.func_74768_a("CY", this.field_75582_d.func_177956_o());
        compound.func_74768_a("CZ", this.field_75582_d.func_177952_p());
        compound.func_74768_a("ACX", this.field_75585_c.func_177958_n());
        compound.func_74768_a("ACY", this.field_75585_c.func_177956_o());
        compound.func_74768_a("ACZ", this.field_75585_c.func_177952_p());
        NBTTagList nbttaglist = new NBTTagList();
        for (VillageDoorInfo villageDoorInfo : this.field_75584_b) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("X", villageDoorInfo.func_179852_d().func_177958_n());
            nbttagcompound.func_74768_a("Y", villageDoorInfo.func_179852_d().func_177956_o());
            nbttagcompound.func_74768_a("Z", villageDoorInfo.func_179852_d().func_177952_p());
            nbttagcompound.func_74768_a("IDX", villageDoorInfo.func_179847_f());
            nbttagcompound.func_74768_a("IDZ", villageDoorInfo.func_179855_g());
            nbttagcompound.func_74768_a("TS", villageDoorInfo.func_75473_b());
            nbttaglist.add((INBTBase)nbttagcompound);
        }
        compound.func_74782_a("Doors", (INBTBase)nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (UUID s : this.field_82693_j.keySet()) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            try {
                nbttagcompound1.func_74778_a("UUID", s.toString());
                nbttagcompound1.func_74768_a("S", this.field_82693_j.get(s));
                nbttaglist1.add((INBTBase)nbttagcompound1);
            }
            catch (RuntimeException runtimeException) {}
        }
        compound.func_74782_a("Players", (INBTBase)nbttaglist1);
        NBTTagCompound nBTTagCompound = this.serializeCaps();
        if (nBTTagCompound != null) {
            compound.func_74782_a("ForgeCaps", nBTTagCompound);
        }
    }

    public void func_82692_h() {
        this.field_82694_i = this.field_75581_g;
    }

    public boolean func_82686_i() {
        return this.field_82694_i == 0 || this.field_75581_g - this.field_82694_i >= 3600;
    }

    public void func_82683_b(int defaultReputation) {
        for (UUID s : this.field_82693_j.keySet()) {
            this.modifyPlayerReputation(s, defaultReputation);
        }
    }

    class VillageAggressor {
        public EntityLivingBase field_75592_a;
        public int field_75590_b;

        VillageAggressor(EntityLivingBase agressorIn, int agressionTimeIn) {
            this.field_75592_a = agressorIn;
            this.field_75590_b = agressionTimeIn;
        }
    }
}

