/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClassInheritanceMultiMap<T>
extends AbstractSet<T> {
    private static final Set<Class<?>> field_181158_a = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Class<?>, List<T>> field_180218_a = Maps.newHashMap();
    private final Set<Class<?>> field_180216_b = Sets.newIdentityHashSet();
    private final Class<T> field_180217_c;
    private final List<T> field_181745_e = Lists.newArrayList();

    public ClassInheritanceMultiMap(Class<T> baseClassIn) {
        this.field_180217_c = baseClassIn;
        this.field_180216_b.add(baseClassIn);
        this.field_180218_a.put(baseClassIn, this.field_181745_e);
        for (Class oclass : Lists.newArrayList(field_181158_a)) {
            this.func_180213_a(oclass);
        }
    }

    protected void func_180213_a(Class<?> clazz) {
        field_181158_a.add(clazz);
        for (T t : this.field_181745_e) {
            if (!clazz.isAssignableFrom(t.getClass())) continue;
            this.func_181743_a(t, clazz);
        }
        this.field_180216_b.add(clazz);
    }

    protected Class<?> func_181157_b(Class<?> clazz) {
        if (this.field_180217_c.isAssignableFrom(clazz)) {
            if (!this.field_180216_b.contains(clazz)) {
                this.func_180213_a(clazz);
            }
            return clazz;
        }
        throw new IllegalArgumentException("Don't know how to search for " + clazz);
    }

    @Override
    public boolean add(T p_add_1_) {
        for (Class<?> oclass : this.field_180216_b) {
            if (!oclass.isAssignableFrom(p_add_1_.getClass())) continue;
            this.func_181743_a(p_add_1_, oclass);
        }
        return true;
    }

    private void func_181743_a(T value, Class<?> parentClass) {
        List<T> list = this.field_180218_a.get(parentClass);
        if (list == null) {
            this.field_180218_a.put(parentClass, Lists.newArrayList((Object[])new Object[]{value}));
        } else {
            list.add(value);
        }
    }

    @Override
    public boolean remove(Object p_remove_1_) {
        Object t = p_remove_1_;
        boolean flag = false;
        for (Class<?> oclass : this.field_180216_b) {
            List<T> list;
            if (!oclass.isAssignableFrom(t.getClass()) || (list = this.field_180218_a.get(oclass)) == null || !list.remove(t)) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean contains(Object p_contains_1_) {
        return Iterators.contains(this.func_180215_b(p_contains_1_.getClass()).iterator(), (Object)p_contains_1_);
    }

    public <S> Iterable<S> func_180215_b(Class<S> clazz) {
        return () -> {
            List<T> list = this.field_180218_a.get(this.func_181157_b(clazz));
            if (list == null) {
                return Collections.emptyIterator();
            }
            Iterator<T> iterator = list.iterator();
            return Iterators.filter(iterator, (Class)clazz);
        };
    }

    @Override
    public Iterator<T> iterator() {
        return this.field_181745_e.isEmpty() ? Collections.emptyIterator() : Iterators.unmodifiableIterator(this.field_181745_e.iterator());
    }

    @Override
    public int size() {
        return this.field_181745_e.size();
    }
}

