/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeTileEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TileEntity
extends CapabilityProvider<TileEntity>
implements IForgeTileEntity {
    private static final Logger field_145852_a = LogManager.getLogger();
    private final TileEntityType<?> field_200663_e;
    protected World field_145850_b;
    protected BlockPos field_174879_c = BlockPos.field_177992_a;
    protected boolean field_145846_f;
    @Nullable
    private IBlockState field_195045_e;
    private NBTTagCompound customTileData;

    public TileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(TileEntity.class);
        this.field_200663_e = tileEntityTypeIn;
        this.gatherCapabilities();
    }

    @Nullable
    public World func_145831_w() {
        return this.field_145850_b;
    }

    public void func_145834_a(World worldIn) {
        this.field_145850_b = worldIn;
    }

    public boolean func_145830_o() {
        return this.field_145850_b != null;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.field_174879_c = new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
        if (compound.func_74764_b("ForgeData")) {
            this.customTileData = compound.func_74775_l("ForgeData");
        }
        if (this.getCapabilities() != null && compound.func_74764_b("ForgeCaps")) {
            this.deserializeCaps(compound.func_74775_l("ForgeCaps"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return this.func_189516_d(compound);
    }

    private NBTTagCompound func_189516_d(NBTTagCompound compound) {
        ResourceLocation resourcelocation = TileEntityType.func_200969_a(this.func_200662_C());
        if (resourcelocation == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass() + " is missing a mapping! This is a bug!");
        }
        compound.func_74778_a("id", resourcelocation.toString());
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        if (this.customTileData != null) {
            compound.func_74782_a("ForgeData", this.customTileData);
        }
        if (this.getCapabilities() != null) {
            compound.func_74782_a("ForgeCaps", this.serializeCaps());
        }
        return compound;
    }

    @Nullable
    public static TileEntity func_203403_c(NBTTagCompound tag) {
        TileEntity tileentity = null;
        String s = tag.func_74779_i("id");
        try {
            tileentity = TileEntityType.func_200967_a(s);
        }
        catch (Throwable throwable1) {
            field_145852_a.error("Failed to create block entity {}", (Object)s, (Object)throwable1);
        }
        if (tileentity != null) {
            try {
                tileentity.func_145839_a(tag);
            }
            catch (Throwable throwable) {
                field_145852_a.error("Failed to load data for block entity {}", (Object)s, (Object)throwable);
                tileentity = null;
            }
        } else {
            field_145852_a.warn("Skipping BlockEntity with id {}", (Object)s);
        }
        return tileentity;
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_195045_e = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_175646_b(this.field_174879_c, this);
            if (!this.field_195045_e.isAir((IBlockReader)this.field_145850_b, this.field_174879_c)) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_195045_e.func_177230_c());
            }
        }
    }

    public double func_145835_a(double x, double y, double z) {
        double d0 = (double)this.field_174879_c.func_177958_n() + 0.5 - x;
        double d1 = (double)this.field_174879_c.func_177956_o() + 0.5 - y;
        double d2 = (double)this.field_174879_c.func_177952_p() + 0.5 - z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 4096.0;
    }

    public BlockPos func_174877_v() {
        return this.field_174879_c;
    }

    public IBlockState func_195044_w() {
        if (this.field_195045_e == null) {
            this.field_195045_e = this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        return this.field_195045_e;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return null;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189516_d(new NBTTagCompound());
    }

    public boolean func_145837_r() {
        return this.field_145846_f;
    }

    public void func_145843_s() {
        this.field_145846_f = true;
        this.invalidateCaps();
    }

    public void func_145829_t() {
        this.field_145846_f = false;
    }

    public boolean func_145842_c(int id, int type) {
        return false;
    }

    public void func_145836_u() {
        this.field_195045_e = null;
    }

    public void func_145828_a(CrashReportCategory reportCategory) {
        reportCategory.func_189529_a("Name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> IRegistry.field_212626_o.func_177774_c(this.func_200662_C()) + " // " + ((Object)((Object)this)).getClass().getCanonicalName()));
        if (this.field_145850_b != null) {
            CrashReportCategory.func_175750_a(reportCategory, this.field_174879_c, this.func_195044_w());
            CrashReportCategory.func_175750_a(reportCategory, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
        }
    }

    public void func_174878_a(BlockPos posIn) {
        this.field_174879_c = posIn.func_185334_h();
    }

    public boolean func_183000_F() {
        return false;
    }

    public void func_189667_a(Rotation rotationIn) {
    }

    public void func_189668_a(Mirror mirrorIn) {
    }

    public TileEntityType<?> func_200662_C() {
        return this.field_200663_e;
    }

    public NBTTagCompound getTileData() {
        if (this.customTileData == null) {
            this.customTileData = new NBTTagCompound();
        }
        return this.customTileData;
    }
}

