/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTTagCompound
implements INBTBase {
    private static final Logger field_191551_b = LogManager.getLogger();
    private static final Pattern field_193583_c = Pattern.compile("[A-Za-z0-9._+-]+");
    private final Map<String, INBTBase> field_74784_a = Maps.newHashMap();

    public void func_74734_a(DataOutput output) throws IOException {
        for (String s : this.field_74784_a.keySet()) {
            INBTBase inbtbase = this.field_74784_a.get(s);
            NBTTagCompound.func_150298_a(s, inbtbase, output);
        }
        output.writeByte(0);
    }

    public void func_152446_a(DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        byte b0;
        sizeTracker.func_152450_a(384L);
        if (depth > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.field_74784_a.clear();
        while ((b0 = NBTTagCompound.func_152447_a(input, sizeTracker)) != 0) {
            String s = NBTTagCompound.func_152448_b(input, sizeTracker);
            sizeTracker.func_152450_a(224 + 16 * s.length());
            INBTBase inbtbase = NBTTagCompound.func_152449_a(b0, s, input, depth + 1, sizeTracker);
            if (this.field_74784_a.put(s, inbtbase) == null) continue;
            sizeTracker.func_152450_a(288L);
        }
    }

    public Set<String> func_150296_c() {
        return this.field_74784_a.keySet();
    }

    public byte func_74732_a() {
        return 10;
    }

    public int func_186856_d() {
        return this.field_74784_a.size();
    }

    public void func_74782_a(String key, INBTBase value) {
        if (value == null) {
            throw new IllegalArgumentException("Invalid null NBT value with key " + key);
        }
        this.field_74784_a.put(key, value);
    }

    public void func_74774_a(String key, byte value) {
        this.field_74784_a.put(key, (INBTBase)new NBTTagByte(value));
    }

    public void func_74777_a(String key, short value) {
        this.field_74784_a.put(key, (INBTBase)new NBTTagShort(value));
    }

    public void func_74768_a(String key, int value) {
        this.field_74784_a.put(key, (INBTBase)new NBTTagInt(value));
    }

    public void func_74772_a(String key, long value) {
        this.field_74784_a.put(key, (INBTBase)new NBTTagLong(value));
    }

    public void func_186854_a(String key, UUID value) {
        this.func_74772_a(key + "Most", value.getMostSignificantBits());
        this.func_74772_a(key + "Least", value.getLeastSignificantBits());
    }

    @Nullable
    public UUID func_186857_a(String key) {
        return new UUID(this.func_74763_f(key + "Most"), this.func_74763_f(key + "Least"));
    }

    public boolean func_186855_b(String key) {
        return this.func_150297_b(key + "Most", 99) && this.func_150297_b(key + "Least", 99);
    }

    public void func_74776_a(String key, float value) {
        this.field_74784_a.put(key, (INBTBase)new NBTTagFloat(value));
    }

    public void func_74780_a(String key, double value) {
        this.field_74784_a.put(key, (INBTBase)new NBTTagDouble(value));
    }

    public void func_74778_a(String key, String value) {
        this.field_74784_a.put(key, new NBTTagString(value));
    }

    public void func_74773_a(String key, byte[] value) {
        this.field_74784_a.put(key, (INBTBase)new NBTTagByteArray(value));
    }

    public void func_74783_a(String key, int[] value) {
        this.field_74784_a.put(key, (INBTBase)new NBTTagIntArray(value));
    }

    public void func_197646_b(String p_197646_1_, List<Integer> p_197646_2_) {
        this.field_74784_a.put(p_197646_1_, (INBTBase)new NBTTagIntArray(p_197646_2_));
    }

    public void func_197644_a(String p_197644_1_, long[] p_197644_2_) {
        this.field_74784_a.put(p_197644_1_, (INBTBase)new NBTTagLongArray(p_197644_2_));
    }

    public void func_202168_c(String p_202168_1_, List<Long> p_202168_2_) {
        this.field_74784_a.put(p_202168_1_, (INBTBase)new NBTTagLongArray(p_202168_2_));
    }

    public void func_74757_a(String key, boolean value) {
        this.func_74774_a(key, (byte)(value ? 1 : 0));
    }

    public INBTBase func_74781_a(String key) {
        return this.field_74784_a.get(key);
    }

    public byte func_150299_b(String key) {
        INBTBase inbtbase = this.field_74784_a.get(key);
        return inbtbase == null ? (byte)0 : inbtbase.func_74732_a();
    }

    public boolean func_74764_b(String key) {
        return this.field_74784_a.containsKey(key);
    }

    public boolean func_150297_b(String key, int type) {
        byte i = this.func_150299_b(key);
        if (i == type) {
            return true;
        }
        if (type != 99) {
            return false;
        }
        return i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6;
    }

    public byte func_74771_c(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NBTPrimitive)this.field_74784_a.get(key)).func_150290_f();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short func_74765_d(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NBTPrimitive)this.field_74784_a.get(key)).func_150289_e();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int func_74762_e(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NBTPrimitive)this.field_74784_a.get(key)).func_150287_d();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long func_74763_f(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NBTPrimitive)this.field_74784_a.get(key)).func_150291_c();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float func_74760_g(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NBTPrimitive)this.field_74784_a.get(key)).func_150288_h();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double func_74769_h(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NBTPrimitive)this.field_74784_a.get(key)).func_150286_g();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String func_74779_i(String key) {
        try {
            if (this.func_150297_b(key, 8)) {
                return this.field_74784_a.get(key).func_150285_a_();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] func_74770_j(String key) {
        try {
            if (this.func_150297_b(key, 7)) {
                return ((NBTTagByteArray)this.field_74784_a.get(key)).func_150292_c();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_82581_a(key, 7, classcastexception));
        }
        return new byte[0];
    }

    public int[] func_74759_k(String key) {
        try {
            if (this.func_150297_b(key, 11)) {
                return ((NBTTagIntArray)this.field_74784_a.get(key)).func_150302_c();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_82581_a(key, 11, classcastexception));
        }
        return new int[0];
    }

    public long[] func_197645_o(String key) {
        try {
            if (this.func_150297_b(key, 12)) {
                return ((NBTTagLongArray)this.field_74784_a.get(key)).func_197652_h();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_82581_a(key, 12, classcastexception));
        }
        return new long[0];
    }

    public NBTTagCompound func_74775_l(String key) {
        try {
            if (this.func_150297_b(key, 10)) {
                return (NBTTagCompound)this.field_74784_a.get(key);
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_82581_a(key, 10, classcastexception));
        }
        return new NBTTagCompound();
    }

    public NBTTagList func_150295_c(String key, int type) {
        try {
            if (this.func_150299_b(key) == 9) {
                NBTTagList nbttaglist = (NBTTagList)this.field_74784_a.get(key);
                if (!nbttaglist.isEmpty() && nbttaglist.func_150303_d() != type) {
                    return new NBTTagList();
                }
                return nbttaglist;
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_82581_a(key, 9, classcastexception));
        }
        return new NBTTagList();
    }

    public boolean func_74767_n(String key) {
        return this.func_74771_c(key) != 0;
    }

    public void func_82580_o(String key) {
        this.field_74784_a.remove(key);
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("{");
        Collection<String> collection = this.field_74784_a.keySet();
        if (field_191551_b.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(this.field_74784_a.keySet());
            Collections.sort(list);
            collection = list;
        }
        for (String s : collection) {
            if (stringbuilder.length() != 1) {
                stringbuilder.append(',');
            }
            stringbuilder.append(NBTTagCompound.func_193582_s(s)).append(':').append(this.field_74784_a.get(s));
        }
        return stringbuilder.append('}').toString();
    }

    public boolean isEmpty() {
        return this.field_74784_a.isEmpty();
    }

    private CrashReport func_82581_a(String key, int expectedType, ClassCastException ex) {
        CrashReport crashreport = CrashReport.func_85055_a(ex, "Reading NBT data");
        CrashReportCategory crashreportcategory = crashreport.func_85057_a("Corrupt NBT tag", 1);
        crashreportcategory.func_189529_a("Tag type found", (ICrashReportDetail<String>)((ICrashReportDetail)() -> field_82578_b[this.field_74784_a.get(key).func_74732_a()]));
        crashreportcategory.func_189529_a("Tag type expected", (ICrashReportDetail<String>)((ICrashReportDetail)() -> field_82578_b[expectedType]));
        crashreportcategory.func_71507_a("Tag name", key);
        return crashreport;
    }

    public NBTTagCompound func_74737_b() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        for (String s : this.field_74784_a.keySet()) {
            nbttagcompound.func_74782_a(s, this.field_74784_a.get(s).func_74737_b());
        }
        return nbttagcompound;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        return p_equals_1_ instanceof NBTTagCompound && Objects.equals(this.field_74784_a, ((NBTTagCompound)p_equals_1_).field_74784_a);
    }

    public int hashCode() {
        return this.field_74784_a.hashCode();
    }

    private static void func_150298_a(String name, INBTBase data, DataOutput output) throws IOException {
        output.writeByte(data.func_74732_a());
        if (data.func_74732_a() != 0) {
            output.writeUTF(name);
            data.func_74734_a(output);
        }
    }

    private static byte func_152447_a(DataInput input, NBTSizeTracker sizeTracker) throws IOException {
        sizeTracker.func_152450_a(8L);
        return input.readByte();
    }

    private static String func_152448_b(DataInput input, NBTSizeTracker sizeTracker) throws IOException {
        return input.readUTF();
    }

    static INBTBase func_152449_a(byte id, String key, DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        sizeTracker.func_152450_a(32L);
        INBTBase inbtbase = INBTBase.func_150284_a((byte)id);
        try {
            inbtbase.func_152446_a(input, depth, sizeTracker);
            return inbtbase;
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.func_85055_a(ioexception, "Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("NBT Tag");
            crashreportcategory.func_71507_a("Tag name", key);
            crashreportcategory.func_71507_a("Tag type", id);
            throw new ReportedException(crashreport);
        }
    }

    public NBTTagCompound func_197643_a(NBTTagCompound other) {
        for (String s : other.field_74784_a.keySet()) {
            INBTBase inbtbase = other.field_74784_a.get(s);
            if (inbtbase.func_74732_a() == 10) {
                if (this.func_150297_b(s, 10)) {
                    NBTTagCompound nbttagcompound = this.func_74775_l(s);
                    nbttagcompound.func_197643_a((NBTTagCompound)inbtbase);
                    continue;
                }
                this.func_74782_a(s, inbtbase.func_74737_b());
                continue;
            }
            this.func_74782_a(s, inbtbase.func_74737_b());
        }
        return this;
    }

    protected static String func_193582_s(String p_193582_0_) {
        return field_193583_c.matcher(p_193582_0_).matches() ? p_193582_0_ : NBTTagString.func_197654_a(p_193582_0_, true);
    }

    protected static ITextComponent func_197642_t(String p_197642_0_) {
        if (field_193583_c.matcher(p_197642_0_).matches()) {
            return new TextComponentString(p_197642_0_).func_211708_a(field_197638_b);
        }
        ITextComponent itextcomponent = new TextComponentString(NBTTagString.func_197654_a(p_197642_0_, false)).func_211708_a(field_197638_b);
        return new TextComponentString("\"").func_150257_a(itextcomponent).func_150258_a("\"");
    }

    public ITextComponent func_199850_a(String indentation, int indentDepth) {
        if (this.field_74784_a.isEmpty()) {
            return new TextComponentString("{}");
        }
        TextComponentString itextcomponent = new TextComponentString("{");
        Collection<String> collection = this.field_74784_a.keySet();
        if (field_191551_b.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(this.field_74784_a.keySet());
            Collections.sort(list);
            collection = list;
        }
        if (!indentation.isEmpty()) {
            itextcomponent.func_150258_a("\n");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            ITextComponent itextcomponent1 = new TextComponentString(Strings.repeat((String)indentation, (int)(indentDepth + 1))).func_150257_a(NBTTagCompound.func_197642_t(s)).func_150258_a(String.valueOf(':')).func_150258_a(" ").func_150257_a(this.field_74784_a.get(s).func_199850_a(indentation, indentDepth + 1));
            if (iterator.hasNext()) {
                itextcomponent1.func_150258_a(String.valueOf(',')).func_150258_a(indentation.isEmpty() ? " " : "\n");
            }
            itextcomponent.func_150257_a(itextcomponent1);
        }
        if (!indentation.isEmpty()) {
            itextcomponent.func_150258_a("\n").func_150258_a(Strings.repeat((String)indentation, (int)indentDepth));
        }
        itextcomponent.func_150258_a("}");
        return itextcomponent;
    }
}

