/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;

public class CompressedStreamTools {
    public static NBTTagCompound func_74796_a(InputStream is) throws IOException {
        NBTTagCompound nbttagcompound;
        try (DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(is)));){
            nbttagcompound = CompressedStreamTools.func_152456_a(datainputstream, NBTSizeTracker.field_152451_a);
        }
        return nbttagcompound;
    }

    public static void func_74799_a(NBTTagCompound compound, OutputStream outputStream) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputStream)));){
            CompressedStreamTools.func_74800_a(compound, dataoutputstream);
        }
    }

    public static void func_74793_a(NBTTagCompound compound, File fileIn) throws IOException {
        File file1 = new File(fileIn.getAbsolutePath() + "_tmp");
        if (file1.exists()) {
            file1.delete();
        }
        CompressedStreamTools.func_74795_b(compound, file1);
        if (fileIn.exists()) {
            fileIn.delete();
        }
        if (fileIn.exists()) {
            throw new IOException("Failed to delete " + fileIn);
        }
        file1.renameTo(fileIn);
    }

    public static void func_74795_b(NBTTagCompound compound, File fileIn) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(fileIn));){
            CompressedStreamTools.func_74800_a(compound, dataoutputstream);
        }
    }

    @Nullable
    public static NBTTagCompound func_74797_a(File fileIn) throws IOException {
        NBTTagCompound nbttagcompound;
        if (!fileIn.exists()) {
            return null;
        }
        try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(fileIn));){
            nbttagcompound = CompressedStreamTools.func_152456_a(datainputstream, NBTSizeTracker.field_152451_a);
        }
        return nbttagcompound;
    }

    public static NBTTagCompound func_74794_a(DataInputStream inputStream) throws IOException {
        return CompressedStreamTools.func_152456_a(inputStream, NBTSizeTracker.field_152451_a);
    }

    public static NBTTagCompound func_152456_a(DataInput input, NBTSizeTracker accounter) throws IOException {
        INBTBase inbtbase = CompressedStreamTools.func_152455_a(input, 0, accounter);
        if (inbtbase instanceof NBTTagCompound) {
            return (NBTTagCompound)inbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void func_74800_a(NBTTagCompound compound, DataOutput output) throws IOException {
        CompressedStreamTools.func_150663_a(compound, output);
    }

    private static void func_150663_a(INBTBase tag, DataOutput output) throws IOException {
        output.writeByte(tag.func_74732_a());
        if (tag.func_74732_a() != 0) {
            output.writeUTF("");
            tag.func_74734_a(output);
        }
    }

    private static INBTBase func_152455_a(DataInput input, int depth, NBTSizeTracker accounter) throws IOException {
        byte b0 = input.readByte();
        accounter.func_152450_a(8L);
        if (b0 == 0) {
            return new NBTTagEnd();
        }
        NBTSizeTracker.readUTF(accounter, input.readUTF());
        accounter.func_152450_a(32L);
        INBTBase inbtbase = INBTBase.func_150284_a((byte)b0);
        try {
            inbtbase.func_152446_a(input, depth, accounter);
            return inbtbase;
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.func_85055_a(ioexception, "Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("NBT Tag");
            crashreportcategory.func_71507_a("Tag type", b0);
            throw new ReportedException(crashreport);
        }
    }
}

