/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.init;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarvedPumpkin;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSkullWither;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.EntityOptions;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBoneMeal;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemSpawnEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionType;
import net.minecraft.server.DebugLoggingPrintStream;
import net.minecraft.state.IProperty;
import net.minecraft.stats.StatList;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LoggingPrintStream;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Bootstrap {
    public static final PrintStream field_179872_a = System.out;
    private static boolean field_151355_a;
    private static final Logger field_179871_c;

    public static boolean func_179869_a() {
        return field_151355_a;
    }

    static void func_151353_a() {
        BlockDispenser.func_199774_a((IItemProvider)Items.field_151032_g, (IBehaviorDispenseItem)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityTippedArrow entitytippedarrow = new EntityTippedArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                entitytippedarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entitytippedarrow;
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Items.field_185167_i, (IBehaviorDispenseItem)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityTippedArrow entitytippedarrow = new EntityTippedArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                entitytippedarrow.func_184555_a(stackIn);
                entitytippedarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entitytippedarrow;
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Items.field_185166_h, (IBehaviorDispenseItem)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntitySpectralArrow entityarrow = new EntitySpectralArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entityarrow;
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Items.field_151110_aK, (IBehaviorDispenseItem)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return new EntityEgg(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Items.field_151126_ay, (IBehaviorDispenseItem)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return new EntitySnowball(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Items.field_151062_by, (IBehaviorDispenseItem)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return new EntityExpBottle(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }

            protected float func_82498_a() {
                return super.func_82498_a() * 0.5f;
            }

            protected float func_82500_b() {
                return super.func_82500_b() * 1.25f;
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Items.field_185155_bH, (IBehaviorDispenseItem)new IBehaviorDispenseItem(){

            public ItemStack dispense(IBlockSource p_dispense_1_, final ItemStack p_dispense_2_) {
                return new BehaviorProjectileDispense(){

                    protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                        return new EntityPotion(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), p_dispense_2_.func_77946_l());
                    }

                    protected float func_82498_a() {
                        return super.func_82498_a() * 0.5f;
                    }

                    protected float func_82500_b() {
                        return super.func_82500_b() * 1.25f;
                    }
                }.dispense(p_dispense_1_, p_dispense_2_);
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Items.field_185156_bI, (IBehaviorDispenseItem)new IBehaviorDispenseItem(){

            public ItemStack dispense(IBlockSource p_dispense_1_, final ItemStack p_dispense_2_) {
                return new BehaviorProjectileDispense(){

                    protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                        return new EntityPotion(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), p_dispense_2_.func_77946_l());
                    }

                    protected float func_82498_a() {
                        return super.func_82498_a() * 0.5f;
                    }

                    protected float func_82500_b() {
                        return super.func_82500_b() * 1.25f;
                    }
                }.dispense(p_dispense_1_, p_dispense_2_);
            }
        });
        BehaviorDefaultDispenseItem behaviordefaultdispenseitem = new BehaviorDefaultDispenseItem(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                EnumFacing enumfacing = (EnumFacing)((Object)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                EntityType entitytype = ((ItemSpawnEgg)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                if (entitytype != null) {
                    entitytype.func_208049_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(enumfacing), enumfacing != EnumFacing.UP, false);
                }
                stack.func_190918_g(1);
                return stack;
            }
        };
        for (ItemSpawnEgg itemspawnegg : ItemSpawnEgg.func_195985_g()) {
            BlockDispenser.func_199774_a((IItemProvider)itemspawnegg, (IBehaviorDispenseItem)behaviordefaultdispenseitem);
        }
        BlockDispenser.func_199774_a((IItemProvider)Items.field_196152_dE, (IBehaviorDispenseItem)new BehaviorDefaultDispenseItem(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                EnumFacing enumfacing = (EnumFacing)((Object)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                double d0 = source.func_82615_a() + (double)enumfacing.func_82601_c();
                double d1 = (float)source.func_180699_d().func_177956_o() + 0.2f;
                double d2 = source.func_82616_c() + (double)enumfacing.func_82599_e();
                EntityFireworkRocket entityfireworkrocket = new EntityFireworkRocket(source.func_197524_h(), d0, d1, d2, stack);
                source.func_197524_h().func_72838_d((Entity)entityfireworkrocket);
                stack.func_190918_g(1);
                return stack;
            }

            protected void func_82485_a(IBlockSource source) {
                source.func_197524_h().func_175718_b(1004, source.func_180699_d(), 0);
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Items.field_151059_bz, (IBehaviorDispenseItem)new BehaviorDefaultDispenseItem(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                EnumFacing enumfacing = (EnumFacing)((Object)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)source);
                double d0 = iposition.func_82615_a() + (double)((float)enumfacing.func_82601_c() * 0.3f);
                double d1 = iposition.func_82617_b() + (double)((float)enumfacing.func_96559_d() * 0.3f);
                double d2 = iposition.func_82616_c() + (double)((float)enumfacing.func_82599_e() * 0.3f);
                World world = source.func_197524_h();
                Random random = world.field_73012_v;
                double d3 = random.nextGaussian() * 0.05 + (double)enumfacing.func_82601_c();
                double d4 = random.nextGaussian() * 0.05 + (double)enumfacing.func_96559_d();
                double d5 = random.nextGaussian() * 0.05 + (double)enumfacing.func_82599_e();
                world.func_72838_d(new EntitySmallFireball(world, d0, d1, d2, d3, d4, d5));
                stack.func_190918_g(1);
                return stack;
            }

            protected void func_82485_a(IBlockSource source) {
                source.func_197524_h().func_175718_b(1018, source.func_180699_d(), 0);
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Items.field_151124_az, (IBehaviorDispenseItem)new BehaviorDispenseBoat(EntityBoat.Type.OAK));
        BlockDispenser.func_199774_a((IItemProvider)Items.field_185150_aH, (IBehaviorDispenseItem)new BehaviorDispenseBoat(EntityBoat.Type.SPRUCE));
        BlockDispenser.func_199774_a((IItemProvider)Items.field_185151_aI, (IBehaviorDispenseItem)new BehaviorDispenseBoat(EntityBoat.Type.BIRCH));
        BlockDispenser.func_199774_a((IItemProvider)Items.field_185152_aJ, (IBehaviorDispenseItem)new BehaviorDispenseBoat(EntityBoat.Type.JUNGLE));
        BlockDispenser.func_199774_a((IItemProvider)Items.field_185154_aL, (IBehaviorDispenseItem)new BehaviorDispenseBoat(EntityBoat.Type.DARK_OAK));
        BlockDispenser.func_199774_a((IItemProvider)Items.field_185153_aK, (IBehaviorDispenseItem)new BehaviorDispenseBoat(EntityBoat.Type.ACACIA));
        BehaviorDefaultDispenseItem ibehaviordispenseitem = new BehaviorDefaultDispenseItem(){
            private final BehaviorDefaultDispenseItem field_150841_b = new BehaviorDefaultDispenseItem();

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ItemBucket itembucket = (ItemBucket)stack.func_77973_b();
                BlockPos blockpos = source.func_180699_d().func_177972_a((EnumFacing)((Object)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)));
                World world = source.func_197524_h();
                if (itembucket.func_180616_a(null, world, blockpos, null)) {
                    itembucket.func_203792_a(world, stack, blockpos);
                    return new ItemStack(Items.field_151133_ar);
                }
                return this.field_150841_b.dispense(source, stack);
            }
        };
        BlockDispenser.func_199774_a((IItemProvider)Items.field_151129_at, (IBehaviorDispenseItem)ibehaviordispenseitem);
        BlockDispenser.func_199774_a((IItemProvider)Items.field_151131_as, (IBehaviorDispenseItem)ibehaviordispenseitem);
        BlockDispenser.func_199774_a((IItemProvider)Items.field_203796_aM, (IBehaviorDispenseItem)ibehaviordispenseitem);
        BlockDispenser.func_199774_a((IItemProvider)Items.field_203797_aN, (IBehaviorDispenseItem)ibehaviordispenseitem);
        BlockDispenser.func_199774_a((IItemProvider)Items.field_203795_aL, (IBehaviorDispenseItem)ibehaviordispenseitem);
        BlockDispenser.func_199774_a((IItemProvider)Items.field_204272_aO, (IBehaviorDispenseItem)ibehaviordispenseitem);
        BlockDispenser.func_199774_a((IItemProvider)Items.field_151133_ar, (IBehaviorDispenseItem)new BehaviorDefaultDispenseItem(){
            private final BehaviorDefaultDispenseItem field_150840_b = new BehaviorDefaultDispenseItem();

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos;
                World iworld = source.func_197524_h();
                IBlockState iblockstate = iworld.func_180495_p(blockpos = source.func_180699_d().func_177972_a((EnumFacing)((Object)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a))));
                Block block = iblockstate.func_177230_c();
                if (block instanceof IBucketPickupHandler) {
                    Fluid fluid = ((IBucketPickupHandler)block).func_204508_a((IWorld)iworld, blockpos, iblockstate);
                    if (!(fluid instanceof FlowingFluid)) {
                        return super.func_82487_b(source, stack);
                    }
                    Item item = fluid.func_204524_b();
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        return new ItemStack(item);
                    }
                    if (((TileEntityDispenser)source.func_150835_j()).func_146019_a(new ItemStack(item)) < 0) {
                        this.field_150840_b.dispense(source, new ItemStack(item));
                    }
                    return stack;
                }
                return super.func_82487_b(source, stack);
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Items.field_151033_d, (IBehaviorDispenseItem)new BehaviorDispenseOptional(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                World world = source.func_197524_h();
                this.field_190911_b = true;
                BlockPos blockpos = source.func_180699_d().func_177972_a((EnumFacing)((Object)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)));
                if (ItemFlintAndSteel.func_201825_a((IWorld)world, (BlockPos)blockpos)) {
                    world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                } else {
                    Block block = world.func_180495_p(blockpos).func_177230_c();
                    if (block instanceof BlockTNT) {
                        ((BlockTNT)block).func_196534_a(world, blockpos);
                        world.func_175698_g(blockpos);
                    } else {
                        this.field_190911_b = false;
                    }
                }
                if (this.field_190911_b && stack.func_96631_a(1, world.field_73012_v, null)) {
                    stack.func_190920_e(0);
                }
                return stack;
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Items.field_196106_bc, (IBehaviorDispenseItem)new BehaviorDispenseOptional(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos;
                this.field_190911_b = true;
                World world = source.func_197524_h();
                if (!ItemBoneMeal.func_195966_a(stack, world, blockpos = source.func_180699_d().func_177972_a((EnumFacing)((Object)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)))) && !ItemBoneMeal.func_203173_b(stack, world, blockpos, null)) {
                    this.field_190911_b = false;
                } else if (!world.field_72995_K) {
                    world.func_175718_b(2005, blockpos, 0);
                }
                return stack;
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Blocks.field_150335_W, (IBehaviorDispenseItem)new BehaviorDefaultDispenseItem(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                World world = source.func_197524_h();
                BlockPos blockpos = source.func_180699_d().func_177972_a((EnumFacing)((Object)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)));
                EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, (EntityLivingBase)null);
                world.func_72838_d((Entity)entitytntprimed);
                world.func_184148_a(null, entitytntprimed.field_70165_t, entitytntprimed.field_70163_u, entitytntprimed.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                stack.func_190918_g(1);
                return stack;
            }
        });
        BehaviorDispenseOptional bootstrap$behaviordispenseoptional = new BehaviorDispenseOptional(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                this.field_190911_b = !ItemArmor.func_185082_a(source, stack).func_190926_b();
                return stack;
            }
        };
        BlockDispenser.func_199774_a((IItemProvider)Items.field_196185_dy, (IBehaviorDispenseItem)bootstrap$behaviordispenseoptional);
        BlockDispenser.func_199774_a((IItemProvider)Items.field_196186_dz, (IBehaviorDispenseItem)bootstrap$behaviordispenseoptional);
        BlockDispenser.func_199774_a((IItemProvider)Items.field_196151_dA, (IBehaviorDispenseItem)bootstrap$behaviordispenseoptional);
        BlockDispenser.func_199774_a((IItemProvider)Items.field_196182_dv, (IBehaviorDispenseItem)bootstrap$behaviordispenseoptional);
        BlockDispenser.func_199774_a((IItemProvider)Items.field_196184_dx, (IBehaviorDispenseItem)bootstrap$behaviordispenseoptional);
        BlockDispenser.func_199774_a((IItemProvider)Items.field_196183_dw, (IBehaviorDispenseItem)new BehaviorDispenseOptional(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                World world = source.func_197524_h();
                EnumFacing enumfacing = (EnumFacing)((Object)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                BlockPos blockpos = source.func_180699_d().func_177972_a(enumfacing);
                this.field_190911_b = true;
                if (world.func_175623_d(blockpos) && BlockSkullWither.func_196299_b((World)world, (BlockPos)blockpos, (ItemStack)stack)) {
                    world.func_180501_a(blockpos, (IBlockState)Blocks.field_196705_eO.func_176223_P().func_206870_a((IProperty)BlockSkull.field_196294_a, Integer.valueOf(enumfacing.func_176740_k() == EnumFacing.Axis.Y ? 0 : enumfacing.func_176734_d().func_176736_b() * 4)), 3);
                    TileEntity tileentity = world.func_175625_s(blockpos);
                    if (tileentity instanceof TileEntitySkull) {
                        BlockSkullWither.func_196298_a((World)world, (BlockPos)blockpos, (TileEntitySkull)((TileEntitySkull)tileentity));
                    }
                    stack.func_190918_g(1);
                } else if (ItemArmor.func_185082_a(source, stack).func_190926_b()) {
                    this.field_190911_b = false;
                }
                return stack;
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Blocks.field_196625_cS, (IBehaviorDispenseItem)new BehaviorDispenseOptional(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                World world = source.func_197524_h();
                BlockPos blockpos = source.func_180699_d().func_177972_a((EnumFacing)((Object)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)));
                BlockCarvedPumpkin blockcarvedpumpkin = (BlockCarvedPumpkin)Blocks.field_196625_cS;
                this.field_190911_b = true;
                if (world.func_175623_d(blockpos) && blockcarvedpumpkin.func_196354_a((IWorldReaderBase)world, blockpos)) {
                    if (!world.field_72995_K) {
                        world.func_180501_a(blockpos, blockcarvedpumpkin.func_176223_P(), 3);
                    }
                    stack.func_190918_g(1);
                } else {
                    ItemStack itemstack = ItemArmor.func_185082_a(source, stack);
                    if (itemstack.func_190926_b()) {
                        this.field_190911_b = false;
                    }
                }
                return stack;
            }
        });
        BlockDispenser.func_199774_a((IItemProvider)Blocks.field_204409_il.func_199767_j(), (IBehaviorDispenseItem)new BehaviorDispenseShulkerBox());
        for (EnumDyeColor enumdyecolor : EnumDyeColor.values()) {
            BlockDispenser.func_199774_a((IItemProvider)BlockShulkerBox.func_190952_a((EnumDyeColor)enumdyecolor).func_199767_j(), (IBehaviorDispenseItem)new BehaviorDispenseShulkerBox());
        }
    }

    public static void func_151354_b() {
        if (!field_151355_a) {
            field_151355_a = true;
            SoundEvent.func_187504_b();
            Fluid.func_207195_i();
            Block.func_149671_p();
            BlockFire.func_149843_e();
            Potion.func_188411_k();
            Enchantment.func_185257_f();
            if (EntityType.func_200718_a(EntityType.field_200729_aH) == null) {
                throw new IllegalStateException("Failed loading EntityTypes");
            }
            Item.func_150900_l();
            PotionType.func_185175_b();
            PotionBrewing.func_185207_a();
            Biome.func_185358_q();
            EntityOptions.func_197445_a();
            ParticleType.func_197576_c();
            Bootstrap.func_151353_a();
            ArgumentTypes.func_197483_a();
            BiomeProviderType.func_212580_a();
            TileEntityType.func_212641_a();
            ChunkGeneratorType.func_212675_a();
            DimensionType.func_212680_a();
            PaintingType.func_200831_a();
            StatList.func_212734_a();
            IRegistry.func_212613_e();
            VillagerRegistry.instance();
            if (SharedConstants.field_206244_b) {
                Bootstrap.func_210839_a("block", IRegistry.field_212618_g, Block::func_149739_a);
                Bootstrap.func_210839_a("biome", IRegistry.field_212624_m, Biome::func_210773_k);
                Bootstrap.func_210839_a("enchantment", IRegistry.field_212628_q, Enchantment::func_77320_a);
                Bootstrap.func_210839_a("item", IRegistry.field_212630_s, Item::func_77658_a);
                Bootstrap.func_210839_a("effect", IRegistry.field_212631_t, Potion::func_76393_a);
                Bootstrap.func_210839_a("entity", IRegistry.field_212629_r, EntityType::func_210760_d);
            }
        }
    }

    private static <T> void func_210839_a(String type, IRegistry<T> registry, Function<T, String> getTranslationKey) {
        LanguageMap languagemap = LanguageMap.func_74808_a();
        registry.iterator().forEachRemaining(p_210840_4_ -> {
            String s = (String)getTranslationKey.apply(p_210840_4_);
            if (!languagemap.func_210813_b(s)) {
                field_179871_c.warn("Missing translation for {}: {} (key: '{}')", (Object)type, (Object)registry.func_177774_c(p_210840_4_), (Object)s);
            }
        });
    }

    private static void func_179868_d() {
        if (field_179871_c.isDebugEnabled()) {
            System.setErr((PrintStream)new DebugLoggingPrintStream("STDERR", (OutputStream)System.err));
            System.setOut((PrintStream)new DebugLoggingPrintStream("STDOUT", (OutputStream)field_179872_a));
        } else {
            System.setErr((PrintStream)new LoggingPrintStream("STDERR", (OutputStream)System.err));
            System.setOut((PrintStream)new LoggingPrintStream("STDOUT", (OutputStream)field_179872_a));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_179870_a(String message) {
        field_179872_a.println(message);
    }

    static {
        field_179871_c = LogManager.getLogger();
    }

    static class DispensePlaceContext
    extends BlockItemUseContext {
        private final EnumFacing field_196015_j;

        public DispensePlaceContext(World p_i47754_1_, BlockPos p_i47754_2_, EnumFacing p_i47754_3_, ItemStack p_i47754_4_, EnumFacing p_i47754_5_) {
            super(p_i47754_1_, (EntityPlayer)null, p_i47754_4_, p_i47754_2_, p_i47754_5_, 0.5f, 0.0f, 0.5f);
            this.field_196015_j = p_i47754_3_;
        }

        public BlockPos func_195995_a() {
            return this.field_196008_i;
        }

        public boolean func_196011_b() {
            return this.field_196006_g.func_180495_p(this.field_196008_i).func_196953_a(this);
        }

        public boolean func_196012_c() {
            return this.func_196011_b();
        }

        public EnumFacing func_196010_d() {
            return EnumFacing.DOWN;
        }

        public EnumFacing[] func_196009_e() {
            switch (this.field_196015_j) {
                default: {
                    return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP};
                }
                case UP: {
                    return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
                }
                case NORTH: {
                    return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.UP, EnumFacing.SOUTH};
                }
                case SOUTH: {
                    return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.UP, EnumFacing.NORTH};
                }
                case WEST: {
                    return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST};
                }
                case EAST: 
            }
            return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.WEST};
        }

        public EnumFacing func_195992_f() {
            return this.field_196015_j.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : this.field_196015_j;
        }

        public boolean func_195998_g() {
            return false;
        }

        public float func_195990_h() {
            return this.field_196015_j.func_176736_b() * 90;
        }
    }

    static class BehaviorDispenseShulkerBox
    extends BehaviorDispenseOptional {
        private BehaviorDispenseShulkerBox() {
        }

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            this.field_190911_b = false;
            Item item = stack.func_77973_b();
            if (item instanceof ItemBlock) {
                EnumFacing enumfacing = (EnumFacing)((Object)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                BlockPos blockpos = source.func_180699_d().func_177972_a(enumfacing);
                EnumFacing enumfacing1 = source.func_197524_h().func_175623_d(blockpos.func_177977_b()) ? enumfacing : EnumFacing.UP;
                boolean bl = this.field_190911_b = ((ItemBlock)item).func_195942_a(new DispensePlaceContext(source.func_197524_h(), blockpos, enumfacing, stack, enumfacing1)) == EnumActionResult.SUCCESS;
                if (this.field_190911_b) {
                    stack.func_190918_g(1);
                }
            }
            return stack;
        }
    }

    public static abstract class BehaviorDispenseOptional
    extends BehaviorDefaultDispenseItem {
        protected boolean field_190911_b = true;

        protected void func_82485_a(IBlockSource source) {
            source.func_197524_h().func_175718_b(this.field_190911_b ? 1000 : 1001, source.func_180699_d(), 0);
        }
    }

    public static class BehaviorDispenseBoat
    extends BehaviorDefaultDispenseItem {
        private final BehaviorDefaultDispenseItem field_185026_b = new BehaviorDefaultDispenseItem();
        private final EntityBoat.Type field_185027_c;

        public BehaviorDispenseBoat(EntityBoat.Type boatTypeIn) {
            this.field_185027_c = boatTypeIn;
        }

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            double d3;
            EnumFacing enumfacing = (EnumFacing)((Object)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
            World world = source.func_197524_h();
            double d0 = source.func_82615_a() + (double)((float)enumfacing.func_82601_c() * 1.125f);
            double d1 = source.func_82617_b() + (double)((float)enumfacing.func_96559_d() * 1.125f);
            double d2 = source.func_82616_c() + (double)((float)enumfacing.func_82599_e() * 1.125f);
            BlockPos blockpos = source.func_180699_d().func_177972_a(enumfacing);
            if (world.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a)) {
                d3 = 1.0;
            } else {
                if (!world.func_180495_p(blockpos).func_196958_f() || !world.func_204610_c(blockpos.func_177977_b()).func_206884_a(FluidTags.field_206959_a)) {
                    return this.field_185026_b.dispense(source, stack);
                }
                d3 = 0.0;
            }
            EntityBoat entityboat = new EntityBoat(world, d0, d1 + d3, d2);
            entityboat.func_184458_a(this.field_185027_c);
            entityboat.field_70177_z = enumfacing.func_185119_l();
            world.func_72838_d(entityboat);
            stack.func_190918_g(1);
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
            source.func_197524_h().func_175718_b(1000, source.func_180699_d(), 0);
        }
    }
}

