/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityWitherSkull
extends EntityFireball {
    private static final DataParameter<Boolean> field_184565_e = EntityDataManager.func_187226_a(EntityWitherSkull.class, DataSerializers.field_187198_h);

    public EntityWitherSkull(World worldIn) {
        super(EntityType.field_200723_aB, worldIn, 0.3125f, 0.3125f);
    }

    public EntityWitherSkull(World worldIn, EntityLivingBase shooter, double accelX, double accelY, double accelZ) {
        super(EntityType.field_200723_aB, shooter, accelX, accelY, accelZ, worldIn, 0.3125f, 0.3125f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityWitherSkull(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(EntityType.field_200723_aB, x, y, z, accelX, accelY, accelZ, worldIn, 0.3125f, 0.3125f);
    }

    @Override
    protected float func_82341_c() {
        return this.func_82342_d() ? 0.73f : super.func_82341_c();
    }

    @Override
    public boolean func_70027_ad() {
        return false;
    }

    @Override
    public float func_180428_a(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, IBlockState blockStateIn, IFluidState p_180428_5_, float p_180428_6_) {
        return this.func_82342_d() && blockStateIn.canEntityDestroy(worldIn, pos, this) ? Math.min(0.8f, p_180428_6_) : p_180428_6_;
    }

    @Override
    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.field_72308_g != null) {
                if (this.field_70235_a != null) {
                    if (result.field_72308_g.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.field_70235_a), 8.0f)) {
                        if (result.field_72308_g.func_70089_S()) {
                            this.func_174815_a(this.field_70235_a, result.field_72308_g);
                        } else {
                            this.field_70235_a.func_70691_i(5.0f);
                        }
                    }
                } else {
                    result.field_72308_g.func_70097_a(DamageSource.field_76376_m, 5.0f);
                }
                if (result.field_72308_g instanceof EntityLivingBase) {
                    int i = 0;
                    if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                        i = 10;
                    } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        i = 40;
                    }
                    if (i > 0) {
                        ((EntityLivingBase)result.field_72308_g).func_195064_c(new PotionEffect(MobEffects.field_82731_v, 20 * i, 1));
                    }
                }
            }
            this.field_70170_p.func_72885_a(this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, false, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.field_70235_a));
            this.func_70106_y();
        }
    }

    @Override
    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184565_e, false);
    }

    public boolean func_82342_d() {
        return this.field_70180_af.func_187225_a(field_184565_e);
    }

    public void func_82343_e(boolean invulnerable) {
        this.field_70180_af.func_187227_b(field_184565_e, invulnerable);
    }

    @Override
    protected boolean func_184564_k() {
        return false;
    }
}

