/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class EntityArrow
extends Entity
implements IProjectile {
    private static final Predicate<Entity> field_184553_f = EntitySelectors.field_180132_d.and(EntitySelectors.field_94557_a.and(Entity::func_70067_L));
    private static final DataParameter<Byte> field_184554_g = EntityDataManager.func_187226_a(EntityArrow.class, DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> field_212362_a = EntityDataManager.func_187226_a(EntityArrow.class, DataSerializers.field_187203_m);
    private int field_145791_d = -1;
    private int field_145792_e = -1;
    private int field_145789_f = -1;
    @Nullable
    private IBlockState field_195056_av;
    protected boolean field_70254_i;
    protected int field_184552_b;
    public PickupStatus field_70251_a = PickupStatus.DISALLOWED;
    public int field_70249_b;
    public UUID field_70250_c;
    private int field_70252_j;
    private int field_70257_an;
    private double field_70255_ao = 2.0;
    private int field_70256_ap;

    protected EntityArrow(EntityType<?> type, World p_i48546_2_) {
        super(type, p_i48546_2_);
        this.func_70105_a(0.5f, 0.5f);
    }

    protected EntityArrow(EntityType<?> p_i48547_1_, double p_i48547_2_, double p_i48547_4_, double p_i48547_6_, World p_i48547_8_) {
        this(p_i48547_1_, p_i48547_8_);
        this.func_70107_b(p_i48547_2_, p_i48547_4_, p_i48547_6_);
    }

    protected EntityArrow(EntityType<?> p_i48548_1_, EntityLivingBase p_i48548_2_, World p_i48548_3_) {
        this(p_i48548_1_, p_i48548_2_.field_70165_t, p_i48548_2_.field_70163_u + (double)p_i48548_2_.func_70047_e() - (double)0.1f, p_i48548_2_.field_70161_v, p_i48548_3_);
        this.func_212361_a(p_i48548_2_);
        if (p_i48548_2_ instanceof EntityPlayer) {
            this.field_70251_a = PickupStatus.ALLOWED;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityArrow.func_184183_bd()) * d0;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184554_g, (byte)0);
        this.field_70180_af.func_187214_a(field_212362_a, Optional.empty());
    }

    public void func_184547_a(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.field_70252_j = 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.field_70252_j = 0;
        }
    }

    @Override
    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        IBlockState iblockstate;
        super.func_70071_h_();
        boolean flag = this.func_203047_q();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f))).isAir((IBlockReader)this.field_70170_p, blockpos) || flag || (voxelshape = iblockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.field_70254_i && !flag) {
            if (this.field_195056_av != iblockstate && this.field_70170_p.func_195586_b(null, this.func_174813_aQ().func_186662_g(0.05))) {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            } else {
                this.func_203048_f();
            }
            ++this.field_184552_b;
        } else {
            Entity entity;
            this.field_184552_b = 0;
            ++this.field_70257_an;
            Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_200259_a(vec3d, vec3d1, RayTraceFluidMode.NEVER, true, false);
            vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            if ((entity = this.func_184551_a(vec3d, vec3d1)) != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
                Entity entity1 = this.func_212360_k();
                if (entity1 instanceof EntityPlayer && !((EntityPlayer)entity1).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (raytraceresult != null && !flag && !ForgeEventFactory.onProjectileImpact((EntityArrow)this, (RayTraceResult)raytraceresult)) {
                this.func_184549_a(raytraceresult);
                this.field_70160_al = true;
            }
            if (this.func_70241_g()) {
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)Particles.field_197614_g, this.field_70165_t + this.field_70159_w * (double)j / 4.0, this.field_70163_u + this.field_70181_x * (double)j / 4.0, this.field_70161_v + this.field_70179_y * (double)j / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-this.field_70159_w), (double)(-this.field_70179_y)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f3) * 57.2957763671875);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f4 = 0.99f;
            float f1 = 0.05f;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    float f2 = 0.25f;
                    this.field_70170_p.func_195594_a((IParticleData)Particles.field_197612_e, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                f4 = this.func_203044_p();
            }
            this.field_70159_w *= (double)f4;
            this.field_70181_x *= (double)f4;
            this.field_70179_y *= (double)f4;
            if (!this.func_189652_ae() && !flag) {
                this.field_70181_x -= (double)0.05f;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    protected void func_203048_f() {
        ++this.field_70252_j;
        if (this.field_70252_j >= 1200) {
            this.func_70106_y();
        }
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        if (raytraceResultIn.field_72308_g != null) {
            this.func_203046_b(raytraceResultIn);
        } else {
            IBlockState iblockstate;
            BlockPos blockpos = raytraceResultIn.func_178782_a();
            this.field_145791_d = blockpos.func_177958_n();
            this.field_145792_e = blockpos.func_177956_o();
            this.field_145789_f = blockpos.func_177952_p();
            this.field_195056_av = iblockstate = this.field_70170_p.func_180495_p(blockpos);
            this.field_70159_w = (float)(raytraceResultIn.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(raytraceResultIn.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(raytraceResultIn.field_72307_f.field_72449_c - this.field_70161_v);
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)) * 20.0f;
            this.field_70165_t -= this.field_70159_w / (double)f;
            this.field_70163_u -= this.field_70181_x / (double)f;
            this.field_70161_v -= this.field_70179_y / (double)f;
            this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70254_i = true;
            this.field_70249_b = 7;
            this.func_70243_d(false);
            if (!iblockstate.isAir((IBlockReader)this.field_70170_p, blockpos)) {
                this.field_195056_av.func_196950_a(this.field_70170_p, blockpos, this);
            }
        }
    }

    protected void func_203046_b(RayTraceResult p_203046_1_) {
        Entity entity1;
        Entity entity = p_203046_1_.field_72308_g;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        int i = MathHelper.func_76143_f((double)((double)f * this.field_70255_ao));
        if (this.func_70241_g()) {
            i += this.field_70146_Z.nextInt(i / 2 + 2);
        }
        DamageSource damagesource = (entity1 = this.func_212360_k()) == null ? DamageSource.func_76353_a((EntityArrow)this, (Entity)this) : DamageSource.func_76353_a((EntityArrow)this, (Entity)entity1);
        if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(damagesource, i)) {
            if (entity instanceof EntityLivingBase) {
                float f1;
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                if (!this.field_70170_p.field_72995_K) {
                    entitylivingbase.func_85034_r(entitylivingbase.func_85035_bI() + 1);
                }
                if (this.field_70256_ap > 0 && (f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                    entitylivingbase.func_70024_g(this.field_70159_w * (double)this.field_70256_ap * (double)0.6f / (double)f1, 0.1, this.field_70179_y * (double)this.field_70256_ap * (double)0.6f / (double)f1);
                }
                if (entity1 instanceof EntityLivingBase) {
                    EnchantmentHelper.func_151384_a(entitylivingbase, entity1);
                    EnchantmentHelper.func_151385_b((EntityLivingBase)entity1, entitylivingbase);
                }
                this.func_184548_a(entitylivingbase);
                if (entity1 != null && entitylivingbase != entity1 && entitylivingbase instanceof EntityPlayer && entity1 instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)entity1).field_71135_a.func_147359_a((Packet<?>)new SPacketChangeGameState(6, 0.0f));
                }
            }
            this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (!(entity instanceof EntityEnderman)) {
                this.func_70106_y();
            }
        } else {
            this.field_70159_w *= (double)-0.1f;
            this.field_70181_x *= (double)-0.1f;
            this.field_70179_y *= (double)-0.1f;
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.field_70257_an = 0;
            if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                if (this.field_70251_a == PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    protected SoundEvent func_203050_i() {
        return SoundEvents.field_187731_t;
    }

    @Override
    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        if (this.field_70254_i) {
            this.field_145791_d = MathHelper.func_76128_c((double)this.field_70165_t);
            this.field_145792_e = MathHelper.func_76128_c((double)this.field_70163_u);
            this.field_145789_f = MathHelper.func_76128_c((double)this.field_70161_v);
        }
    }

    protected void func_184548_a(EntityLivingBase living) {
    }

    @Nullable
    protected Entity func_184551_a(Vec3d start, Vec3d end) {
        Entity entity = null;
        List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), field_184553_f);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = list.get(i);
            if (entity1 == this.func_212360_k() && this.field_70257_an < 5 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("xTile", this.field_145791_d);
        compound.func_74768_a("yTile", this.field_145792_e);
        compound.func_74768_a("zTile", this.field_145789_f);
        compound.func_74777_a("life", (short)this.field_70252_j);
        if (this.field_195056_av != null) {
            compound.func_74782_a("inBlockState", NBTUtil.func_190009_a((IBlockState)this.field_195056_av));
        }
        compound.func_74774_a("shake", (byte)this.field_70249_b);
        compound.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        compound.func_74774_a("pickup", (byte)this.field_70251_a.ordinal());
        compound.func_74780_a("damage", this.field_70255_ao);
        compound.func_74757_a("crit", this.func_70241_g());
        if (this.field_70250_c != null) {
            compound.func_186854_a("OwnerUUID", this.field_70250_c);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.field_145791_d = compound.func_74762_e("xTile");
        this.field_145792_e = compound.func_74762_e("yTile");
        this.field_145789_f = compound.func_74762_e("zTile");
        this.field_70252_j = compound.func_74765_d("life");
        if (compound.func_150297_b("inBlockState", 10)) {
            this.field_195056_av = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("inBlockState"));
        }
        this.field_70249_b = compound.func_74771_c("shake") & 0xFF;
        boolean bl = this.field_70254_i = compound.func_74771_c("inGround") == 1;
        if (compound.func_150297_b("damage", 99)) {
            this.field_70255_ao = compound.func_74769_h("damage");
        }
        if (compound.func_150297_b("pickup", 99)) {
            this.field_70251_a = PickupStatus.func_188795_a(compound.func_74771_c("pickup"));
        } else if (compound.func_150297_b("player", 99)) {
            this.field_70251_a = compound.func_74767_n("player") ? PickupStatus.ALLOWED : PickupStatus.DISALLOWED;
        }
        this.func_70243_d(compound.func_74767_n("crit"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.field_70250_c = compound.func_186857_a("OwnerUUID");
        }
    }

    public void func_212361_a(@Nullable Entity p_212361_1_) {
        this.field_70250_c = p_212361_1_ == null ? null : p_212361_1_.func_110124_au();
    }

    @Nullable
    public Entity func_212360_k() {
        return this.field_70250_c != null && this.field_70170_p instanceof WorldServer ? ((WorldServer)this.field_70170_p).func_175733_a(this.field_70250_c) : null;
    }

    @Override
    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && (this.field_70254_i || this.func_203047_q()) && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == PickupStatus.ALLOWED || this.field_70251_a == PickupStatus.CREATIVE_ONLY && entityIn.field_71075_bZ.field_75098_d || this.func_203047_q() && this.func_212360_k().func_110124_au() == entityIn.func_110124_au();
            if (this.field_70251_a == PickupStatus.ALLOWED && !entityIn.field_71071_by.func_70441_a(this.func_184550_j())) {
                flag = false;
            }
            if (flag) {
                entityIn.func_71001_a(this, 1);
                this.func_70106_y();
            }
        }
    }

    protected abstract ItemStack func_184550_j();

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70239_b(double damageIn) {
        this.field_70255_ao = damageIn;
    }

    public double func_70242_d() {
        return this.field_70255_ao;
    }

    public void func_70240_a(int knockbackStrengthIn) {
        this.field_70256_ap = knockbackStrengthIn;
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    public float func_70047_e() {
        return 0.0f;
    }

    public void func_70243_d(boolean critical) {
        this.func_203049_a(1, critical);
    }

    private void func_203049_a(int p_203049_1_, boolean p_203049_2_) {
        byte b0 = this.field_70180_af.func_187225_a(field_184554_g);
        if (p_203049_2_) {
            this.field_70180_af.func_187227_b(field_184554_g, (byte)(b0 | p_203049_1_));
        } else {
            this.field_70180_af.func_187227_b(field_184554_g, (byte)(b0 & ~p_203049_1_));
        }
    }

    public boolean func_70241_g() {
        byte b0 = this.field_70180_af.func_187225_a(field_184554_g);
        return (b0 & 1) != 0;
    }

    public void func_190547_a(EntityLivingBase p_190547_1_, float p_190547_2_) {
        int i = EnchantmentHelper.func_185284_a(Enchantments.field_185309_u, p_190547_1_);
        int j = EnchantmentHelper.func_185284_a(Enchantments.field_185310_v, p_190547_1_);
        this.func_70239_b((double)(p_190547_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            this.func_70239_b(this.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            this.func_70240_a(j);
        }
        if (EnchantmentHelper.func_185284_a(Enchantments.field_185311_w, p_190547_1_) > 0) {
            this.func_70015_d(100);
        }
    }

    protected float func_203044_p() {
        return 0.6f;
    }

    public void func_203045_n(boolean p_203045_1_) {
        this.field_70145_X = p_203045_1_;
        this.func_203049_a(2, p_203045_1_);
    }

    public boolean func_203047_q() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return (this.field_70180_af.func_187225_a(field_184554_g) & 2) != 0;
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static PickupStatus func_188795_a(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }
    }
}

