/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowGolem;
import net.minecraft.entity.ai.EntityAIHarvestFarmland;
import net.minecraft.entity.ai.EntityAILookAtTradePlayer;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIPlay;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITradePlayer;
import net.minecraft.entity.ai.EntityAIVillagerInteract;
import net.minecraft.entity.ai.EntityAIVillagerMate;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosestWithoutMoving;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityVillager
extends EntityAgeable
implements INpc,
IMerchant {
    private static final Logger field_190674_bx = LogManager.getLogger();
    private static final DataParameter<Integer> field_184752_bw = EntityDataManager.func_187226_a(EntityVillager.class, DataSerializers.field_187192_b);
    private int field_70955_e;
    private boolean field_70952_f;
    private boolean field_70953_g;
    private Village field_70954_d;
    @Nullable
    private EntityPlayer field_70962_h;
    @Nullable
    private MerchantRecipeList field_70963_i;
    private int field_70961_j;
    private boolean field_70959_by;
    private boolean field_175565_bs;
    private int field_70956_bz;
    private UUID field_82189_bL;
    private int field_175563_bv;
    private int field_175562_bw;
    private boolean field_82190_bM;
    private boolean field_175564_by;
    private final InventoryBasic field_175560_bz = new InventoryBasic((ITextComponent)new TextComponentString("Items"), 8);
    private static final ITradeList[][][][] field_175561_bA = new ITradeList[][][][]{{{{new EmeraldForItems(Items.field_151015_O, new PriceInfo(18, 22)), new EmeraldForItems(Items.field_151174_bG, new PriceInfo(15, 19)), new EmeraldForItems(Items.field_151172_bF, new PriceInfo(15, 19)), new ListItemForEmeralds(Items.field_151025_P, new PriceInfo(-4, -2))}, {new EmeraldForItems(Blocks.field_150423_aK, new PriceInfo(8, 13)), new ListItemForEmeralds(Items.field_151158_bO, new PriceInfo(-3, -2))}, {new EmeraldForItems(Blocks.field_150440_ba, new PriceInfo(7, 12)), new ListItemForEmeralds(Items.field_151034_e, new PriceInfo(-7, -5))}, {new ListItemForEmeralds(Items.field_151106_aX, new PriceInfo(-10, -6)), new ListItemForEmeralds(Blocks.field_150414_aQ, new PriceInfo(1, 1))}}, {{new EmeraldForItems(Items.field_151007_F, new PriceInfo(15, 20)), new EmeraldForItems(Items.field_151044_h, new PriceInfo(16, 24)), new ItemAndEmeraldToItem(Items.field_196086_aW, new PriceInfo(6, 6), Items.field_196102_ba, new PriceInfo(6, 6)), new ItemAndEmeraldToItem(Items.field_196087_aX, new PriceInfo(6, 6), Items.field_196104_bb, new PriceInfo(6, 6))}, {new ListEnchantedItemForEmeralds(Items.field_151112_aM, new PriceInfo(7, 8))}}, {{new EmeraldForItems(Blocks.field_196556_aL, new PriceInfo(16, 22)), new ListItemForEmeralds(Items.field_151097_aZ, new PriceInfo(3, 4))}, {new ListItemForEmeralds(new ItemStack(Blocks.field_196556_aL), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196557_aM), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196558_aN), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196559_aO), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196560_aP), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196561_aQ), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196562_aR), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196563_aS), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196564_aT), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196565_aU), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196566_aV), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196567_aW), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196568_aX), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196569_aY), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196570_aZ), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196602_ba), new PriceInfo(1, 2))}}, {{new EmeraldForItems(Items.field_151007_F, new PriceInfo(15, 20)), new ListItemForEmeralds(Items.field_151032_g, new PriceInfo(-12, -8))}, {new ListItemForEmeralds(Items.field_151031_f, new PriceInfo(2, 3)), new ItemAndEmeraldToItem(Blocks.field_150351_n, new PriceInfo(10, 10), Items.field_151145_ak, new PriceInfo(6, 10))}}}, {{{new EmeraldForItems(Items.field_151121_aF, new PriceInfo(24, 36)), new ListEnchantedBookForEmeralds()}, {new EmeraldForItems(Items.field_151122_aG, new PriceInfo(8, 10)), new ListItemForEmeralds(Items.field_151111_aL, new PriceInfo(10, 12)), new ListItemForEmeralds(Blocks.field_150342_X, new PriceInfo(3, 4))}, {new EmeraldForItems(Items.field_151164_bB, new PriceInfo(2, 2)), new ListItemForEmeralds(Items.field_151113_aN, new PriceInfo(10, 12)), new ListItemForEmeralds(Blocks.field_150359_w, new PriceInfo(-5, -3))}, {new ListEnchantedBookForEmeralds()}, {new ListEnchantedBookForEmeralds()}, {new ListItemForEmeralds(Items.field_151057_cb, new PriceInfo(20, 22))}}, {{new EmeraldForItems(Items.field_151121_aF, new PriceInfo(24, 36))}, {new EmeraldForItems(Items.field_151111_aL, new PriceInfo(1, 1))}, {new ListItemForEmeralds(Items.field_151148_bJ, new PriceInfo(7, 11))}, {new TreasureMapForEmeralds(new PriceInfo(12, 20), "Monument", MapDecoration.Type.MONUMENT), new TreasureMapForEmeralds(new PriceInfo(16, 28), "Mansion", MapDecoration.Type.MANSION)}}}, {{{new EmeraldForItems(Items.field_151078_bh, new PriceInfo(36, 40)), new EmeraldForItems(Items.field_151043_k, new PriceInfo(8, 10))}, {new ListItemForEmeralds(Items.field_151137_ax, new PriceInfo(-4, -1)), new ListItemForEmeralds(new ItemStack(Items.field_196128_bn), new PriceInfo(-2, -1))}, {new ListItemForEmeralds(Items.field_151079_bi, new PriceInfo(4, 7)), new ListItemForEmeralds(Blocks.field_150426_aN, new PriceInfo(-3, -1))}, {new ListItemForEmeralds(Items.field_151062_by, new PriceInfo(3, 11))}}}, {{{new EmeraldForItems(Items.field_151044_h, new PriceInfo(16, 24)), new ListItemForEmeralds(Items.field_151028_Y, new PriceInfo(4, 6))}, {new EmeraldForItems(Items.field_151042_j, new PriceInfo(7, 9)), new ListItemForEmeralds(Items.field_151030_Z, new PriceInfo(10, 14))}, {new EmeraldForItems(Items.field_151045_i, new PriceInfo(3, 4)), new ListEnchantedItemForEmeralds(Items.field_151163_ad, new PriceInfo(16, 19))}, {new ListItemForEmeralds(Items.field_151029_X, new PriceInfo(5, 7)), new ListItemForEmeralds(Items.field_151022_W, new PriceInfo(9, 11)), new ListItemForEmeralds(Items.field_151020_U, new PriceInfo(5, 7)), new ListItemForEmeralds(Items.field_151023_V, new PriceInfo(11, 15))}}, {{new EmeraldForItems(Items.field_151044_h, new PriceInfo(16, 24)), new ListItemForEmeralds(Items.field_151036_c, new PriceInfo(6, 8))}, {new EmeraldForItems(Items.field_151042_j, new PriceInfo(7, 9)), new ListEnchantedItemForEmeralds(Items.field_151040_l, new PriceInfo(9, 10))}, {new EmeraldForItems(Items.field_151045_i, new PriceInfo(3, 4)), new ListEnchantedItemForEmeralds(Items.field_151048_u, new PriceInfo(12, 15)), new ListEnchantedItemForEmeralds(Items.field_151056_x, new PriceInfo(9, 12))}}, {{new EmeraldForItems(Items.field_151044_h, new PriceInfo(16, 24)), new ListEnchantedItemForEmeralds(Items.field_151037_a, new PriceInfo(5, 7))}, {new EmeraldForItems(Items.field_151042_j, new PriceInfo(7, 9)), new ListEnchantedItemForEmeralds(Items.field_151035_b, new PriceInfo(9, 11))}, {new EmeraldForItems(Items.field_151045_i, new PriceInfo(3, 4)), new ListEnchantedItemForEmeralds(Items.field_151046_w, new PriceInfo(12, 15))}}}, {{{new EmeraldForItems(Items.field_151147_al, new PriceInfo(14, 18)), new EmeraldForItems(Items.field_151076_bf, new PriceInfo(14, 18))}, {new EmeraldForItems(Items.field_151044_h, new PriceInfo(16, 24)), new ListItemForEmeralds(Items.field_151157_am, new PriceInfo(-7, -5)), new ListItemForEmeralds(Items.field_151077_bg, new PriceInfo(-8, -6))}}, {{new EmeraldForItems(Items.field_151116_aA, new PriceInfo(9, 12)), new ListItemForEmeralds(Items.field_151026_S, new PriceInfo(2, 4))}, {new ListEnchantedItemForEmeralds(Items.field_151027_R, new PriceInfo(7, 12))}, {new ListItemForEmeralds(Items.field_151141_av, new PriceInfo(8, 10))}}}, {new ITradeList[0][]}};
    private VillagerRegistry.VillagerProfession prof;

    public EntityVillager(World worldIn) {
        this(worldIn, 0);
    }

    public EntityVillager(World worldIn, int professionId) {
        super(EntityType.field_200756_av, worldIn);
        this.func_70938_b(professionId);
        this.func_70105_a(0.6f, 1.95f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_98053_h(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityEvoker.class, 12.0f, 0.8, 0.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityVindicator.class, 8.0f, 0.8, 0.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityVex.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)((Object)this), true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIVillagerMate(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFollowGolem(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosestWithoutMoving((EntityLiving)((Object)this), EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIVillagerInteract(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityLiving.class, 8.0f));
    }

    private void func_175552_ct() {
        if (!this.field_175564_by) {
            this.field_175564_by = true;
            if (this.func_70631_g_()) {
                this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIPlay(this, 0.32));
            } else if (this.func_70946_n() == 0) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIHarvestFarmland(this, 0.6));
            }
        }
    }

    protected void func_175500_n() {
        if (this.func_70946_n() == 0) {
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIHarvestFarmland(this, 0.6));
        }
        super.func_175500_n();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected void func_70619_bc() {
        if (--this.field_70955_e <= 0) {
            BlockPos blockpos = new BlockPos((Entity)((Object)this));
            this.field_70170_p.func_175714_ae().func_176060_a(blockpos);
            this.field_70955_e = 70 + this.field_70146_Z.nextInt(50);
            this.field_70954_d = this.field_70170_p.func_175714_ae().func_176056_a(blockpos, 32);
            if (this.field_70954_d == null) {
                this.func_110177_bN();
            } else {
                BlockPos blockpos1 = this.field_70954_d.func_180608_a();
                this.func_175449_a(blockpos1, this.field_70954_d.func_75568_b());
                if (this.field_82190_bM) {
                    this.field_82190_bM = false;
                    this.field_70954_d.func_82683_b(5);
                }
            }
        }
        if (!this.func_70940_q() && this.field_70961_j > 0) {
            --this.field_70961_j;
            if (this.field_70961_j <= 0) {
                if (this.field_70959_by) {
                    for (MerchantRecipe merchantrecipe : this.field_70963_i) {
                        if (!merchantrecipe.func_82784_g()) continue;
                        merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    this.func_175554_cu();
                    this.field_70959_by = false;
                    if (this.field_70954_d != null && this.field_82189_bL != null) {
                        this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)14);
                        this.field_70954_d.modifyPlayerReputation(this.field_82189_bL, 1);
                    }
                }
                this.func_195064_c(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            itemstack.func_111282_a(player, (EntityLivingBase)((Object)this), hand);
            return true;
        }
        if (itemstack.func_77973_b() != Items.field_196172_da && this.func_70089_S() && !this.func_70940_q() && !this.func_70631_g_() && !player.func_70093_af()) {
            if (this.field_70963_i == null) {
                this.func_175554_cu();
            }
            if (hand == EnumHand.MAIN_HAND) {
                player.func_195066_a(StatList.field_188074_H);
            }
            if (!this.field_70170_p.field_72995_K && !this.field_70963_i.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a(this);
            } else if (this.field_70963_i.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184752_bw, 0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Profession", this.func_70946_n());
        compound.func_74778_a("ProfessionName", this.getProfessionForge().getRegistryName().toString());
        compound.func_74768_a("Riches", this.field_70956_bz);
        compound.func_74768_a("Career", this.field_175563_bv);
        compound.func_74768_a("CareerLevel", this.field_175562_bw);
        compound.func_74757_a("Willing", this.field_175565_bs);
        if (this.field_70963_i != null) {
            compound.func_74782_a("Offers", this.field_70963_i.func_77202_a());
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.field_175560_bz.func_70302_i_(); ++i) {
            ItemStack itemstack = this.field_175560_bz.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            nbttaglist.add((INBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Inventory", (INBTBase)nbttaglist);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_70938_b(compound.func_74762_e("Profession"));
        if (compound.func_74764_b("ProfessionName")) {
            VillagerRegistry.VillagerProfession p = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation(compound.func_74779_i("ProfessionName")));
            if (p == null) {
                p = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:farmer"));
            }
            this.setProfession(p);
        }
        this.field_70956_bz = compound.func_74762_e("Riches");
        this.field_175563_bv = compound.func_74762_e("Career");
        this.field_175562_bw = compound.func_74762_e("CareerLevel");
        this.field_175565_bs = compound.func_74767_n("Willing");
        if (compound.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("Offers");
            this.field_70963_i = new MerchantRecipeList(nbttagcompound);
        }
        NBTTagList nbttaglist = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            ItemStack itemstack = ItemStack.func_199557_a(nbttaglist.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.field_175560_bz.func_174894_a(itemstack);
        }
        this.func_98053_h(true);
        this.func_175552_ct();
    }

    public boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70940_q() ? SoundEvents.field_187914_gn : SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191184_at;
    }

    public void func_70938_b(int professionId) {
        this.field_70180_af.func_187227_b(field_184752_bw, professionId);
        VillagerRegistry.onSetProfession((EntityVillager)this, (int)professionId);
    }

    @Deprecated
    public int func_70946_n() {
        return Math.max(this.field_70180_af.func_187225_a(field_184752_bw), 0);
    }

    public void setProfession(VillagerRegistry.VillagerProfession prof) {
        this.prof = prof;
        this.func_70938_b(VillagerRegistry.getId((VillagerRegistry.VillagerProfession)prof));
    }

    public VillagerRegistry.VillagerProfession getProfessionForge() {
        if (this.prof == null) {
            this.prof = VillagerRegistry.getById((int)this.func_70946_n());
            if (this.prof == null) {
                return VillagerRegistry.getById((int)0);
            }
        }
        return this.prof;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key.equals(field_184752_bw)) {
            VillagerRegistry.onSetProfession((EntityVillager)this, (int)this.field_70180_af.func_187225_a(field_184752_bw));
        }
    }

    public boolean func_70941_o() {
        return this.field_70952_f;
    }

    public void func_70947_e(boolean mating) {
        this.field_70952_f = mating;
    }

    public void func_70939_f(boolean playing) {
        this.field_70953_g = playing;
    }

    public boolean func_70945_p() {
        return this.field_70953_g;
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (this.field_70954_d != null && livingBase != null) {
            this.field_70954_d.func_75575_a(livingBase);
            if (livingBase instanceof EntityPlayer) {
                int i = -1;
                if (this.func_70631_g_()) {
                    i = -3;
                }
                this.field_70954_d.modifyPlayerReputation(((EntityPlayer)livingBase).func_146103_bH().getId(), i);
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)13);
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (this.field_70954_d != null) {
            Entity entity = cause.func_76346_g();
            if (entity != null) {
                if (entity instanceof EntityPlayer) {
                    this.field_70954_d.modifyPlayerReputation(((EntityPlayer)entity).func_146103_bH().getId(), -2);
                } else if (entity instanceof IMob) {
                    this.field_70954_d.func_82692_h();
                }
            } else {
                EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)((Object)this), 16.0);
                if (entityplayer != null) {
                    this.field_70954_d.func_82692_h();
                }
            }
        }
        super.func_70645_a(cause);
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.field_70962_h = player;
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.field_70962_h;
    }

    public boolean func_70940_q() {
        return this.field_70962_h != null;
    }

    public boolean func_175550_n(boolean updateFirst) {
        if (!this.field_175565_bs && updateFirst && this.func_175553_cp()) {
            boolean flag = false;
            for (int i = 0; i < this.field_175560_bz.func_70302_i_(); ++i) {
                ItemStack itemstack = this.field_175560_bz.func_70301_a(i);
                if (!itemstack.func_190926_b()) {
                    if (itemstack.func_77973_b() == Items.field_151025_P && itemstack.func_190916_E() >= 3) {
                        flag = true;
                        this.field_175560_bz.func_70298_a(i, 3);
                    } else if ((itemstack.func_77973_b() == Items.field_151174_bG || itemstack.func_77973_b() == Items.field_151172_bF) && itemstack.func_190916_E() >= 12) {
                        flag = true;
                        this.field_175560_bz.func_70298_a(i, 12);
                    }
                }
                if (!flag) continue;
                this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)18);
                this.field_175565_bs = true;
                break;
            }
        }
        return this.field_175565_bs;
    }

    public void func_175549_o(boolean isWillingToMate) {
        this.field_175565_bs = isWillingToMate;
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.field_70961_j = 40;
            this.field_70959_by = true;
            this.field_175565_bs = true;
            this.field_82189_bL = this.field_70962_h != null ? this.field_70962_h.func_110124_au() : null;
            i += 5;
        }
        if (recipe.func_77394_a().func_77973_b() == Items.field_151166_bC) {
            this.field_70956_bz += recipe.func_77394_a().func_190916_E();
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d(new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
        if (this.field_70962_h instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192138_r.func_192234_a((EntityPlayerMP)this.field_70962_h, this, recipe.func_77397_d());
        }
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Nullable
    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.field_70963_i == null) {
            this.func_175554_cu();
        }
        return ForgeEventFactory.listTradeOffers((IMerchant)this, (EntityPlayer)player, (MerchantRecipeList)this.field_70963_i);
    }

    private void func_175554_cu() {
        if (this.field_175563_bv != 0 && this.field_175562_bw != 0) {
            ++this.field_175562_bw;
        } else {
            this.field_175563_bv = this.getProfessionForge().getRandomCareer(this.field_70146_Z) + 1;
            this.field_175562_bw = 1;
        }
        if (this.field_70963_i == null) {
            this.field_70963_i = new MerchantRecipeList();
        }
        int i = this.field_175563_bv - 1;
        int j = this.field_175562_bw - 1;
        List trades = this.getProfessionForge().getCareer(i).getTrades(j);
        if (i >= 0 && trades != null) {
            for (ITradeList entityvillager$itradelist : trades) {
                entityvillager$itradelist.func_190888_a(this, this.field_70963_i, this.field_70146_Z);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)((Object)this));
    }

    public ITextComponent func_145748_c_() {
        Team team = this.func_96124_cp();
        ITextComponent itextcomponent = this.func_200201_e();
        if (itextcomponent != null) {
            return ScorePlayerTeam.func_200541_a((Team)team, (ITextComponent)itextcomponent).func_211710_a(p_211519_1_ -> p_211519_1_.func_150209_a(this.func_174823_aP()).func_179989_a(this.func_189512_bd()));
        }
        if (this.field_70963_i == null) {
            this.func_175554_cu();
        }
        String s = null;
        switch (this.func_70946_n()) {
            case 0: {
                if (this.field_175563_bv == 1) {
                    s = "farmer";
                    break;
                }
                if (this.field_175563_bv == 2) {
                    s = "fisherman";
                    break;
                }
                if (this.field_175563_bv == 3) {
                    s = "shepherd";
                    break;
                }
                if (this.field_175563_bv != 4) break;
                s = "fletcher";
                break;
            }
            case 1: {
                if (this.field_175563_bv == 1) {
                    s = "librarian";
                    break;
                }
                if (this.field_175563_bv != 2) break;
                s = "cartographer";
                break;
            }
            case 2: {
                s = "cleric";
                break;
            }
            case 3: {
                if (this.field_175563_bv == 1) {
                    s = "armorer";
                    break;
                }
                if (this.field_175563_bv == 2) {
                    s = "weapon_smith";
                    break;
                }
                if (this.field_175563_bv != 3) break;
                s = "tool_smith";
                break;
            }
            case 4: {
                if (this.field_175563_bv == 1) {
                    s = "butcher";
                    break;
                }
                if (this.field_175563_bv != 2) break;
                s = "leatherworker";
                break;
            }
            case 5: {
                s = "nitwit";
            }
        }
        s = this.getProfessionForge().getCareer(this.field_175563_bv - 1).getName();
        ITextComponent itextcomponent1 = new TextComponentTranslation(this.func_200600_R().func_210760_d() + '.' + s, new Object[0]).func_211710_a(p_211520_1_ -> p_211520_1_.func_150209_a(this.func_174823_aP()).func_179989_a(this.func_189512_bd()));
        if (team != null) {
            itextcomponent1.func_211708_a(team.func_178775_l());
        }
        return itextcomponent1;
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? 0.81f : 1.62f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.func_195400_a((IParticleData)Particles.field_197633_z);
        } else if (id == 13) {
            this.func_195400_a((IParticleData)Particles.field_197609_b);
        } else if (id == 14) {
            this.func_195400_a((IParticleData)Particles.field_197632_y);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void func_195400_a(IParticleData p_195400_1_) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(p_195400_1_, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
        }
    }

    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData, @Nullable NBTTagCompound itemNbt) {
        return this.func_190672_a(difficulty, entityLivingData, itemNbt, true);
    }

    public IEntityLivingData func_190672_a(DifficultyInstance p_190672_1_, @Nullable IEntityLivingData p_190672_2_, @Nullable NBTTagCompound p_190672_3_, boolean p_190672_4_) {
        p_190672_2_ = super.func_204210_a(p_190672_1_, p_190672_2_, p_190672_3_);
        if (p_190672_4_) {
            VillagerRegistry.setRandomProfession((EntityVillager)this, (Random)this.field_70170_p.field_73012_v);
        }
        this.func_175552_ct();
        this.func_175554_cu();
        return p_190672_2_;
    }

    public void func_82187_q() {
        this.field_82190_bM = true;
    }

    public EntityVillager func_90011_a(EntityAgeable ageable) {
        EntityVillager entityvillager = new EntityVillager(this.field_70170_p);
        entityvillager.func_204210_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)((Object)entityvillager))), null, null);
        return entityvillager;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            EntityWitch entitywitch = new EntityWitch(this.field_70170_p);
            entitywitch.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitywitch.func_204210_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entitywitch)), (IEntityLivingData)null, (NBTTagCompound)null);
            entitywitch.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                entitywitch.func_200203_b(this.func_200201_e());
                entitywitch.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entitywitch);
            this.func_70106_y();
        }
    }

    public InventoryBasic func_175551_co() {
        return this.field_175560_bz;
    }

    protected void func_175445_a(EntityItem itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        Item item = itemstack.func_77973_b();
        if (this.func_175558_a(item)) {
            ItemStack itemstack1 = this.field_175560_bz.func_174894_a(itemstack);
            if (itemstack1.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    private boolean func_175558_a(Item itemIn) {
        return itemIn == Items.field_151025_P || itemIn == Items.field_151174_bG || itemIn == Items.field_151172_bF || itemIn == Items.field_151015_O || itemIn == Items.field_151014_N || itemIn == Items.field_185164_cV || itemIn == Items.field_185163_cU;
    }

    public boolean func_175553_cp() {
        return this.func_175559_s(1);
    }

    public boolean func_175555_cq() {
        return this.func_175559_s(2);
    }

    public boolean func_175557_cr() {
        boolean flag;
        boolean bl = flag = this.func_70946_n() == 0;
        if (flag) {
            return !this.func_175559_s(5);
        }
        return !this.func_175559_s(1);
    }

    private boolean func_175559_s(int multiplier) {
        boolean flag = this.func_70946_n() == 0;
        for (int i = 0; i < this.field_175560_bz.func_70302_i_(); ++i) {
            ItemStack itemstack = this.field_175560_bz.func_70301_a(i);
            Item item = itemstack.func_77973_b();
            int j = itemstack.func_190916_E();
            if (item == Items.field_151025_P && j >= 3 * multiplier || item == Items.field_151174_bG && j >= 12 * multiplier || item == Items.field_151172_bF && j >= 12 * multiplier || item == Items.field_185164_cV && j >= 12 * multiplier) {
                return true;
            }
            if (!flag || item != Items.field_151015_O || j < 9 * multiplier) continue;
            return true;
        }
        return false;
    }

    public boolean func_175556_cs() {
        for (int i = 0; i < this.field_175560_bz.func_70302_i_(); ++i) {
            Item item = this.field_175560_bz.func_70301_a(i).func_77973_b();
            if (item != Items.field_151014_N && item != Items.field_151174_bG && item != Items.field_151172_bF && item != Items.field_185163_cU) continue;
            return true;
        }
        return false;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (super.func_174820_d(inventorySlot, itemStackIn)) {
            return true;
        }
        int i = inventorySlot - 300;
        if (i >= 0 && i < this.field_175560_bz.func_70302_i_()) {
            this.field_175560_bz.func_70299_a(i, itemStackIn);
            return true;
        }
        return false;
    }

    @Deprecated
    public static ITradeList[][][][] GET_TRADES_DONT_USE() {
        return field_175561_bA;
    }

    static class TreasureMapForEmeralds
    implements ITradeList {
        public PriceInfo field_190889_a;
        public String field_190890_b;
        public MapDecoration.Type field_190891_c;

        public TreasureMapForEmeralds(PriceInfo p_i47340_1_, String p_i47340_2_, MapDecoration.Type p_i47340_3_) {
            this.field_190889_a = p_i47340_1_;
            this.field_190890_b = p_i47340_2_;
            this.field_190891_c = p_i47340_3_;
        }

        @Override
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int i = this.field_190889_a.func_179412_a(random);
            World world = merchant.func_190670_t_();
            BlockPos blockpos = world.func_211157_a(this.field_190890_b, merchant.func_190671_u_(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = ItemMap.func_195952_a(world, blockpos.func_177958_n(), blockpos.func_177952_p(), (byte)2, true, true);
                ItemMap.func_190905_a(world, itemstack);
                MapData.func_191094_a(itemstack, blockpos, "+", this.field_190891_c);
                itemstack.func_200302_a((ITextComponent)new TextComponentTranslation("filled_map." + this.field_190890_b.toLowerCase(Locale.ROOT), new Object[0]));
                recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, i), new ItemStack(Items.field_151111_aL), itemstack));
            }
        }
    }

    public static class PriceInfo
    extends Tuple<Integer, Integer> {
        public PriceInfo(int p_i45810_1_, int p_i45810_2_) {
            super((Object)p_i45810_1_, (Object)p_i45810_2_);
            if (p_i45810_2_ < p_i45810_1_) {
                field_190674_bx.warn("PriceRange({}, {}) invalid, {} smaller than {}", (Object)p_i45810_1_, (Object)p_i45810_2_, (Object)p_i45810_2_, (Object)p_i45810_1_);
            }
        }

        public int func_179412_a(Random rand) {
            return (Integer)this.func_76341_a() >= (Integer)this.func_76340_b() ? (Integer)this.func_76341_a() : (Integer)this.func_76341_a() + rand.nextInt((Integer)this.func_76340_b() - (Integer)this.func_76341_a() + 1);
        }
    }

    public static class ListItemForEmeralds
    implements ITradeList {
        public ItemStack field_179403_a;
        public PriceInfo field_179402_b;

        public ListItemForEmeralds(Block p_i48004_1_, PriceInfo p_i48004_2_) {
            this(new ItemStack(p_i48004_1_), p_i48004_2_);
        }

        public ListItemForEmeralds(Item par1Item, PriceInfo priceInfo) {
            this(new ItemStack(par1Item), priceInfo);
        }

        public ListItemForEmeralds(ItemStack stack, PriceInfo priceInfo) {
            this.field_179403_a = stack;
            this.field_179402_b = priceInfo;
        }

        @Override
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            ItemStack itemstack1;
            ItemStack itemstack;
            int i = 1;
            if (this.field_179402_b != null) {
                i = this.field_179402_b.func_179412_a(random);
            }
            if (i < 0) {
                itemstack = new ItemStack(Items.field_151166_bC);
                itemstack1 = new ItemStack(this.field_179403_a.func_77973_b(), -i);
            } else {
                itemstack = new ItemStack(Items.field_151166_bC, i);
                itemstack1 = new ItemStack(this.field_179403_a.func_77973_b());
            }
            recipeList.add((Object)new MerchantRecipe(itemstack, itemstack1));
        }
    }

    public static class ListEnchantedItemForEmeralds
    implements ITradeList {
        public ItemStack field_179407_a;
        public PriceInfo field_179406_b;

        public ListEnchantedItemForEmeralds(Item p_i45814_1_, PriceInfo p_i45814_2_) {
            this.field_179407_a = new ItemStack(p_i45814_1_);
            this.field_179406_b = p_i45814_2_;
        }

        @Override
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int i = 1;
            if (this.field_179406_b != null) {
                i = this.field_179406_b.func_179412_a(random);
            }
            ItemStack itemstack = new ItemStack(Items.field_151166_bC, i);
            ItemStack itemstack1 = EnchantmentHelper.func_77504_a(random, new ItemStack(this.field_179407_a.func_77973_b()), 5 + random.nextInt(15), false);
            recipeList.add((Object)new MerchantRecipe(itemstack, itemstack1));
        }
    }

    public static class ListEnchantedBookForEmeralds
    implements ITradeList {
        @Override
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            Enchantment enchantment = IRegistry.field_212628_q.func_186801_a(random);
            int i = MathHelper.func_76136_a((Random)random, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
            ItemStack itemstack = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, i));
            int j = 2 + random.nextInt(5 + i * 10) + 3 * i;
            if (enchantment.func_185261_e()) {
                j *= 2;
            }
            if (j > 64) {
                j = 64;
            }
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151122_aG), new ItemStack(Items.field_151166_bC, j), itemstack));
        }
    }

    public static class ItemAndEmeraldToItem
    implements ITradeList {
        public ItemStack field_199763_a;
        public PriceInfo field_179409_b;
        public ItemStack field_199764_c;
        public PriceInfo field_179408_d;

        public ItemAndEmeraldToItem(IItemProvider p_i48215_1_, PriceInfo p_i48215_2_, Item p_i48215_3_, PriceInfo p_i48215_4_) {
            this.field_199763_a = new ItemStack(p_i48215_1_);
            this.field_179409_b = p_i48215_2_;
            this.field_199764_c = new ItemStack(p_i48215_3_);
            this.field_179408_d = p_i48215_4_;
        }

        @Override
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int i = this.field_179409_b.func_179412_a(random);
            int j = this.field_179408_d.func_179412_a(random);
            recipeList.add((Object)new MerchantRecipe(new ItemStack(this.field_199763_a.func_77973_b(), i), new ItemStack(Items.field_151166_bC), new ItemStack(this.field_199764_c.func_77973_b(), j)));
        }
    }

    public static interface ITradeList {
        public void func_190888_a(IMerchant var1, MerchantRecipeList var2, Random var3);
    }

    public static class EmeraldForItems
    implements ITradeList {
        public Item field_179405_a;
        public PriceInfo field_179404_b;

        public EmeraldForItems(IItemProvider p_i48216_1_, PriceInfo p_i48216_2_) {
            this.field_179405_a = p_i48216_1_.func_199767_j();
            this.field_179404_b = p_i48216_2_;
        }

        @Override
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            ItemStack itemstack = new ItemStack(this.field_179405_a, this.field_179404_b == null ? 1 : this.field_179404_b.func_179412_a(random));
            recipeList.add((Object)new MerchantRecipe(itemstack, Items.field_151166_bC));
        }
    }
}

