/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.ForgeEventFactory;

public class EntitySilverfish
extends EntityMob {
    private AISummonSilverfish field_175460_b;

    public EntitySilverfish(World worldIn) {
        super(EntityType.field_200740_af, worldIn);
        this.func_70105_a(0.4f, 0.3f);
    }

    protected void func_184651_r() {
        this.field_175460_b = new AISummonSilverfish(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)((Object)this)));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.field_175460_b);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIHideInStone(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public double func_70033_W() {
        return 0.1;
    }

    public float func_70047_e() {
        return 0.1f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187793_eY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187850_fa;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187795_eZ;
    }

    protected void func_180429_a(BlockPos pos, IBlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187852_fb, 0.15f, 1.0f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if ((source instanceof EntityDamageSource || source == DamageSource.field_76376_m) && this.field_175460_b != null) {
            this.field_175460_b.func_179462_f();
        }
        return super.func_70097_a(source, amount);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186438_t;
    }

    public void func_70071_h_() {
        this.field_70761_aq = this.field_70177_z;
        super.func_70071_h_();
    }

    public void func_181013_g(float offset) {
        this.field_70177_z = offset;
        super.func_181013_g(offset);
    }

    public float func_205022_a(BlockPos p_205022_1_, IWorldReaderBase worldIn) {
        return BlockSilverfish.func_196466_i((IBlockState)worldIn.func_180495_p(p_205022_1_.func_177977_b())) ? 10.0f : super.func_205022_a(p_205022_1_, worldIn);
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_205020_a(IWorld worldIn, boolean p_205020_2_) {
        if (super.func_205020_a(worldIn, p_205020_2_)) {
            EntityPlayer entityplayer = worldIn.func_184136_b((Entity)((Object)this), 5.0);
            return entityplayer == null;
        }
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.ARTHROPOD;
    }

    static class AISummonSilverfish
    extends EntityAIBase {
        private final EntitySilverfish field_179464_a;
        private int field_179463_b;

        public AISummonSilverfish(EntitySilverfish silverfishIn) {
            this.field_179464_a = silverfishIn;
        }

        public void func_179462_f() {
            if (this.field_179463_b == 0) {
                this.field_179463_b = 20;
            }
        }

        public boolean func_75250_a() {
            return this.field_179463_b > 0;
        }

        public void func_75246_d() {
            --this.field_179463_b;
            if (this.field_179463_b <= 0) {
                World world = this.field_179464_a.field_70170_p;
                Random random = this.field_179464_a.func_70681_au();
                BlockPos blockpos = new BlockPos((Entity)((Object)this.field_179464_a));
                int i = 0;
                while (i <= 5 && i >= -5) {
                    int j = 0;
                    while (j <= 10 && j >= -10) {
                        int k = 0;
                        while (k <= 10 && k >= -10) {
                            BlockPos blockpos1 = blockpos.func_177982_a(j, i, k);
                            IBlockState iblockstate = world.func_180495_p(blockpos1);
                            Block block = iblockstate.func_177230_c();
                            if (block instanceof BlockSilverfish) {
                                if (ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)((Object)this.field_179464_a))) {
                                    world.func_175655_b(blockpos1, true);
                                } else {
                                    world.func_180501_a(blockpos1, ((BlockSilverfish)block).func_196468_d().func_176223_P(), 3);
                                }
                                if (random.nextBoolean()) {
                                    return;
                                }
                            }
                            k = (k <= 0 ? 1 : 0) - k;
                        }
                        j = (j <= 0 ? 1 : 0) - j;
                    }
                    i = (i <= 0 ? 1 : 0) - i;
                }
            }
        }
    }

    static class AIHideInStone
    extends EntityAIWander {
        private EnumFacing field_179483_b;
        private boolean field_179484_c;

        public AIHideInStone(EntitySilverfish silverfishIn) {
            super((EntityCreature)silverfishIn, 1.0, 10);
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (this.field_75457_a.func_70638_az() != null) {
                return false;
            }
            if (!this.field_75457_a.func_70661_as().func_75500_f()) {
                return false;
            }
            Random random = this.field_75457_a.func_70681_au();
            if (ForgeEventFactory.getMobGriefingEvent((World)this.field_75457_a.field_70170_p, (Entity)this.field_75457_a) && random.nextInt(10) == 0) {
                this.field_179483_b = EnumFacing.func_176741_a(random);
                BlockPos blockpos = new BlockPos(this.field_75457_a.field_70165_t, this.field_75457_a.field_70163_u + 0.5, this.field_75457_a.field_70161_v).func_177972_a(this.field_179483_b);
                IBlockState iblockstate = this.field_75457_a.field_70170_p.func_180495_p(blockpos);
                if (BlockSilverfish.func_196466_i((IBlockState)iblockstate)) {
                    this.field_179484_c = true;
                    return true;
                }
            }
            this.field_179484_c = false;
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return this.field_179484_c ? false : super.func_75253_b();
        }

        public void func_75249_e() {
            if (!this.field_179484_c) {
                super.func_75249_e();
            } else {
                World iworld = this.field_75457_a.field_70170_p;
                BlockPos blockpos = new BlockPos(this.field_75457_a.field_70165_t, this.field_75457_a.field_70163_u + 0.5, this.field_75457_a.field_70161_v).func_177972_a(this.field_179483_b);
                IBlockState iblockstate = iworld.func_180495_p(blockpos);
                if (BlockSilverfish.func_196466_i((IBlockState)iblockstate)) {
                    iworld.func_180501_a(blockpos, BlockSilverfish.func_196467_h((Block)iblockstate.func_177230_c()), 3);
                    this.field_75457_a.func_70656_aK();
                    this.field_75457_a.func_70106_y();
                }
            }
        }
    }
}

