/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityEnderman
extends EntityMob {
    private static final UUID field_110192_bp = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier field_110193_bq = new AttributeModifier(field_110192_bp, "Attacking speed boost", (double)0.15f, 0).func_111168_a(false);
    private static final DataParameter<Optional<IBlockState>> field_184718_bv = EntityDataManager.func_187226_a(EntityEnderman.class, DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> field_184719_bw = EntityDataManager.func_187226_a(EntityEnderman.class, DataSerializers.field_187198_h);
    private int field_184720_bx;
    private int field_184721_by;

    public EntityEnderman(World worldIn) {
        super(EntityType.field_200803_q, worldIn);
        this.func_70105_a(0.6f, 2.9f);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)((Object)this)));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)((Object)this)));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new AIPlaceBlock(this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new AITakeBlock(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIFindPlayer(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityEndermite.class, 10, true, false, EntityEndermite::func_175495_n));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (entitylivingbaseIn == null) {
            this.field_184721_by = 0;
            this.field_70180_af.func_187227_b(field_184719_bw, false);
            iattributeinstance.func_111124_b(field_110193_bq);
        } else {
            this.field_184721_by = this.field_70173_aa;
            this.field_70180_af.func_187227_b(field_184719_bw, true);
            if (!iattributeinstance.func_180374_a(field_110193_bq)) {
                iattributeinstance.func_111121_a(field_110193_bq);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184718_bv, Optional.empty());
        this.field_70180_af.func_187214_a(field_184719_bw, false);
    }

    public void func_184716_o() {
        if (this.field_70173_aa >= this.field_184720_bx + 400) {
            this.field_184720_bx = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (field_184719_bw.equals(key) && this.func_70823_r() && this.field_70170_p.field_72995_K) {
            this.func_184716_o();
        }
        super.func_184206_a(key);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        IBlockState iblockstate = this.func_195405_dq();
        if (iblockstate != null) {
            compound.func_74782_a("carriedBlockState", NBTUtil.func_190009_a((IBlockState)iblockstate));
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        IBlockState iblockstate = null;
        if (compound.func_150297_b("carriedBlockState", 10) && (iblockstate = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("carriedBlockState"))).func_196958_f()) {
            iblockstate = null;
        }
        this.func_195406_b(iblockstate);
    }

    private boolean func_70821_d(EntityPlayer player) {
        ItemStack itemstack = (ItemStack)((Object)player.field_71071_by.field_70460_b.get(3));
        if (itemstack.func_77973_b() == Blocks.field_196625_cS.func_199767_j()) {
            return false;
        }
        Vec3d vec3d = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(this.field_70165_t - player.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e()), this.field_70161_v - player.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)((Object)this)) : false;
    }

    public float func_70047_e() {
        return 2.55f;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)Particles.field_197599_J, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        float f;
        if (this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.field_70170_p.func_72935_r() && this.field_70173_aa >= this.field_184721_by + 600 && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_175678_i(new BlockPos((Entity)((Object)this))) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.func_70624_b(null);
            this.func_70820_n();
        }
        super.func_70619_bc();
    }

    protected boolean func_70820_n() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.func_70825_j(d0, d1, d2);
    }

    protected boolean func_70816_c(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.func_70825_j(d1, d2, d3);
    }

    private boolean func_70825_j(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)((Object)this), x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70823_r() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187531_aU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        IBlockState iblockstate = this.func_195405_dq();
        if (iblockstate != null) {
            this.func_199703_a(iblockstate.func_177230_c());
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186439_u;
    }

    public void func_195406_b(@Nullable IBlockState p_195406_1_) {
        this.field_70180_af.func_187227_b(field_184718_bv, Optional.ofNullable(p_195406_1_));
    }

    @Nullable
    public IBlockState func_195405_dq() {
        return this.field_70180_af.func_187225_a(field_184718_bv).orElse(null);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect) {
            for (int i = 0; i < 64; ++i) {
                if (!this.func_70820_n()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
            this.func_70820_n();
        }
        return flag;
    }

    public boolean func_70823_r() {
        return this.field_70180_af.func_187225_a(field_184719_bw);
    }

    static class AITakeBlock
    extends EntityAIBase {
        private final EntityEnderman field_179473_a;

        public AITakeBlock(EntityEnderman p_i45841_1_) {
            this.field_179473_a = p_i45841_1_;
        }

        public boolean func_75250_a() {
            if (this.field_179473_a.func_195405_dq() != null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_179473_a.field_70170_p, (Entity)((Object)this.field_179473_a))) {
                return false;
            }
            return this.field_179473_a.func_70681_au().nextInt(20) == 0;
        }

        public void func_75246_d() {
            boolean flag;
            Random random = this.field_179473_a.func_70681_au();
            World world = this.field_179473_a.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.field_179473_a.field_70165_t - 2.0 + random.nextDouble() * 4.0));
            int j = MathHelper.func_76128_c((double)(this.field_179473_a.field_70163_u + random.nextDouble() * 3.0));
            int k = MathHelper.func_76128_c((double)(this.field_179473_a.field_70161_v - 2.0 + random.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            RayTraceResult raytraceresult = world.func_200259_a(new Vec3d((float)MathHelper.func_76128_c((double)this.field_179473_a.field_70165_t) + 0.5f, (float)j + 0.5f, (float)MathHelper.func_76128_c((double)this.field_179473_a.field_70161_v) + 0.5f), new Vec3d((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f), RayTraceFluidMode.NEVER, true, false);
            boolean bl = flag = raytraceresult != null && raytraceresult.func_178782_a().equals((Object)blockpos);
            if (block.func_203417_a(BlockTags.field_201151_l) && flag) {
                this.field_179473_a.func_195406_b(iblockstate);
                world.func_175698_g(blockpos);
            }
        }
    }

    static class AIPlaceBlock
    extends EntityAIBase {
        private final EntityEnderman field_179475_a;

        public AIPlaceBlock(EntityEnderman p_i45843_1_) {
            this.field_179475_a = p_i45843_1_;
        }

        public boolean func_75250_a() {
            if (this.field_179475_a.func_195405_dq() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_179475_a.field_70170_p, (Entity)((Object)this.field_179475_a))) {
                return false;
            }
            return this.field_179475_a.func_70681_au().nextInt(2000) == 0;
        }

        public void func_75246_d() {
            Random random = this.field_179475_a.func_70681_au();
            World iworld = this.field_179475_a.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.field_179475_a.field_70165_t - 1.0 + random.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.field_179475_a.field_70163_u + random.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.field_179475_a.field_70161_v - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState iblockstate = iworld.func_180495_p(blockpos);
            IBlockState iblockstate1 = iworld.func_180495_p(blockpos.func_177977_b());
            IBlockState iblockstate2 = this.field_179475_a.func_195405_dq();
            if (iblockstate2 != null && this.func_195924_a(iworld, blockpos, iblockstate2, iblockstate, iblockstate1) && !ForgeEventFactory.onBlockPlace((Entity)((Object)this.field_179475_a), (BlockSnapshot)new BlockSnapshot(this.field_179475_a.field_70170_p, blockpos, iblockstate), (EnumFacing)EnumFacing.UP)) {
                iworld.func_180501_a(blockpos, iblockstate2, 3);
                this.field_179475_a.func_195406_b(null);
            }
        }

        private boolean func_195924_a(IWorldReaderBase p_195924_1_, BlockPos p_195924_2_, IBlockState p_195924_3_, IBlockState p_195924_4_, IBlockState p_195924_5_) {
            return p_195924_4_.func_196958_f() && !p_195924_5_.func_196958_f() && p_195924_5_.func_185917_h() && p_195924_3_.func_196955_c(p_195924_1_, p_195924_2_);
        }
    }

    static class AIFindPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        private final EntityEnderman field_179449_j;
        private EntityPlayer field_179448_g;
        private int field_179450_h;
        private int field_179451_i;

        public AIFindPlayer(EntityEnderman p_i45842_1_) {
            super((EntityCreature)p_i45842_1_, EntityPlayer.class, false);
            this.field_179449_j = p_i45842_1_;
        }

        public boolean func_75250_a() {
            double d0 = this.func_111175_f();
            this.field_179448_g = this.field_179449_j.field_70170_p.func_184150_a(this.field_179449_j.field_70165_t, this.field_179449_j.field_70163_u, this.field_179449_j.field_70161_v, d0, d0, null, p_210295_1_ -> p_210295_1_ != null && this.field_179449_j.func_70821_d(p_210295_1_));
            return this.field_179448_g != null;
        }

        public void func_75249_e() {
            this.field_179450_h = 5;
            this.field_179451_i = 0;
        }

        public void func_75251_c() {
            this.field_179448_g = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.field_179448_g != null) {
                if (!this.field_179449_j.func_70821_d(this.field_179448_g)) {
                    return false;
                }
                this.field_179449_j.func_70625_a(this.field_179448_g, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && ((EntityPlayer)this.field_75309_a).func_70089_S() ? true : super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.field_179448_g != null) {
                if (--this.field_179450_h <= 0) {
                    this.field_75309_a = this.field_179448_g;
                    this.field_179448_g = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null) {
                    if (this.field_179449_j.func_70821_d((EntityPlayer)this.field_75309_a)) {
                        if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)((Object)this.field_179449_j)) < 16.0) {
                            this.field_179449_j.func_70820_n();
                        }
                        this.field_179451_i = 0;
                    } else if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)((Object)this.field_179449_j)) > 256.0 && this.field_179451_i++ >= 30 && this.field_179449_j.func_70816_c(this.field_75309_a)) {
                        this.field_179451_i = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

