/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityXPOrb
extends Entity {
    public int field_70533_a;
    public int field_70531_b;
    public int field_70532_c;
    private int field_70529_d = 5;
    public int field_70530_e;
    private EntityPlayer field_80001_f;
    private int field_80002_g;

    public EntityXPOrb(World worldIn, double x, double y, double z, int expValue) {
        super(EntityType.field_200807_u, worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(Math.random() * 360.0);
        this.field_70159_w = (float)(Math.random() * (double)0.2f - (double)0.1f) * 2.0f;
        this.field_70181_x = (float)(Math.random() * 0.2) * 2.0f;
        this.field_70179_y = (float)(Math.random() * (double)0.2f - (double)0.1f) * 2.0f;
        this.field_70530_e = expValue;
    }

    public EntityXPOrb(World worldIn) {
        super(EntityType.field_200807_u, worldIn);
        this.func_70105_a(0.25f, 0.25f);
    }

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        float f = 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        int i = super.func_70070_b();
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    @Override
    public void func_70071_h_() {
        double d3;
        double d2;
        double d1;
        double d4;
        double d5;
        super.func_70071_h_();
        if (this.field_70532_c > 0) {
            --this.field_70532_c;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.func_208600_a(FluidTags.field_206959_a)) {
            this.func_205711_k();
        } else if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.03f;
        }
        if (this.field_70170_p.func_204610_c(new BlockPos((Entity)this)).func_206884_a(FluidTags.field_206960_b)) {
            this.field_70181_x = 0.2f;
            this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        double d0 = 8.0;
        if (this.field_80002_g < this.field_70533_a - 20 + this.func_145782_y() % 100) {
            if (this.field_80001_f == null || this.field_80001_f.func_70068_e(this) > 64.0) {
                this.field_80001_f = this.field_70170_p.func_72890_a(this, 8.0);
            }
            this.field_80002_g = this.field_70533_a;
        }
        if (this.field_80001_f != null && this.field_80001_f.func_175149_v()) {
            this.field_80001_f = null;
        }
        if (this.field_80001_f != null && (d5 = 1.0 - (d4 = Math.sqrt((d1 = (this.field_80001_f.field_70165_t - this.field_70165_t) / 8.0) * d1 + (d2 = (this.field_80001_f.field_70163_u + (double)this.field_80001_f.func_70047_e() / 2.0 - this.field_70163_u) / 8.0) * d2 + (d3 = (this.field_80001_f.field_70161_v - this.field_70161_v) / 8.0) * d3))) > 0.0) {
            d5 *= d5;
            this.field_70159_w += d1 / d4 * d5 * 0.1;
            this.field_70181_x += d2 / d4 * d5 * 0.1;
            this.field_70179_y += d3 / d4 * d5 * 0.1;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = 0.98f;
        if (this.field_70122_E) {
            BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            f = this.field_70170_p.func_180495_p(underPos).getSlipperiness(this.field_70170_p, underPos, this) * 0.98f;
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= (double)-0.9f;
        }
        ++this.field_70533_a;
        ++this.field_70531_b;
        if (this.field_70531_b >= 6000) {
            this.func_70106_y();
        }
    }

    private void func_205711_k() {
        this.field_70181_x += (double)5.0E-4f;
        this.field_70181_x = Math.min(this.field_70181_x, (double)0.06f);
        this.field_70159_w *= (double)0.99f;
        this.field_70179_y *= (double)0.99f;
    }

    @Override
    protected void func_71061_d_() {
    }

    @Override
    protected void func_70081_e(int amount) {
        this.func_70097_a(DamageSource.field_76372_a, amount);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        this.field_70529_d = (int)((float)this.field_70529_d - amount);
        if (this.field_70529_d <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Health", (short)this.field_70529_d);
        compound.func_74777_a("Age", (short)this.field_70531_b);
        compound.func_74777_a("Value", (short)this.field_70530_e);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.field_70529_d = compound.func_74765_d("Health");
        this.field_70531_b = compound.func_74765_d("Age");
        this.field_70530_e = compound.func_74765_d("Value");
    }

    @Override
    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && this.field_70532_c == 0 && entityIn.field_71090_bL == 0) {
            if (MinecraftForge.EVENT_BUS.post((Event)new PlayerPickupXpEvent(entityIn, this))) {
                return;
            }
            entityIn.field_71090_bL = 2;
            entityIn.func_71001_a(this, 1);
            ItemStack itemstack = EnchantmentHelper.func_92099_a(Enchantments.field_185296_A, entityIn);
            if (!itemstack.func_190926_b() && itemstack.func_77951_h()) {
                float ratio = itemstack.func_77973_b().getXpRepairRatio(itemstack);
                int i = Math.min(EntityXPOrb.roundAverage((float)this.field_70530_e * ratio), itemstack.func_77952_i());
                this.field_70530_e -= EntityXPOrb.roundAverage((float)i / ratio);
                itemstack.func_196085_b(itemstack.func_77952_i() - i);
            }
            if (this.field_70530_e > 0) {
                entityIn.func_195068_e(this.field_70530_e);
            }
            this.func_70106_y();
        }
    }

    private int func_184515_b(int durability) {
        return durability / 2;
    }

    private int func_184514_c(int xp) {
        return xp * 2;
    }

    public int func_70526_d() {
        return this.field_70530_e;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70528_g() {
        if (this.field_70530_e >= 2477) {
            return 10;
        }
        if (this.field_70530_e >= 1237) {
            return 9;
        }
        if (this.field_70530_e >= 617) {
            return 8;
        }
        if (this.field_70530_e >= 307) {
            return 7;
        }
        if (this.field_70530_e >= 149) {
            return 6;
        }
        if (this.field_70530_e >= 73) {
            return 5;
        }
        if (this.field_70530_e >= 37) {
            return 4;
        }
        if (this.field_70530_e >= 17) {
            return 3;
        }
        if (this.field_70530_e >= 7) {
            return 2;
        }
        return this.field_70530_e >= 3 ? 1 : 0;
    }

    public static int func_70527_a(int expValue) {
        if (expValue >= 2477) {
            return 2477;
        }
        if (expValue >= 1237) {
            return 1237;
        }
        if (expValue >= 617) {
            return 617;
        }
        if (expValue >= 307) {
            return 307;
        }
        if (expValue >= 149) {
            return 149;
        }
        if (expValue >= 73) {
            return 73;
        }
        if (expValue >= 37) {
            return 37;
        }
        if (expValue >= 17) {
            return 17;
        }
        if (expValue >= 7) {
            return 7;
        }
        return expValue >= 3 ? 3 : 1;
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    private static int roundAverage(float value) {
        double floor = Math.floor(value);
        return (int)floor + (Math.random() < (double)value - floor ? 1 : 0);
    }
}

