/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class EntityMinecartContainer
extends EntityMinecart
implements ILockableContainer,
ILootContainer {
    private NonNullList<ItemStack> field_94113_a = NonNullList.func_191197_a((int)36, (Object)((Object)ItemStack.field_190927_a));
    public boolean field_94112_b = true;
    private ResourceLocation field_184290_c;
    private long field_184291_d;
    private LazyOptional<?> itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this));

    protected EntityMinecartContainer(EntityType<?> p_i48536_1_, World p_i48536_2_) {
        super(p_i48536_1_, p_i48536_2_);
    }

    protected EntityMinecartContainer(EntityType<?> p_i48537_1_, double p_i48537_2_, double p_i48537_4_, double p_i48537_6_, World p_i48537_8_) {
        super(p_i48537_1_, p_i48537_8_, p_i48537_2_, p_i48537_4_, p_i48537_6_);
    }

    @Override
    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this);
        }
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.field_94113_a) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        this.func_184288_f(null);
        return (ItemStack)((Object)this.field_94113_a.get(index));
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_184288_f(null);
        return ItemStackHelper.func_188382_a(this.field_94113_a, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        this.func_184288_f(null);
        ItemStack itemstack = (ItemStack)((Object)this.field_94113_a.get(index));
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.field_94113_a.set(index, (Object)ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184288_f(null);
        this.field_94113_a.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    @Override
    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (inventorySlot >= 0 && inventorySlot < this.func_70302_i_()) {
            this.func_70299_a(inventorySlot, itemStackIn);
            return true;
        }
        return false;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_70128_L) {
            return false;
        }
        return !(player.func_70068_e(this) > 64.0);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    @Nullable
    public Entity changeDimension(DimensionType p_212321_1_, ITeleporter teleporter) {
        this.field_94112_b = false;
        return super.changeDimension(p_212321_1_, teleporter);
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
    }

    @Override
    public void remove(boolean keepData) {
        if (this.field_94112_b) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this);
        }
        super.remove(keepData);
        if (!keepData) {
            this.itemHandler.invalidate();
        }
    }

    @Override
    public void func_184174_b(boolean dropWhenDead) {
        this.field_94112_b = dropWhenDead;
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.field_184290_c != null) {
            compound.func_74778_a("LootTable", this.field_184290_c.toString());
            if (this.field_184291_d != 0L) {
                compound.func_74772_a("LootTableSeed", this.field_184291_d);
            }
        } else {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.field_94113_a);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_94113_a = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)((Object)ItemStack.field_190927_a));
        if (compound.func_150297_b("LootTable", 8)) {
            this.field_184290_c = new ResourceLocation(compound.func_74779_i("LootTable"));
            this.field_184291_d = compound.func_74763_f("LootTableSeed");
        } else {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.field_94113_a);
        }
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_71007_a((IInventory)this);
        }
        return true;
    }

    @Override
    protected void func_94101_h() {
        float f = 0.98f;
        if (this.field_184290_c == null) {
            int i = 15 - Container.func_94526_b((IInventory)this);
            f += (float)i * 0.001f;
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= 0.0;
        this.field_70179_y *= (double)f;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_174893_q_() {
        return false;
    }

    public void func_174892_a(LockCode code) {
    }

    public LockCode func_174891_i() {
        return LockCode.field_180162_a;
    }

    public void func_184288_f(@Nullable EntityPlayer player) {
        if (this.field_184290_c != null && this.field_70170_p.func_73046_m() != null) {
            LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(this.field_184290_c);
            this.field_184290_c = null;
            Random random = this.field_184291_d == 0L ? new Random() : new Random(this.field_184291_d);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p).func_204313_a(new BlockPos((Entity)this)).func_186472_a(this);
            if (player != null) {
                lootcontext$builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            }
            loottable.func_186460_a((IInventory)this, random, lootcontext$builder.func_186471_a());
        }
    }

    public void func_174888_l() {
        this.func_184288_f(null);
        this.field_94113_a.clear();
    }

    public void func_184289_a(ResourceLocation lootTableIn, long lootTableSeedIn) {
        this.field_184290_c = lootTableIn;
        this.field_184291_d = lootTableSeedIn;
    }

    public ResourceLocation func_184276_b() {
        return this.field_184290_c;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }
}

