/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.IAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityAttach;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityTracker {
    private static final Logger field_151249_a = LogManager.getLogger();
    private final WorldServer field_72795_a;
    private final Set<EntityTrackerEntry> field_72793_b = Sets.newHashSet();
    private final IntHashMap<EntityTrackerEntry> field_72794_c = new IntHashMap();
    private int field_72792_d;

    public EntityTracker(WorldServer theWorldIn) {
        this.field_72795_a = theWorldIn;
        this.field_72792_d = theWorldIn.func_73046_m().func_184103_al().func_72372_a();
    }

    public static long func_187253_a(double value) {
        return MathHelper.func_76124_d((double)(value * 4096.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_187254_a(Entity entityIn, double x, double y, double z) {
        entityIn.field_70118_ct = EntityTracker.func_187253_a(x);
        entityIn.field_70117_cu = EntityTracker.func_187253_a(y);
        entityIn.field_70116_cv = EntityTracker.func_187253_a(z);
    }

    public void func_72786_a(Entity entityIn) {
        if (entityIn.func_200600_R().hasCustomTracking()) {
            this.func_72785_a(entityIn, entityIn.func_200600_R().getTrackingRange(), entityIn.func_200600_R().getUpdateFrequency(), entityIn.func_200600_R().shouldSendVelocityUpdates());
            return;
        }
        if (entityIn instanceof EntityPlayerMP) {
            this.func_72791_a(entityIn, 512, 2);
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entityIn;
            for (EntityTrackerEntry entitytrackerentry : this.field_72793_b) {
                if (entitytrackerentry.func_187260_b() == entityplayermp) continue;
                entitytrackerentry.func_73117_b(entityplayermp);
            }
        } else if (entityIn instanceof EntityFishHook) {
            this.func_72785_a(entityIn, 64, 5, true);
        } else if (entityIn instanceof EntityArrow) {
            this.func_72785_a(entityIn, 64, 20, false);
        } else if (entityIn instanceof EntitySmallFireball) {
            this.func_72785_a(entityIn, 64, 10, false);
        } else if (entityIn instanceof EntityFireball) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntitySnowball) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntityLlamaSpit) {
            this.func_72785_a(entityIn, 64, 10, false);
        } else if (entityIn instanceof EntityEnderPearl) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntityEnderEye) {
            this.func_72785_a(entityIn, 64, 4, true);
        } else if (entityIn instanceof EntityEgg) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntityPotion) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntityExpBottle) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntityFireworkRocket) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntityItem) {
            this.func_72785_a(entityIn, 64, 20, true);
        } else if (entityIn instanceof EntityMinecart) {
            this.func_72785_a(entityIn, 80, 3, true);
        } else if (entityIn instanceof EntityBoat) {
            this.func_72785_a(entityIn, 80, 3, true);
        } else if (entityIn instanceof EntitySquid) {
            this.func_72785_a(entityIn, 64, 3, true);
        } else if (entityIn instanceof EntityWither) {
            this.func_72785_a(entityIn, 80, 3, false);
        } else if (entityIn instanceof EntityShulkerBullet) {
            this.func_72785_a(entityIn, 80, 3, true);
        } else if (entityIn instanceof EntityBat) {
            this.func_72785_a(entityIn, 80, 3, false);
        } else if (entityIn instanceof EntityDragon) {
            this.func_72785_a(entityIn, 160, 3, true);
        } else if (entityIn instanceof IAnimal) {
            this.func_72785_a(entityIn, 80, 3, true);
        } else if (entityIn instanceof EntityTNTPrimed) {
            this.func_72785_a(entityIn, 160, 10, true);
        } else if (entityIn instanceof EntityFallingBlock) {
            this.func_72785_a(entityIn, 160, 20, true);
        } else if (entityIn instanceof EntityHanging) {
            this.func_72785_a(entityIn, 160, Integer.MAX_VALUE, false);
        } else if (entityIn instanceof EntityArmorStand) {
            this.func_72785_a(entityIn, 160, 3, true);
        } else if (entityIn instanceof EntityXPOrb) {
            this.func_72785_a(entityIn, 160, 20, true);
        } else if (entityIn instanceof EntityAreaEffectCloud) {
            this.func_72785_a(entityIn, 160, Integer.MAX_VALUE, true);
        } else if (entityIn instanceof EntityEnderCrystal) {
            this.func_72785_a(entityIn, 256, Integer.MAX_VALUE, false);
        } else if (entityIn instanceof EntityEvokerFangs) {
            this.func_72785_a(entityIn, 160, 2, false);
        }
    }

    public void func_72791_a(Entity entityIn, int trackingRange, int updateInterval) {
        this.func_72785_a(entityIn, trackingRange, updateInterval, false);
    }

    public void func_72785_a(Entity entityIn, int trackingRange, int updateInterval, boolean sendVelocityUpdates) {
        try {
            if (this.field_72794_c.func_76037_b(entityIn.func_145782_y())) {
                throw new IllegalStateException("Entity is already tracked!");
            }
            EntityTrackerEntry entitytrackerentry = new EntityTrackerEntry(entityIn, trackingRange, this.field_72792_d, updateInterval, sendVelocityUpdates);
            this.field_72793_b.add(entitytrackerentry);
            this.field_72794_c.func_76038_a(entityIn.func_145782_y(), (Object)entitytrackerentry);
            entitytrackerentry.func_73125_b(this.field_72795_a.field_73010_i);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Adding entity to track");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity To Track");
            crashreportcategory.func_71507_a("Tracking range", trackingRange + " blocks");
            crashreportcategory.func_189529_a("Update interval", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
                String s = "Once per " + updateInterval + " ticks";
                if (updateInterval == Integer.MAX_VALUE) {
                    s = "Maximum (" + s + ")";
                }
                return s;
            }));
            entityIn.func_85029_a(crashreportcategory);
            ((EntityTrackerEntry)this.field_72794_c.func_76041_a(entityIn.func_145782_y())).func_187260_b().func_85029_a(crashreport.func_85058_a("Entity That Is Already Tracked"));
            try {
                throw new ReportedException(crashreport);
            }
            catch (ReportedException reportedexception) {
                field_151249_a.error("\"Silently\" catching entity tracking error.", (Throwable)reportedexception);
            }
        }
    }

    public void func_72790_b(Entity entityIn) {
        EntityTrackerEntry entitytrackerentry1;
        if (entityIn instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entityIn;
            for (EntityTrackerEntry entitytrackerentry : this.field_72793_b) {
                entitytrackerentry.func_73118_a(entityplayermp);
            }
        }
        if ((entitytrackerentry1 = (EntityTrackerEntry)this.field_72794_c.func_76049_d(entityIn.func_145782_y())) != null) {
            this.field_72793_b.remove(entitytrackerentry1);
            entitytrackerentry1.func_73119_a();
        }
    }

    public void func_72788_a() {
        ArrayList list = Lists.newArrayList();
        for (EntityTrackerEntry entitytrackerentry : this.field_72793_b) {
            Entity entity;
            entitytrackerentry.func_73122_a(this.field_72795_a.field_73010_i);
            if (!entitytrackerentry.field_73133_n || !((entity = entitytrackerentry.func_187260_b()) instanceof EntityPlayerMP)) continue;
            list.add((EntityPlayerMP)entity);
        }
        for (int i = 0; i < list.size(); ++i) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)((Object)list.get(i));
            for (EntityTrackerEntry entitytrackerentry1 : this.field_72793_b) {
                if (entitytrackerentry1.func_187260_b() == entityplayermp) continue;
                entitytrackerentry1.func_73117_b(entityplayermp);
            }
        }
    }

    public void func_180245_a(EntityPlayerMP player) {
        for (EntityTrackerEntry entitytrackerentry : this.field_72793_b) {
            if (entitytrackerentry.func_187260_b() == player) {
                entitytrackerentry.func_73125_b(this.field_72795_a.field_73010_i);
                continue;
            }
            entitytrackerentry.func_73117_b(player);
        }
    }

    public void func_151247_a(Entity entityIn, Packet<?> packetIn) {
        EntityTrackerEntry entitytrackerentry = (EntityTrackerEntry)this.field_72794_c.func_76041_a(entityIn.func_145782_y());
        if (entitytrackerentry != null) {
            entitytrackerentry.func_151259_a(packetIn);
        }
    }

    public void func_151248_b(Entity entityIn, Packet<?> packetIn) {
        EntityTrackerEntry entitytrackerentry = (EntityTrackerEntry)this.field_72794_c.func_76041_a(entityIn.func_145782_y());
        if (entitytrackerentry != null) {
            entitytrackerentry.func_151261_b(packetIn);
        }
    }

    public void func_72787_a(EntityPlayerMP player) {
        for (EntityTrackerEntry entitytrackerentry : this.field_72793_b) {
            entitytrackerentry.func_73123_c(player);
        }
    }

    public void func_85172_a(EntityPlayerMP player, Chunk chunkIn) {
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (EntityTrackerEntry entitytrackerentry : this.field_72793_b) {
            Entity entity = entitytrackerentry.func_187260_b();
            if (entity == player || entity.field_70176_ah != chunkIn.field_76635_g || entity.field_70164_aj != chunkIn.field_76647_h) continue;
            entitytrackerentry.func_73117_b(player);
            if (entity instanceof EntityLiving && ((EntityLiving)entity).func_110166_bE() != null) {
                list.add(entity);
            }
            if (entity.func_184188_bt().isEmpty()) continue;
            list1.add(entity);
        }
        if (!list.isEmpty()) {
            for (Entity entity1 : list) {
                player.field_71135_a.func_147359_a((Packet<?>)new SPacketEntityAttach(entity1, ((EntityLiving)entity1).func_110166_bE()));
            }
        }
        if (!list1.isEmpty()) {
            for (Entity entity2 : list1) {
                player.field_71135_a.func_147359_a((Packet<?>)new SPacketSetPassengers(entity2));
            }
        }
    }

    public void func_187252_a(int distance) {
        this.field_72792_d = (distance - 1) * 16;
        for (EntityTrackerEntry entitytrackerentry : this.field_72793_b) {
            entitytrackerentry.func_187259_a(this.field_72792_d);
        }
    }

    public Set<? extends EntityPlayer> getTrackingPlayers(Entity entity) {
        EntityTrackerEntry entry = (EntityTrackerEntry)this.field_72794_c.func_76041_a(entity.func_145782_y());
        if (entry == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(entry.field_73134_o);
    }
}

