/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.vertex;

import java.nio.ByteBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class VertexFormatElement {
    private static final Logger field_177381_a = LogManager.getLogger();
    private final EnumType field_177379_b;
    private final EnumUsage field_177380_c;
    private final int field_177377_d;
    private final int field_177378_e;

    public VertexFormatElement(int indexIn, EnumType typeIn, EnumUsage usageIn, int count) {
        if (this.func_177372_a(indexIn, usageIn)) {
            this.field_177380_c = usageIn;
        } else {
            field_177381_a.warn("Multiple vertex elements of the same type other than UVs are not supported. Forcing type to UV.");
            this.field_177380_c = EnumUsage.UV;
        }
        this.field_177379_b = typeIn;
        this.field_177377_d = indexIn;
        this.field_177378_e = count;
    }

    private final boolean func_177372_a(int p_177372_1_, EnumUsage p_177372_2_) {
        return p_177372_1_ == 0 || p_177372_2_ == EnumUsage.UV;
    }

    public final EnumType func_177367_b() {
        return this.field_177379_b;
    }

    public final EnumUsage func_177375_c() {
        return this.field_177380_c;
    }

    public final int func_177370_d() {
        return this.field_177378_e;
    }

    public final int func_177369_e() {
        return this.field_177377_d;
    }

    public String toString() {
        return this.field_177378_e + "," + this.field_177380_c.func_177384_a() + "," + this.field_177379_b.func_177396_b();
    }

    public final int func_177368_f() {
        return this.field_177379_b.func_177395_a() * this.field_177378_e;
    }

    public final boolean func_177374_g() {
        return this.field_177380_c == EnumUsage.POSITION;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            VertexFormatElement vertexformatelement = (VertexFormatElement)p_equals_1_;
            if (this.field_177378_e != vertexformatelement.field_177378_e) {
                return false;
            }
            if (this.field_177377_d != vertexformatelement.field_177377_d) {
                return false;
            }
            if (this.field_177379_b != vertexformatelement.field_177379_b) {
                return false;
            }
            return this.field_177380_c == vertexformatelement.field_177380_c;
        }
        return false;
    }

    public int hashCode() {
        int i = this.field_177379_b.hashCode();
        i = 31 * i + this.field_177380_c.hashCode();
        i = 31 * i + this.field_177377_d;
        i = 31 * i + this.field_177378_e;
        return i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum EnumUsage {
        POSITION("Position"),
        NORMAL("Normal"),
        COLOR("Vertex Color"),
        UV("UV"),
        MATRIX("Bone Matrix"),
        BLEND_WEIGHT("Blend Weight"),
        PADDING("Padding"),
        GENERIC("Generic");

        private final String field_177392_h;

        public void preDraw(VertexFormat format, int element, int stride, ByteBuffer buffer) {
            ForgeHooksClient.preDraw((EnumUsage)this, (VertexFormat)format, (int)element, (int)stride, (ByteBuffer)buffer);
        }

        public void postDraw(VertexFormat format, int element, int stride, ByteBuffer buffer) {
            ForgeHooksClient.postDraw((EnumUsage)this, (VertexFormat)format, (int)element, (int)stride, (ByteBuffer)buffer);
        }

        private EnumUsage(String displayNameIn) {
            this.field_177392_h = displayNameIn;
        }

        public String func_177384_a() {
            return this.field_177392_h;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum EnumType {
        FLOAT(4, "Float", 5126),
        UBYTE(1, "Unsigned Byte", 5121),
        BYTE(1, "Byte", 5120),
        USHORT(2, "Unsigned Short", 5123),
        SHORT(2, "Short", 5122),
        UINT(4, "Unsigned Int", 5125),
        INT(4, "Int", 5124);

        private final int field_177407_h;
        private final String field_177408_i;
        private final int field_177405_j;

        private EnumType(int sizeIn, String displayNameIn, int glConstantIn) {
            this.field_177407_h = sizeIn;
            this.field_177408_i = displayNameIn;
            this.field_177405_j = glConstantIn;
        }

        public int func_177395_a() {
            return this.field_177407_h;
        }

        public String func_177396_b() {
            return this.field_177408_i;
        }

        public int func_177397_c() {
            return this.field_177405_j;
        }
    }
}

