/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.progress.ProgressBar;
import net.minecraftforge.fml.common.progress.StartupProgressManager;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class TextureManager
implements ITickable,
IResourceManagerReloadListener {
    private static final Logger field_147646_a = LogManager.getLogger();
    public static final ResourceLocation field_194008_a = new ResourceLocation("");
    private final Map<ResourceLocation, ITextureObject> field_110585_a = Maps.newHashMap();
    private final List<ITickable> field_110583_b = Lists.newArrayList();
    private final Map<String, Integer> field_110584_c = Maps.newHashMap();
    private final IResourceManager field_110582_d;

    public TextureManager(IResourceManager resourceManager) {
        this.field_110582_d = resourceManager;
    }

    public void func_110577_a(ResourceLocation resource) {
        ITextureObject itextureobject = this.field_110585_a.get(resource);
        if (itextureobject == null) {
            itextureobject = new SimpleTexture(resource);
            this.func_110579_a(resource, itextureobject);
        }
        itextureobject.func_195412_h();
    }

    public boolean func_110580_a(ResourceLocation textureLocation, ITickableTextureObject textureObj) {
        if (this.func_110579_a(textureLocation, (ITextureObject)textureObj)) {
            this.field_110583_b.add((ITickable)textureObj);
            return true;
        }
        return false;
    }

    public boolean func_110579_a(ResourceLocation textureLocation, ITextureObject textureObj) {
        boolean flag = true;
        try {
            textureObj.func_195413_a(this.field_110582_d);
        }
        catch (IOException ioexception) {
            if (textureLocation != field_194008_a) {
                field_147646_a.warn("Failed to load texture: {}", (Object)textureLocation, (Object)ioexception);
            }
            textureObj = MissingTextureSprite.func_195676_d();
            this.field_110585_a.put(textureLocation, textureObj);
            flag = false;
        }
        catch (Throwable throwable) {
            ITextureObject p_110579_2_f = textureObj;
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Registering texture");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Resource location being registered");
            crashreportcategory.func_71507_a("Resource location", textureLocation);
            crashreportcategory.func_189529_a("Texture object class", (ICrashReportDetail<String>)((ICrashReportDetail)() -> p_110579_2_f.getClass().getName()));
            throw new ReportedException(crashreport);
        }
        this.field_110585_a.put(textureLocation, textureObj);
        return flag;
    }

    public ITextureObject func_110581_b(ResourceLocation textureLocation) {
        return this.field_110585_a.get(textureLocation);
    }

    public ResourceLocation func_110578_a(String name, DynamicTexture texture) {
        Integer integer = this.field_110584_c.get(name);
        integer = integer == null ? Integer.valueOf(1) : Integer.valueOf(integer + 1);
        this.field_110584_c.put(name, integer);
        ResourceLocation resourcelocation = new ResourceLocation(String.format("dynamic/%s_%d", name, integer));
        this.func_110579_a(resourcelocation, (ITextureObject)texture);
        return resourcelocation;
    }

    public void func_110550_d() {
        for (ITickable itickable : this.field_110583_b) {
            itickable.func_110550_d();
        }
    }

    public void func_147645_c(ResourceLocation textureLocation) {
        ITextureObject itextureobject = this.func_110581_b(textureLocation);
        if (itextureobject != null) {
            this.field_110585_a.remove(textureLocation);
            TextureUtil.func_147942_a(itextureobject.func_110552_b());
        }
    }

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        MissingTextureSprite.func_195676_d();
        try (ProgressBar bar = StartupProgressManager.start((String)"Reloading Texture Manager", (int)this.field_110585_a.entrySet().size(), (boolean)true);){
            Iterator<Map.Entry<ResourceLocation, ITextureObject>> iterator = this.field_110585_a.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, ITextureObject> entry = iterator.next();
                ResourceLocation resourcelocation = entry.getKey();
                bar.step(resourcelocation.toString());
                ITextureObject itextureobject = entry.getValue();
                if (itextureobject == MissingTextureSprite.func_195676_d() && !resourcelocation.equals((Object)MissingTextureSprite.func_195675_b())) {
                    iterator.remove();
                    continue;
                }
                this.func_110579_a(entry.getKey(), itextureobject);
            }
        }
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.TEXTURES;
    }
}

